//
//  ListaRecursosViewController.h
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 12/06/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "RecursoTuristico.h"
#import <CoreLocation/CoreLocation.h>
#import "DetalleRecursoViewController.h"
#import "RecursoCustomCell.h"
#import "BMActivityIndicator.h"
#import "descargarRecursos.h"
#import "DTCustomColoredAccessory.h"

@interface ListaRecursosViewController : UIViewController <UITableViewDelegate, UITableViewDataSource, CLLocationManagerDelegate>
{

    NSMutableArray *_arrRecursos;
    NSMutableArray *_arrCategorias;
    
    //User Location
    CLLocationManager *_locationManager;
    int didUpateLocation;
    
    DetalleRecursoViewController *detalleRecursoView;
    RecursoCustomCell *customCell;
    
    // ACTIVITY INDICATOR
    BMActivityIndicator *_activityIndicator;
    
    //Se controla si se debe mostrar el activity o no
    BOOL _activity;
}

@property (nonatomic, strong) IBOutlet UIImageView *imgBackground;
@property (strong, nonatomic) IBOutlet UITableView *tableView;

@property (nonatomic, strong) DetalleRecursoViewController *detalleRecursoView;
@property (nonatomic, strong) RecursoCustomCell *customCell;

@property (nonatomic, strong) NSMutableArray *arrCategorias;
@property (nonatomic, strong) NSString *strDistancia;

@end
