//
//  BMAudioRecorder.m
//  iNVASIVE
//
//  Created by Bilbomatica on 27/07/11.
//  Copyright 2011 Bilbomatica. All rights reserved.
//

#import "LeyendaMapa.h"
#import <QuartzCore/QuartzCore.h>

@implementation LeyendaMapa

@synthesize btnCancel, delegate;


- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
    }
    return self;
}

-(id) initWithTitle:(NSString *)title image:(UIImage*)_image
{
    [self recargarLiterales];
    self = [super initWithFrame:CGRectMake(0, 0, 300, 330)];
    
    self.layer.backgroundColor = [UIColor colorWithRed:0.0 green:0.0 blue:0.0 alpha:0.7f].CGColor;
    self.layer.cornerRadius = 10.0f;
    self.layer.borderColor = [UIColor whiteColor].CGColor;
    self.layer.borderWidth = 2.0f;
    self.layer.masksToBounds = YES;
    self.alpha = 1.0f;
    
    //button cancel
    btnCancel = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnCancel setBackgroundImage:[UIImage imageNamed:@"iconCloseX.png"] forState:UIControlStateNormal];
    btnCancel.frame = CGRectMake(self.frame.size.width - (btnCancel.currentBackgroundImage.size.width)-5, 5, btnCancel.currentBackgroundImage.size.width, btnCancel.currentBackgroundImage.size.height);
    [btnCancel addTarget:self action:@selector(cancelAndClose:) forControlEvents:UIControlEventTouchUpInside];
    [self insertSubview:btnCancel aboveSubview:self];
    
    //Cultura
    UIImageView *imgIconoCultura = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"PinCultura.png"]];
     imgIconoCultura.frame = CGRectMake(10, 5, 30, 30);
     [self insertSubview:imgIconoCultura aboveSubview:self];
     
     UILabel *lblCultura = [[UILabel alloc] initWithFrame:CGRectMake(70, 5, 200, 30)];
    [lblCultura setText:strCultura];
     lblCultura.backgroundColor = [UIColor clearColor];
     [lblCultura setTextColor:[UIColor whiteColor]];
     [self insertSubview:lblCultura aboveSubview:self];
    
    //Deportes
    UIImageView *imgIconoDeportes = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"PinDeportes.png"]];
    imgIconoDeportes.frame = CGRectMake(10, 40, 30, 30);
    [self insertSubview:imgIconoDeportes aboveSubview:self];
    
    UILabel *lblDeportes = [[UILabel alloc] initWithFrame:CGRectMake(70, 40, 200, 30)];
    [lblDeportes setText:strDeportes];
    lblDeportes.backgroundColor = [UIColor clearColor];
    [lblDeportes setTextColor:[UIColor whiteColor]];
    [self insertSubview:lblDeportes aboveSubview:self];
    
    //Transporte
    UIImageView *imgIconoTransporte = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"PinTransporte.png"]];
    imgIconoTransporte.frame = CGRectMake(10, 75, 30, 30);
    [self insertSubview:imgIconoTransporte aboveSubview:self];
    
    UILabel *lblTransporte = [[UILabel alloc] initWithFrame:CGRectMake(70, 75, 200, 30)];
    [lblTransporte setText:strTransporte];
    lblTransporte.backgroundColor = [UIColor clearColor];
    [lblTransporte setTextColor:[UIColor whiteColor]];
    [self insertSubview:lblTransporte aboveSubview:self];
    
    //Comer
    UIImageView *imgIconoComer = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"PinComer.png"]];
    imgIconoComer.frame = CGRectMake(10, 110, 30, 30);
    [self insertSubview:imgIconoComer aboveSubview:self];
    
    UILabel *lblComer = [[UILabel alloc] initWithFrame:CGRectMake(70, 110, 200, 30)];
    [lblComer setText:strComer];
    lblComer.backgroundColor = [UIColor clearColor];
    [lblComer setTextColor:[UIColor whiteColor]];
    [self insertSubview:lblComer aboveSubview:self];
    
    //Dormir
    UIImageView *imgIconoDormir = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"PinDormir.png"]];
    imgIconoDormir.frame = CGRectMake(10, 145, 30, 30);
    [self insertSubview:imgIconoDormir aboveSubview:self];
    
    UILabel *lblDormir = [[UILabel alloc] initWithFrame:CGRectMake(70, 145, 200, 30)];
    [lblDormir setText:strDormir];
    lblDormir.backgroundColor = [UIColor clearColor];
    [lblDormir setTextColor:[UIColor whiteColor]];
    [self insertSubview:lblDormir aboveSubview:self];
    
    //Playas
    UIImageView *imgIconoPlayas = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"PinPlayas.png"]];
    imgIconoPlayas.frame = CGRectMake(10, 180, 30, 30);
    [self insertSubview:imgIconoPlayas aboveSubview:self];
    
    UILabel *lblPlayas = [[UILabel alloc] initWithFrame:CGRectMake(70, 180, 200, 30)];
    [lblPlayas setText:strPlayas];
    lblPlayas.backgroundColor = [UIColor clearColor];
    [lblPlayas setTextColor:[UIColor whiteColor]];
    [self insertSubview:lblPlayas aboveSubview:self];
    
    //Experiencias top
    UIImageView *imgIconoExperiencias = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"PinExperiencias.png"]];
    imgIconoExperiencias.frame = CGRectMake(10, 215, 30, 30);
    [self insertSubview:imgIconoExperiencias aboveSubview:self];
    
    UILabel *lblExperiencias = [[UILabel alloc] initWithFrame:CGRectMake(70, 215, 200, 30)];
    [lblExperiencias setText:strExperiencias];
    lblExperiencias.backgroundColor = [UIColor clearColor];
    [lblExperiencias setTextColor:[UIColor whiteColor]];
    [self insertSubview:lblExperiencias aboveSubview:self];
    
    //Oficinas de turismo
    UIImageView *imgIconoInfo = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"PinInfo.png"]];
    imgIconoInfo.frame = CGRectMake(10, 250, 30, 30);
    [self insertSubview:imgIconoInfo aboveSubview:self];
    
    UILabel *lblInfo = [[UILabel alloc] initWithFrame:CGRectMake(70, 250, 200, 30)];
    [lblInfo setText:strInfo];
    lblInfo.backgroundColor = [UIColor clearColor];
    [lblInfo setTextColor:[UIColor whiteColor]];
    [self insertSubview:lblInfo aboveSubview:self];
    
    //Reuniones
    UIImageView *imgIconoReuniones = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"PinReuniones.png"]];
    imgIconoReuniones.frame = CGRectMake(10, 285, 30, 30);
    [self insertSubview:imgIconoReuniones aboveSubview:self];
    
    UILabel *lblReuniones = [[UILabel alloc] initWithFrame:CGRectMake(70, 285, 200, 30)];
    [lblReuniones setText:strReuniones];
    lblReuniones.backgroundColor = [UIColor clearColor];
    [lblReuniones setTextColor:[UIColor whiteColor]];
    [self insertSubview:lblReuniones aboveSubview:self];
    
    self.transform = CGAffineTransformMakeScale(1.0, 0.1);
    return self;
}

/*
 Procedimiento que traduce los literales de la pantalla.
 */

- (void)traduccionLiterales{
    
    if ([[[NSLocale currentLocale] localeIdentifier] isEqualToString:@"eu_ES"])
    {
        [self traducirEuskera];
    }
    else
    {
        strCultura = NSLocalizedString(@"CULTURA", nil);
        strDeportes = NSLocalizedString(@"DEPORTES", nil);
        strTransporte = NSLocalizedString(@"COMOMOVERSE", nil);
        strDormir = NSLocalizedString(@"DONDEDORMIR", nil);
        strComer = NSLocalizedString(@"DONDECOMER", nil);
        strPlayas = NSLocalizedString(@"PLAYAS", nil);
        strExperiencias = NSLocalizedString(@"EXPERIENCIASTOP", nil);
        strInfo = NSLocalizedString(@"OFICINASDETURISMO", nil);
    }
    
}

/*
 Procedimiento que traduce los literales de la pantalla 
 a euskera.
 */
- (void)traducirEuskera{

    strCultura =eu_lblCultura;
    strDeportes = eu_lblDeportes;
    strTransporte = eu_lblMoverse;
    strDormir = eu_lblDormir;
    strComer = eu_lblComer;
    strPlayas = eu_lblPlayas;
    strExperiencias = eu_lblExperiencias;
    strInfo = eu_lblOficinas;
    
}

- (void) awakeFromNib
{
    [super awakeFromNib];
}

-(void)show
{
    
    [UIView beginAnimations:@"playAnimation" context:nil];
    [UIView setAnimationDuration:0.5f];
    self.transform = CGAffineTransformMakeScale(1.0, 1.0);
    [UIView commitAnimations];
    
}

-(IBAction)cancelAndClose:(id)sender{

    [UIView setAnimationDuration:0.5f];
    self.transform = CGAffineTransformMakeScale(0.1, 0.1);
    [UIView commitAnimations];
    [delegate didClose];
    
    [self removeFromSuperview];
    
}

-(void) recargarLiterales{
    
    strCultura = [traducirLiteral languageSelectedStringForKey:@"CULTURA"];
    strDeportes = [traducirLiteral languageSelectedStringForKey:@"DEPORTES"];
    strTransporte = [traducirLiteral languageSelectedStringForKey:@"COMOMOVERSE"];
    strDormir = [traducirLiteral languageSelectedStringForKey:@"DONDEDORMIR"];
    strComer = [traducirLiteral languageSelectedStringForKey:@"DONDECOMER"];
    strPlayas = [traducirLiteral languageSelectedStringForKey:@"PLAYAS"];
    strExperiencias = [traducirLiteral languageSelectedStringForKey:@"EXPERIENCIASTOP"];
    strInfo = [traducirLiteral languageSelectedStringForKey:@"OFICINASDETURISMO"];
    strReuniones = [traducirLiteral languageSelectedStringForKey:@"REUNIONES"];
    
}

@end
