//
//  FavoritosViewController.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 26/06/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "FavoritosViewController.h"
#import <QuartzCore/QuartzCore.h>
#import "AppDelegate.h"
#import "RecursoDB.h"
#import "RecursoTuristico.h"

@implementation FavoritosViewController

@synthesize vistaTableView;
@synthesize customCell, imgBackground;
@synthesize recursos = _fetchedResultsController;

#pragma mark - View Lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];

    UIBarButtonItem *editButton =[[UIBarButtonItem alloc] initWithTitle:[traducirLiteral languageSelectedStringForKey:@"EDITAR"] style:UIBarButtonItemStylePlain target:self action:@selector(editTable:)];
    self.navigationItem.rightBarButtonItem = editButton;
    
    self.navigationItem.title = [traducirLiteral languageSelectedStringForKey:@"FAVORITOS"];
    
    /*if (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad){
        [imgBackground setImage:[UIImage imageNamed:@"FondoIpadGris.png"]];
    }*/
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

#pragma mark - Segues

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    if ([[segue identifier] isEqualToString:@"vista_detalle"])
    {
        RecursoDB *recurso = [self.recursos objectAtIndexPath:[self.vistaTableView indexPathForSelectedRow]];
        DetalleRecursoViewController *vc = (DetalleRecursoViewController*)[segue destinationViewController];
        
        RecursoTuristico *recursoVista = [[RecursoTuristico alloc] initWithName:recurso.idRec imageURL:recurso.imageURL title:recurso.title desc:recurso.desc type:recurso.type latitud:recurso.latitud longitud:recurso.longitud telefono:recurso.telefono mail:recurso.mail urlRecurso:recurso.url distance:0];
        vc.recurso = recursoVista;
    }
}

#pragma mark - RESULT CONTROLLER 

- (NSFetchedResultsController *)recursos
{   
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];  
    NSString *strLang = [defaults objectForKey:@"AppLanguage"]; 

    AppDelegate *appDelegate = [[UIApplication sharedApplication] delegate];
    
    if (_fetchedResultsController != nil) {
        return _fetchedResultsController;
    }
    
    NSFetchRequest *fetchRequest = [[NSFetchRequest alloc] init];
    NSPredicate *requestPredicate = [NSPredicate predicateWithFormat:[NSString stringWithFormat:@"(lang like '%@')", strLang]];
    [fetchRequest setPredicate:requestPredicate];
    NSEntityDescription *entity = [NSEntityDescription entityForName:@"RecursoDB" inManagedObjectContext:appDelegate.managedObjectContext];
    [fetchRequest setEntity:entity];
    [fetchRequest setFetchBatchSize:20];
    
    NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"title" ascending:YES];
    NSArray *sortDescriptors = [[NSArray alloc] initWithObjects:sortDescriptor, nil];
    [fetchRequest setSortDescriptors:sortDescriptors];
    [NSFetchedResultsController deleteCacheWithName:@"Root"];

    NSFetchedResultsController *aFetchedResultsController = [[NSFetchedResultsController alloc] initWithFetchRequest:fetchRequest managedObjectContext:appDelegate.managedObjectContext sectionNameKeyPath:nil cacheName:@"Root"];
    
    aFetchedResultsController.delegate = self;
    
    self.recursos = aFetchedResultsController;
    
    NSError *error = nil;
    if (![_fetchedResultsController performFetch:&error]) {
        NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
        abort();
    }
    
    return _fetchedResultsController;
} 

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
	// Return the number of rows in the section.
        id <NSFetchedResultsSectionInfo> sectionInfo = [[self.recursos sections] objectAtIndex:section];
        return [sectionInfo numberOfObjects];
}

- (UITableViewCell *)tableView:(UITableView *)tableViewPar cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"RecursoCustomCell";
	
	// Recoger una celda con su identificador
	customCell = (RecursoCustomCell *)[vistaTableView dequeueReusableCellWithIdentifier:cellID];
	
    
	// Si la celda no esta disponible, creamos una con el identificador
	if (customCell == nil) {
		NSArray *nibObjects = [[NSBundle mainBundle] loadNibNamed:@"RecursoCustomCell" owner:nil options:nil];
		for (id currentObject in nibObjects) {
			if ([currentObject isKindOfClass:[RecursoCustomCell class]]) {
				customCell = (RecursoCustomCell *)currentObject;
			}
		}
	}
    
    RecursoDB *recurso = [self.recursos objectAtIndexPath:indexPath];
    //setting name for cell
    [customCell.lblTitle setText:recurso.title];
    NSString *distancia = [NSString stringWithFormat:@""];
    [customCell.lblSubTitle setText:distancia];
    //[customCell.lblSubTitle setText:[NSString stringWithFormat:@"%d", recurso.type]];
    if (recurso.type == [NSNumber numberWithInt:1]){
        customCell.imageView.image = [UIImage imageNamed:@"iconCultura"];
    }else if(recurso.type == [NSNumber numberWithInt:2]) {
        customCell.imageView.image = [UIImage imageNamed:@"iconTransporte"];
    }else if(recurso.type == [NSNumber numberWithInt:3]) {
        customCell.imageView.image = [UIImage imageNamed:@"iconDeportes"];
    }else if(recurso.type == [NSNumber numberWithInt:4]) {
        customCell.imageView.image = [UIImage imageNamed:@"iconComer"];
    }else if(recurso.type == [NSNumber numberWithInt:5]) {
        customCell.imageView.image = [UIImage imageNamed:@"iconDormir"];
    }else if(recurso.type == [NSNumber numberWithInt:6]) {
        customCell.imageView.image = [UIImage imageNamed:@"iconExperiencias"];
    }else if(recurso.type == [NSNumber numberWithInt:7]) {
        customCell.imageView.image = [UIImage imageNamed:@"iconPlayas"];
    }else if(recurso.type == [NSNumber numberWithInt:8]) {
        customCell.imageView.image = [UIImage imageNamed:@"iconInfo"];
    }else if(recurso.type == [NSNumber numberWithInt:9]) {
        customCell.imageView.image = [UIImage imageNamed:@"iconReuniones"];
    }
    
    customCell.backgroundColor = [UIColor clearColor];
    return customCell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [self performSegueWithIdentifier:@"vista_detalle" sender:self];
}

#pragma mark - Table view edit

-(IBAction)editTable: (id) sender {

    if(vistaTableView.editing)
    {
        [super setEditing:NO animated:NO];
        self.navigationItem.leftBarButtonItem = nil;
        
        UIBarButtonItem *editButton =[[UIBarButtonItem alloc] initWithTitle:[traducirLiteral languageSelectedStringForKey:@"EDITAR"] style:UIBarButtonItemStylePlain target:self action:@selector(editTable:)];
        self.navigationItem.rightBarButtonItem = editButton;
        
        [vistaTableView setEditing:NO animated:NO];
        [vistaTableView reloadData];
        //[self.navigationItem.rightBarButtonItem setTitle:[traducirLiteral languageSelectedStringForKey:@"EDITAR"]];
        [self.navigationItem.rightBarButtonItem setStyle:UIBarButtonItemStylePlain];
        
    }
    else
    {
        [super setEditing:YES animated:YES];
        
        UIBarButtonItem *doneButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemDone target:self action:@selector(editTable:)];
        self.navigationItem.rightBarButtonItem = doneButton;
        
        [vistaTableView setEditing:YES animated:YES];
        [vistaTableView reloadData];
        
        [self.navigationItem.rightBarButtonItem setStyle:UIBarButtonItemStyleBordered];
        
    }
}

- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (editingStyle == UITableViewCellEditingStyleDelete) { // Delete the managed object for the given index path 
        NSManagedObjectContext *context = [self.recursos managedObjectContext];
        [context deleteObject:[self.recursos objectAtIndexPath:indexPath]];
        // Save the context. 
        NSError *error = nil; 
        if (![context save:&error]) {
            NSLog(@"Unresolved error %@, %@", error, [error userInfo]); abort();
        }
        
    }
}

#pragma mark - Fetched results controller delegate

- (void)controllerWillChangeContent:(NSFetchedResultsController *)controller {
    [vistaTableView beginUpdates];
}


- (void)controller:(NSFetchedResultsController *)controller didChangeSection:(id <NSFetchedResultsSectionInfo>)sectionInfo
           atIndex:(NSUInteger)sectionIndex forChangeType:(NSFetchedResultsChangeType)type {
    
    switch(type) {
        case NSFetchedResultsChangeInsert:
            [vistaTableView insertSections:[NSIndexSet indexSetWithIndex:sectionIndex] withRowAnimation:UITableViewRowAnimationFade];
            break;
            
        case NSFetchedResultsChangeDelete:
            [vistaTableView deleteSections:[NSIndexSet indexSetWithIndex:sectionIndex] withRowAnimation:UITableViewRowAnimationFade];
            break;
    }
}


- (void)controller:(NSFetchedResultsController *)controller didChangeObject:(id)anObject
       atIndexPath:(NSIndexPath *)indexPath forChangeType:(NSFetchedResultsChangeType)type
      newIndexPath:(NSIndexPath *)newIndexPath {
    
    UITableView *tableView = vistaTableView;
    
    switch(type) {
            
        case NSFetchedResultsChangeInsert:
            [tableView insertRowsAtIndexPaths:[NSArray arrayWithObject:newIndexPath] withRowAnimation:UITableViewRowAnimationFade];
            break;
            
        case NSFetchedResultsChangeDelete:
            [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
            break;
            
        case NSFetchedResultsChangeUpdate:
            //[self configureCell:[tableView cellForRowAtIndexPath:indexPath] atIndexPath:indexPath];
			[vistaTableView reloadData];
            break;
            
        case NSFetchedResultsChangeMove:
            [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
            [tableView insertRowsAtIndexPaths:[NSArray arrayWithObject:newIndexPath]withRowAnimation:UITableViewRowAnimationFade];
            break;
    }
}


- (void)controllerDidChangeContent:(NSFetchedResultsController *)controller {
    [vistaTableView endUpdates];
}

- (NSString *)tableView:(UITableView *)tableView titleForDeleteConfirmationButtonForRowAtIndexPath:(NSIndexPath *)indexPath{
    return [traducirLiteral languageSelectedStringForKey:@"BORRAR"];
}

@end
