//
//  DetalleRecursoViewController.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 30/05/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "DetalleRecursoViewController.h"
#import <QuartzCore/QuartzCore.h>
#import <AddressBook/AddressBook.h>
#import "AppDelegate.h"
#import "RecursoDB.h"
#import "UIColor(Extras).h"

@implementation DetalleRecursoViewController

@synthesize recurso, imageURLView, textView;
@synthesize lblTitle;
@synthesize webView;
@synthesize facebook;


#pragma mark - ciclo de vida objeto


- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [lblTitle setText:recurso.title];
    
    dispatch_queue_t downloadQueue = dispatch_queue_create("image downloader", NULL);
    dispatch_async(downloadQueue, ^{
        NSURL* aURL = [NSURL URLWithString:recurso.imageURL];
        NSData* data = [[NSData alloc] initWithContentsOfURL:aURL];
        dispatch_async(dispatch_get_main_queue(), ^{
                self.imageURLView.image = [UIImage imageWithData:data];
        });
        
    });
    dispatch_release(downloadQueue);
    self.imageURLView.layer.cornerRadius = 1.0f;
    self.imageURLView.layer.borderColor = [UIColor grayColor].CGColor;
    self.imageURLView.layer.borderWidth = 2.0f;
    self.imageURLView.layer.shadowColor = [UIColor lightGrayColor].CGColor;
    CGMutablePathRef path = CGPathCreateMutable();
    if (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad)
        CGPathAddRect(path, NULL, CGRectMake(0, 0, 708, 360));
    else
        CGPathAddRect(path, NULL, self.imageURLView.bounds);
    self.imageURLView.layer.shadowPath = path;
    self.imageURLView.layer.shadowOffset = CGSizeMake(10, 5);
    self.imageURLView.layer.shadowRadius = 5.0f;
    self.imageURLView.layer.shadowOpacity = 0.3;
    [textView setText:recurso.desc];
    facebook = [[Facebook alloc] initWithAppId:fb_appId andDelegate:self];
    [self recargarLiterales];
}

-(void)runRequests {
    @autoreleasepool {
        NSURL* aURL = [NSURL URLWithString:recurso.imageURL];
        NSData* data = [[NSData alloc] initWithContentsOfURL:aURL];
        self.imageURLView.image = [UIImage imageWithData:data];
    }
}

- (void)viewDidUnload
{
    [super viewDidUnload];
}

-(void) dealloc
{
    [facebook logout];
}

- (void) viewDidAppear:(BOOL)animated{
    int alturaBoton = 50;
    if (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad) alturaBoton = 100;
    float anchuraBoton = self.view.bounds.size.width/5;
    
    float origin_y = self.view.bounds.origin.y;
    
    // ----- BOTON TELEFONO
    CGRect rect = CGRectMake(self.view.bounds.origin.x, origin_y, anchuraBoton, alturaBoton);
    _btnTelefono = [[UIButton alloc] initWithFrame:rect];
    [_btnTelefono addTarget:self action:@selector(onClickBtnTelefono:) forControlEvents:UIControlEventTouchUpInside];
    [_btnTelefono setImage:[UIImage imageNamed:@"btnDetalleTelefonoGris"] forState:UIControlStateNormal];
    [self.view addSubview:_btnTelefono];
    //Si el dato viene vacio, se deshabilita el botón
    if (self.recurso.telefono == nil || [self.recurso.telefono isEqualToString:@""]) _btnTelefono.enabled = NO;
    
    // ----- BOTON EMAIL
    rect = CGRectMake(anchuraBoton, origin_y, anchuraBoton, alturaBoton);
    _btnEmail = [[UIButton alloc] initWithFrame: rect];
    [_btnEmail setImage:[UIImage imageNamed:@"btnDetalleMailGris"] forState:UIControlStateNormal];
    [_btnEmail addTarget:self action:@selector(onClickBtnMail:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:_btnEmail];
    //Si el dato viene vacio, se deshabilita el botón
    if (self.recurso.mail == nil || [self.recurso.mail isEqualToString:@""]) _btnEmail.enabled = NO;
    
    // ----- BOTON WEB
    rect = CGRectMake(anchuraBoton*2, origin_y, (self.view.bounds.size.width/5), alturaBoton);
    _btnWeb = [[UIButton alloc] initWithFrame:rect];
    [_btnWeb setImage:[UIImage imageNamed:@"btnDetalleInternetGris"] forState:UIControlStateNormal];
    [_btnWeb addTarget:self action:@selector(onClickBtnLink:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:_btnWeb];
    
    // ----- BOTON FAVORITO
    rect = CGRectMake(anchuraBoton*3, origin_y, anchuraBoton, alturaBoton);
    _btnFavorito = [[UIButton alloc] initWithFrame:rect];
    [_btnFavorito addTarget:self action:@selector(addFavorites:) forControlEvents:UIControlEventTouchUpInside];
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    NSString *strLangApp = [defaults objectForKey:@"AppLanguage"];
    if (![self existsInDB:[NSNumber numberWithInt:[recurso.id_recurso intValue]] language:strLangApp])
        [_btnFavorito setImage:[UIImage imageNamed:@"btnDetalleFavoritosGris"] forState:UIControlStateNormal];
    else
        [_btnFavorito setImage:[UIImage imageNamed:@"btnDetalleFavoritosAmarillo"] forState:UIControlStateNormal];
    [self.view addSubview:_btnFavorito];
    
    // ----- BOTON COMPARTIR
    rect = CGRectMake(anchuraBoton*4, origin_y, anchuraBoton, alturaBoton);
    _btnCompartir = [[UIButton alloc] initWithFrame:rect];
    [_btnCompartir setImage:[UIImage imageNamed:@"btnDetalleConectarGris"] forState:UIControlStateNormal];
    [_btnCompartir addTarget:self action:@selector(onClickBtnConnect:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:_btnCompartir];
    
    //Si el dato viene vacio, se deshabilita el botón
    if (self.recurso.urlRecurso == nil || [self.recurso.urlRecurso isEqualToString:@""]){
        _btnWeb.enabled = NO;
        _btnCompartir.enabled = NO;
    }
    
    // BOTON VER MAS
    _btnVerMas = [[UIButton alloc] initWithFrame:CGRectMake(self.view.bounds.size.width - 110, self.view.bounds.size.height - 40, 100, 40)];
    [_btnVerMas setBackgroundImage:[UIImage imageNamed:@"btnDetalleVerMas"] forState:UIControlStateNormal];
    [_btnVerMas addTarget:self action:@selector(onClickBtnVerMas:) forControlEvents:UIControlEventTouchUpInside];
    [_btnVerMas setTitle:[traducirLiteral languageSelectedStringForKey:@"VERMAS"] forState:UIControlStateNormal];
    _btnVerMas.titleLabel.font = [UIFont fontWithName:@"Verdana-Bold" size:15];
    [self.view addSubview:_btnVerMas];
    
    if (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad){
        self.imageURLView.layer.cornerRadius = 1.0f;
        self.imageURLView.layer.borderColor = [UIColor grayColor].CGColor;
        self.imageURLView.layer.borderWidth = 2.0f;
        self.imageURLView.layer.shadowColor = [UIColor lightGrayColor].CGColor;
        self.imageURLView.layer.shadowOffset = CGSizeMake(10, 5);
        self.imageURLView.layer.shadowRadius = 5.0f;
        self.imageURLView.layer.shadowOpacity = 0.3;
        [_btnVerMas setFrame:CGRectMake(self.view.layer.frame.size.width - 130, self.view.layer.frame.size.height - 70, 120, 60)];
    }
    
}

#pragma mark - SEGUE

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    if ([[segue identifier] isEqualToString:@"mapa_detalle"]) {
        MapaDetalleViewController *vc = (MapaDetalleViewController*)[segue destinationViewController];
        vc.strNombre = recurso.title;
        vc.gpsLat = [recurso.latitud stringValue];
        vc.gpsLong = [recurso.longitud stringValue];
        vc.type = recurso.type;
        vc.title = @"Mapa";
    }
}

#pragma mark - Other

- (IBAction)onClickBtnLink:(id)sender{
    WebViewController *viewController = [[WebViewController alloc] initWithNibName:@"WebViewController" bundle:nil];
    viewController.url = recurso.urlRecurso;
    viewController.title = recurso.title;
    [self.navigationController pushViewController:viewController animated:YES];
}

- (IBAction)onClickBtnVerMas:(id)sender{
    WebViewController *viewController = [[WebViewController alloc] initWithNibName:@"WebViewController" bundle:nil];
    viewController.url = recurso.urlRecurso;
    viewController.title = recurso.title;
    [self.navigationController pushViewController:viewController animated:YES];
}

#pragma mark - Modal teléfono

- (IBAction)onClickBtnTelefono:(id)sender
{
    _btnTelefono.enabled = NO;
    _btnEmail.enabled = NO;
    _btnWeb.enabled = NO;
    _btnFavorito.enabled = NO;
    _btnCompartir.enabled = NO;
    _modalTelefono = [[ModalTelefono alloc] initWithTitle:@"ModalTelefono:" image:nil comesFrom:nil];
    _modalTelefono.delegate = self;
    _modalTelefono.center = CGPointMake(self.view.center.x, _btnCompartir.layer.frame.origin.y + _btnCompartir.layer.frame.size.height + 60);
    [self.view addSubview:_modalTelefono];
    [_modalTelefono show];
}

-(void) didCloseTelefono
{
    _btnTelefono.enabled = YES;
    _btnEmail.enabled = YES;
    _btnWeb.enabled = YES;
    _btnFavorito.enabled = YES;
    _btnCompartir.enabled = YES;
}

-(void) didSelectTelefono:(int)option
{
    _btnTelefono.enabled = YES;
    _btnEmail.enabled = YES;
    _btnWeb.enabled = YES;
    _btnFavorito.enabled = YES;
    _btnCompartir.enabled = YES;
    switch (option) {
        case 1:
            [self onClickBtnPhone];
            break;
        case 2:
            [self addContact];
            break;
        default:
            break;
    }
}

#pragma mark - Modal conectar METHODS

- (IBAction)onClickBtnConnect:(id)sender
{
    _btnTelefono.enabled = NO;
    _btnEmail.enabled = NO;
    _btnWeb.enabled = NO;
    _btnFavorito.enabled = NO;
    _btnCompartir.enabled = NO;
    _modalConectar = [[ModalConectar alloc] initWithTitle:@"ModalConectar:" image:nil comesFrom:@"detalle"];
    _modalConectar.delegate = self;
    _modalConectar.center = CGPointMake(self.view.center.x, _btnCompartir.layer.frame.origin.y + _btnCompartir.layer.frame.size.height + 60);
    [self.view addSubview:_modalConectar];
    [_modalConectar show];
}

- (void) didCloseConectar
{
    _btnTelefono.enabled = YES;
    _btnEmail.enabled = YES;
    _btnWeb.enabled = YES;
    _btnFavorito.enabled = YES;
    _btnCompartir.enabled = YES;
}
- (void) didSelectConect:(int) option
{
    _btnTelefono.enabled = YES;
    _btnEmail.enabled = YES;
    _btnWeb.enabled = YES;
    _btnFavorito.enabled = YES;
    _btnCompartir.enabled = YES;
    switch (option) {
        case 1:
            [self onClickBtnFacebook];
            break;
        case 2:
            [self onClickBtnTwitter];
            break;
        default:
            break;
    }
}

#pragma mark - TWITTER ACTION

- (void)onClickBtnTwitter
{
    TWTweetComposeViewController *twitter = [[TWTweetComposeViewController alloc] init];
    NSString *msgTwitter = [NSString stringWithFormat:@"%@ %@", tweet_message, recurso.urlRecurso];
    [twitter setInitialText:msgTwitter];
    [twitter addImage:[UIImage imageNamed:@"twitter.png"]];
    [self presentViewController:twitter animated:YES completion:nil];
        
    twitter.completionHandler = ^(TWTweetComposeViewControllerResult res) {
        if(res == TWTweetComposeViewControllerResultDone) {
            UIAlertView* alertView = [[UIAlertView alloc] initWithTitle:strTweetSuccessTitle message:strTweetSuccess delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil];
            [alertView show];
        } else if(res == TWTweetComposeViewControllerResultCancelled) {
            UIAlertView* alertView = [[UIAlertView alloc] initWithTitle:strTweetErrorTitle message:strTweetError delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil];
            [alertView show];
        }
        [self dismissModalViewControllerAnimated:YES];
    };
}

- (void)onClickBtnFacebook
{
    // Create the parameters dictionary that will keep the data that will be posted.
    NSMutableDictionary* params = [NSMutableDictionary dictionaryWithObjectsAndKeys:
                                  fb_appId, @"app_id",
                                   recurso.urlRecurso, @"link",
                                   recurso.imageURL, @"picture",
                                   recurso.title, @"name",
                                   @"Comparte Euskadi", @"caption",
                                   @"Descarga la aplicación iEuskadi en http://", @"description",
                                   nil];
    [facebook dialog:@"feed" andParams:params andDelegate:self];
}

- (IBAction)onClickBtnMapa:(id)sender
{
    [self performSegueWithIdentifier:@"mapa_detalle" sender:self];
}

- (IBAction)onClickBtnOpciones:(id)sender
{
    _accionesDetalle = [[AccionesDetalle alloc] initWithTitle:@"AccionesDetalle:" image:nil];
    _accionesDetalle.delegate = self;
    _accionesDetalle.center = self.view.center;
    _btnOpciones.enabled = NO;
    
    [self.view addSubview:_accionesDetalle];
    [_accionesDetalle show];
}

-(void) didClose{
    _btnOpciones.enabled = YES;
}

- (void) didSelect:(int) option{
    _btnOpciones.enabled = YES;
	if(option==2)
		[self onClickBtnMail:nil];   
	else if(option==3)
		[self onClickBtnLink:nil];   
    else if(option==4)
		[self onClickBtnTwitter:nil];  
    else if(option==5)
		[self onClickBtnFacebook:nil];
    else if(option==6)
		[self onClickBtnMapa:nil]; 

    
}

-(IBAction)addFavorites:(id)sender{
    NSError *error = nil;
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];  
    NSString *strLang = [defaults objectForKey:@"AppLanguage"];
    
    if (![self existsInDB:[NSNumber numberWithInt:[recurso.id_recurso intValue]] language:strLang]){
    
        NSManagedObjectContext *context = [(AppDelegate *)[[UIApplication sharedApplication] delegate] managedObjectContext]; 
        RecursoDB *managedRecursos = [NSEntityDescription insertNewObjectForEntityForName:@"RecursoDB" inManagedObjectContext:context];
        [managedRecursos setIdRec:[NSNumber numberWithInt:[recurso.id_recurso intValue]]];
        [managedRecursos setImageURL:recurso.imageURL];
        [managedRecursos setLatitud:recurso.latitud];
        [managedRecursos setLongitud:recurso.longitud];
        [managedRecursos setMail:recurso.mail];
        [managedRecursos setTelefono:recurso.telefono];
        [managedRecursos setTitle:recurso.title];
        [managedRecursos setType:recurso.type];
        [managedRecursos setUrl:recurso.urlRecurso];
        [managedRecursos setDesc:recurso.desc];
        [managedRecursos setLang:strLang];

        if (![context save:&error]) 
        {
            NSLog(@"Unresolved error %@, %@", error, [error userInfo]);
            abort();
        }
        UIAlertView *alertOnChoose = [[UIAlertView alloc] initWithTitle:strAnadirFavorito message:nil delegate:self cancelButtonTitle:nil otherButtonTitles:@"Ok", nil];
        [alertOnChoose show];
        [_btnFavorito setImage:[UIImage imageNamed:@"btnDetalleFavoritosAmarillo"] forState:UIControlStateNormal];
    }else{
        UIAlertView *alertOnChoose = [[UIAlertView alloc] initWithTitle:strAnadirFavoritoExiste message:nil delegate:self cancelButtonTitle:nil otherButtonTitles:@"Ok", nil];
        [alertOnChoose show];
    }
}

-(void)addContact{
    ABRecordRef aRecord = ABPersonCreate(); 
    CFErrorRef  anError = NULL;
    
    // Username
    ABRecordSetValue(aRecord, kABPersonFirstNameProperty, (__bridge CFTypeRef)(recurso.title), &anError);
    
    // Phone Number.
    ABMutableMultiValueRef multi = ABMultiValueCreateMutable(kABMultiStringPropertyType);
    ABMultiValueAddValueAndLabel(multi, (__bridge CFStringRef)recurso.telefono, kABWorkLabel, NULL);
    ABRecordSetValue(aRecord, kABPersonPhoneProperty, multi, &anError);
    CFRelease(multi);
    
    // email
    ABMutableMultiValueRef multiemail = ABMultiValueCreateMutable(kABMultiStringPropertyType);
    ABMultiValueAddValueAndLabel(multiemail, (__bridge CFStringRef)recurso.mail, kABWorkLabel, NULL);
    ABRecordSetValue(aRecord, kABPersonEmailProperty, multiemail, &anError);
    CFRelease(multiemail);
    
    // website
    ABMutableMultiValueRef multiweb = ABMultiValueCreateMutable(kABMultiStringPropertyType);
    ABMultiValueAddValueAndLabel(multiweb, (__bridge CFStringRef)recurso.urlRecurso, kABWorkLabel, NULL);
    ABRecordSetValue(aRecord, kABPersonURLProperty, multiweb, &anError);
    CFRelease(multiemail);
    
    // Function
    //ABRecordSetValue(aRecord, kABPersonJobTitleProperty, userrole, &anError);
    
    if (anError != NULL)
        NSLog(@"error while creating..");
    
    CFStringRef personname, personcompind, personemail, personfunction,  personwebsite, personcontact;
    
    personname = ABRecordCopyValue(aRecord, kABPersonFirstNameProperty); 
    personcompind = ABRecordCopyValue(aRecord, kABPersonDepartmentProperty); 
    personfunction = ABRecordCopyValue(aRecord, kABPersonJobTitleProperty); 
    personemail = ABRecordCopyValue(aRecord, kABPersonEmailProperty);
    personwebsite = ABRecordCopyValue(aRecord, kABPersonURLProperty);
    personcontact  = ABRecordCopyValue(aRecord, kABPersonPhoneProperty); 
    
    ABAddressBookRef addressBook; 
    CFErrorRef error = NULL;
    addressBook = ABAddressBookCreate();

    __block BOOL accessGranted = NO;
    
    if (ABAddressBookRequestAccessWithCompletion != NULL) { // we're on iOS 6
        dispatch_semaphore_t sema = dispatch_semaphore_create(0);
        ABAddressBookRequestAccessWithCompletion(addressBook, ^(bool granted, CFErrorRef error) {
            accessGranted = granted;
            dispatch_semaphore_signal(sema);
        });
        dispatch_semaphore_wait(sema, DISPATCH_TIME_FOREVER);
        dispatch_release(sema);
    } else { // we're on iOS 5 or older
        accessGranted = YES;
    }
    
    if (accessGranted) {
        //BOOL isAdded = ABAddressBookAddRecord (addressBook, aRecord, &error);
        if (error != NULL) {
            NSLog(@"ABAddressBookAddRecord %@", error);
        }
        error = NULL;
        
        BOOL isSaved = ABAddressBookSave (addressBook, &error);
        if(isSaved) {
            UIAlertView *alertOnChoose = [[UIAlertView alloc] initWithTitle:strAnadirContacto message:nil delegate:self cancelButtonTitle:nil otherButtonTitles:@"Ok", nil];
            [alertOnChoose show];
        }
        if (error != NULL) {
            
            UIAlertView *alertOnChoose = [[UIAlertView alloc] initWithTitle:strAnadirContactoError message:nil delegate:self cancelButtonTitle:nil otherButtonTitles:@"Ok", nil];
            [alertOnChoose show];
        }
    }
    CFRelease(aRecord);
    CFRelease(personname);
    CFRelease(personcontact);
    CFRelease(personemail);
    CFRelease(personwebsite);  
    CFRelease(addressBook);
}

- (BOOL) existsInDB:(NSNumber *) recursoID language:(NSString *)lang{
    
    BOOL bolExis = NO;
	AppDelegate *appDelegate = [[UIApplication sharedApplication] delegate];
    //Delete current all area data since we got new data from server
	NSFetchRequest * dbRecursos = [[NSFetchRequest alloc] init];
	[dbRecursos setEntity:[NSEntityDescription entityForName:@"RecursoDB" inManagedObjectContext:appDelegate.managedObjectContext]];
	[dbRecursos setIncludesPropertyValues:YES]; //only fetch the managedObjectID
	
	NSError * error = nil;
	NSArray * RecursosArr = [appDelegate.managedObjectContext executeFetchRequest:dbRecursos error:&error]; 
          
	//error handling goes here
	for (int i = 0; i<[RecursosArr count]; i++) {
		
        RecursoDB *rec = [RecursosArr objectAtIndex:i];
        if ([rec.idRec isEqualToNumber:recursoID] && [rec.lang isEqualToString:lang]){
            bolExis = YES;
        }
    }
    return bolExis;
}


#pragma mark - MAILER METHODS


- (IBAction)onClickBtnMail:(id)sender
{
    Class mailClass = (NSClassFromString(@"MFMailComposeViewController"));
    if (mailClass != nil) {
        if ([mailClass canSendMail])
            [self displayComposerSheet];
        else {
            UIAlertView *error = [[UIAlertView alloc] initWithTitle:strMessageErrorTitle message:strMessageError delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
            [error show];
        }
    }
    else {
        UIAlertView *error = [[UIAlertView alloc] initWithTitle:strMessageErrorTitle message:strMessageError delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
        [error show];
    }
}

- (void) displayComposerSheet {
    MFMailComposeViewController *picker = [[MFMailComposeViewController alloc] init];
    picker.mailComposeDelegate = self;
    NSArray *toRecipients = [NSArray arrayWithObject:recurso.mail];
    [picker setToRecipients:toRecipients];
    [picker setSubject:mail_Subject];
    [self presentModalViewController:picker animated:YES];
}

- (void)mailComposeController:(MFMailComposeViewController *)controller didFinishWithResult:(MFMailComposeResult)result error:(NSError *)error {
	if (result == MFMailComposeResultSent){
		UIAlertView *Notpermitted=[[UIAlertView alloc] initWithTitle:strMailEnviado message:strMailEnviadoMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
        [Notpermitted show];
	} else if (result == MFMailComposeResultFailed){
		UIAlertView *Notpermitted=[[UIAlertView alloc] initWithTitle:strMailNoEnviado message:strMailNoEnviadoMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
        [Notpermitted show];
	}
    [self dismissModalViewControllerAnimated:YES];
}

- (void)onClickBtnPhone{
    UIDevice *device = [UIDevice currentDevice];
    if ([[device model] isEqualToString:@"iPhone"] ) {
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:[NSString stringWithFormat:@"tel:%@", recurso.telefono]]];
    } else {
        UIAlertView *Notpermitted=[[UIAlertView alloc] initWithTitle:@"Alert" message:@"Your device doesn't support this feature." delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
        [Notpermitted show];
    }
}


#pragma mark - Funciones de traducción


-(void) recargarLiterales{
    
    strMessageErrorTitle = [traducirLiteral languageSelectedStringForKey:@"ERRORENVIOCABECERA"];
    strMessageError = [traducirLiteral languageSelectedStringForKey:@"ERRORENVIOCUERPO"];
    strTweetError = [traducirLiteral languageSelectedStringForKey:@"TWEETERROR"];
    strTweetSuccess = [traducirLiteral languageSelectedStringForKey:@"TWEETSUCCESS"];
    strTweetErrorTitle = [traducirLiteral languageSelectedStringForKey:@"TWEETERRORTITLE"];
    strTweetSuccessTitle = [traducirLiteral languageSelectedStringForKey:@"TWEETERRORTITLE"];
    strMailEnviado = [traducirLiteral languageSelectedStringForKey:@"MAILENVIADO"];
    strMailNoEnviado = [traducirLiteral languageSelectedStringForKey:@"MAILNOENVIADO"];
    strMailEnviadoMessage = [traducirLiteral languageSelectedStringForKey:@"MAILENVIADOMESSAGE"];
    strMailNoEnviadoMessage = [traducirLiteral languageSelectedStringForKey:@"MAILNOENVIADOMESSAGE"];
    strAnadirFavorito = [traducirLiteral languageSelectedStringForKey:@"ANADIRFAVORITO"];
    strAnadirFavoritoExiste = [traducirLiteral languageSelectedStringForKey:@"ANADIRFAVORITOEXISTE"];
    strAnadirContacto = [traducirLiteral languageSelectedStringForKey:@"ANADIRCONTACTO"];
    strAnadirContactoError = [traducirLiteral languageSelectedStringForKey:@"ANADIRCONTACTOERROR"];
}


@end
