//
//  DetalleRecursoViewController.h
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 30/05/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "RecursoTuristico.h"
#import "WebViewController.h"
#import "MessageUI/MessageUI.h"
#import "MessageUI/MFMailComposeViewController.h"
#import "Twitter/Twitter.h"
#import "FBConnect.h"
#import "Facebook.h"
#import "traducirLiteral.h"
#import "AccionesDetalle.h"
#import "MapaDetalleViewController.h"
#import "ModalConectar.h"
#import "ModalTelefono.h"

//Literales mail
#define mail_Subject                @"[iEuskadi]"
#define mail_Recipient              @"g.torresayastuy@gmail.com"

//Literales Twitter
#define tweet_message               @"#iEuskadi "

//app id Facebook
#define fb_appId                    @"212860918835240"

@interface DetalleRecursoViewController : UIViewController <MFMailComposeViewControllerDelegate, FBSessionDelegate, FBRequestDelegate, FBDialogDelegate, AccionesDetalleDelegate, ModalConectarDelegate, ModalTelefonoDelegate>{

    RecursoTuristico *recurso;
    
    UIButton *_btnOpciones;
    
    //Nuevos botones Batura
    UIButton *_btnTelefono;
    UIButton *_btnEmail;
    UIButton *_btnWeb;
    UIButton *_btnFavorito;
    UIButton *_btnCompartir;
    UIButton *_btnVerMas;
    
    NSString *strMessageErrorTitle;
    NSString *strMessageError;
    NSString *strTweetError;
    NSString *strTweetSuccess;
    NSString *strTweetErrorTitle;
    NSString *strTweetSuccessTitle;
    NSString *strMailEnviado;
    NSString *strMailNoEnviado;
    NSString *strMailEnviadoMessage;
    NSString *strMailNoEnviadoMessage;
    NSString *strAnadirFavorito;
    NSString *strAnadirFavoritoExiste;
    NSString *strAnadirContacto;
    NSString *strAnadirContactoError;
    
    Facebook *facebook;
    
    AccionesDetalle *_accionesDetalle;
    
    ModalConectar *_modalConectar;
    ModalTelefono *_modalTelefono;
}

@property(nonatomic, strong) RecursoTuristico *recurso;

@property(nonatomic, strong) IBOutlet UIImageView *imageURLView;
@property(nonatomic, strong) IBOutlet UILabel *lblTitle;
@property(nonatomic, strong) IBOutlet UITextView *textView;

@property (nonatomic, strong) WebViewController *webView;
@property (strong, nonatomic) Facebook *facebook;

//Métodos
- (IBAction)onClickBtnLink:(id)sender;
- (IBAction)onClickBtnMail:(id)sender;
- (void)onClickBtnPhone;
- (IBAction)onClickBtnTwitter:(id)sender;
- (IBAction)onClickBtnFacebook:(id)sender;
- (IBAction)onClickBtnOpciones:(id)sender;
- (IBAction)onClickBtnConnect:(id)sender;
- (IBAction)onClickBtnTelefono:(id)sender;
- (IBAction)onClickBtnVerMas:(id)sender;
- (void) displayComposerSheet;

@end
