//
//  BMNavigationBar.m
//  iNVASIVE
//
//  Created by Jon Arrien  Fernández on 02/08/11.
//  Copyright 2011 Bilbomatica. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>
#import "BMNavigationBar.h"

@implementation BMNavigationBar

- (id)init
{
    self = [super init];
    if (self) {
        // Initialization code here.
    }
    return self;
}


- (void) drawRect:(CGRect)rect
{
	[super drawRect:rect];
    if ([[[UIDevice currentDevice] systemVersion] floatValue] < 7.0) {
        UIColor *color = [UIColor colorWithRed:0.0/255.0 green:82.0/255.0 blue:155.0/255.0f alpha:1.0];
        self.tintColor = color;
        [[UINavigationBar appearance] setTintColor:color];
    } else {
        self.tintColor = [UIColor whiteColor];
    }
}

- (void)dropShadowWithOffset:(CGSize)offset radius:(CGFloat)radius color:(UIColor *)color opacity:(CGFloat)opacity
{
    CGMutablePathRef path = CGPathCreateMutable();
    CGPathAddRect(path, NULL, self.bounds);
    self.layer.shadowPath = path;
    CGPathCloseSubpath(path);
    CGPathRelease(path);
    
    self.layer.shadowColor = color.CGColor;
    self.layer.shadowOffset = offset;
    self.layer.shadowRadius = radius;
    self.layer.shadowOpacity = opacity;
    self.clipsToBounds = NO;
}

@end
