//
//  BMActivityIndicator.m
//  iNVASIVE
//
//  Created by Jon Arrien on 13/10/11.
//  Copyright (c) 2011 __MyCompanyName__. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>
#import "BMActivityIndicator.h"

@implementation BMActivityIndicator


- (id) initWithPoint:(CGPoint)center withSquare:(CGSize)size
{
    [self recargarLiterales];
    
    float x, y;
    x = center.x - (size.width/2);
    y = center.y - (size.height/2);
	
    self = [super initWithFrame:CGRectMake(x, y, size.width, size.height)];
    if (self){
    
        self.backgroundColor = [UIColor colorWithRed:0.0 green:0.0 blue:0.0 alpha:0.7f];
        self.layer.cornerRadius = 10.0f;
        self.layer.borderColor = [UIColor darkGrayColor].CGColor;
        self.layer.borderWidth = 2.0f;
        self.layer.masksToBounds = YES;
        self.alpha = 1.0;
        self.clipsToBounds = YES;

        UILabel	*label = [[UILabel alloc] initWithFrame: CGRectMake(0, size.height-20, size.width, 15)];
        label.text = strMensaje;
        label.backgroundColor = [UIColor clearColor];
        label.textColor = [UIColor whiteColor];
        label.textAlignment = UITextAlignmentCenter;
        label.font = [UIFont boldSystemFontOfSize: 15];
        [self addSubview:label];
        
        UIActivityIndicatorView *activityIndicator = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhite];
        activityIndicator.center = CGPointMake(self.bounds.size.width/2, (self.bounds.size.height/2)-10);
        [activityIndicator startAnimating];
        [self addSubview:activityIndicator];
    }
            
    return self;
}

-(void) recargarLiterales{
    
    strMensaje = [traducirLiteral languageSelectedStringForKey:@"ACTIVITY"];
    
}

 
@end
