//
//  SeleccionIdioma.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 08/06/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "AccionesDetalle.h"
#import <QuartzCore/QuartzCore.h>

@implementation AccionesDetalle

@synthesize btnUrl, btnMail, btnCancel, btnTwitter, btnFacebook, btnMapa, delegate, btnTelefono, lblOpciones;

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
    }
    return self;
}

-(id) initWithTitle:(NSString *)title image:(UIImage*)_image{
    
    self = [super initWithFrame:CGRectMake(0, 0, 300, 180)];
    
    //self.layer.backgroundColor = [UIColor colorWithRed:0.2 green:0.4 blue:0.5 alpha:0.8f].CGColor;
    
    self.layer.cornerRadius = 10.0f;
    self.layer.borderColor = [UIColor darkTextColor].CGColor;
    self.layer.borderWidth = 1.0f;
    self.layer.masksToBounds = YES;
    self.alpha = 1.0f;
    
    int y = self.frame.origin.y +50;
    int y2 = self.frame.origin.y + 115;
    int alturaBoton = 54;
    int anchuraBoton = 54;
    
    //button cancel
    btnCancel = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnCancel setBackgroundImage:[UIImage imageNamed:@"iconCloseX.png"] forState:UIControlStateNormal];
    btnCancel.frame = CGRectMake(self.frame.size.width - (btnCancel.currentBackgroundImage.size.width)-5, 5, btnCancel.currentBackgroundImage.size.width, btnCancel.currentBackgroundImage.size.height);
    [btnCancel addTarget:self action:@selector(cancelAndClose:) forControlEvents:UIControlEventTouchUpInside];
    [self insertSubview:btnCancel aboveSubview:self];
    
    //button euskera
    btnTelefono = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnTelefono setBackgroundImage:[UIImage imageNamed:@"btnPhone2.png"] forState:UIControlStateNormal];
    btnTelefono.frame = CGRectMake(31, y, anchuraBoton, alturaBoton);
    [btnTelefono addTarget:self action:@selector(onClickTelefono:) forControlEvents:UIControlEventTouchUpInside];
    //btnTelefono.layer.borderWidth = 2.0f;
    //btnTelefono.layer.borderColor = [UIColor blackColor].CGColor;
    //btnTelefono.layer.cornerRadius = 25;
    [self insertSubview:btnTelefono aboveSubview:self];
    
    //label euskera
    lblOpciones = [[UILabel alloc] initWithFrame:CGRectMake(110, 5, 150, 30)];
    //[lblEuskera setText:@"Euskera"];
    lblOpciones.font = [UIFont fontWithName:@"Verdana-Bold" size:17];
    lblOpciones.backgroundColor = [UIColor clearColor];
    [lblOpciones setTextColor:[UIColor whiteColor]];
    [self insertSubview:lblOpciones aboveSubview:self];
    
    //button espanol
    btnMail = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnMail setBackgroundImage:[UIImage imageNamed:@"btnMail2.png"] forState:UIControlStateNormal];
    btnMail.frame = CGRectMake(123, y, anchuraBoton, alturaBoton);
    [btnMail addTarget:self action:@selector(onClickMail:) forControlEvents:UIControlEventTouchUpInside];
    //btnMail.layer.borderWidth = 2.0f;
    //btnMail.layer.borderColor = [UIColor blackColor].CGColor;
    //btnMail.layer.cornerRadius = 25;
    [self insertSubview:btnMail aboveSubview:self];
    
    //button ingles
    btnUrl = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnUrl setBackgroundImage:[UIImage imageNamed:@"btnLink2.png"] forState:UIControlStateNormal];
    btnUrl.frame = CGRectMake(213, y, anchuraBoton, alturaBoton);
    [btnUrl addTarget:self action:@selector(onClickUrl:) forControlEvents:UIControlEventTouchUpInside];
    //btnUrl.layer.borderWidth = 2.0f;
    //btnUrl.layer.borderColor = [UIColor blackColor].CGColor;
    //btnUrl.layer.cornerRadius = 25;
    [self insertSubview:btnUrl aboveSubview:self];
    
    //button frances
    btnTwitter = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnTwitter setBackgroundImage:[UIImage imageNamed:@"btnTwitter2.png"] forState:UIControlStateNormal];
    btnTwitter.frame = CGRectMake(31, y2, anchuraBoton, alturaBoton);
    [btnTwitter addTarget:self action:@selector(onClickTwitter:) forControlEvents:UIControlEventTouchUpInside];
    //btnTwitter.layer.borderWidth = 2.0f;
    //btnTwitter.layer.borderColor = [UIColor blackColor].CGColor;
    //btnTwitter.layer.cornerRadius = 25;
    [self insertSubview:btnTwitter aboveSubview:self];
    
    //button aleman
    btnFacebook = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnFacebook setBackgroundImage:[UIImage imageNamed:@"btnFacebook2.png"] forState:UIControlStateNormal];
    btnFacebook.frame = CGRectMake(123, y2, anchuraBoton, alturaBoton);
    [btnFacebook addTarget:self action:@selector(onClickFacebook:) forControlEvents:UIControlEventTouchUpInside];
    //btnFacebook.layer.borderWidth = 2.0f;
    //btnFacebook.layer.borderColor = [UIColor blackColor].CGColor;
    //btnFacebook.layer.cornerRadius = 25;
    [self insertSubview:btnFacebook aboveSubview:self];
    
    //button aleman
    btnMapa = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnMapa setBackgroundImage:[UIImage imageNamed:@"btnMapa.png"] forState:UIControlStateNormal];
    btnMapa.frame = CGRectMake(213, y2, anchuraBoton, alturaBoton);
    [btnMapa addTarget:self action:@selector(onClickMapa:) forControlEvents:UIControlEventTouchUpInside];
    //btnFacebook.layer.borderWidth = 2.0f;
    //btnFacebook.layer.borderColor = [UIColor blackColor].CGColor;
    //btnFacebook.layer.cornerRadius = 25;
    [self insertSubview:btnMapa aboveSubview:self];
    
    [self recargarLiterales];
    
    self.transform = CGAffineTransformMakeScale(1.0, 0.1);
    
    return self;
}

-(void)show
{
    
    [UIView beginAnimations:@"playAnimation" context:nil];
    [UIView setAnimationDuration:0.5f];
    self.transform = CGAffineTransformMakeScale(1.0, 1.0);
    [UIView commitAnimations];
    
}

-(IBAction)cancelAndClose:(id)sender{
    
    [UIView setAnimationDuration:0.5f];
    self.transform = CGAffineTransformMakeScale(0.1, 0.1);
    [UIView commitAnimations];
    [delegate didClose];
    
    [self removeFromSuperview];
    
}

-(IBAction)onClickTelefono:(id)sender{
    [delegate didSelect:1];
    [self removeFromSuperview];
    
}

-(IBAction)onClickMail:(id)sender{
    [delegate didSelect:2];
    [self removeFromSuperview];
    
}

-(IBAction)onClickUrl:(id)sender{
    [delegate didSelect:3];
    [self removeFromSuperview];
    
}

-(IBAction)onClickTwitter:(id)sender{
    [delegate didSelect:4];
    [self removeFromSuperview];
    
}

-(IBAction)onClickFacebook:(id)sender{
    [delegate didSelect:5];
    [self removeFromSuperview];
    
}

-(IBAction)onClickMapa:(id)sender{
    [delegate didSelect:6];
    [self removeFromSuperview];
    
}

-(void) recargarLiterales{
    
    [lblOpciones setText:[traducirLiteral languageSelectedStringForKey:@"OPCIONES"]];  
    
}

- (void)drawRect:(CGRect)rect 
{
    CGContextRef currentContext = UIGraphicsGetCurrentContext();
    
    CGGradientRef glossGradient;
    CGColorSpaceRef rgbColorspace = NULL;
    size_t num_locations = 2;
    CGFloat locations[2] = { 0.0, 1.0 };
    CGFloat components[8] = { 0.08, 0.28, 0.38, 1.0,  // Start color
        0.2, 0.4, 0.5, 1.0 }; // End color

    rgbColorspace = CGColorSpaceCreateDeviceRGB();
    glossGradient = CGGradientCreateWithColorComponents(rgbColorspace, components, locations, num_locations);
    
    CGRect currentBounds = self.bounds;
    CGPoint topCenter = CGPointMake(CGRectGetMidX(currentBounds), 0.0f);
    CGPoint midCenter = CGPointMake(CGRectGetMidX(currentBounds), CGRectGetMaxY(currentBounds));
    CGContextDrawLinearGradient(currentContext, glossGradient, topCenter, midCenter, 0);
    
    CGGradientRelease(glossGradient);
    CGColorSpaceRelease(rgbColorspace); 
}

@end
