package net.euskadi.turismo.app.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class Utils {
	
	private static Utils instance = null;

	public static Utils getInstance() {
		if (instance == null) {
			instance = new Utils();
		}
		return instance;
	}

	
	/**
	 * check data connection, if no connection return false
	 * 
	 * @param context
	 * 
	 * @return boolean
	 */
	public boolean isOnline(Context context) {
		if (null == context)
			return false;

		ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
		
		NetworkInfo netInfo = cm.getActiveNetworkInfo();

		if (netInfo != null && netInfo.isConnected()/*isConnectedOrConnecting()*/) {
			cm = null;
			netInfo = null;
			
			return true;
		}		
		cm = null;
		netInfo = null;
		return false;
	}
	

	public static void GPSActivo(Activity act){
        LocationManager locManager = (LocationManager)act.getSystemService(android.content.Context.LOCATION_SERVICE);
        //Comporbar si esta activado el GPS
        if (!locManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
            //Ir a activar el GPS
            Intent settingsIntent = new Intent(android.provider.Settings.ACTION_LOCATION_SOURCE_SETTINGS);
            settingsIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED);
            act.startActivity(settingsIntent); 
    	}
	}
	
	public Drawable createDrawableFromURL(String urlString) {
		Drawable image = null;
		try {
			URL url = new URL(urlString);
			InputStream is = (InputStream) url.getContent();
			image = Drawable.createFromStream(is, "src");
			return image;
		} catch (MalformedURLException e) {
			e.printStackTrace();
			return null;
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}
	   
   public static float getDistance(double lngA, double latA, double lngB, double latB){
	   
	   Location locationA = new Location("point A");
	   locationA.setLatitude(latA);
	   locationA.setLongitude(lngA);

	   Location locationB = new Location("point B");
	   locationB.setLatitude(latB);
	   locationB.setLongitude(lngB);

	   float distance = locationA.distanceTo(locationB);
	   return distance;
   }
   
   public String supportLang (Context context){
       Configuration config = context.getResources().getConfiguration();
       String[] strLanguages = new String[]{"es", "eu", "en", "fr", "de"};
       if (config.locale.getLanguage().equalsIgnoreCase("") || (!Arrays.asList(strLanguages).contains(config.locale.getLanguage()))){
           Locale locale = new Locale("en");
           Locale.setDefault(locale);
           config.locale = locale;           
       }       
       SharedPreferences pref = context.getSharedPreferences("MisPreferencias", Context.MODE_PRIVATE);
       String strIdioma = pref.getString("langApp", config.locale.getLanguage());
       return strIdioma;
   }
	   
}
