package net.euskadi.turismo.app.util;

import net.euskadi.turismo.app.R;
import android.content.Context;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.LinearLayout;



public class SegmentedButton extends LinearLayout implements OnClickListener{

	private Context parent;
	private int selected;
	private SegmentedButtonCallback mCallback;
	
	public SegmentedButton(Context context, SegmentedButtonCallback callback) {
		super(context);
		this.setOrientation(HORIZONTAL);
		this.parent = context;
		mCallback = callback;
	}
	
	public void setSelected(int index)
	{
		selected = index;
		setResources();
	}
	
	public int getSelected()
	{
		return selected;
	}

	public void AddButton(String text)
	{
		Button newButton = new Button(parent);
		newButton.setText(text);
		newButton.setTextSize(12);
		newButton.setTextAppearance(getContext(), R.style.normalText);
		newButton.setOnClickListener(this);
		newButton.setTag(Integer.valueOf(this.getChildCount()));
		this.addView(newButton);
		setResources();
	}
	
	private void setResources()
	{
		int numChild = this.getChildCount();
		if (numChild == 2)
		{
			//left button gets left resource, right button gets right resource
			Button leftButton = (Button)this.getChildAt(0);
			if(selected == 0)
			{
				leftButton.setBackgroundResource(R.drawable.segmented_button_selected_left);
				Button rightButton = (Button)this.getChildAt(1);
				rightButton.setBackgroundResource(R.drawable.segmented_button_notselected_right);
			}
			else
			{
				leftButton.setBackgroundResource(R.drawable.segmented_button_notselected_left);
				Button rightButton = (Button)this.getChildAt(1);
				rightButton.setBackgroundResource(R.drawable.segmented_button_selected_right);
			}
		}
		else if (numChild > 2)
		{
			//left button gets left resource, right button gets right resource
			//and middle buttons get middle resources
			Button leftButton = (Button)this.getChildAt(0);
			if(selected == 0)
				leftButton.setBackgroundResource(R.drawable.segmented_button_selected_left);
			else
				leftButton.setBackgroundResource(R.drawable.segmented_button_notselected_left);
			
			for(int x = 1; x < numChild-1; x++)
			{
				Button midButton = (Button)this.getChildAt(x);
				if(selected == x)
					midButton.setBackgroundResource(R.drawable.segmented_button_selected_center);
				else
					midButton.setBackgroundResource(R.drawable.segmented_button_notselected_center);
			}
			Button rightButton = (Button)this.getChildAt(numChild-1);
			if(selected == numChild-1)
				rightButton.setBackgroundResource(R.drawable.segmented_button_selected_right);
			else
				rightButton.setBackgroundResource(R.drawable.segmented_button_notselected_right);
		}
	}

	@Override
	public void onClick(View view) 
	{
		selected = ((Integer)view.getTag()).intValue();
		setResources();
		mCallback.OnSelectionChanged(selected);
	}
	
	public interface SegmentedButtonCallback
	{
		public void OnSelectionChanged(int selected);
	}
}
