package net.euskadi.turismo.app.recursos;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Locale;

import net.euskadi.turismo.app.MainActivity;
import net.euskadi.turismo.app.R;
import net.euskadi.turismo.app.data.MyDB;
import net.euskadi.turismo.app.util.Utils;
import net.euskadi.turismo.app.valueObjects.Recurso;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;

import android.content.Intent;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.actionbarsherlock.app.SherlockFragment;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;
import com.actionbarsherlock.widget.ShareActionProvider;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient.ConnectionCallbacks;
import com.google.android.gms.common.GooglePlayServicesClient.OnConnectionFailedListener;
import com.google.android.gms.location.LocationClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;

public class ViewerFragment extends SherlockFragment 
	implements 
	ConnectionCallbacks,
	OnConnectionFailedListener,
	LocationListener {
    
    private LocationClient mLocationClient;
    protected Location ubicacionRecibida;	//usada para recibir la ultima ubicacin desde la actividad que nos llama.

	final String LOG_TITLE = this.getClass().getName();
    private WebView viewer = null;
    ImageView imageIV;
    private ShareActionProvider mShareActionProvider;
    Recurso recSeleccionado = new Recurso();

	// Settings para actualizaciones de la localizacin. Los rangos mximos posibles actualmente.
    private static final LocationRequest REQUEST = LocationRequest.create()
            .setInterval(5000)         // 5 seconds
            .setFastestInterval(16)    // 16ms = 60fps
            .setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);
    
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
	        Bundle savedInstanceState) {
		super.onCreateView(inflater, container, savedInstanceState);	
	    //Intent launchingIntent = getActivity().getIntent();
	    //String content = launchingIntent.getData().toString();
	    //WebView viewer = (WebView) inflater.inflate(R.layout.tut_view, container, false);
	    //viewer.loadUrl(content);
        
        viewer = (WebView) inflater.inflate(R.layout.detalle_recurso, container, false);        
        return viewer;
	}

	   /** This is where we perform additional setup for the fragment that's either
     * not related to the fragment's layout or must be done after the layout is drawn.
     */
	
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
	  // refresh your views here
	  super.onConfigurationChanged(newConfig);
      String lang = Utils.getInstance().supportLang(getActivity());
      newConfig.locale = new Locale(lang);
      Locale.setDefault(newConfig.locale);
      getActivity().getBaseContext().getResources().updateConfiguration(newConfig, getActivity().getBaseContext().getResources().getDisplayMetrics());

	  Log.v("ViewerFragment","ViewerFragment:locale:"+newConfig.locale.getLanguage());
	  
	}
	
    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        setHasOptionsMenu(true);
        // Current position and UI visibility should survive screen rotations.
        if (savedInstanceState != null) {
            // Restoring these members is not necessary when this fragment
            // is combined with the ListaFragment, because when the ListaFragment
            // is restored, it selects the appropriate item and sends the event
            // to the updateRecurso() method itself
        	recSeleccionado = (Recurso)savedInstanceState.getSerializable("listRecurso");
            updateRecurso(recSeleccionado);
        }
    }
    
    public void updateRecurso(Recurso recurso) {
    	recSeleccionado = recurso;
        if (viewer != null) {
            if(recSeleccionado.getImagenRecurso()!=null){
            	imageIV = (ImageView) viewer.findViewById(R.id.imageViewFoto);        	
    	        new DownloadImageTask().execute(recSeleccionado.getImagenRecurso());
            }else{
            	imageIV.setVisibility(View.GONE);
            }
            
        	/*ImageView imageLocation = (ImageView) viewer.findViewById(R.id.imageLocation);
        	imageLocation.setVisibility(View.GONE);
        	TextView textLocation = (TextView) viewer.findViewById(R.id.textLocation);
        	textLocation.setVisibility(View.GONE);
                   
            if(recurso.getTelRecurso()!=null){
            	TextView textTelfono = (TextView) viewer.findViewById(R.id.textTelefono);
            	textTelfono.setText(recurso.getTelRecurso());
            }else{
            	ImageView imageTelef = (ImageView) viewer.findViewById(R.id.imageTelefono);        	
            	imageTelef.setVisibility(View.GONE);
            	TextView textTelfono = (TextView) viewer.findViewById(R.id.textTelefono);
            	textTelfono.setVisibility(View.GONE);
        	}
            if(recurso.getMailRecurso()!=null){
            	TextView textMail = (TextView) viewer.findViewById(R.id.textMail);
            	textMail.setText(recurso.getMailRecurso());
            }else{
            	ImageView imageMail = (ImageView) viewer.findViewById(R.id.imageMail);
            	imageMail.setVisibility(View.GONE);
            	TextView textMail = (TextView) viewer.findViewById(R.id.textMail);
            	textMail.setVisibility(View.GONE);
        	}
            if(recurso.getUrlRecurso()!=null){
            	TextView textWeb = (TextView) viewer.findViewById(R.id.textWeb);
            	textWeb.setText(recurso.getUrlRecurso());
            }else{
            	TextView textWeb = (TextView) viewer.findViewById(R.id.textWeb);
            	textWeb.setVisibility(View.GONE);
            	ImageView imageWeb = (ImageView) viewer.findViewById(R.id.imageWeb);
            	imageWeb.setVisibility(View.GONE);
        	}*/
            TextView titleTV = (TextView) viewer.findViewById(R.id.textViewTitulo);
            titleTV.setText(recSeleccionado.getNomRecurso());

            if(recurso.getDescRecurso()!=null){
            	TextView descTV = (TextView) viewer.findViewById(R.id.textViewDescripcion);
            	descTV.setText(recSeleccionado.getDescRecurso());
            }
            
            Button button = (Button) viewer.findViewById(R.id.buttonVermas);
            button.setOnClickListener(new View.OnClickListener() {
                public void onClick(View v) {
                	if(recSeleccionado.getUrlTurismo()!=null){
                		startActivity(new Intent(Intent.ACTION_VIEW).setData(Uri.parse(recSeleccionado.getUrlTurismo())));
                	}
                }
            });          

        }
    }
	
	private class DownloadImageTask extends AsyncTask<String, Void, Drawable>{
		
        protected Drawable doInBackground(String... urls) {
        	try {
	        	InputStream is = (InputStream) this.fetch(urls[0]);
				Drawable d = Drawable.createFromStream(is, "src");
				return d;
        	} catch (MalformedURLException e) {
    			e.printStackTrace();
    			return null;
    		} catch (IOException e) {
    			e.printStackTrace();
    			return null;
    		}
        }
        
        protected void onPostExecute(Drawable image) {
        	imageIV.setImageDrawable(image);
        }
        
        private InputStream fetch(String urlString) throws MalformedURLException, IOException {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            Uri uri = Uri.parse(urlString);
            //quitar los espacios en blanco
            HttpGet request = new HttpGet(uri.getScheme()+":"+uri.getSchemeSpecificPart().replaceAll(" ","%20"));
            HttpResponse response = httpClient.execute(request);
            return response.getEntity().getContent();
        }
        
		/*public Object fetch(String address) throws MalformedURLException,IOException {
			URL url = new URL(address);
			Object content = url.getContent();
			return content;
		}*/	
		
	}
	
	 @Override
	    public void onSaveInstanceState (Bundle outState) {
	        super.onSaveInstanceState(outState);
	        outState.putSerializable("listRecurso", recSeleccionado);
	    }
	
	//@Override
	public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {        
        inflater.inflate(R.menu.detalle_recurso, menu);
        
        /** Getting the actionprovider associated with the menu item whose id is share */
        mShareActionProvider = (ShareActionProvider) menu.findItem(R.id.ic_menu_share).getActionProvider();
 
        /** Getting the target intent */
        Intent intent = getDefaultShareIntent();
 
        /** Setting a share intent */
        if(intent!=null)
            mShareActionProvider.setShareIntent(intent);

        super.onCreateOptionsMenu(menu, inflater);
	}
			
	   
   /** Returns a share intent */
    private Intent getDefaultShareIntent(){
        Intent intent = new Intent(Intent.ACTION_SEND);
        intent.putExtra(Intent.EXTRA_SUBJECT, "[iEuskadi]");
        intent.putExtra(Intent.EXTRA_TEXT, recSeleccionado.getUrlRecurso());
        intent.setType("text/plain");        
        return intent;
    }

	 

    public boolean onOptionsItemSelected(MenuItem item) {
    	if (item.getItemId() == android.R.id.home) {
    		Intent intent = new Intent(getActivity(), MainActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
            startActivity(intent);
         } else if (item.getItemId() == R.id.favorite) {
        	anyadirRecursos();
        	Toast.makeText(getActivity(), R.string.anadirFavorito, Toast.LENGTH_SHORT).show();	
         } else if (item.getItemId() == R.id.location_web_site) {
        	 if(recSeleccionado.getUrlRecurso()!=null)
        		 startActivity(new Intent(Intent.ACTION_VIEW).setData(Uri.parse(recSeleccionado.getUrlRecurso())));	
         } else if (item.getItemId() == R.id.device_access_call) {
        	 if(recSeleccionado.getTelRecurso()!=null)
        	   startActivity(new Intent(Intent.ACTION_VIEW,Uri.parse("tel:"+recSeleccionado.getTelRecurso()+"")));
         } else if (item.getItemId() == R.id.new_email) {
        	 if(recSeleccionado.getMailRecurso()!=null){
        		 Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
        		 //quitar el mailto
        		 int indexStart = recSeleccionado.getMailRecurso().indexOf(":");        		 
        		 String aEmailList[] = {recSeleccionado.getMailRecurso().substring(indexStart+1)};
        		 emailIntent.putExtra(Intent.EXTRA_EMAIL, aEmailList);
        		 emailIntent.putExtra(Intent.EXTRA_SUBJECT, getResources().getString(R.string.email_subject));
        		 emailIntent.setType("message/rfc822");
        		 startActivity(Intent.createChooser(emailIntent, getResources().getString(R.string.chooser)));
        	 }
         } else if (item.getItemId() == R.id.social_add_person) {
        	 if(recSeleccionado.getTelRecurso()!=null || recSeleccionado.getMailRecurso()!=null){
             	Intent launchContactos = new Intent(getActivity(), ContactosRecurso.class);
             	launchContactos.putExtra("recursoObject", recSeleccionado);
 		    	startActivity(launchContactos);
			 }
         } else if (item.getItemId() == R.id.recurso_location) {
        	 Intent launchMapa = new Intent(getActivity(), MapLocalizacion.class);
        	 launchMapa.putExtra("recursoObject", recSeleccionado);
        	 launchMapa.putExtra("currentlocation", ubicacionRecibida);
		     startActivity(launchMapa);
         }
    	return super.onOptionsItemSelected(item);
    }    
	    
    private void anyadirRecursos(){
    	MyDB dba;
    	dba = new MyDB(getActivity());
    	dba.open();
    	Cursor c = dba.getRec(recSeleccionado.getCodRec());
    	if(c.getCount()==0){
    		c.close();
    		dba.insertRec(recSeleccionado);
    	}
    	dba.close();
    }


	@Override
	public void onPause() {
		super.onPause();
		
        if (mLocationClient != null) {
            mLocationClient.disconnect();
        }
		
	}

	@Override
	public void onResume() {
		super.onResume();
		
		Log.d(LOG_TITLE, "conectar el cliente de localizacion");
        setUpLocationClientIfNeeded();
        mLocationClient.connect();
	}

    private void setUpLocationClientIfNeeded() {
        if (mLocationClient == null) {
            mLocationClient = new LocationClient(
            		getActivity().getApplicationContext(),
                    this,  // ConnectionCallbacks
                    this); // OnConnectionFailedListener
        }
    }

    /**
     * Implementation of {@link LocationListener}.
     */
    @Override
    public void onLocationChanged(Location location) {
    	Log.d(LOG_TITLE, "Location = " + location);
    	
    	ubicacionRecibida = mLocationClient.getLastLocation();
//    	cargarRecursos();
    	
    }

    /**
     * Callback called when connected to GCore. Implementation of {@link ConnectionCallbacks}.
     */
    @Override
    public void onConnected(Bundle connectionHint) {
        mLocationClient.requestLocationUpdates(REQUEST, this);  // LocationListener
        
    }

    /**
     * Callback called when disconnected from GCore. Implementation of {@link ConnectionCallbacks}.
     */
    @Override
    public void onDisconnected() {
        // Do nothing
    }

    /**
     * Implementation of {@link OnConnectionFailedListener}.
     */
    @Override
    public void onConnectionFailed(ConnectionResult result) {
        // Do nothing
    }
    
	
	@Override
	public void onStop() {

        // If the client is connected
        if (mLocationClient.isConnected()) {
        	mLocationClient.removeLocationUpdates(this);	//stopPeriodicUpdates
        }

        // After disconnect() is called, the client is considered "dead".
        mLocationClient.disconnect();

        super.onStop();
	}
    
    
}
