package net.euskadi.turismo.app.recursos;

import java.util.Locale;

import net.euskadi.turismo.app.R;
import net.euskadi.turismo.app.util.Utils;
import net.euskadi.turismo.app.valueObjects.Recurso;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.location.Location;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.app.SherlockFragmentActivity;


public class ViewerActivity extends SherlockFragmentActivity{

    private Location ubicacionRecibida;	//usada para recibir la ultima ubicacin desde la actividad que nos llama.
	
	//private ShareActionProvider mShareActionProvider;
	Recurso recurso = new Recurso();
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.view_fragment);
	    
	    Intent i = getIntent();
      	recurso = (Recurso)i.getSerializableExtra("recursoObject");
      	ViewerFragment viewer = (ViewerFragment) getSupportFragmentManager().findFragmentById(R.id.view_fragment);
      	viewer.updateRecurso(recurso);
      	
      	
	   	ActionBar ab = getSupportActionBar();
	    ab.setDisplayOptions(ActionBar.DISPLAY_HOME_AS_UP|ActionBar.DISPLAY_SHOW_HOME|ActionBar.DISPLAY_SHOW_CUSTOM);
	    ab.setDisplayShowTitleEnabled(false);
	    ab.setIcon(R.drawable.iconturismo);
	    LayoutInflater inflator = (LayoutInflater) this.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View v = inflator.inflate(R.layout.actionbar_title_centered, null);
        TextView titleTV = (TextView) v.findViewById(R.id.actionBarTitle);
        titleTV.setText(recurso.getNomRecurso());
        ab.setCustomView(v);	   	 
            	
	    //comprobamos la localizacin rebicida en el intent
	    Location loc = getIntent().getParcelableExtra("currentlocation");
	    if (loc!=null){
	    	ubicacionRecibida = loc;
	    } 

	    viewer.ubicacionRecibida = this.ubicacionRecibida;
        
	}
	
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
	  // refresh your views here
	  super.onConfigurationChanged(newConfig);
      String lang = Utils.getInstance().supportLang(this);
      newConfig.locale = new Locale(lang);
      Locale.setDefault(newConfig.locale);
      getBaseContext().getResources().updateConfiguration(newConfig, getBaseContext().getResources().getDisplayMetrics());
	  Log.v("ViewerActivity","ViewerActivity:locale:"+newConfig.locale.getLanguage());
	  
	}
	
/*	@Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getSupportMenuInflater();
        inflater.inflate(R.menu.detalle_recurso, menu);
        
        /** Getting the actionprovider associated with the menu item whose id is share 
        mShareActionProvider = (ShareActionProvider) menu.findItem(R.id.ic_menu_share).getActionProvider();
 
        /** Getting the target intent 
        Intent intent = getDefaultShareIntent();
 
        /** Setting a share intent 
        if(intent!=null)
            mShareActionProvider.setShareIntent(intent);
        return super.onCreateOptionsMenu(menu);

    }
	   
   /** Returns a share intent 
    private Intent getDefaultShareIntent(){
        Intent intent = new Intent(Intent.ACTION_SEND);
        intent.putExtra(Intent.EXTRA_SUBJECT, "[iEuskadi]");
        intent.putExtra(Intent.EXTRA_TEXT, recurso.getUrlRecurso());
        intent.setType("text/plain");        
        return intent;
    }

	 
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
    	if (item.getItemId() == android.R.id.home) {
    		Intent intent = new Intent(this, MainActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
            startActivity(intent);
         } else if (item.getItemId() == R.id.favorite) {
        	anyadirRecursos();
        	Toast.makeText(this, R.string.anadirFavorito, Toast.LENGTH_SHORT).show();	
         } else if (item.getItemId() == R.id.location_web_site) {
        	 if(recurso.getUrlRecurso()!=null)
        		 startActivity(new Intent(Intent.ACTION_VIEW).setData(Uri.parse(recurso.getUrlRecurso())));	
         } else if (item.getItemId() == R.id.device_access_call) {
        	 if(recurso.getTelRecurso()!=null)
        	   startActivity(new Intent(Intent.ACTION_VIEW,Uri.parse("tel:"+recurso.getTelRecurso()+"")));
         } else if (item.getItemId() == R.id.new_email) {
        	 if(recurso.getMailRecurso()!=null){
        		 Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
        		 //quitar el mailto
        		 int indexStart = recurso.getMailRecurso().indexOf(":");        		 
        		 String aEmailList[] = {recurso.getMailRecurso().substring(indexStart+1)};
        		 emailIntent.putExtra(Intent.EXTRA_EMAIL, aEmailList);
        		 emailIntent.putExtra(Intent.EXTRA_SUBJECT, getResources().getString(R.string.email_subject));
        		 emailIntent.setType("text/plain");
        		 startActivity(Intent.createChooser(emailIntent, getResources().getString(R.string.chooser)));
        	 }
         } else if (item.getItemId() == R.id.social_add_person) {
        	 if(recurso.getTelRecurso()!=null || recurso.getMailRecurso()!=null){
             	Intent launchContactos = new Intent(getApplicationContext(), ContactosRecurso.class);
             	launchContactos.putExtra("recursoObject", recurso);
 		    	startActivity(launchContactos);
			 }
         } else if (item.getItemId() == R.id.location_map) {
        	 Intent launchContactos = new Intent(getApplicationContext(), MapLocalizacion.class);
          	 launchContactos.putExtra("recursoObject", recurso);
		     startActivity(launchContactos);
         }
    	 return true;
    }    
	    
    private void anyadirRecursos(){
    	MyDB dba;
    	dba = new MyDB(this);
    	dba.open();
    	Cursor c = dba.getRec(recurso.getCodRec());
    	if(c.getCount()==0){
    		c.close();
    		dba.insertRec(recurso);
    	}
    	dba.close();
    }*/
}
