package net.euskadi.turismo.app.recursos;

import java.util.ArrayList;
import java.util.Locale;

import net.euskadi.turismo.app.MainActivity;
import net.euskadi.turismo.app.R;
import net.euskadi.turismo.app.json.UpdateJsonData;
import net.euskadi.turismo.app.util.Constantes;
import net.euskadi.turismo.app.util.Utils;
import net.euskadi.turismo.app.valueObjects.Categoria;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.location.Location;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;
import android.widget.Toast;

import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.app.SherlockListActivity;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient.ConnectionCallbacks;
import com.google.android.gms.common.GooglePlayServicesClient.OnConnectionFailedListener;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.location.LocationClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;

public class SeleccionarCategorias extends SherlockListActivity 
	implements OnSeekBarChangeListener,
	ConnectionCallbacks,
	OnConnectionFailedListener,
	LocationListener {
	
    private LocationClient mLocationClient;
	
    private Location ubicacionRecibida;	//usada para recibir la ultima ubicacin desde la actividad que nos llama.
    
	final String LOG_TITLE = this.getClass().getName();
	private SeekBar seekBarDistancia;    
    private AdaptadorCategorias myAdapter;
    private ArrayList<Categoria> categorias = new ArrayList<Categoria>();   

	// Settings para actualizaciones de la localizacin. Los rangos mximos posibles actualmente.
    private static final LocationRequest REQUEST = LocationRequest.create()
            .setInterval(5000)         // 5 seconds
            .setFastestInterval(16)    // 16ms = 60fps
            .setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.lista_categorias);
          
        myAdapter = new AdaptadorCategorias(this);            
        this.setListAdapter(myAdapter);
        
	    seekBarDistancia = (SeekBar) findViewById(R.id.SeekBarDistancia);
	    seekBarDistancia.setOnSeekBarChangeListener(this);  
	    
	    TextView distanciaInicial = (TextView) findViewById(R.id.distanciaInicial);    	
    	distanciaInicial.setText(String.valueOf(seekBarDistancia.getProgress()));  
	    
    	ActionBar ab = getSupportActionBar();
	    ab.setDisplayOptions(ActionBar.DISPLAY_SHOW_TITLE|ActionBar.DISPLAY_HOME_AS_UP);
	    ab.setTitle(getString(R.string.titleRecursos));
	    
	    //comprobamos la localizacin rebicida en el intent
	    Location loc = getIntent().getParcelableExtra("currentlocation");
	    if (loc!=null){
	    	ubicacionRecibida = loc;
	    } 
	    
    }

    protected Location leerUbicacion() {
    	Location currentLocation = new Location("");
        // If Google Play Services is available
        if (servicesConnected()) {

            // Get the current location
            currentLocation = mLocationClient.getLastLocation();

        }
        
        return currentLocation;
	}

    
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
 	   super.onConfigurationChanged(newConfig);
       String lang = Utils.getInstance().supportLang(this);
       newConfig.locale = new Locale(lang);
       Locale.setDefault(newConfig.locale);
       getBaseContext().getResources().updateConfiguration(newConfig, getBaseContext().getResources().getDisplayMetrics());
    } 
    
	@Override
	protected void onResume() {
		super.onResume();
		//CAMBIO EN SERVICIOS DE LOCALIACION
//		LocationService.setUpdateListener(CurrentPosition.getInstance(this));
		//UpdateJsonData.setUpdateListener(this);

		if (!Utils.getInstance().isOnline(this)){
			Log.i(LOG_TITLE, "No internet connection, exit app");
			msgNoDataConnection(getString(R.string.con_red));			
		}else{
			Log.d(LOG_TITLE, "conectar el cliente de localizacion");
	        setUpLocationClientIfNeeded();
	        mLocationClient.connect();
			
		}
		
	}
	
	
	@Override
	protected void onPause() {
		super.onPause();		
//		LocationService.setUpdateListener(null);
	}

	
		
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getSupportMenuInflater();
        inflater.inflate(R.menu.buscar_recursos, menu);
        return true;
    }
 
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
    	
    	if (item.getItemId() == android.R.id.home) {
    		Intent intent = new Intent(this, MainActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
            startActivity(intent);           
        }else{ 
			UpdateJsonData.distancia = Float.valueOf(seekBarDistancia.getProgress());
			UpdateJsonData.categoria = categorias(categorias);					
//			LocationService.setUpdateListener(CurrentPosition.getInstance(this));	
			/*UpdateJsonData.setUpdateListener(this);	
			if(LocationService.getLocation()!=null)
				UpdateJsonData.getInstance().update(this, WITH_DIALOG);				
			else{
				Toast.makeText(getApplicationContext(), R.string.ubicacionNoDisponible, Toast.LENGTH_LONG).show();				
			}*/
			if(item.getItemId() == R.id.view_as_list){
				Location loc = leerUbicacion();
	    		Intent launchLista = new Intent(getApplicationContext(), ListActivity.class);
				launchLista.putExtra("currentlocation", loc);
				startActivity(launchLista); 
			}else if (item.getItemId() == R.id.location_place){
				Location loc = leerUbicacion();
	    		Intent launchMapa = new Intent(getApplicationContext(), MapRecursos.class);
				launchMapa.putExtra("currentlocation", loc);
				startActivity(launchMapa); 
			}	
        }
        return true;
    }
    
	
    class AdaptadorCategorias extends BaseAdapter {
    	
    	private LayoutInflater mInflater;   
    	private boolean[] itemSelection;
    	
    	AdaptadorCategorias(Context context) {
    		mInflater = LayoutInflater.from(context);    
    		categorias.add(new Categoria(1, R.string.cultura));
    		categorias.add(new Categoria(2, R.string.transportes));
    		categorias.add(new Categoria(3, R.string.deportes));
    		categorias.add(new Categoria(4, R.string.comer));
    		categorias.add(new Categoria(5, R.string.dormir));
    		categorias.add(new Categoria(6, R.string.expTop));
    		categorias.add(new Categoria(7, R.string.playas));
    		categorias.add(new Categoria(8, R.string.infoTurismo));
    		categorias.add(new Categoria(9, R.string.reuniones));
    		this.itemSelection = new boolean[9];
    	}
    	
    	public int getCount() {return categorias.size();}
		public Categoria getItem(int i) {return categorias.get(i);}
		public long getItemId(int i) {return i;}
    	
    	public View getView(int position, View convertView, ViewGroup parent) {
    		final ViewHolder holder;
			View v = convertView;
			if ((v == null) || (v.getTag() == null)) {
				v = mInflater.inflate(R.layout.listitem_categoria, null);
				holder = new ViewHolder();
				holder.imageCategoria = (ImageView)v.findViewById(R.id.imageCategoria);
				holder.nombreCategoria = (TextView)v.findViewById(R.id.idNombre);
				holder.idCategoria = (CheckBox)v.findViewById(R.id.idcategoria);
				holder.idCategoria.setOnCheckedChangeListener(new OnCheckedChangeListener(){

		            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
		                int chkPosition = (Integer) buttonView.getTag(); 
		                categorias.get(chkPosition).setSelected(buttonView.isChecked());
		                itemSelection[chkPosition] = holder.idCategoria.isChecked();
		                
		            }               
		        });
				
				holder.idCategoria.setChecked(itemSelection[position]);
				v.setTag(holder);
				v.setTag(R.id.imageCategoria, holder.imageCategoria);
				v.setTag(R.id.idNombre, holder.nombreCategoria);	
				v.setTag(R.id.idcategoria, holder.idCategoria);	
				v.setOnClickListener(new OnClickListener() {
	                @Override
	                public void onClick(View v) {
	                	ViewHolder chkPosition = (ViewHolder) v.getTag();
	                	if(holder.idCategoria.isChecked()){	                		
	                		holder.idCategoria.setChecked(false);	                		
	                	}else{	                		
	                		holder.idCategoria.setChecked(true);	                		
	                	}
	                	categorias.get(chkPosition.categoria.getIcono()-1).setSelected(holder.idCategoria.isChecked());
	                }	               
	            });
				
			} else {
				holder = (ViewHolder) v.getTag();			
			}
			
			holder.idCategoria.setTag(position);// This line is important.
			holder.categoria = getItem(position);
				    			
			if(holder.categoria.getIcono()==Constantes.CATEGORIA_CULTURA){
				holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.iconcultura));	
			}else if(holder.categoria.getIcono()==Constantes.CATEGORIA_TRANSPORTES){
				holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.icontransporte));
            }else if(holder.categoria.getIcono()==Constantes.CATEGORIA_DEPORTES){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.icondeportes));
            }else if(holder.categoria.getIcono()==Constantes.CATEGORIA_COMER){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.iconcomer));
            }else if(holder.categoria.getIcono()==Constantes.CATEGORIA_DORMIR){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.icondormir));
            }else if(holder.categoria.getIcono()==Constantes.CATEGORIA_EXPTOP){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.iconexperiencias));
            }else if(holder.categoria.getIcono()==Constantes.CATEGORIA_PLAYAS){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.iconplayas));
            }else if(holder.categoria.getIcono()==Constantes.CATEGORIA_INFOTURISMO){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.iconinfo));
            }else if(holder.categoria.getIcono()==Constantes.CATEGORIA_REUNIONES){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.iconreuniones));
            }			
			holder.nombreCategoria.setText(holder.categoria.getNombre());	
			holder.idCategoria.setId(holder.categoria.getIcono());			
			holder.idCategoria.setChecked(itemSelection[position]);			
			return v;
		}
    	public class ViewHolder {
			Categoria categoria;
			ImageView imageCategoria;
			TextView nombreCategoria;
			CheckBox idCategoria;
		}	
    }
	
    /** 
     * Cambiamos el ttulo del control cuando el usuario mueve el SeekBar. 
     */  
    @Override  
    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    	TextView distanciaInicial = (TextView) findViewById(R.id.distanciaInicial);    	
    	distanciaInicial.setText(String.valueOf(seekBarDistancia.getProgress()));  
    }  
  
    @Override  
    public void onStartTrackingTouch(SeekBar seekBar) {}  
  
    @Override  
    public void onStopTrackingTouch(SeekBar seekBar) {}  
    
    private String categorias(ArrayList<Categoria> categorias) {
   
    	int count = this.getListView().getCount();
    	String categoria="";
    	
        for (int i = 0; i < count; i++) {   
        	if(categorias.get(i).isSelected()){
    			if(categoria.equals("")){
            		categoria = String.valueOf(categorias.get(i).getIcono());
            	}else{
            		categoria +="c" + categorias.get(i).getIcono();
            	}
    		}
        }  

        return categoria;                
    }

    private void setUpLocationClientIfNeeded() {
        if (mLocationClient == null) {
            mLocationClient = new LocationClient(
            		getApplicationContext(),
                    this,  // ConnectionCallbacks
                    this); // OnConnectionFailedListener
        }
    }
	
    /**
     * Implementation of {@link LocationListener}.
     */
    @Override
    public void onLocationChanged(Location location) {
    	Log.d(LOG_TITLE, "Location = " + location);
    }

    /**
     * Callback called when connected to GCore. Implementation of {@link ConnectionCallbacks}.
     */
    @Override
    public void onConnected(Bundle connectionHint) {
        mLocationClient.requestLocationUpdates(REQUEST, this);  // LocationListener
    }

    /**
     * Callback called when disconnected from GCore. Implementation of {@link ConnectionCallbacks}.
     */
    @Override
    public void onDisconnected() {
        // Do nothing
    }

    /**
     * Implementation of {@link OnConnectionFailedListener}.
     */
    @Override
    public void onConnectionFailed(ConnectionResult result) {
        // Do nothing
    }
    
	@Override
	public void onStop() {

        // If the client is connected
        if (mLocationClient.isConnected()) {
        	mLocationClient.removeLocationUpdates(this);	//stopPeriodicUpdates
        }

        // After disconnect() is called, the client is considered "dead".
        mLocationClient.disconnect();

        super.onStop();
		
	}
    
    
	/**
	 * Dialog no data connection
	 */
	private void msgNoDataConnection(String message) {
		new AlertDialog.Builder(this)
				.setMessage(message)
				.setPositiveButton("Settings", new DialogInterface.OnClickListener() {

							public void onClick(DialogInterface dialog,
									int which) {
					            startActivityForResult(new Intent(android.provider.Settings.ACTION_WIRELESS_SETTINGS),0);
					            dialog.cancel();
							}
						}).setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

							public void onClick(DialogInterface dialog,
									int which) {
								Log.i(LOG_TITLE, "Call start service");		
								dialog.cancel();
							}
						}).show();
	}
    
    /**
     * Verify that Google Play services is available before making a request.
     *
     * @return true if Google Play services is available, otherwise false
     */
    private boolean servicesConnected() {

        // Check that Google Play services is available
        int resultCode =
                GooglePlayServicesUtil.isGooglePlayServicesAvailable(this);

        // If Google Play services is available
        if (ConnectionResult.SUCCESS == resultCode) {
            // In debug mode, log the status
            Log.d(LOG_TITLE, getString(R.string.log_play_services_available));

            // Continue
            return true;
        // Google Play services was not available for some reason
        } else {
            // Display an error message
        	Toast.makeText(this, getString(R.string.ubicacionNoDisponible), Toast.LENGTH_SHORT).show();
            return false;
        }
    }
 
}
