package net.euskadi.turismo.app.recursos;

import static com.google.android.gms.maps.GoogleMap.MAP_TYPE_HYBRID;
import static com.google.android.gms.maps.GoogleMap.MAP_TYPE_NORMAL;
import static com.google.android.gms.maps.GoogleMap.MAP_TYPE_SATELLITE;

import java.text.DecimalFormat;
import java.util.Locale;

import net.euskadi.turismo.app.MainActivity;
import net.euskadi.turismo.app.R;
import net.euskadi.turismo.app.util.Constantes;
import net.euskadi.turismo.app.util.SegmentedButton;
import net.euskadi.turismo.app.util.Utils;
import net.euskadi.turismo.app.valueObjects.Recurso;
import android.content.Intent;
import android.content.res.Configuration;
import android.location.Location;
import android.os.Bundle;
import android.util.Log;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.app.SherlockFragmentActivity;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMap.OnCameraChangeListener;
import com.google.android.gms.maps.GoogleMap.OnInfoWindowClickListener;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;

public class MapLocalizacion extends SherlockFragmentActivity implements OnInfoWindowClickListener {
	
	final String LOG_TITLE = this.getClass().getName();
    private GoogleMap mMap;
	private Recurso recurso = new Recurso();

    private Location ubicacionRecibida;	//usada para recibir la ultima ubicacin desde la actividad que nos llama.
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.map_localizacion);
        
        recurso = (Recurso)getIntent().getSerializableExtra("recursoObject");
        
        ActionBar ab = getSupportActionBar();
	    ab.setDisplayOptions(ActionBar.DISPLAY_SHOW_TITLE|ActionBar.DISPLAY_HOME_AS_UP);
	    ab.setTitle(getString(R.string.mapa));       

	    //comprobamos la localizacin rebicida en el intent
	    Location loc = getIntent().getParcelableExtra("currentlocation");
	    if (loc!=null){
	    	ubicacionRecibida = loc;
	    }
	    
	    setUpMapIfNeeded();
	    
		SegmentedButton.SegmentedButtonCallback selectionChangedListener = new SegmentedButton.SegmentedButtonCallback() {
			
			@Override
			public void OnSelectionChanged(int selected) {
				 if (!checkReady()) {
			            return;
			        }
			    switch(selected) {			    
			    	case 0:
			    		mMap.setMapType(MAP_TYPE_NORMAL);
			    		break;

			    	case 1:
			    		mMap.setMapType(MAP_TYPE_SATELLITE);
			    		break;

			    	case 2:
			    		mMap.setMapType(MAP_TYPE_HYBRID);
			    		break;
			    		
			    }
			 }
		};
		SegmentedButton sb = new SegmentedButton(this,selectionChangedListener);
		sb.AddButton(getString(R.string.normal));
		sb.AddButton(getString(R.string.satellite));
		sb.AddButton(getString(R.string.hybrid));				
		sb.setSelected(0);
		LinearLayout layoutSegmented = (LinearLayout)findViewById(R.id.layoutSegmented);
		layoutSegmented.addView(sb);	    
	    
    }
    
    
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
 	   super.onConfigurationChanged(newConfig);
       String lang = Utils.getInstance().supportLang(this);
       newConfig.locale = new Locale(lang);
       Locale.setDefault(newConfig.locale);
       getBaseContext().getResources().updateConfiguration(newConfig, getBaseContext().getResources().getDisplayMetrics());
    } 
    
    private boolean checkReady() {
        if (mMap == null) {
            Toast.makeText(this, "Map not ready", Toast.LENGTH_SHORT).show();
            return false;
        }
        return true;
    }

    public void clearMap() {
        if (!checkReady()) {
            return;
        }
        mMap.clear();
    }
    
    @Override
    protected void onResume() {
        super.onResume();
        setUpMapIfNeeded();
    }
    
	@Override
	public void onBackPressed() {
		super.onBackPressed();
		clearMap();
	}
	
    private void setUpMapIfNeeded() {
        // Do a null check to confirm that we have not already instantiated the map.
        if (mMap == null) {
        	// Try to obtain the map from the SupportMapFragment.
        	mMap = ((SupportMapFragment) getSupportFragmentManager().findFragmentById(R.id.map)).getMap();
        	if (mMap != null) {
        		setUpMap();
            }
        }
    }
    
    /**
     * This is where we can add markers or lines, add listeners or move the camera. In this case, we
     * just add a marker near Africa.
     * <p>
     * This should only be called once and when we are sure that {@link #mMap} is not null.
     */
    private void setUpMap() {
    	
//    	Log.i(LOG_TITLE, "setUpMap CurrentPosition.location:"+CurrentPosition.getInstance(getApplicationContext()).getLoc().getLongitude());
    	Log.i(LOG_TITLE, "setUpMap ubicacion actual:"+ ubicacionRecibida);
        
    	final LatLngBounds.Builder builder = new LatLngBounds.Builder();
        // Add lots of markers to the map.
        addMarkersToMap(builder);
        
//        final Location actualPosition = CurrentPosition.getInstance(getApplicationContext()).getLoc();              
        final Location actualPosition = this.ubicacionRecibida;
		if(actualPosition!=null){
			mMap.setMyLocationEnabled(true);
			LatLng locLatLng = new LatLng(actualPosition.getLatitude(), actualPosition.getLongitude()); 
			builder.include(locLatLng);
		}else{
			mMap.setMyLocationEnabled(false);
		}
        mMap.setOnInfoWindowClickListener(this);        
        
        mMap.setOnCameraChangeListener(new OnCameraChangeListener() {

            @Override
            public void onCameraChange(CameraPosition arg0) {
                // Move camera.
            	if(recurso!=null){
            		if(actualPosition!=null){
            			//LatLng locLatLng = new LatLng(actualPosition.getLatitude(), actualPosition.getLongitude()); 
            			//builder.include(locLatLng);
            		}
            		mMap.moveCamera(CameraUpdateFactory.newLatLngBounds(builder.build(), 60));
            	}else{
            		if(mMap.isMyLocationEnabled()){            			
            			//LatLng locLatLng = new LatLng(actualPosition.getLatitude(), actualPosition.getLongitude());
            			//Google has stated that the issue will be fixed in the next update to the Google Maps API via Issue 4644
                		//LatLng locLatLng = new LatLng(mMap.getMyLocation().getLatitude(), mMap.getMyLocation().getLongitude());
            			mMap.moveCamera(CameraUpdateFactory.newLatLngBounds(builder.build(), 60));
                		mMap.animateCamera(CameraUpdateFactory.zoomTo(9));            			
            		}            		
            	}
                // Remove listener to prevent position reset on camera move.
            	mMap.setOnCameraChangeListener(null);
            }
        });
    }    
    
    
    private void addMarkersToMap(LatLngBounds.Builder builder) {
    	
        DecimalFormat df = new DecimalFormat("#0.##");
        int imageCat = 0;
                   			
		if(recurso.getCodCategoria()==Constantes.CATEGORIA_CULTURA){
			imageCat = R.drawable.pincultura;
		}else if(recurso.getCodCategoria()==Constantes.CATEGORIA_TRANSPORTES){
			imageCat = R.drawable.pintransporte;
		}else if(recurso.getCodCategoria()==Constantes.CATEGORIA_DEPORTES){    				 
			imageCat = R.drawable.pindeportes;
		}else if(recurso.getCodCategoria()==Constantes.CATEGORIA_COMER){    	
			imageCat = R.drawable.pincomer;
		}else if(recurso.getCodCategoria()==Constantes.CATEGORIA_DORMIR){ 	
			imageCat = R.drawable.pindormir;
		}else if(recurso.getCodCategoria()==Constantes.CATEGORIA_EXPTOP){ 
			imageCat = R.drawable.pinexperiencias;
		}else if(recurso.getCodCategoria()==Constantes.CATEGORIA_PLAYAS){ 
			imageCat = R.drawable.pinplayas;
		}else if(recurso.getCodCategoria()==Constantes.CATEGORIA_INFOTURISMO){ 
			imageCat = R.drawable.pininfo;
		}else if(recurso.getCodCategoria()==Constantes.CATEGORIA_REUNIONES){ 
			imageCat = R.drawable.pinreuniones;
		}    
		LatLng recLatLng = new LatLng(recurso.getLat(), recurso.getLng());
		Log.d(LOG_TITLE, "Recurso ubicado en lat: " + recurso.getLat() + " lon: " + recurso.getLng());
		mMap.addMarker(new MarkerOptions()
            .position(recLatLng)
            .title(recurso.getNomRecurso())
            .snippet(df.format(recurso.getDistancia()/1000)+" Km.")	     	                
            .icon(BitmapDescriptorFactory.fromResource(imageCat)));
	 	builder.include(recLatLng);
   
    }    
    
    @Override
    public void onInfoWindowClick(Marker marker) {
    	Intent showContent = new Intent(getApplicationContext(), ViewerActivity.class);
		showContent.putExtra("recursoObject", recurso);
		showContent.putExtra("currentlocation", ubicacionRecibida);
		startActivity(showContent);
    }   
        

    //@Override
    public boolean onCreateOptionsMenu(Menu menu) {
    	MenuInflater inflater = getSupportMenuInflater();
    	inflater.inflate(R.menu.map_recursos, menu);
    	menu.findItem(R.id.view_as_list).setVisible(false);
    	return super.onCreateOptionsMenu(menu);
    }
    
    public boolean onOptionsItemSelected(MenuItem item) {
    	switch (item.getItemId()) {
   	 	case android.R.id.home:
   	 		Intent intent = new Intent(this, MainActivity.class);
   	 		intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
   	 		startActivity(intent);
   	 		return true;
    
   	 	default:
           return super.onOptionsItemSelected(item);
    	}
    }
    
}
