package net.euskadi.turismo.app.recursos;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;

import net.euskadi.turismo.app.MainActivity;
import net.euskadi.turismo.app.R;
import net.euskadi.turismo.app.MainActivity.ErrorDialogFragment;
import net.euskadi.turismo.app.json.JsonDataParse;
import net.euskadi.turismo.app.json.UpdateJsonData;
import net.euskadi.turismo.app.json.UpdateJsonDataChangeListener;
import net.euskadi.turismo.app.util.Constantes;
import net.euskadi.turismo.app.util.Utils;
import net.euskadi.turismo.app.valueObjects.Recurso;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.location.Location;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

import com.actionbarsherlock.app.SherlockListFragment;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.GooglePlayServicesClient.ConnectionCallbacks;
import com.google.android.gms.common.GooglePlayServicesClient.OnConnectionFailedListener;
import com.google.android.gms.location.LocationClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;

public class ListaFragment extends SherlockListFragment 
	implements 
    ConnectionCallbacks,
    OnConnectionFailedListener,
    LocationListener,
    UpdateJsonDataChangeListener {

    private LocationClient mLocationClient;

	final String LOG_TITLE = this.getClass().getName();
	private OnSelectedListener recSelectedListener;
	protected RecursosAdapter myAdapter;
	private Recurso recSeleccionado; 
	protected Location ubicacionRecibida;
	
	// Settings para actualizaciones de la localizacin. Los rangos mximos posibles actualmente.
    private static final LocationRequest REQUEST = LocationRequest.create()
            .setInterval(5000)         // 5 seconds
            .setFastestInterval(16)    // 16ms = 60fps
            .setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);
	
	public void onListItemClick(ListView l, View v, int position, long id) {
		recSeleccionado = JsonDataParse.arrRecursos.get(position);
		recSelectedListener.onSelected(recSeleccionado);
		l.setItemChecked(position, true);
		
	}
	
	public interface OnSelectedListener {
	    public void onSelected(Recurso selRecurso);
	}

	
	public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);	    
	    myAdapter = new RecursosAdapter(getActivity(), R.layout.recursorow, JsonDataParse.arrRecursos);
        this.setListAdapter(myAdapter);
        setHasOptionsMenu(true);

//		LocationService.setUpdateListener(CurrentPosition.getInstance(getActivity()));
//        UpdateJsonData.setUpdateListener(this);
//		UpdateJsonData.getInstance().update(getActivity(), true);
        //cambiamos la llamada actual al mtodo update
        //en su lugar, tomamos la localizacin y usamos el update con sobrecarga que recibe una localizacion.
//        if (mLocationClient != null && mLocationClient.isConnected()) {
//            Location loc = mLocationClient.getLastLocation();
//            Log.d(LOG_TITLE, "Location = " + loc);
//            UpdateJsonData.getInstance().update(getActivity(), loc, true);
//        } else {
//        	UpdateJsonData.getInstance().update(getActivity(), new Location(""), true);
//        }
      //TODO: mostrar mensaje al usuario si no hay una localizacion disponible??
        
	}
	

	@Override
	public void onConfigurationChanged(Configuration newConfig) {
	  // refresh your views here
	  super.onConfigurationChanged(newConfig);
      String lang = Utils.getInstance().supportLang(getActivity());
      newConfig.locale = new Locale(lang);
      Locale.setDefault(newConfig.locale);
      getActivity().getBaseContext().getResources().updateConfiguration(newConfig, getActivity().getBaseContext().getResources().getDisplayMetrics());
	  Log.v("ListaFragment","ListaFragment:locale:"+newConfig.locale.getLanguage());
	  
	}
	
	@Override
	public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {        
        inflater.inflate(R.menu.buscar_recursos, menu);
        menu.findItem(R.id.view_as_list).setVisible(false);
        
        super.onCreateOptionsMenu(menu, inflater);
	}

	//@Override
	public boolean onOptionsItemSelected(MenuItem item) {
    	if (item.getItemId() == android.R.id.home) {
    		Intent intent = new Intent(getActivity(), MainActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
            startActivity(intent);
        }else if (item.getItemId() == R.id.location_place) {
        	Intent launchMapaRecursos = new Intent(getActivity(), MapRecursos.class);
        	//launchMapaRecursos.putExtra("arrRecursos", arrRecursos);
        	if (ubicacionRecibida==null){
        		ubicacionRecibida = leerUbicacion();
        	}
			launchMapaRecursos.putExtra("currentlocation", ubicacionRecibida);
        	startActivity(launchMapaRecursos); 
        } 
    	return super.onOptionsItemSelected(item);
    }
	
	@Override
	public void onResume() {
		super.onResume();

		Log.d(LOG_TITLE, "conectar el cliente de localizacion");
        setUpLocationClientIfNeeded();
        mLocationClient.connect();
		
	}
	
	
	@Override
	public void onPause() {
		super.onPause();

        if (mLocationClient != null) {
            mLocationClient.disconnect();
        }
		
		UpdateJsonData.setUpdateListener(null);
//		LocationService.setUpdateListener(null);		
	}

    private void setUpLocationClientIfNeeded() {
        if (mLocationClient == null) {
            mLocationClient = new LocationClient(
            		getActivity().getApplicationContext(),
                    this,  // ConnectionCallbacks
                    this); // OnConnectionFailedListener
        }
    }

    /**
     * Implementation of {@link LocationListener}.
     */
    @Override
    public void onLocationChanged(Location location) {
    	Log.d(LOG_TITLE, "Location = " + location);
    	
//    	cargarRecursos();
    	
    }

    /**
     * Callback called when connected to GCore. Implementation of {@link ConnectionCallbacks}.
     */
    @Override
    public void onConnected(Bundle connectionHint) {
        mLocationClient.requestLocationUpdates(REQUEST, this);  // LocationListener
        
        cargarRecursos();
    }

    /**
     * Callback called when disconnected from GCore. Implementation of {@link ConnectionCallbacks}.
     */
    @Override
    public void onDisconnected() {
        // Do nothing
    }

    /**
     * Implementation of {@link OnConnectionFailedListener}.
     */
    @Override
    public void onConnectionFailed(ConnectionResult result) {
        // Do nothing
    }
    
	@Override
	public void onStop() {

        // If the client is connected
        if (mLocationClient.isConnected()) {
        	mLocationClient.removeLocationUpdates(this);	//stopPeriodicUpdates
        }

        // After disconnect() is called, the client is considered "dead".
        mLocationClient.disconnect();

        super.onStop();
		
		//myAdapter.clear();
		//myAdapter.notifyDataSetChanged();
	}
	
	/**
	 * catch the trigger listener to refresh list adapter
	 */
	public void update() {
		Log.i(LOG_TITLE, "catch the trigger listener to refresh list adapter");
		((BaseAdapter)getListAdapter()).notifyDataSetChanged();
	}	
	
	
    class RecursosAdapter extends ArrayAdapter<Recurso> {
    	
		public class ViewHolder {
			Recurso recurso;
			ImageView categoriaRec;
			TextView nombreRec;
			TextView distancia;
		}	
    	private ArrayList<Recurso> arrayListRecurso;
    	private int layout;
    	
    	public RecursosAdapter(Context context, int layout, ArrayList<Recurso> arrayListRecurso) {
    	    super(context, layout, arrayListRecurso);

    	    //es fundamental hacer copia del array porque nos va a venir el array del JSON que se carga de forma asncrona 
    	    //y eso nos causar estados incoherentes en algunas situaciones si lo asignamos directamente
    	    @SuppressWarnings("unchecked")
			ArrayList<Recurso> copia = (ArrayList<Recurso>) arrayListRecurso.clone();
			this.arrayListRecurso = copia;
    	    this.layout = layout;
    	    
    	 }
    	
		public int getCount() {return arrayListRecurso.size();}
		public Recurso getItem(int i) {return arrayListRecurso.get(i);}
		public long getItemId(int i) {return i;}
		
		public View getView(int arg0, View arg1, ViewGroup arg2) {
			final ViewHolder holder;
			View v = arg1;
			if ((v == null) || (v.getTag() == null)) {
				LayoutInflater layoutInflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
				v = layoutInflater.inflate(layout, null);

				holder = new ViewHolder();
				holder.categoriaRec = (ImageView)v.findViewById(R.id.categoriaRec);
				holder.nombreRec = (TextView)v.findViewById(R.id.nombreRec);
				holder.distancia = (TextView)v.findViewById(R.id.distancia);
				v.setTag(holder);
			} else {
				holder = (ViewHolder) v.getTag();
			}
			holder.recurso = getItem(arg0);
			if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_CULTURA){
				holder.categoriaRec.setImageDrawable(getResources().getDrawable(R.drawable.iconcultura));	
			}else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_TRANSPORTES){
				holder.categoriaRec.setImageDrawable(getResources().getDrawable(R.drawable.icontransporte));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_DEPORTES){
            	holder.categoriaRec.setImageDrawable(getResources().getDrawable(R.drawable.icondeportes));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_COMER){
            	holder.categoriaRec.setImageDrawable(getResources().getDrawable(R.drawable.iconcomer));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_DORMIR){
            	holder.categoriaRec.setImageDrawable(getResources().getDrawable(R.drawable.icondormir));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_EXPTOP){
            	holder.categoriaRec.setImageDrawable(getResources().getDrawable(R.drawable.iconexperiencias));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_PLAYAS){
            	holder.categoriaRec.setImageDrawable(getResources().getDrawable(R.drawable.iconplayas));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_INFOTURISMO){
            	holder.categoriaRec.setImageDrawable(getResources().getDrawable(R.drawable.iconinfo));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_REUNIONES){
            	holder.categoriaRec.setImageDrawable(getResources().getDrawable(R.drawable.iconreuniones));
            }	
			holder.nombreRec.setText(holder.recurso.getNomRecurso());	
			DecimalFormat df = new DecimalFormat("#0.###");
			holder.distancia.setText(df.format(holder.recurso.getDistancia()/1000) + " km");			
			v.setTag(holder);
			return v;
		}

    	@Override
		public void notifyDataSetChanged() {
			super.notifyDataSetChanged();
			//el trigger indica que se ha actualizado el array de recursos del JSON, actualizar la lista del adaptador.
			//IMPORTANTE: asignamos una copia ya que su carga es asncrona y queremos hacerla independiente 
			//de la interfaz de usuario.
			@SuppressWarnings("unchecked")
			ArrayList<Recurso> copia = (ArrayList<Recurso>) JsonDataParse.arrRecursos.clone();
			arrayListRecurso = copia;
		}
		
    }

    @Override
    public void onSaveInstanceState (Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("listRecurso", recSeleccionado);
    }
    
    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);
        getListView().setBackgroundResource(R.drawable.i_slide4_flitro_osc);
        getListView().setCacheColorHint(0);
        
        //Current position should survive screen rotations.
        if (savedInstanceState != null) {
        	recSeleccionado = (Recurso)savedInstanceState.getSerializable("listRecurso");
        }
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
        	recSelectedListener = (OnSelectedListener) activity;
        } catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement ListaFragment");
        }
    }

    private void cargarRecursos(){

		UpdateJsonData.setUpdateListener(this);
        
        if (mLocationClient != null && mLocationClient.isConnected()) {
			Location loc = mLocationClient.getLastLocation();
	        Log.d(LOG_TITLE, "Location = " + loc);
	        if (loc==null){
	        	//no teniendo ubicacin, tratamos de usar la ltima recibida
	        	loc = this.ubicacionRecibida;
	        }
	        UpdateJsonData.getInstance().update(getActivity(), loc, true);
        }

        ((BaseAdapter)getListAdapter()).notifyDataSetChanged();		
    	
    }

    protected Location leerUbicacion() {
    	Location currentLocation = new Location("");
        // If Google Play Services is available
        if (servicesConnected()) {

            // Get the current location
            currentLocation = mLocationClient.getLastLocation();

        }
        
        return currentLocation;
	}
    
    /**
     * Verify that Google Play services is available before making a request.
     *
     * @return true if Google Play services is available, otherwise false
     */
    private boolean servicesConnected() {

        // Check that Google Play services is available
        int resultCode =
                GooglePlayServicesUtil.isGooglePlayServicesAvailable(getActivity().getApplicationContext());

        // If Google Play services is available
        if (ConnectionResult.SUCCESS == resultCode) {
            // In debug mode, log the status
            Log.d(LOG_TITLE, getString(R.string.log_play_services_available));

            // Continue
            return true;
        // Google Play services was not available for some reason
        } else {
            // Display an error dialog
            Dialog dialog = GooglePlayServicesUtil.getErrorDialog(resultCode, getActivity(), 0);
            if (dialog != null) {
                ErrorDialogFragment errorFragment = new ErrorDialogFragment();
                errorFragment.setDialog(dialog);
                errorFragment.show(getFragmentManager(), LOG_TITLE);
            }
            return false;
        }
    }
 
}
