package net.euskadi.turismo.app.recursos;

import java.util.Locale;

import net.euskadi.turismo.app.R;
import net.euskadi.turismo.app.util.Utils;
import net.euskadi.turismo.app.valueObjects.Recurso;
import android.content.Intent;
import android.content.res.Configuration;
import android.location.Location;
import android.os.Bundle;

import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.app.SherlockFragmentActivity;

public class ListActivity extends SherlockFragmentActivity implements ListaFragment.OnSelectedListener{
	
	private boolean mDualFragments = false;
	ViewerFragment frag;
	
    private Location ubicacionRecibida;	//usada para recibir la ultima ubicacin desde la actividad que nos llama.
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.list_fragment);
	    
	    ActionBar ab = getSupportActionBar();
	    ab.setDisplayOptions(ActionBar.DISPLAY_SHOW_TITLE|ActionBar.DISPLAY_HOME_AS_UP);
	    ab.setTitle(getString(R.string.titleRecursos));
	    
	    ListaFragment listFrag =(ListaFragment) getSupportFragmentManager().findFragmentById(R.id.list_fragment);	
	    if(listFrag.myAdapter!=null)
	    	listFrag.myAdapter.clear();
	    
	    frag = (ViewerFragment) getSupportFragmentManager().findFragmentById(R.id.view_fragment);	    
        if (frag != null)
        	mDualFragments = true;

	    //comprobamos la localizacin rebicida en el intent
	    Location loc = getIntent().getParcelableExtra("currentlocation");
	    if (loc!=null){
	    	ubicacionRecibida = loc;
	    }

	    listFrag.ubicacionRecibida = this.ubicacionRecibida;
        
//        LocationService.setUpdateListener(CurrentPosition.getInstance(getApplicationContext()));
        
		/*if(LocationService.getLocation()!=null)
			UpdateJsonData.getInstance().update(this, true);				
		else{
			Toast.makeText(getApplicationContext(), R.string.ubicacionNoDisponible, Toast.LENGTH_LONG).show();				
		}*/
       
	}
	
   @Override
   public void onConfigurationChanged(Configuration newConfig) {
	   super.onConfigurationChanged(newConfig);
       String lang = Utils.getInstance().supportLang(this);
       newConfig.locale = new Locale(lang);
       Locale.setDefault(newConfig.locale);
       getBaseContext().getResources().updateConfiguration(newConfig, getBaseContext().getResources().getDisplayMetrics());
	   //setContentView(R.layout.list_fragment);
   }    

	
	@Override
	public void onSelected(Recurso selRecurso) {
		if (!mDualFragments) {			
			Intent showContent = new Intent(getApplicationContext(), ViewerActivity.class);
			showContent.putExtra("recursoObject",selRecurso);
			showContent.putExtra("currentlocation", ubicacionRecibida);
			startActivity(showContent);
		}else{
			frag.updateRecurso(selRecurso);		
		}
	}
	
	
	/*@Override
	public void onBackPressed() {
		super.onBackPressed();
		
		Intent serviceIntent = new Intent(this,net.euskadi.turismo.app.location.LocationService.class);
		stopService(serviceIntent);
		
	}*/
		 
}
