package net.euskadi.turismo.app.recursos;

import java.util.ArrayList;
import java.util.Locale;

import net.euskadi.turismo.app.R;
import net.euskadi.turismo.app.util.Utils;
import net.euskadi.turismo.app.valueObjects.Recurso;
import android.app.Activity;
import android.content.ContentProviderOperation;
import android.content.res.Configuration;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.widget.Toast;

public class ContactosRecurso extends Activity {
	
	Recurso recurso = new Recurso();

    @Override
    public void onCreate(Bundle savedInstanceState) {
    	
        super.onCreate(savedInstanceState);
        setContentView(R.layout.detalle_recurso);
        recurso = (Recurso)getIntent().getSerializableExtra("recursoObject");
        
        ArrayList<ContentProviderOperation> ops =  new ArrayList<ContentProviderOperation>();

    	ops.add(ContentProviderOperation.newInsert(ContactsContract.RawContacts.CONTENT_URI)
    	    .withValue(ContactsContract.RawContacts.ACCOUNT_TYPE, null)
    	    .withValue(ContactsContract.RawContacts.ACCOUNT_NAME, null)
    	    .build()
    	);

		if(recurso.getNomRecurso() != null){           
		    ops.add(ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI)              
		        .withValueBackReference(ContactsContract.Data.RAW_CONTACT_ID, 0)
		        .withValue(ContactsContract.Data.MIMETYPE, ContactsContract.CommonDataKinds.StructuredName.CONTENT_ITEM_TYPE)
		        .withValue(ContactsContract.CommonDataKinds.StructuredName.DISPLAY_NAME, recurso.getNomRecurso())
		        .build()
		    );
		} 
		                      
		if(recurso.getTelRecurso() != null){
		    ops.add(ContentProviderOperation.
		        newInsert(ContactsContract.Data.CONTENT_URI)
		        .withValueBackReference(ContactsContract.Data.RAW_CONTACT_ID, 0)
		        .withValue(ContactsContract.Data.MIMETYPE, ContactsContract.CommonDataKinds.Phone.CONTENT_ITEM_TYPE)
		        .withValue(ContactsContract.CommonDataKinds.Phone.NUMBER, recurso.getTelRecurso())
		        .withValue(ContactsContract.CommonDataKinds.Phone.TYPE, ContactsContract.CommonDataKinds.Phone.TYPE_WORK)
		        .build()
		    );
		}
		
        if(recurso.getMailRecurso() != null){
             ops.add(ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI)
                 .withValueBackReference(ContactsContract.Data.RAW_CONTACT_ID, 0)
                 .withValue(ContactsContract.Data.MIMETYPE, ContactsContract.CommonDataKinds.Email.CONTENT_ITEM_TYPE)
                 .withValue(ContactsContract.CommonDataKinds.Email.DATA, recurso.getMailRecurso())
                 .withValue(ContactsContract.CommonDataKinds.Email.TYPE, ContactsContract.CommonDataKinds.Email.TYPE_WORK)
                 .build());
        }
		
        if(recurso.getUrlRecurso() != null){
            ops.add(ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI)
                .withValueBackReference(ContactsContract.Data.RAW_CONTACT_ID, 0)
                .withValue(ContactsContract.Data.MIMETYPE, ContactsContract.CommonDataKinds.Website.CONTENT_ITEM_TYPE)
                .withValue(ContactsContract.CommonDataKinds.Website.URL, recurso.getUrlRecurso())
                .withValue(ContactsContract.CommonDataKinds.Website.TYPE, ContactsContract.CommonDataKinds.Website.TYPE_WORK)
                .build());
       }
		
        // Asking the Contact provider to create a new contact                  
        try {
            getContentResolver().applyBatch(ContactsContract.AUTHORITY, ops);
            Toast.makeText(this, R.string.anadirContacto, Toast.LENGTH_SHORT).show();
            finish();
        } catch (Exception e) {               
            e.printStackTrace();
            Toast.makeText(this, R.string.anadirContactoError, Toast.LENGTH_SHORT).show();
        }

    }
    
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
 	   super.onConfigurationChanged(newConfig);
       String lang = Utils.getInstance().supportLang(this);
       newConfig.locale = new Locale(lang);
       Locale.setDefault(newConfig.locale);
       getBaseContext().getResources().updateConfiguration(newConfig, getBaseContext().getResources().getDisplayMetrics());
    } 
    

}
