package net.euskadi.turismo.app.json;

import net.euskadi.turismo.app.R;
import net.euskadi.turismo.app.util.Constantes;
import net.euskadi.turismo.app.util.MyProgressDialog;
import net.euskadi.turismo.app.util.Utils;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.content.res.Configuration;
import android.location.Location;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.widget.Toast;

public class UpdateJsonData {

	private static final int DATA_UPDATE = 1;

	private final String LOG_TITLE = this.getClass().getName();

	public static float distancia = 1000;
	public static String categoria;
	public static UpdateJsonDataChangeListener JSON_DATA_UPDATE_LISTENER;
	private static UpdateJsonData instance = null;

	Context context;

	/**
	 * Listener to call back
	 * 
	 * @param UpdateJsonDataChangeListener
	 *            jsonListener
	 * 
	 */
	public static void setUpdateListener(
			final UpdateJsonDataChangeListener jsonListener) {
		JSON_DATA_UPDATE_LISTENER = jsonListener;
	}

	protected UpdateJsonData() {
	}

	public static UpdateJsonData getInstance() {
		if (null == instance)
			instance = new UpdateJsonData();

		return instance;
	}

	/**
	 * Location listener, if location change, update json
	 * 
	 * @param Context
	 *            context
	 * @param Location
	 *            loc
	 * @param boolean dialog
	 * 
	 */
	public void update(final Context context, final Location loc, final boolean dialog) {
		this.context = context;

		Log.i(LOG_TITLE, "Read new json");
		if (false == Utils.getInstance().isOnline(context)){
			Toast.makeText(context, R.string.conexion, Toast.LENGTH_LONG).show(); 
		}else{
			new ParseJsonThread(context, dialog).execute(loc);
		}
	}

	//CAMBIO EN SERVICIOS DE LOCALIZACION
//	/**
//	 * update json under demand when the app need.
//	 * 
//	 * @param Context
//	 *            context
//	 * 
//	 * @param boolean dialog
//	 * 
//	 */
//	public void update(final Context context, final boolean dialog) {
//		this.context = context;
//		if (false == Utils.getInstance().isOnline(context)){
//			Toast.makeText(context, R.string.conexion, Toast.LENGTH_LONG).show();
//		}else{
//			new ParseJsonThread(context, dialog).execute(CurrentPosition.getInstance(context).getLoc()); 
//		}
//	}

	
	/**
	 * configure the url to download the json for pois
	 * 
	 * @param Location
	 *            loc
	 * 
	 * @param boolean originalSize
	 * 
	 * @return String
	 * 
	 */
	private String getURL(final Location loc) {
		Configuration config = context.getResources().getConfiguration();
		StringBuffer urlTurismo = new StringBuffer();
		Log.i(LOG_TITLE, "Prepare url to parse");
		Location locConsulta = loc;
		//si no se ha podido obtener valor de localizacion lo inicializamos para la consulta
		if (locConsulta == null){
			locConsulta = new Location("");
		}
		urlTurismo.append(Constantes.URL_TURISMO);
		urlTurismo.append("?countryCode=").append(config.locale.getCountry());
        urlTurismo.append("&lang=").append(config.locale.getLanguage());
        urlTurismo.append("&lon=").append(locConsulta.getLongitude());
        urlTurismo.append("&lat=").append(locConsulta.getLatitude());
        urlTurismo.append("&radius=").append(distancia);
        urlTurismo.append("&accuracy=").append(locConsulta.getAccuracy());
        urlTurismo.append("&multicat=").append(categoria);
        urlTurismo.append("&userId=").append(context.getString(R.string.user_id));
        urlTurismo.append("&version=").append(context.getString(R.string.version));
        urlTurismo.append("&layerName=").append(context.getString(R.string.layer_name));
        urlTurismo.append("&R01HNoPortal=true");
		
        urlTurismo.append("&mapfilter=true");
        urlTurismo.toString().replace(" ", "");

		return urlTurismo.toString();
	}

	/**
	 * trigger to update json
	 */
	Handler handlerDataProcess = new Handler() {
		@Override		
		public void handleMessage(Message msg) {			
				if (null != JSON_DATA_UPDATE_LISTENER){
					Log.i(LOG_TITLE, "JSON_DATA_UPDATE_LISTENER");
					// update for new position
					JSON_DATA_UPDATE_LISTENER.update();
				}

		}
	};

	/**
	 * 
	 * Download json file with data about user, and photos, on background. First
	 * download thumbnails and data user, after that, download only the url
	 * to full image
	 * 
	 */
	public class ParseJsonThread extends AsyncTask<Location, Void, Void> {
		private MyProgressDialog pd;

		private Context context;
		private boolean dialog;

		public ParseJsonThread(final Context context, final boolean _dialog) {
			this.context = context;
			this.dialog = _dialog;
		}

		@Override
		protected void onPreExecute() {
			super.onPreExecute();
			if (true == dialog) {
				try {
					Log.i(LOG_TITLE, "Mostrar dialog");				
					pd= MyProgressDialog.show(context, "", context.getString(R.string.activity));
					pd.setCancelable(true);
					pd.setOnCancelListener(new OnCancelListener() {
			            @Override
			            public void onCancel(DialogInterface dialog) {
			                // actually could set running = false; right here, but I'll stick to contract.
			                cancel(true);
			            }
			        });
				} catch (Exception e) {
					e.getMessage();
					//dialog = false;
					//pd = null;
				}
			}
			
		}

		@Override
		protected Void doInBackground(Location... params) {
			JsonDataParse jsonDataParse = new JsonDataParse(context);
			jsonDataParse.startDownloadJsonData(getURL(params[0]), params[0]);

			return null;
		}

		@Override
		protected void onPostExecute(Void v) {
			if(JsonDataParse.arrRecursos.size()<0){
				Toast.makeText(context, R.string.noResultados, Toast.LENGTH_LONG).show();
			}
			handlerDataProcess.sendEmptyMessage(DATA_UPDATE);
			try{
				if (null != pd) {
					Log.i(LOG_TITLE, "Borrar dialog");
					pd.dismiss();
					pd = null;
				}
			}catch (Exception e) {
		        // nothing
		    }
		}

	}
}
