package net.euskadi.turismo.app.json;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

import net.euskadi.turismo.app.util.Constantes;
import net.euskadi.turismo.app.util.Utils;
import net.euskadi.turismo.app.valueObjects.Recurso;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.content.Context;
import android.location.Location;
import android.text.TextUtils;
import android.util.Log;

public class JsonDataParse {
	final String LOG_TITLE = this.getClass().getName();
	final String CHARSET = "iso-8859-1";

	Context context;
	public static ArrayList<Recurso> arrRecursos = new ArrayList<Recurso>();

	public JsonDataParse(Context context) {
		this.context = context;
	}

	
	/**
	 * Get an url, download json string and parse information to create
	 * POI_Json's class.
	 * 
	 * @param String
	 *            sourceUrl
	 * @param boolean original_size
	 * 
	 */
	public void startDownloadJsonData(String sourceUrl, Location actualPosition) {
		Log.i(LOG_TITLE, "ParseJsonPOIs - Start to parse json");

		try {
			String sJson = getJsonString(sourceUrl);
			Log.i(LOG_TITLE, "URLTURISMO:" +sourceUrl);
			if (!TextUtils.isEmpty(sJson)) {
				Log.i(LOG_TITLE, sJson);
				
//				Location actualPosition = CurrentPosition.getInstance(context).getLoc();
				JSONObject jsonObj = new JSONObject(sJson);

				JSONArray poisArray = jsonObj.getJSONArray("hotspots");
				Log.v("recursosSearch","number of resultst:"+poisArray.length());				
				synchronized (JsonDataParse.arrRecursos) {
					arrRecursos.clear();

					for (int i = 0; i < poisArray.length(); i++) {
						JSONObject allpoi = poisArray.getJSONObject(i);
						Recurso recurso = new Recurso();

						recurso.setCodRec(allpoi.getString("id"));
						
						JSONObject iconJSON = new JSONObject(allpoi.getString("icon"));
			            recurso.setCodCategoria(iconJSON.getInt("type"));
						
			            JSONObject geolocJSON = new JSONObject(new JSONObject(allpoi.getString("anchor")).getString("geolocation"));
			            
			            recurso.setLat(geolocJSON.getDouble("lat"));           
			        	recurso.setLng(geolocJSON.getDouble("lon"));
			        	
			        	JSONObject textJSON = new JSONObject(allpoi.getString("text"));
			        	recurso.setNomRecurso(textJSON.getString("title"));
			        	
			        	if(!textJSON.isNull("description")){
			        		recurso.setDescRecurso(textJSON.getString("description"));
			        	}
			        	if(!allpoi.isNull("imageURL")){
			        		recurso.setImagenRecurso(allpoi.getString("imageURL"));
			        	}
			        	
			        	JSONArray actionsJSON = allpoi.getJSONArray("actions");        		
			    		for(int j=0; j<actionsJSON.length(); j++){
			    			JSONObject objAction = actionsJSON.getJSONObject(j);
			    			if (Constantes.ACCION_WEB == objAction.getInt("tipoAccion")){
			    				if(!objAction.isNull("uri")){
			    					recurso.setUrlRecurso(objAction.getString("uri"));
			    				}
			    			}
			    			if (Constantes.ACCION_MAIL == objAction.getInt("tipoAccion")){
			    				if(!objAction.isNull("uri")){
			    					recurso.setMailRecurso(objAction.getString("uri"));
			    				}
			    			}
			    			if (Constantes.ACCION_TELEFONO == objAction.getInt("tipoAccion")){
			    				if(!objAction.isNull("uri")){
			    					recurso.setTelRecurso(objAction.getString("uri").substring(4));
			    				}
			    			}
			    			if (Constantes.ACCION_WEB_TURISMO == objAction.getInt("tipoAccion")){
			    				if(!objAction.isNull("uri")){
			    					recurso.setUrlTurismo(objAction.getString("uri"));
			    				}
			    			}
			    		}
			    		
			    		float distancia = Utils.getDistance(actualPosition.getLongitude(), actualPosition.getLatitude(), geolocJSON.getDouble("lon"),geolocJSON.getDouble("lat"));
			    		recurso.setDistancia(distancia);			    		
			            arrRecursos.add(recurso);   
			            

						allpoi = null;
						recurso = null;
						
					}
					Log.v("recursosSearch","JsonDataParse.arrRecursos:"+JsonDataParse.arrRecursos.size());
					Log.i(LOG_TITLE, "ParseJsonPOIs - Parse json ok");
				}

				jsonObj = null;
				poisArray = null;
			} else
				Log.e(LOG_TITLE, "ParseJsonPOIs - the Url: " + sourceUrl+ " is empty");

		} catch (JSONException e) {
			Log.e(LOG_TITLE, "ParseJsonPOIs Error - " + e.getMessage());
			e.printStackTrace();
		}
	}



	private String getJsonString(final String sUrl) {
		
		HttpClient httpClient = new DefaultHttpClient();
		HttpGet del = new HttpGet(sUrl);
        del.setHeader("content-type", "application/json");
        
        try{
        	HttpResponse resp = httpClient.execute(del);
            String respStr = EntityUtils.toString(resp.getEntity());        
            return respStr;
        } catch (UnsupportedEncodingException e) {
			Log.e(LOG_TITLE, "getJsonString - " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			Log.e(LOG_TITLE, "getJsonString - " + e.getMessage());
			e.printStackTrace();
		}catch (Exception e){
			Log.e(LOG_TITLE, "getJsonString - " + e.getMessage());
			e.printStackTrace();
		}

		return "";
	}
}