package net.euskadi.turismo.app.favoritos;

import java.util.ArrayList;
import java.util.Locale;

import net.euskadi.turismo.app.MainActivity;
import net.euskadi.turismo.app.R;
import net.euskadi.turismo.app.data.Constants;
import net.euskadi.turismo.app.data.MyDB;
import net.euskadi.turismo.app.recursos.ViewerActivity;
import net.euskadi.turismo.app.util.Constantes;
import net.euskadi.turismo.app.util.Utils;
import net.euskadi.turismo.app.valueObjects.Recurso;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.Cursor;
import android.location.Location;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.app.SherlockListActivity;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;

public class ConsultaFavoritos extends SherlockListActivity {
	

	MyDB dba;
	FavoritosAdapter myAdapter;

    private Location ubicacionRecibida;	//usada para recibir la ultima ubicacin desde la actividad que nos llama.
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
    	dba = new MyDB(this);
    	dba.open();
        setContentView(R.layout.lista_favoritos);
        
        super.onCreate(savedInstanceState);        
        myAdapter = new FavoritosAdapter(this);
        this.setListAdapter(myAdapter);
        
        ActionBar ab = getSupportActionBar();
	    ab.setDisplayOptions(ActionBar.DISPLAY_SHOW_TITLE|ActionBar.DISPLAY_HOME_AS_UP);
	    ab.setTitle(getString(R.string.favoritos));
	    
	    //comprobamos la localizacin rebicida en el intent
	    Location loc = getIntent().getParcelableExtra("currentlocation");
	    if (loc!=null){
	    	ubicacionRecibida = loc;
	    }
	    
    }
    
    
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
 	   super.onConfigurationChanged(newConfig);
       String lang = Utils.getInstance().supportLang(this);
       newConfig.locale = new Locale(lang);
       Locale.setDefault(newConfig.locale);
       getBaseContext().getResources().updateConfiguration(newConfig, getBaseContext().getResources().getDisplayMetrics());
    } 
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getSupportMenuInflater();
        inflater.inflate(R.menu.favoritos, menu);
        return super.onCreateOptionsMenu(menu);        
    }
 
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
    	if (item.getItemId() == android.R.id.home) {
    		Intent intent = new Intent(this, MainActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
            startActivity(intent);
            return true;
        }else if (item.getItemId() == R.id.content_discard) {
        	eliminarRecurso();
        	Toast.makeText(this, R.string.borrar, Toast.LENGTH_SHORT).show();
        } 
        return true;
    }
    

    private class FavoritosAdapter extends BaseAdapter {
    	
    	private LayoutInflater mInflater;
    	private ArrayList<Recurso> arrRecursos;
    	
    	public FavoritosAdapter(Context context) {
    		mInflater = LayoutInflater.from(context);    		
    		arrRecursos = new ArrayList<Recurso>();
    		getdata();
    	}
    	

		public void getdata(){
			dba.open();
    		Cursor c = dba.getRecFavoritos();
    		if(c.moveToFirst()){
    			do{
    				Recurso recurso = new Recurso();    			
    				recurso.setCodRec(c.getString(c.getColumnIndex(Constants.COD_REC)));
    				recurso.setCodCategoria(c.getInt(c.getColumnIndex(Constants.CAT_REC)));
    				recurso.setNomRecurso(c.getString(c.getColumnIndex(Constants.TITLE_REC)));
    				recurso.setImagenRecurso(c.getString(c.getColumnIndex(Constants.IMAGE_REC)));
    				recurso.setDescRecurso(c.getString(c.getColumnIndex(Constants.DESC_REC)));
    				arrRecursos.add(recurso);
    			} while(c.moveToNext());
    		}
    		c.close();
    		dba.close();
    	}
    	
		public int getCount() {return arrRecursos.size();}
		public Recurso getItem(int i) {return arrRecursos.get(i);}
		public long getItemId(int i) {return i;}
		
		public View getView(int arg0, View arg1, ViewGroup arg2) {
			final ViewHolder holder;
			View v = arg1;
			if ((v == null) || (v.getTag() == null)) {
				v = mInflater.inflate(R.layout.favoritorow, null);
				holder = new ViewHolder();
				holder.imageCategoria = (ImageView)v.findViewById(R.id.categoria);
				holder.titleRec = (TextView)v.findViewById(R.id.title);
				holder.codRec = (CheckBox)v.findViewById(R.id.codrecurso);
				v.setTag(holder);
			} else {
				holder = (ViewHolder) v.getTag();
			}
			holder.recurso = getItem(arg0);
			if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_CULTURA){
				holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.iconcultura));	
			}else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_TRANSPORTES){
				holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.icontransporte));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_DEPORTES){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.icondeportes));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_COMER){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.iconcomer));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_DORMIR){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.icondormir));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_EXPTOP){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.iconexperiencias));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_PLAYAS){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.iconplayas));
            }else if(holder.recurso.getCodCategoria()==Constantes.CATEGORIA_INFOTURISMO){
            	holder.imageCategoria.setImageDrawable(getResources().getDrawable(R.drawable.iconinfo));
            }	
			holder.titleRec.setText(holder.recurso.getNomRecurso());	
			holder.codRec.setId(Long.valueOf(holder.recurso.getCodRec()).intValue());			
			v.setTag(holder);
			
			v.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                	Intent launchRecursos = new Intent(getApplicationContext(), ViewerActivity.class);
    		    	launchRecursos.putExtra("recursoObject", holder.recurso);
    		    	launchRecursos.putExtra("currentlocation", ubicacionRecibida);
    		    	startActivity(launchRecursos);
                 }});		
			return v;
		}
		
		@Override
		public void notifyDataSetChanged() {
			super.notifyDataSetChanged();
    		arrRecursos.clear();
    		getdata();
		}

		public class ViewHolder {
			Recurso recurso;
			ImageView imageCategoria;
			TextView titleRec;
			CheckBox codRec;
		}	
    }
    
    private void eliminarRecurso() {
    	dba.open();    	
    	int count = this.getListView().getAdapter().getCount();
        for (int i = 0; i < count; i++) {
    		Recurso recurso = (Recurso)this.getListView().getItemAtPosition(i);
    		CheckBox check = (CheckBox)this.getListView().findViewById(Long.valueOf(recurso.getCodRec()).intValue());
    		if(check.isChecked()) {
    			dba.deleteRec(recurso.getCodRec());
    			check.setChecked(false);
    		}
        }       
    	dba.close();
    	//TODO: FIX no arrancar de nuevo la actividad (refrescar la lista o bien finalizar o bien ir a main)
    	((BaseAdapter)getListAdapter()).notifyDataSetChanged();
//    	Intent launchFavoritos = new Intent(getApplicationContext(), ConsultaFavoritos.class);
//		startActivity(launchFavoritos);		
    }

}
