package net.euskadi.turismo.app.data;

import net.euskadi.turismo.app.valueObjects.Recurso;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;

public class MyDB {
	private SQLiteDatabase db;
	private final Context context;
	private final MyDBhelper dbhelper;
	public MyDB(Context c){
		context = c;
		dbhelper = new MyDBhelper(context, Constants.DATABASE_NAME, null, Constants.DATABASE_VERSION);
	}
	public void close(){
		db.close();
	}
	public void open() throws SQLiteException{
		try {
			db = dbhelper.getWritableDatabase();
		} catch(SQLiteException ex) {
			Log.v("Open database exception caught", ex.getMessage());
			db = dbhelper.getReadableDatabase();
		}
	}
	public long insertRec(Recurso recurso) {
		try{
			ContentValues newTaskValue = new ContentValues();
			newTaskValue.put(Constants.COD_REC, recurso.getCodRec());
			newTaskValue.put(Constants.CAT_REC, recurso.getCodCategoria());			
			newTaskValue.put(Constants.TITLE_REC, recurso.getNomRecurso());
			newTaskValue.put(Constants.IMAGE_REC, recurso.getImagenRecurso());
			newTaskValue.put(Constants.DESC_REC, recurso.getDescRecurso());
			return db.insert(Constants.TABLE_NAME, null, newTaskValue);
		} catch(SQLiteException ex) {
			Log.v("Insert into database exception caught CAUSE",ex.getCause().toString());
			Log.v("Insert into database exception caught MESSAGE",ex.getMessage());
			return -1;
		}
	}
	public Cursor getRecFavoritos(){
		Cursor c = db.query(Constants.TABLE_NAME, null, null, null, null, null, null);
		Log.v("rows en favoritos",String.valueOf(c.getCount()));
		return c;
	}
	
	public Cursor getRec(String codRec){
		Cursor c = db.query(Constants.TABLE_NAME, null,  Constants.COD_REC + " = ?", new String[] { codRec }, null, null, null);
		Log.v("rows a insertar",String.valueOf(c.getCount()));
		return c;
	}	

	public void deleteRec(String codRec){
		db.delete(Constants.TABLE_NAME, Constants.COD_REC + " = ?", new String[] { codRec });
	}
}
