package net.euskadi.turismo.app;

import java.util.ArrayList;
import java.util.Locale;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.TextView;

import com.actionbarsherlock.app.SherlockListActivity;

public class SettingsActivity extends SherlockListActivity{
	
	private Configuration config = new Configuration();
	private ArrayList<String> arrIdiomas = new ArrayList<String>();
	
    @SuppressWarnings("deprecation")
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);        
        config = getBaseContext().getResources().getConfiguration();       
        
        showDialog(1);  
        
    }
    
    
    /**
     * Definition of the list adapter...uses the View Holder pattern to
     * optimize performance.
     */
	class IdiomaAdapter extends BaseAdapter {

		private LayoutInflater mInflater;

		public IdiomaAdapter(Context context) {
    		mInflater = LayoutInflater.from(context);    	
    		arrIdiomas.add(getString(R.string.espanol));
    		arrIdiomas.add(getString(R.string.euskera));
    		arrIdiomas.add(getString(R.string.ingles));
    		arrIdiomas.add(getString(R.string.aleman));
    		arrIdiomas.add(getString(R.string.frances));
    	}
		
		public int getCount() {return arrIdiomas.size();}
		public String getItem(int i) {return arrIdiomas.get(i);}
		public long getItemId(int i) {return i;}			
        
		public View getView(final int position, View arg1, ViewGroup arg2) {
			
			View v = arg1;
			if ((v == null) || (v.getTag() == null)) {
				
				mInflater = (LayoutInflater)getSystemService(Context.LAYOUT_INFLATER_SERVICE);
				v = mInflater.inflate(R.layout.idiomarow, null);
				TextView textView =(TextView)v.findViewById(R.id.itemIdioma);
				textView.setText(arrIdiomas.get(position));
				textView.setTextSize(15);				
				textView.setTextColor(Color.BLACK);
			}
			return v;
		}
		
	}            	        
    //@Override
    protected Dialog onCreateDialog(int id) {
    	
    	ListAdapter adapter = new IdiomaAdapter(this);
    	
        AlertDialog.Builder builder= new AlertDialog.Builder(this);        
        builder.setAdapter(adapter, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
            	 String lang = "";
                 switch (which){
                 	case 0:
                 		lang = "es";
                 		break;
                 	case 1:
                 		lang = "eu";
                 		break;
                 	case 2:
                 		lang = "en";
                 		break;
                 	case 3:
                 		lang = "de";
                 		break;
                 	case 4:
                 		lang = "fr";
                 		break;                 			
                 }		
                 Log.v("SettingsActivity","lang:"+lang);
                 Locale locale = new Locale(lang);
                 Locale.setDefault(locale);
                 config.locale = locale;
                 getBaseContext().getResources().updateConfiguration(config, getBaseContext().getResources().getDisplayMetrics());
                 
	         	 SharedPreferences prefs = getSharedPreferences("MisPreferencias", Context.MODE_PRIVATE);
	             SharedPreferences.Editor editor = prefs.edit();
	             editor.putString("langApp", lang);
	             editor.commit();
	             
                 Intent intent = new Intent(getApplicationContext(), MainActivity.class);
                 intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);                 
                 startActivity(intent);
                 finish();
            }
        });
        builder.setNegativeButton("Cancel",new DialogInterface.OnClickListener() {
        	public void onClick(DialogInterface dialog, int item) {
        		finish();
        	}
        });
        
        return builder.create();        
    }     
      
}
