package net.euskadi.turismo.app;

import java.util.Arrays;
import java.util.Locale;

import net.euskadi.turismo.app.util.Utils;
import android.app.Application;
import android.content.res.Configuration;
import android.util.Log;

public class MyApplication extends Application {
	
	private Locale locale = null;

    @Override
    public void onConfigurationChanged(Configuration newConfig){
        super.onConfigurationChanged(newConfig);
        String lang = Utils.getInstance().supportLang(this);
        newConfig.locale = new Locale(lang);
        Locale.setDefault(newConfig.locale);
        getBaseContext().getResources().updateConfiguration(newConfig, getBaseContext().getResources().getDisplayMetrics());

    }

    @Override
    public void onCreate(){
        super.onCreate();

        Configuration config = getBaseContext().getResources().getConfiguration();
        Log.v("MyApplication","config:"+config.locale.getLanguage());
        String[] strLanguages = new String[]{"es", "eu", "en", "fr", "de"};
        
        if (config.locale.getLanguage().equalsIgnoreCase("") || (!Arrays.asList(strLanguages).contains(config.locale.getLanguage()))){
            locale = new Locale("en");
            Locale.setDefault(locale);
            config.locale = locale;
            getBaseContext().getResources().updateConfiguration(config, getBaseContext().getResources().getDisplayMetrics());
        }
    }


}
