package net.euskadi.turismo.app;

import java.util.ArrayList;
import java.util.Locale;

import net.euskadi.turismo.app.favoritos.ConsultaFavoritos;
import net.euskadi.turismo.app.layar.Launcher;
//import net.euskadi.turismo.app.location.CurrentPosition;
//import net.euskadi.turismo.app.location.LocationService;
import net.euskadi.turismo.app.recursos.SeleccionarCategorias;
import net.euskadi.turismo.app.util.CyclicTransitionDrawable;
import net.euskadi.turismo.app.util.TypefaceSpan;
import net.euskadi.turismo.app.util.Utils;
//import android.app.ActivityManager;
import android.app.Dialog;
//import android.app.ActivityManager.RunningServiceInfo;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.location.Location;
//import android.location.LocationManager;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.text.Spannable;
import android.text.SpannableString;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;

import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.app.SherlockFragmentActivity;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;
import com.actionbarsherlock.widget.ShareActionProvider;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.GooglePlayServicesClient.ConnectionCallbacks;
import com.google.android.gms.common.GooglePlayServicesClient.OnConnectionFailedListener;
import com.google.android.gms.location.LocationClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;

public class MainActivity extends SherlockFragmentActivity
	implements 
	ConnectionCallbacks,
	OnConnectionFailedListener,
	LocationListener {
	
    private LocationClient mLocationClient;

    final String LOG_TITLE = this.getClass().getName();
	private ShareActionProvider mShareActionProvider;
    private Configuration config = new Configuration();
	
	// Settings para actualizaciones de la localizacin. Los rangos mximos posibles actualmente.
    private static final LocationRequest REQUEST = LocationRequest.create()
            .setInterval(5000)         // 5 seconds
            .setFastestInterval(16)    // 16ms = 60fps
            .setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);
    
	@Override
    public void onCreate(Bundle savedInstanceState) {
    	setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
	    SpannableString s = new SpannableString(getString(R.string.app_name));
	    s.setSpan(new TypefaceSpan(this, "fonts/MyriadWebPro-Bold.ttf"), 0, s.length(),
	            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);

	    // Update the action bar title with the TypefaceSpan instance
	    ActionBar ab = getSupportActionBar();
	    ab.setDisplayOptions(ActionBar.DISPLAY_SHOW_TITLE|ActionBar.DISPLAY_HOME_AS_UP);
	    ab.setTitle(s);
        
        CyclicTransitionDrawable ctd = new CyclicTransitionDrawable(new Drawable[] {
        		getResources().getDrawable(R.drawable.slide1),
        		getResources().getDrawable(R.drawable.slide2),        
        		getResources().getDrawable(R.drawable.slide3),        		
        		getResources().getDrawable(R.drawable.slide4),
        		getResources().getDrawable(R.drawable.slide5),
        		getResources().getDrawable(R.drawable.slide6)        		
        		});
        
  		LinearLayout layout = (LinearLayout) findViewById(R.id.mainLayout);
  		layout.setBackgroundDrawable(ctd);
        ctd.startTransition(1000, 3000); // 1 second transition, 3 second pause between transitions.*/
        
        String locale = getBaseContext().getResources().getConfiguration().locale.getDisplayName();
        Log.v(LOG_TITLE,"locale:"+locale);
                
        Button btnRecursos = (Button) findViewById(R.id.btnRecursos);        
        Drawable dRecursos = getResources().getDrawable(R.drawable.btnmainrecursos);
        dRecursos.setAlpha(220);
        btnRecursos.setBackgroundDrawable(dRecursos);
        
        Button btnRealidad = (Button) findViewById(R.id.btnRealidad);
        Drawable dRealidad = getResources().getDrawable(R.drawable.btnmainrealidad);
        dRealidad.setAlpha(220);
        btnRealidad.setBackgroundDrawable(dRealidad);
        
        Button btnFavoritos = (Button) findViewById(R.id.btnFavoritos);
        Drawable dFavoritos = getResources().getDrawable(R.drawable.btnmainfavoritos);
        dFavoritos.setAlpha(220);
        btnFavoritos.setBackgroundDrawable(dFavoritos);
        
        btnRecursos.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				Location loc = leerUbicacion();
				Intent launchRecursos = new Intent(getApplicationContext(), SeleccionarCategorias.class);
				launchRecursos.putExtra("currentlocation", loc);
				startActivity(launchRecursos);
			}
		});
        btnRealidad.setOnClickListener(new OnClickListener() {
 			public void onClick(View v) {
 				Intent launchAR = new Intent(getApplicationContext(), Launcher.class);
				startActivity(launchAR);
 			}
     	});
        
        btnFavoritos.setOnClickListener(new OnClickListener() {
   			public void onClick(View v) {
				Location loc = leerUbicacion();
				Intent launchFavoritos = new Intent(getApplicationContext(), ConsultaFavoritos.class);
				launchFavoritos.putExtra("currentlocation", loc);
				startActivity(launchFavoritos);		
   			}
       	});
        
        //comprobar google play services al inicio
        servicesConnected();
    }
    
	    
    protected Location leerUbicacion() {
    	Location currentLocation = new Location("");
        // If Google Play Services is available
        if (servicesConnected()) {

            // Get the current location
            currentLocation = mLocationClient.getLastLocation();

        }
        
        return currentLocation;
	}


	@Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getSupportMenuInflater();
        inflater.inflate(R.menu.main, menu);

        /** Getting the actionprovider associated with the menu item whose id is share */
        mShareActionProvider = (ShareActionProvider) menu.findItem(R.id.ic_menu_share).getActionProvider();
 
        /** Getting the target intent */
        Intent intent = getDefaultShareIntent();
 
        /** Setting a share intent */
        if(intent!=null)
            mShareActionProvider.setShareIntent(intent);
        return super.onCreateOptionsMenu(menu);
    }        
    
    /** Returns a share intent */
    private Intent getDefaultShareIntent(){
        Intent intent = new Intent(Intent.ACTION_SEND);
	 	String aEmailList[] = {getResources().getString(R.string.email_address)};
	 	intent.putExtra(Intent.EXTRA_EMAIL, aEmailList);
        intent.putExtra(Intent.EXTRA_SUBJECT, getResources().getString(R.string.email_subject));
        intent.setType("text/plain");        
        return intent;
    }
    
    public boolean onOptionsItemSelected(MenuItem item) {
    	if (item.getItemId() == R.id.configuracion) {
            //startActivity(new Intent(this, SettingsActivity.class));
        	showSettings();
    	}
    	/*else if (item.getItemId() == R.id.mail) {
   		 	Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
   		 	String aEmailList[] = {getResources().getString(R.string.email_address)};
   		 	emailIntent.putExtra(Intent.EXTRA_EMAIL, aEmailList);
   		 	emailIntent.putExtra(Intent.EXTRA_SUBJECT, getResources().getString(R.string.email_subject));
   		 	emailIntent.setType("text/plain");
   		 	startActivity(Intent.createChooser(emailIntent, getResources().getString(R.string.chooser)));   		 	
    	} else if (item.getItemId() == R.id.facebook) {
    		 startActivity(new Intent(Intent.ACTION_VIEW).setData(Uri.parse("http://www.facebook.com/EmbajadoresEuskadi")));	
    	} else if (item.getItemId() == R.id.twitter) {
    		startActivity(new Intent(Intent.ACTION_VIEW).setData(Uri.parse("https://twitter.com/TvEuskadi")));	
    	}*/
    	return true;
    }
        /**
     * Definition of the list adapter...uses the View Holder pattern to
     * optimize performance.
     */
	class IdiomaAdapter extends BaseAdapter {

		private LayoutInflater mInflater;
		private ArrayList<String> arrIdiomas = new ArrayList<String>();
		
		public IdiomaAdapter(Context context) {
    		mInflater = LayoutInflater.from(context);    	
    		arrIdiomas.add(getString(R.string.espanol));
    		arrIdiomas.add(getString(R.string.euskera));
    		arrIdiomas.add(getString(R.string.ingles));
    		arrIdiomas.add(getString(R.string.aleman));
    		arrIdiomas.add(getString(R.string.frances));
    	}
		
		public int getCount() {return arrIdiomas.size();}
		public String getItem(int i) {return arrIdiomas.get(i);}
		public long getItemId(int i) {return i;}			
        
		public View getView(final int position, View arg1, ViewGroup arg2) {
			
			View v = arg1;
			if ((v == null) || (v.getTag() == null)) {
				
				mInflater = (LayoutInflater)getSystemService(Context.LAYOUT_INFLATER_SERVICE);
				v = mInflater.inflate(R.layout.idiomarow, null);
				TextView textView =(TextView)v.findViewById(R.id.itemIdioma);
				textView.setText(arrIdiomas.get(position));
				textView.setTextSize(15);				
				textView.setTextColor(Color.BLACK);
			}
			return v;
		}
		
	}     
	
	public void showSettings(){
		ListAdapter adapter = new IdiomaAdapter(this);
    	
        AlertDialog.Builder builder = new AlertDialog.Builder(this);       
        builder.setAdapter(adapter, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
            	 String lang = "";
                 switch (which){
                 	case 0:
                 		lang = "es";
                 		break;
                 	case 1:
                 		lang = "eu";
                 		break;
                 	case 2:
                 		lang = "en";
                 		break;
                 	case 3:
                 		lang = "de";
                 		break;
                 	case 4:
                 		lang = "fr";
                 		break;                               			
                 }		
                 Log.v(LOG_TITLE,"lang:"+lang);
                 Locale locale = new Locale(lang);
                 Locale.setDefault(locale);
                 config.locale = locale;
                 getBaseContext().getResources().updateConfiguration(config, getBaseContext().getResources().getDisplayMetrics());
                 	
                 Intent intent = new Intent(getApplicationContext(), MainActivity.class);
                 intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
                 startActivity(intent);
                 finish();
            }
        });        
        builder.setNegativeButton("Cancel",new DialogInterface.OnClickListener() {
        	public void onClick(DialogInterface dialog, int item) {
        		dialog.cancel();
        	}
        });
        AlertDialog alert = builder.create();
        alert.show();
	}
	protected void onResume() {
		super.onResume();
		if (!Utils.getInstance().isOnline(this)){
			Log.i(LOG_TITLE, "No internet connection, exit app");
			msgNoDataConnection(getString(R.string.con_red));			
		}else{
			//CAMBIO EN SERVICIOS DE LOCALIACION
//			LocationManager locManager = (LocationManager)this.getSystemService(android.content.Context.LOCATION_SERVICE);
//	    	if (!locManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
//	    		msgUbicacion(getString(R.string.activarGPS));			
//	    	}
//			// Start Location Service
//			Log.i(LOG_TITLE, "Call start service");
//			startLocationService();
			
			Log.d(LOG_TITLE, "conectar el cliente de localizacion");
	        setUpLocationClientIfNeeded();
	        mLocationClient.connect();
			
		}
		
	}
	
	@Override
	protected void onPause() {
		super.onPause();		

        if (mLocationClient != null) {
            mLocationClient.disconnect();
        }
	}	

    private void setUpLocationClientIfNeeded() {
        if (mLocationClient == null) {
            mLocationClient = new LocationClient(
            		getApplicationContext(),
                    this,  // ConnectionCallbacks
                    this); // OnConnectionFailedListener
        }
    }
	
    /**
     * Implementation of {@link LocationListener}.
     */
    @Override
    public void onLocationChanged(Location location) {
    	Log.d(LOG_TITLE, "Location = " + location);
    }

    /**
     * Callback called when connected to GCore. Implementation of {@link ConnectionCallbacks}.
     */
    @Override
    public void onConnected(Bundle connectionHint) {
        mLocationClient.requestLocationUpdates(REQUEST, this);  // LocationListener
    }

    /**
     * Callback called when disconnected from GCore. Implementation of {@link ConnectionCallbacks}.
     */
    @Override
    public void onDisconnected() {
        // Do nothing
    }

    /**
     * Implementation of {@link OnConnectionFailedListener}.
     */
    @Override
    public void onConnectionFailed(ConnectionResult result) {
        // Do nothing
    }
    
	@Override
	public void onStop() {

        // If the client is connected
        if (mLocationClient.isConnected()) {
        	mLocationClient.removeLocationUpdates(this);	//stopPeriodicUpdates
        }

        // After disconnect() is called, the client is considered "dead".
        mLocationClient.disconnect();

        super.onStop();
		
	}
    
    //CAMBIO EN SERVICIOS DE LOCALIZACION
//	/**
//	 * Start location service
//	 */
//	private void startLocationService() {
//		// Initialize update service listener
//		CurrentPosition.getInstance(this);
//		if (false == isServiceRunning()) {
//			Log.i(LOG_TITLE, "!isServiceRunning()");
//			Intent serviceIntent = new Intent(this,
//					net.euskadi.turismo.app.location.LocationService.class);
//
//			startService(serviceIntent);
//			Log.i(LOG_TITLE, "startService-LocationService");
//		} else {
//			Log.i(LOG_TITLE, "setUpdateListener-LocationService");
//			LocationService.setUpdateListener(CurrentPosition.getInstance(this));
//		}
//	}
//	
//	/**
//	 * check if service is running
//	 */
//	private boolean isServiceRunning() {
//		ActivityManager manager = (ActivityManager) getSystemService(ACTIVITY_SERVICE);
//
//		for (RunningServiceInfo service : manager
//				.getRunningServices(Integer.MAX_VALUE)) {
//			if (LocationService.class.getName().equals(
//					service.service.getClassName())) {
//				return true;
//			}
//		}
//		return false;
//	}
	
	/**
	 * Dialog no data connection
	 */
	private void msgNoDataConnection(String message) {
		new AlertDialog.Builder(this)
				.setMessage(message)
				.setPositiveButton("Settings", new DialogInterface.OnClickListener() {

							public void onClick(DialogInterface dialog,
									int which) {
					            startActivityForResult(new Intent(android.provider.Settings.ACTION_WIRELESS_SETTINGS),0);
					            dialog.cancel();
							}
						}).setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

							public void onClick(DialogInterface dialog,
									int which) {
								Log.i(LOG_TITLE, "Call start service");		
								dialog.cancel();
							}
						}).show();
	}

	//CAMBIO EN SERVICIOS DE LOCALIZACION
//    public void msgUbicacion(String message) {
//    	
//        AlertDialog.Builder builder = new AlertDialog.Builder(this);
//        builder.setMessage(message)
//               .setPositiveButton("Settings", new DialogInterface.OnClickListener() {
//                   public void onClick(DialogInterface dialog, int id) {                	   
//                	   	startActivityForResult(new Intent(android.provider.Settings.ACTION_LOCATION_SOURCE_SETTINGS),0);       					       				
//                	    dialog.cancel();
//                   }
//               })
//               .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
//                   public void onClick(DialogInterface dialog, int id) {                	                   	  
//                	   //startActivity(new Intent(getApplicationContext(), MainActivity.class));
//                	   dialog.cancel();
//                   }
//               }).show();
//    }
    
	@Override
	public void onBackPressed() {
		super.onBackPressed();
		//CAMBIO EN SERVICIOS DE LOCALIZACION
//		Intent serviceIntent = new Intent(this, LocationService.class);
//		stopService(serviceIntent);
	}

    /**
     * Para la comprobacin de google play services.
     * Define a DialogFragment to display the error dialog generated in
     * showErrorDialog.
     */
    public static class ErrorDialogFragment extends DialogFragment {

        // Global field to contain the error dialog
        private Dialog mDialog;

        /**
         * Default constructor. Sets the dialog field to null
         */
        public ErrorDialogFragment() {
            super();
            mDialog = null;
        }

        /**
         * Set the dialog to display
         *
         * @param dialog An error dialog
         */
        public void setDialog(Dialog dialog) {
            mDialog = dialog;
        }

        /*
         * This method must return a Dialog to the DialogFragment.
         */
        @Override
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return mDialog;
        }
    }

    /**
     * Verify that Google Play services is available before making a request.
     *
     * @return true if Google Play services is available, otherwise false
     */
    private boolean servicesConnected() {

        // Check that Google Play services is available
        int resultCode =
                GooglePlayServicesUtil.isGooglePlayServicesAvailable(this);

        // If Google Play services is available
        if (ConnectionResult.SUCCESS == resultCode) {
            // In debug mode, log the status
            Log.d(LOG_TITLE, getString(R.string.log_play_services_available));

            // Continue
            return true;
        // Google Play services was not available for some reason
        } else {
            // Display an error dialog
            Dialog dialog = GooglePlayServicesUtil.getErrorDialog(resultCode, this, 0);
            if (dialog != null) {
                ErrorDialogFragment errorFragment = new ErrorDialogFragment();
                errorFragment.setDialog(dialog);
                errorFragment.show(getSupportFragmentManager(), LOG_TITLE);
            }
            return false;
        }
    }
    
}