package util;

import itourbaskBeans.q53RespuestaGrupoBean;
import q53_util.q53LogEstadisticas;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;

public class q53RespuestaUtil {
  
   /**
     * Metodo para recorrer las respuestas de la encuesta de tipo grupos
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return q53RespuestaGruposBean objeto con los datos de la respuesta
     *
     * @throws ProcletException
     */
    public static q53RespuestaGrupoBean getGruposData(
            ProcletServiceData sd, String codRespuesta,int numPersonasProc) throws ProcletException {
    	q53LogEstadisticas.printLog("q53RespuestaGrupoBean getGruposData");

        if (numPersonasProc == 0)
        { 
        	q53LogEstadisticas.printLog("Numero de personas en la procedencia CERO, lo dejamos todo a cero");
            q53RespuestaGrupoBean respGrupoBean = new q53RespuestaGrupoBean();
            respGrupoBean.setNumHombres(0);
            respGrupoBean.setNumMujeres(0);
            respGrupoBean.setNumMenor27(0);
            respGrupoBean.setNumEntre27_45(0);
            respGrupoBean.setNumEntre46_65(0);
            respGrupoBean.setNumMayor65(0);
            respGrupoBean.setNumSinConcretar(0);
            q53LogEstadisticas.printLog("---------------- FIN ------------------");
            return respGrupoBean;
        }


        int numHombres = 0;
        int numMujeres = 0;
        double menor27=(double)0;
        double entre27_45=(double)0;
        double entre46_65=(double)0;
        double mayor65=(double)0;
        double sinConcretar=(double)0;

        PSP.getValFromSessionProclet(sd,"n_Hombres");
        PSP.getValFromSessionProclet(sd,"n_Mujeres");
        PSP.getValFromSessionProclet(sd,"n_Menor27");
        PSP.getValFromSessionProclet(sd,"n_Entre27_45");
        PSP.getValFromSessionProclet(sd,"n_Entre46_65");
        PSP.getValFromSessionProclet(sd,"n_Mas65");
        PSP.getValFromSessionProclet(sd,"sinConcretar");
        PSP.getValFromSessionProclet(sd,"hombresAsig");
        PSP.getValFromSessionProclet(sd,"mujeresAsig");
        PSP.getValFromSessionProclet(sd, "menor27Asig");
        PSP.getValFromSessionProclet(sd, "entre27_45Asig");
        PSP.getValFromSessionProclet(sd, "entre46_65Asig");
        PSP.getValFromSessionProclet(sd, "mas65Asig");
        PSP.getValFromSessionProclet(sd, "sinConcretarAsig");
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():Valores en sesion para:");
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():n_Hombres="+sd.gOS("n_Hombres"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():n_Mujeres="+sd.gOS("n_Mujeres"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():n_Menor27="+sd.gOS("n_Menor27"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():n_Entre27_45="+sd.gOS("n_Entre27_45"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():n_Entre46_65="+sd.gOS("n_Entre46_65"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():n_Mas65="+sd.gOS("n_Mas65"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():sinConcretar="+sd.gOS("sinConcretar"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():hombresAsigIni="+sd.gOS("hombresAsig"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():mujeresAsigIni="+sd.gOS("mujeresAsig"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():menor27AsigIni="+sd.gOS("menor27Asig"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():entre27_45AsigIni="+sd.gOS("entre27_45Asig"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():entre46_65AsigIni="+sd.gOS("entre46_65Asig"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():mas65AsigIni="+sd.gOS("mas65Asig"));
        q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():sinConcretarAsigIni="+sd.gOS("sinConcretarAsig"));

/*        int hombresAsig = sd.gI("hombresAsig");
        int mujeresAsig = sd.gI("mujeresAsig");
        int menor27Asig = sd.gI("menor27Asig");
        int entre27_45Asig = sd.gI("entre27_45Asig");
        int entre46_65Asig = sd.gI("entre46_65Asig");
        int mas65Asig = sd.gI("mas65Asig");
        int sinConcretarAsig = sd.gI("sinConcretarAsig");
*/
        int hombresAsig = 0;
        int mujeresAsig = 0;
        int menor27Asig = 0;
        int entre27_45Asig = 0;
        int entre46_65Asig = 0;
        int mas65Asig = 0;
        int sinConcretarAsig = 0;

        int hombresAsigIni = sd.gI("hombresAsig");
        int mujeresAsigIni = sd.gI("mujeresAsig");
        int menor27AsigIni = sd.gI("menor27Asig");
        int entre27_45AsigIni = sd.gI("entre27_45Asig");
        int entre46_65AsigIni = sd.gI("entre46_65Asig");
        int mas65AsigIni = sd.gI("mas65Asig");
        int sinConcretarAsigIni = sd.gI("sinConcretarAsig");

        if((sd.gOS("n_Hombres")!=null) && (!sd.gOS("n_Hombres").equals("")))
            numHombres=Integer.parseInt(sd.gOS("n_Hombres"));

        if((sd.gOS("n_Mujeres")!=null) && (!sd.gOS("n_Mujeres").equals("")))
            numMujeres=Integer.parseInt(sd.gOS("n_Mujeres"));

        if ((sd.gOS("n_Menor27")!=null)&&(!sd.gOS("n_Menor27").equals("")))
            menor27=Double.valueOf(sd.gOS("n_Menor27")).doubleValue();

        if ((sd.gOS("n_Entre27_45")!=null)&&(!sd.gOS("n_Entre27_45").equals("")))
            entre27_45=Double.valueOf(sd.gOS("n_Entre27_45")).doubleValue();

        if ((sd.gOS("n_Entre46_65")!=null)&&(!sd.gOS("n_Entre46_65").equals("")))
            entre46_65=Double.valueOf(sd.gOS("n_Entre46_65")).doubleValue();

        if ((sd.gOS("n_Mas65")!=null)&&(!sd.gOS("n_Mas65").equals("")))
            mayor65=Double.valueOf(sd.gOS("n_Mas65")).doubleValue();

        if ((sd.gOS("sinConcretar")!=null)&&(!sd.gOS("sinConcretar").equals("")))
            sinConcretar=Double.valueOf(sd.gOS("sinConcretar")).doubleValue();

        int numTotalPersonas = numHombres + numMujeres;


        q53LogEstadisticas.printLog("Vamos a hacer el reparto de hombres y mujeres para la procedencia");
        int voyAsignandoSexo = 0;
        //Calculamos el numero de "hombres" en la procedencia
        double nH=0;
        double resultH = 0;
        double ratioHombres = 0;
        int rHombres=0;
        if (hombresAsigIni != numHombres)
        {
        	q53LogEstadisticas.printLog("El numero de hombres asignados es distinto del numero de hombres en la encuesta");
            nH = ((double)numHombres)/((double)numTotalPersonas);
            resultH = ((double)numPersonasProc)*nH;
            ratioHombres = Math.rint(resultH);
            rHombres = (new Double(ratioHombres)).intValue();
            int temp = hombresAsig+rHombres;
            if (temp > numHombres)
            {
                rHombres = numHombres - hombresAsig;
                hombresAsig = numHombres;
            } else {
                hombresAsig = temp;
            }
            q53LogEstadisticas.printLog("Numero de hombres asignados="+hombresAsig);
            q53LogEstadisticas.printLog("Ratio Hombres="+rHombres);
            voyAsignandoSexo = voyAsignandoSexo + hombresAsig;
            if (voyAsignandoSexo > numPersonasProc)
            {
                int mm = voyAsignandoSexo-numPersonasProc;
                q53LogEstadisticas.printLog("Me he pasado en el reparto de sexos (Hombres)"+ (mm));
                voyAsignandoSexo = voyAsignandoSexo - mm;
                hombresAsig = hombresAsig - mm;
                rHombres = rHombres - mm;
                q53LogEstadisticas.printLog("Numero de hombres asignados="+hombresAsig);
                q53LogEstadisticas.printLog("Ratio Hombres="+rHombres);
            }
            q53LogEstadisticas.printLog("LLevo asignados (voyAsignandoSexo)="+voyAsignandoSexo);
        }

        //Calculamos el numero de "mujeres" en la procedencia
        double nM = 0;
        double resultM = 0;
        double ratioMujeres = 0;
        int rMujeres = 0;
        if (mujeresAsigIni != numMujeres ){
        	q53LogEstadisticas.printLog("Numero de mujeres asignadas diferente del numero de mujeres en la encuesta");
            nM = ((double)numMujeres)/((double)numTotalPersonas);
            resultM = ((double)numPersonasProc)*nM;
            ratioMujeres = Math.rint(resultM); //3
            rMujeres = (new Double(ratioMujeres)).intValue(); // 3
            int temp = mujeresAsig+rMujeres; // 6+3
            if (temp > numMujeres) // 9>8
            {
                rMujeres = numMujeres - mujeresAsig;//8-6
                mujeresAsig = numMujeres; // 8
            } else {
                mujeresAsig = temp;
            }
            q53LogEstadisticas.printLog("Numero de mujeres asignados="+mujeresAsig);
            q53LogEstadisticas.printLog("Ratio Mujeres="+rMujeres);
            voyAsignandoSexo = voyAsignandoSexo + mujeresAsig;
            if (voyAsignandoSexo > numPersonasProc)
            {
                int mm = voyAsignandoSexo-numPersonasProc;
                q53LogEstadisticas.printLog("Me he pasado en el reparto de sexos (Mujeres)"+ (mm));
                voyAsignandoSexo = voyAsignandoSexo - mm;
                mujeresAsig = mujeresAsig - mm;
                rMujeres = rMujeres - mm;
                q53LogEstadisticas.printLog("Numero de mujeres asignados="+mujeresAsig);
                q53LogEstadisticas.printLog("Ratio Mujeres="+rMujeres);
            }
            q53LogEstadisticas.printLog("q53RespuestaUtil:getGruposData():LLevo asignados (voyAsignandoSexo)="+voyAsignandoSexo);
        }


        // Comprobamos que el reparto de mujeres y hombres se corresponda con el numero de personas de la procedencia, si no es asi, se sumara al sexo que aun no este completamente asignado.
        q53LogEstadisticas.printLog("Comprobar que los hombres y mujeres correspondan con el numero de personas de la procedencia");
        q53LogEstadisticas.printLog("Hombres + mujeres="+ (rMujeres+rHombres));
        q53LogEstadisticas.printLog("Numero personas en la procedencia="+numPersonasProc);
        int cuadrar = 0;
hombresAsig = hombresAsig + hombresAsigIni;
mujeresAsig = mujeresAsig + mujeresAsigIni;

//3.12.2007        if (rMujeres+rHombres < numPersonasProc)
        if (voyAsignandoSexo < numPersonasProc)
        { // falta por asignar algun sexo
            cuadrar = numPersonasProc - (rMujeres+rHombres);
            q53LogEstadisticas.printLog("Falta por cuadrar el sexo por procedencia: "+cuadrar);
            while (cuadrar >0)
            {

                if (hombresAsig != numHombres)
                {
                	q53LogEstadisticas.printLog("El numero de hombres asignados es distinto del numero de hombres ...");
                    int max = numHombres - hombresAsig;
                    int tmpMax = cuadrar;
                    if (cuadrar > max) tmpMax = max;
                    hombresAsig = hombresAsig + tmpMax;
                    rHombres = rHombres + tmpMax;
                    cuadrar = cuadrar - tmpMax;
                    q53LogEstadisticas.printLog("Hombres asignados="+hombresAsig);
                } else if (mujeresAsig != numMujeres)
                {
                	q53LogEstadisticas.printLog("El numero de mujeres asignadas es distinto del numero de mujeres ...");
                    int max = numMujeres - mujeresAsig;
                    int tmpMax = cuadrar;
                    if (cuadrar > max) tmpMax = max;
                    mujeresAsig = mujeresAsig + tmpMax;
                    rMujeres = rMujeres + tmpMax;
                    cuadrar = cuadrar - tmpMax;
                    q53LogEstadisticas.printLog("Mujeres asignadas="+mujeresAsig);
                }
            }// fin while
        } // fin cuadrar
//3.12.2007        else if (rMujeres+rHombres == numPersonasProc)
        else if (voyAsignandoSexo == numPersonasProc)
        {
        	q53LogEstadisticas.printLog("Reparto de sexos OK!! ");
        }else 
        { // sobra algun sexo (no se da el caso )
        	q53LogEstadisticas.printLog("Sobra algun sexo ? ");
            
        }


/************************************************************/
/************************************************************/
/************************************************************/

        q53LogEstadisticas.printLog("Reparto de edades para la procedencia. Numero personas en la procedencia="+numPersonasProc);
        int voyAsignando = 0;
        // Calculamos numero de personas "<27" en la procedencia
        double n27 = 0;
        double result27 = 0;
        double ratio27 =0;
        int rMenor27 = 0;
        if (menor27AsigIni != menor27)
        {
        	q53LogEstadisticas.printLog("Falta por asignar "+ (menor27 - menor27Asig)+" Menores de 27 ");
            n27 = menor27/((double)numTotalPersonas);
            result27 = ((double)numPersonasProc)*n27;
            ratio27 = Math.rint(result27);
            rMenor27 = (new Double(ratio27)).intValue();
            int temp = menor27Asig+rMenor27;

            if (temp == 0)
            {
                menor27Asig = new Double(menor27).intValue() - menor27AsigIni;
                rMenor27 = menor27Asig;
            } else if (temp>menor27)
            {
                rMenor27 = new Double(menor27).intValue()-menor27Asig;
                menor27Asig = new Double(menor27).intValue();
            } else {
                menor27Asig = temp;
            }
            q53LogEstadisticas.printLog("Menor 27 asignados="+menor27Asig);
            q53LogEstadisticas.printLog("Ratio Menor 27 ="+rMenor27);

            voyAsignando = voyAsignando + menor27Asig;
            if (voyAsignando > numPersonasProc)
            {
                int mm = voyAsignando - numPersonasProc;
                q53LogEstadisticas.printLog("Me he pasado asignando personas, me sobra alguna="+mm);
                voyAsignando = voyAsignando - mm;
                menor27Asig = menor27Asig-mm;
                rMenor27 = rMenor27 -mm;
                q53LogEstadisticas.printLog("Menor 27 asignados="+menor27Asig);
                q53LogEstadisticas.printLog("Ratio Menor 27 ="+rMenor27);
            }
            q53LogEstadisticas.printLog("LLevo asignados (voyAsignando)="+voyAsignando);
        } else {
        	q53LogEstadisticas.printLog("Menores de 27 asignados OK!!!");
        }

        // Calculamos numero de personas "entre 27-45" en la procedencia
        double n45 = 0;
        double result45 = 0;
        double ratio45 = 0;
        int rEntre27_45 = 0;
        if (entre27_45AsigIni != entre27_45)
        {
        	q53LogEstadisticas.printLog("Entre 27 y 45 asignados diferente del numero entre 27 y 45");
            n45 = entre27_45/((double)numTotalPersonas);
            result45 = ((double)numPersonasProc)*n45;
            ratio45 = Math.rint(result45);
            rEntre27_45 = (new Double(ratio45)).intValue();
            int temp = entre27_45Asig+rEntre27_45;
            if (temp == 0)
            {
                entre27_45Asig = new Double(entre27_45).intValue() - entre27_45AsigIni;
                rEntre27_45 = entre27_45Asig;
            } else if (temp>entre27_45) 
            {
                rEntre27_45 = new Double(entre27_45).intValue() - entre27_45Asig;
                entre27_45Asig = new Double(entre27_45).intValue();
            } else {
                entre27_45Asig = temp;
            }
            q53LogEstadisticas.printLog("entre 27 y 45 asignados="+entre27_45Asig);
            q53LogEstadisticas.printLog("Ratio entre 27 y 45 ="+rEntre27_45);
            voyAsignando = voyAsignando + entre27_45Asig;
            if (voyAsignando > numPersonasProc)
            {
                int mm = voyAsignando - numPersonasProc;
                q53LogEstadisticas.printLog("Me he pasado asignando personas, me sobra alguna="+mm);
                voyAsignando = voyAsignando - mm;
                entre27_45Asig = entre27_45Asig - mm;
                rEntre27_45 = rEntre27_45 -mm;
                q53LogEstadisticas.printLog("Entre 27 - 45 asignados="+entre27_45Asig);
                q53LogEstadisticas.printLog("Ratio entre 27 y 45 ="+rEntre27_45);
            }
            q53LogEstadisticas.printLog("LLevo asignados (voyAsignando)="+voyAsignando);
        } else {
        	q53LogEstadisticas.printLog("Entre 27 - 45 asignados OK!!!");
        }


        // Calculamos numero de personas "entre 46-65" en la procedencia
        double n65 = 0;
        double result65 = 0;
        double ratio65 = 0;
        int rEntre46_65 = 0;
        if (entre46_65AsigIni != entre46_65)
        {
        	q53LogEstadisticas.printLog("Entre 46 y 65 asignados ("+entre46_65AsigIni+") diferente del numero entre 46 y 65 ("+entre46_65+")");
            n65 = entre46_65/((double)numTotalPersonas);
            result65 = ((double)numPersonasProc)*n65;
            ratio65 = Math.rint(result65);        
            rEntre46_65 = (new Double(ratio65)).intValue();
            q53LogEstadisticas.printLog("rEntre46_65 = "+rEntre46_65);
            int temp = entre46_65Asig+rEntre46_65;
            q53LogEstadisticas.printLog("temp ==="+temp);

            if (temp == 0)
            {
                entre46_65Asig = new Double(entre46_65).intValue() - entre46_65AsigIni;
                rEntre46_65 = entre46_65Asig;
            } else if (temp>entre46_65)
            {
                rEntre46_65 = new Double(entre46_65).intValue()-entre46_65Asig;
                entre46_65Asig = new Double(entre46_65).intValue();
            } else{
                entre46_65Asig = temp;
            }
            q53LogEstadisticas.printLog("Ratio Entre46_65 (else)="+rEntre46_65);
            q53LogEstadisticas.printLog("entre 46 y 65 asigandos (else)="+entre46_65Asig);
            voyAsignando = voyAsignando + entre46_65Asig;
            if (voyAsignando > numPersonasProc)
            {
                int mm = voyAsignando - numPersonasProc;
                q53LogEstadisticas.printLog("Me he pasado asignando personas, me sobra alguna="+mm);
                voyAsignando = voyAsignando - mm;
                entre46_65Asig = entre46_65Asig - mm;
                rEntre46_65 = rEntre46_65-mm;
                q53LogEstadisticas.printLog("entre 46 y 65 asigandos="+entre46_65Asig);
                q53LogEstadisticas.printLog("Ratio Entre46_65 ="+rEntre46_65);
            }
            q53LogEstadisticas.printLog("LLevo asignados (voyAsignando)="+voyAsignando);
        } else {
        	q53LogEstadisticas.printLog("entre 46 y 65 asignados OK!!!");
        }


        // Calculamos numero de personas "<65" en la procedencia
        double m65 = 0;
        double r65 = 0;
        double rat65 = 0;
        int rMayor65 = 0;
        if (mas65AsigIni != mayor65)
        {
        	q53LogEstadisticas.printLog("Mayor de 65 asignados diferente del numero mayor de 65");
            m65 = mayor65/((double)numTotalPersonas);
            r65 = ((double)numPersonasProc)*m65;
            rat65 = Math.rint(r65);
            rMayor65 = (new Double(rat65)).intValue();
            int temp = mas65Asig+rMayor65;
            if (temp == 0)
            {
                mas65Asig = new Double(mayor65).intValue() - mas65AsigIni;
                rMayor65 = mas65Asig;
            } else if (temp>mayor65)
            {
                rMayor65 = new Double(mayor65).intValue()-mas65Asig;
                mas65Asig = new Double(mayor65).intValue();
            } else {
                mas65Asig = temp;
            }
            q53LogEstadisticas.printLog("Mayor de 65 asignados="+mas65Asig);
            q53LogEstadisticas.printLog("Ratio Mayor de 65 ="+rMayor65);
            voyAsignando = voyAsignando + mas65Asig;
            if (voyAsignando > numPersonasProc)
            {
                int mm = voyAsignando - numPersonasProc;
                q53LogEstadisticas.printLog("Me he pasado asignando personas, me sobra alguna="+mm);
                voyAsignando = voyAsignando - mm;
                mas65Asig = mas65Asig - mm;
                rMayor65 = rMayor65 -mm;
                q53LogEstadisticas.printLog("Mayor de 65 asigandos="+mas65Asig);
                q53LogEstadisticas.printLog("Ratio Mayor de 65 ="+rMayor65);
            }
            q53LogEstadisticas.printLog("LLevo asignados (voyAsignando)="+voyAsignando);
        } else {
        	q53LogEstadisticas.printLog("Mayor de 65 asignados OK!!!");
        }


        // Calculamos numero de personas "Sin Concretar" en la procedencia
        double nSC = 0;
        double rSC = 0;
        double ratioSC = 0;
        int rSinconcretar = 0;
        if (sinConcretarAsigIni != sinConcretar)
        {
        	q53LogEstadisticas.printLog("Sin concretar asignados diferente del numero de sin concretar");
            nSC = sinConcretar/((double)numTotalPersonas);
            rSC = ((double)numPersonasProc)*nSC;
            ratioSC = Math.rint(rSC);        
            rSinconcretar = (new Double(ratioSC)).intValue();
            int temp = sinConcretarAsig+rSinconcretar;
            if (temp == 0)
            {
                sinConcretarAsig = new Double(sinConcretar).intValue() - sinConcretarAsigIni;
                rSinconcretar = sinConcretarAsig;
            } else if (temp>sinConcretar)
            {
                rSinconcretar = new Double(sinConcretar).intValue()-sinConcretarAsig;
                sinConcretarAsig = new Double(sinConcretar).intValue();
            } else {
                sinConcretarAsig = temp;
            }
            q53LogEstadisticas.printLog("Sin concretar asignados="+sinConcretarAsig);
            q53LogEstadisticas.printLog("Ratio Sin concretar ="+rSinconcretar);
            voyAsignando = voyAsignando + sinConcretarAsig;
            if (voyAsignando > numPersonasProc)
            {
                int mm = voyAsignando - numPersonasProc;
                q53LogEstadisticas.printLog("Me he pasado asignando personas, me sobra alguna="+mm);
                voyAsignando = voyAsignando - mm;
                sinConcretarAsig = sinConcretarAsig - mm;
                rSinconcretar = rSinconcretar - mm;
                q53LogEstadisticas.printLog("Sin concretar asigandos="+sinConcretarAsig);
                q53LogEstadisticas.printLog("Ratio Sin concretar ="+rSinconcretar);
          }
            q53LogEstadisticas.printLog("LLevo asignados (voyAsignando)="+voyAsignando);
        } else {
        	q53LogEstadisticas.printLog("Sin concretar asignados OK!!!");
        }

        // Comprobamos que el reparto de edades se corresponda con el numero de personas de la procedencia, si no es asi, se sumara a la edad que aun no este completamente asignado.
        q53LogEstadisticas.printLog("*** CORRECION REPARTO DE EDADES ***");
        q53LogEstadisticas.printLog("Comprobar que el reparto de edades coincida con el numero de personas de la procedencia");
        q53LogEstadisticas.printLog("LLevo asignados (voyAsignando)="+voyAsignando);
        q53LogEstadisticas.printLog("Personas en la procedencia="+numPersonasProc);
        int tmpEdadRatios = rMenor27+rEntre27_45+rEntre46_65+rMayor65+rSinconcretar;
        q53LogEstadisticas.printLog("La suma de los ratios = "+tmpEdadRatios);

        int tmpEdad = voyAsignando;
        cuadrar = 0;

menor27Asig = menor27Asig + menor27AsigIni;
entre27_45Asig = entre27_45Asig + entre27_45AsigIni;
entre46_65Asig = entre46_65Asig + entre46_65AsigIni;
mas65Asig = mas65Asig + mas65AsigIni;
sinConcretarAsig = sinConcretarAsig + sinConcretarAsigIni;


        if (tmpEdad < numPersonasProc)
        { // falta por asignar alguna edad
//System.out.println("Falta por asignar alguna edad" );
            cuadrar = numPersonasProc - tmpEdad;
            q53LogEstadisticas.printLog("Falta alguna edad por asignar="+cuadrar);
int romper = 4;
            while (cuadrar > 0)
            {
            	q53LogEstadisticas.printLog("Mientras cuadrar > 0 ="+cuadrar);
                if (menor27Asig != menor27)
                {
                	q53LogEstadisticas.printLog("El numero de menores de 27 asignados es distinto del numero de menores de 27 ...");
                    int max = new Double(menor27).intValue() - menor27Asig;
                    int tmpMax = cuadrar;
                    if (cuadrar > max) tmpMax = max;
                    menor27Asig = menor27Asig + tmpMax;
                    rMenor27 = rMenor27 + tmpMax;
                    cuadrar = cuadrar - tmpMax;
                    q53LogEstadisticas.printLog("menor27Asig="+menor27Asig);
                } else if (entre27_45Asig != entre27_45)
                {
                	q53LogEstadisticas.printLog("El numero de entre 27 y 45 asignados es distinto del numero de entre 27 y 45...");
                    int max = new Double(entre27_45).intValue() - entre27_45Asig;
                    int tmpMax = cuadrar;
                    if (cuadrar > max) tmpMax = max;
                    entre27_45Asig = entre27_45Asig + tmpMax;
                    rEntre27_45 = rEntre27_45 + tmpMax;
                    cuadrar = cuadrar - tmpMax;
                    q53LogEstadisticas.printLog("entre27_45Asig="+entre27_45Asig);
                } else if (entre46_65Asig != entre46_65)
                {
                	q53LogEstadisticas.printLog("El numero de entre 46 y 65 asignados es distinto del numero de entre 46 y 65 ...");
                    int max = new Double(entre46_65).intValue() - entre46_65Asig;
                    int tmpMax = cuadrar;
                    if (cuadrar > max) tmpMax = max;
                    entre46_65Asig = entre46_65Asig + tmpMax;
                    rEntre46_65 = rEntre46_65 + tmpMax;
                    cuadrar = cuadrar - tmpMax;
                    q53LogEstadisticas.printLog("entre46_65Asig="+entre46_65Asig);
                } else if (mas65Asig != mayor65)
                {
                	q53LogEstadisticas.printLog("El numero de mayores de 65 asignados es distinto del numero de mayores de 65 ...");
                    int max = new Double(mayor65).intValue() - mas65Asig;
                    int tmpMax = cuadrar;
                    if (cuadrar > max) tmpMax = max;
                    mas65Asig = mas65Asig + tmpMax;
                    rMayor65 = rMayor65 + tmpMax;
                    cuadrar = cuadrar - tmpMax;
                    q53LogEstadisticas.printLog("mas65Asig="+mas65Asig);
                } else if (sinConcretarAsig != sinConcretar)
                {
                	q53LogEstadisticas.printLog("El numero de sin concretar asignados es distinto del numero de sin concretar ...");
                    int max = new Double(sinConcretar).intValue() - sinConcretarAsig;
                    int tmpMax = cuadrar;
                    if (cuadrar > max) tmpMax = max;
                    sinConcretarAsig = sinConcretarAsig + tmpMax;
                    rSinconcretar = rSinconcretar + tmpMax;
                    cuadrar = cuadrar - tmpMax;
                    q53LogEstadisticas.printLog("sinConcretarAsig="+sinConcretarAsig);
                }
                romper --;
                if (romper == 0)
                {
                    break;
                }
            }// fin while
        }  else if (tmpEdad > numPersonasProc)
        { // sobra alguna edad asignada
            cuadrar = tmpEdad - numPersonasProc;
            q53LogEstadisticas.printLog("Sobra alguna edad en el reparto = "+cuadrar);
            if (menor27Asig != menor27)
            {
            	q53LogEstadisticas.printLog("Sobra menor 27");
                menor27Asig = menor27Asig - cuadrar;
                rMenor27 = rMenor27 - cuadrar;
            } else if (entre27_45Asig != entre27_45)
            {
            	q53LogEstadisticas.printLog("Sobra entre 27 y 45");
                entre27_45Asig = entre27_45Asig - cuadrar;
                rEntre27_45 = rEntre27_45 - cuadrar;
            } else if (entre46_65Asig != entre46_65)
            {
            	q53LogEstadisticas.printLog("Sobra entre 46 y 65");
                entre46_65Asig = entre46_65Asig - cuadrar;
                rEntre46_65 = rEntre46_65 - cuadrar;
            } else if (mas65Asig != mayor65)
            {
            	q53LogEstadisticas.printLog("Sobra mayor 65");
                mas65Asig = mas65Asig - cuadrar;
                rMayor65 = rMayor65 - cuadrar;
            } else if (sinConcretarAsig != sinConcretar)
            {
            	q53LogEstadisticas.printLog("Sobra sin concretas");
                sinConcretarAsig = sinConcretarAsig - cuadrar;
                rSinconcretar = rSinconcretar - cuadrar;
            }
        }

/*System.out.println("===>>> DESPUES <<<<===== " );
System.out.println("rMenor27 : " + rMenor27);
System.out.println("rEntre27_45 : " + rEntre27_45);
System.out.println("rEntre46_65 : " + rEntre46_65);
System.out.println("rMayor65 : " + rMayor65);
System.out.println("rSinconcretar : " + rSinconcretar);
System.out.println("menor27Asig : " + menor27Asig);
System.out.println("entre27_45Asig : " + entre27_45Asig);
System.out.println("entre46_65Asig : " + entre46_65Asig);
System.out.println("mas65Asig : " + mas65Asig);
System.out.println("sinConcretarAsig : " + sinConcretarAsig);
*/


q53LogEstadisticas.printLog("*** RESUMIENDO *** ");
q53LogEstadisticas.printLog("Valores asignados en esta pasada ");
q53LogEstadisticas.printLog("hombresAsig : " + hombresAsig);
q53LogEstadisticas.printLog("mujeresAsig : " + mujeresAsig);
q53LogEstadisticas.printLog("menor27Asig : " + menor27Asig);
q53LogEstadisticas.printLog("entre27_45Asig : " + entre27_45Asig);
q53LogEstadisticas.printLog("entre46_65Asig : " + entre46_65Asig);
q53LogEstadisticas.printLog("mas65Asig : " + mas65Asig);
q53LogEstadisticas.printLog("sinConcretarAsig : " + sinConcretarAsig);


q53LogEstadisticas.printLog("Se guardan en sesion los siguientes valores de asignacion");

q53LogEstadisticas.printLog("hombresAsig= "+hombresAsig);
q53LogEstadisticas.printLog("mujeresAsig= "+mujeresAsig);
q53LogEstadisticas.printLog("menor27Asig= "+menor27Asig);
q53LogEstadisticas.printLog("entre27_45Asig= "+entre27_45Asig);
q53LogEstadisticas.printLog("entre46_65Asig= "+entre46_65Asig);
q53LogEstadisticas.printLog("mas65Asig= "+mas65Asig);
q53LogEstadisticas.printLog("sinConcretarAsig= "+sinConcretarAsig);
/* Guardar en sesion los valores que ya vamos asignando*/
PSP.setValInSessionProclet(sd, "hombresAsig", ""+hombresAsig);
PSP.setValInSessionProclet(sd, "mujeresAsig", ""+mujeresAsig);
PSP.setValInSessionProclet(sd, "menor27Asig", ""+menor27Asig);
PSP.setValInSessionProclet(sd, "entre27_45Asig", ""+entre27_45Asig);
PSP.setValInSessionProclet(sd, "entre46_65Asig", ""+entre46_65Asig);
PSP.setValInSessionProclet(sd, "mas65Asig", ""+mas65Asig);
PSP.setValInSessionProclet(sd, "sinConcretarAsig", ""+sinConcretarAsig);


q53LogEstadisticas.printLog("Y devuelvo los siguientes valores para guardar en la base de datos");
q53LogEstadisticas.printLog("rHombres : " + rHombres);
q53LogEstadisticas.printLog("rMujeres : " + rMujeres);
q53LogEstadisticas.printLog("rMenor27 : " + rMenor27);
q53LogEstadisticas.printLog("rEntre27_45 : " + rEntre27_45);
q53LogEstadisticas.printLog("rEntre46_65 : " + rEntre46_65);
q53LogEstadisticas.printLog("rMayor65 : " + rMayor65);
q53LogEstadisticas.printLog("rSinconcretar : " + rSinconcretar);

        q53RespuestaGrupoBean respGrupoBean = new q53RespuestaGrupoBean();
        respGrupoBean.setNumHombres(rHombres);
        respGrupoBean.setNumMujeres(rMujeres);
        respGrupoBean.setNumMenor27(rMenor27);
        respGrupoBean.setNumEntre27_45(rEntre27_45);
        respGrupoBean.setNumEntre46_65(rEntre46_65);
        respGrupoBean.setNumMayor65(rMayor65);
        respGrupoBean.setNumSinConcretar(rSinconcretar);

        q53LogEstadisticas.printLog("---------------- FIN ------------------");

        return respGrupoBean;
    }
    
}
