package util;

import java.util.ArrayList;
import java.util.List;

import q53_util.q53Util;

import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;

public class q53LiteralesEncuestaGV {

    public static List getLiteralesCalendario(ProcletServiceData sd)
        throws ProcletException {
        List calendarioList = new ArrayList();
        String enero = q53Util.getLiteral(sd, "GEN_ENERO", q53Util.getIdioma(sd));
        String febrero = q53Util.getLiteral(sd, "GEN_FEBRERO", q53Util.getIdioma(sd));
        String marzo = q53Util.getLiteral(sd, "GEN_MARZO", q53Util.getIdioma(sd));
        String abril = q53Util.getLiteral(sd, "GEN_ABRIL", q53Util.getIdioma(sd));
        String mayo = q53Util.getLiteral(sd, "GEN_MAYO", q53Util.getIdioma(sd));
        String junio = q53Util.getLiteral(sd, "GEN_JUNIO", q53Util.getIdioma(sd));
        String julio = q53Util.getLiteral(sd, "GEN_JULIO", q53Util.getIdioma(sd));
        String agosto = q53Util.getLiteral(sd, "GEN_AGOSTO", q53Util.getIdioma(sd));
        String septiembre = q53Util.getLiteral(sd, "GEN_SEPTIEMBRE", q53Util.getIdioma(sd));
        String octubre = q53Util.getLiteral(sd, "GEN_OCTUBRE", q53Util.getIdioma(sd));
        String noviembre = q53Util.getLiteral(sd, "GEN_NOVIEMBRE", q53Util.getIdioma(sd));
        String diciembre = q53Util.getLiteral(sd, "GEN_DICIEMBRE", q53Util.getIdioma(sd));

        calendarioList.add(enero);
        calendarioList.add(febrero);
        calendarioList.add(marzo);
        calendarioList.add(abril);
        calendarioList.add(mayo);
        calendarioList.add(junio);
        calendarioList.add(julio);
        calendarioList.add(agosto);
        calendarioList.add(septiembre);
        calendarioList.add(octubre);
        calendarioList.add(noviembre);
        calendarioList.add(diciembre);

        return calendarioList;
    }

    /**
     * Mtodo que nos devuelve desde la B.D. los nombres de los literales de
     * grupos de la encuesta del g.v.
     *
     * @param sd objeto ProcletServiceData
     *
     * @return List con los literales de grupos
     *
     * @throws ProcletException
     */
    public static List getLiteralesGrupos(ProcletServiceData sd)
        throws ProcletException {
        List gruposList = new ArrayList();

        String tituloGrupo_1_2 = q53Util.getLiteral(sd, "N1_2",
                q53Util.getIdioma(sd));
        String grupo8_2_1 = q53Util.getLiteral(sd, "N8_2_1",
                q53Util.getIdioma(sd));
        String grupo8_2_2 = q53Util.getLiteral(sd, "N8_2_2",
                q53Util.getIdioma(sd));

        gruposList.add(tituloGrupo_1_2);
        gruposList.add(grupo8_2_1);
        gruposList.add(grupo8_2_2);

        return gruposList;
    }

    /**
     * Mtodo que nos devuelve desde la B.D. los nombres de los literales de
     * grupos de edad de la encuesta del g.v.
     *
     * @param sd objeto ProcletServiceData
     *
     * @return List con los literales de grupos
     *
     * @throws ProcletException
     */
    public static List getLiteralesGruposEdad(ProcletServiceData sd)
        throws ProcletException {
        List gruposList = new ArrayList();

        String tituloGrupo_1_2 = q53Util.getLiteral(sd, "N1_5",
                q53Util.getIdioma(sd));
        String grupo8_5_1 = q53Util.getLiteral(sd, "N8_5_1",
                q53Util.getIdioma(sd));
        String grupo8_5_2 = q53Util.getLiteral(sd, "N8_5_2",
                q53Util.getIdioma(sd));
        String grupo8_5_3 = q53Util.getLiteral(sd, "N8_5_3",
                q53Util.getIdioma(sd));
        String grupo8_5_4 = q53Util.getLiteral(sd, "N8_5_4",
                q53Util.getIdioma(sd));
        String grupo8_5_5 = q53Util.getLiteral(sd, "N8_5_5",
                q53Util.getIdioma(sd));

        gruposList.add(tituloGrupo_1_2);
        gruposList.add(grupo8_5_1);
        gruposList.add(grupo8_5_2);
        gruposList.add(grupo8_5_3);
        gruposList.add(grupo8_5_4);
        gruposList.add(grupo8_5_5);

        return gruposList;
    }

    /**
     * Mtodo que nos devuelve desde la B.D. los nombres de los literales de
     * las preguntas de tipo opciones de la encuesta del g.v.
     *
     * @param sd objeto ProcletServiceData
     * @param tituloOpciones String que es el cdigo de la pregunta de tipo
     *        opciones
     * @param opcion String que es el cdigo de la opcion
     * @param numOpciones String que es el numero de opciones que tiene esa
     *        pregunta
     *
     * @return List con los literales de grupos
     *
     * @throws ProcletException
     */
    public static List getLiteralesOpciones(ProcletServiceData sd,
        String tituloOpciones, String opcion, int numOpciones)
        throws ProcletException {
        List opcionesList = new ArrayList();

        String tituloOpcion_1_4 = q53Util.getLiteral(sd, tituloOpciones,
                q53Util.getIdioma(sd));
        opcionesList.add(tituloOpcion_1_4);

        for (int i = 1; i < numOpciones; i++) {
            String opcionLiteral = q53Util.getLiteral(sd, opcion + i,
                    q53Util.getIdioma(sd));
            opcionesList.add(opcionLiteral);
        }

        return opcionesList;
    }
    
    public static List getLiteralesOpcionesTipoInfo(ProcletServiceData sd,
            String tituloOpciones, String opcion, int numOpciones)
            throws ProcletException {
            List opcionesList = new ArrayList();

            String tituloOpcion_1_4 = q53Util.getLiteral(sd, tituloOpciones,
                    q53Util.getIdioma(sd));
            opcionesList.add(tituloOpcion_1_4);

            for (int i = 1; i < numOpciones; i++) {
                String opcionLiteral = q53Util.getLiteralOpcionesTipoInfo(sd, opcion + i,
                        q53Util.getIdioma(sd));
                opcionesList.add(opcionLiteral);
            }

            return opcionesList;
        }
    
    public static List getLiteralesOpcionesDesdeHasta(ProcletServiceData sd,
        String tituloOpciones, String opcion, int numOpcionesDesde, int numOpcionesHasta)
        throws ProcletException {
        List opcionesList = new ArrayList();

        String tituloOpcion_1_4 = q53Util.getLiteral(sd, tituloOpciones,
                q53Util.getIdioma(sd));
        opcionesList.add(tituloOpcion_1_4);

        for (int i = numOpcionesDesde; i <= numOpcionesHasta; i++) {
            String opcionLiteral = q53Util.getLiteral(sd, opcion + i,
                    q53Util.getIdioma(sd));
            opcionesList.add(opcionLiteral);
        }

        return opcionesList;
    }


    //20150417  INICIO Devolver Literales de pregunta nueva (VALORACION ESTANCIA	
    /**
     * Mtodo que nos devuelve desde la B.D. el literal de
     * una pregunta de tipo normal (texto..) de la encuesta del g.v.
     *
     * @param sd objeto ProcletServiceData
     * @param pregunta String que es el cdigo de la pregunta
     *
     * @return List con los literales de grupos
     *
     * @throws ProcletException
     */
    public static String getLiteralPregunta(ProcletServiceData sd,
        String pregunta)
        throws ProcletException {
 
        String tituloPregunta = q53Util.getLiteral(sd, pregunta, q53Util.getIdioma(sd));
 
        return tituloPregunta ;
    }
    //20150417  FIN Devolver Literales de pregunta nueva (VALORACION ESTANCIA	

}
