package util;

import itourbaskBeans.q53MunicipioBean;
import itourbaskClases.q53ProcedenciaClass;

import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


public class q53EstPredefinidasUtil {
    
    /**
     * Metodo para recuperar la fecha que se va a pasar en la consulta
     * @param sd el objeto ProcletServiceData
     * @param dia 
     * @param mes 
     * @param anio 
     * @throws com.cidat.proclets.ProcletException 
     * @return String con la fecha
     */
    public static String getFechas(ProcletServiceData sd,String dia,String mes,String anio) throws ProcletException{
        String fecha = "";
        if (sd.gOS("tiempo").equals("mensual")) {
            fecha = "01"+mes+anio;
        }else{
            fecha = dia+mes+anio;
        }
        return fecha;
    }
    
    
    //
    /**
     * Mtodo para obtener los datos de procedencia para las estadisticas
     * @param sd 
     * @throws com.cidat.proclets.ProcletException 
     */
    public static void getProcedencia(ProcletServiceData sd) throws ProcletException {
        
        String q53_idioma = q53Util.getIdioma(sd);
        // Obtener los territorios
        String terr = "SELECT p2_cod_territorio cod_territorio, ";
        if (q53_idioma.equals("C")) {
            terr += " p2_nombre_cas territorio";
        } else {
            terr += " p2_nombre_eus territorio";
        }
        terr += " FROM territorio "
                + "WHERE territorio.p2_cod_comunidad = 0 "
                + " ORDER BY territorio.p2_cod_territorio";
        PSP.sqlProclet(sd,"territorio[]="+terr);
        
        // Obtener las comunidades
        String prov = "SELECT comunidad.p1_cod_comunidad cod_comunidad, ";
        if (q53_idioma.equals("C")) {
            prov += "comunidad.p1_nombre_cas comunidad ";
        } else {
            prov += "comunidad.p1_nombre_eus comunidad ";
        }
        prov += " FROM comunidad "
                + " WHERE comunidad.p1_cod_comunidad != 0 "
                + " AND comunidad.p1_cod_pais = 0 "
                + " ORDER BY comunidad.p1_cod_comunidad ";
        PSP.sqlProclet(sd, "comunidad[]="+prov);
        
        // Obtener las departamentos
        String dep = "SELECT comunidad.p1_cod_comunidad cod_departamento, ";
        if (q53_idioma.equals("C")) {
            dep += "comunidad.p1_nombre_cas departamento ";
        } else {
            dep += "comunidad.p1_nombre_eus departamento ";
        }
        dep += " FROM comunidad "
                + " WHERE comunidad.p1_cod_comunidad != 0 "
                + " AND comunidad.p1_cod_pais = 10 "
                + " ORDER BY comunidad.p1_cod_comunidad ";
        PSP.sqlProclet(sd, "departamento[]="+dep);
        
        // Obtener los paises
        String pais = "SELECT pais.p0_cod_pais cod_pais,";
        if (q53_idioma.equals("C")) {
            pais += "pais.p0_nombre_cas pais ";
        } else {
            pais += "pais.p0_nombre_eus pais ";
        }
        pais += "FROM pais "
                + " WHERE pais.p0_cod_pais != 0 and pais.p0_cod_pais != 10  "
                + " ORDER BY pais.p0_cod_pais";

        PSP.sqlProclet(sd, "pais[]="+pais); 
        
    }

	 /**
     * Mtodo para obtener los datos de procedencia para las estadisticas
     * @param sd 
     * @throws com.cidat.proclets.ProcletException 
     */
    public static void getProcedencia(ProcletServiceData sd,q53LogEstadisticas q53Estlog,String fileName) throws ProcletException {
        
        String q53_idioma = q53Util.getIdioma(sd);
        // Obtener los territorios odenados por nombre
        String terr = "SELECT p2_cod_territorio cod_territorio, ";
        if (q53_idioma.equals("C")) {
            terr += " p2_nombre_cas territorio";
        } else {
            terr += " p2_nombre_eus territorio";
        }
        terr += " FROM territorio "
                + "WHERE territorio.p2_cod_comunidad = 0 "
                + " ORDER BY territorio";
		q53Estlog.log(sd.getLogFilePath(),fileName,"q53EstPredefinidasUtil:getProcedencia()::::"+terr);
        PSP.sqlProclet(sd,"territorio[]="+terr);
        
        // Obtener las comunidades ordenadas por nombre
        String prov = "SELECT comunidad.p1_cod_comunidad cod_comunidad, ";
        if (q53_idioma.equals("C")) {
            prov += "comunidad.p1_nombre_cas comunidad ";
        } else {
            prov += "comunidad.p1_nombre_eus comunidad ";
        }
        prov += " FROM comunidad "
                + " WHERE comunidad.p1_cod_comunidad != 0 "
                + " AND comunidad.p1_cod_pais = 0 "
                + " ORDER BY comunidad ";
		q53Estlog.log(sd.getLogFilePath(),fileName,"q53EstPredefinidasUtil:getProcedencia()::::"+prov);
        PSP.sqlProclet(sd, "comunidad[]="+prov);
        
         // Obtener las departamentos
        String dep = "SELECT comunidad.p1_cod_comunidad cod_departamento, ";
        if (q53_idioma.equals("C")) {
            dep += "comunidad.p1_nombre_cas departamento ";
        } else {
            dep += "comunidad.p1_nombre_eus departamento ";
        }
        dep += " FROM comunidad "
                + " WHERE comunidad.p1_cod_comunidad != 0 "
                + " AND comunidad.p1_cod_pais = 10 "
                + " ORDER BY comunidad.p1_cod_comunidad ";
        	q53Estlog.log(sd.getLogFilePath(),fileName,"q53EstPredefinidasUtil:getProcedencia()::::"+dep);
        PSP.sqlProclet(sd, "departamento[]="+dep);
        
        // Obtener los paises ordenados por nombre
        
        
        String pais = "SELECT pais.p0_cod_pais cod_pais,";
        if (q53_idioma.equals("C")) {
            pais += "pais.p0_nombre_cas pais ";
        } else {
            pais += "pais.p0_nombre_eus pais ";
        }
        pais += "FROM pais "
                + " WHERE pais.p0_cod_pais != 0  and pais.p0_cod_pais != 10  "
                + " ORDER BY pais";
		q53Estlog.log(sd.getLogFilePath(),fileName,"q53EstPredefinidasUtil:getProcedencia() ::::"+pais);
        PSP.sqlProclet(sd, "pais[]="+pais);
        
    }
    
    /**
     * Mtodo que nos devuelve el trozo de consulta del lugar de recepcion
     * @param sd 
     * @throws com.cidat.proclets.ProcletException 
     * @return String con la consulta
     */
    public static String getRecepcionEncuesta(ProcletServiceData sd) throws ProcletException {
        // Por lugar de recepcion de la encuesta
        String recepcion = "";
        if (!q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
            if (sd.gOS("recepcion").equals("comarca")) { // todas las oficinas de la comarca
                PSP.paramProclet(sd,"cod_comarca()");
                String cod_comarca = sd.gOS("cod_comarca");
                // Recoger los municipios de la comarca
                List municipioList = q53ProcedenciaClass.getMunicipiosByComarca(sd, cod_comarca);
                sd.setVal("municipioList", municipioList);
                // Recoger las oficinas de la comarca
                String muni = "";
                int n = municipioList.size();
                for (int i = 0; i < n; i++) {
                    q53MunicipioBean municipio = (q53MunicipioBean) municipioList.get(i);
                    String tmp = municipio.getCodMunicipio();
                    String tmp_muni = tmp.substring(3);
                    if (i < (n - 1)) {
                        muni += (tmp_muni + ",");
                    } else {
                        muni += tmp_muni;
                    }
                }
                String oficinasList = "";
                String select_oficinas = "SELECT t02_coor" +
                        " FROM oficina "+
                        " WHERE t02_codmunicip IN (" + muni + ")"+
                        " AND t02_inesta='S'";
                PSP.sqlProclet(sd, "oficinas[]=" + select_oficinas);
                if (sd.gI("oficinas.length") > 0) {
                    int numOfi = sd.gI("oficinas.length");
                    
                    for (int i = 0; i < numOfi; i++) {
                        oficinasList += "'"+sd.gOS("oficinas[" + i + "].t02_coor")+"',";
                    }
                    oficinasList = oficinasList.substring(0,oficinasList.length()-1);
                }
				
				if(oficinasList != null && !oficinasList.equals("") && !oficinasList.equals(",")){
	                recepcion = " AND respuesta.m0_cod_oficina IN ("+oficinasList+") ";	
				}
                // fin recepcion = comarca
            } else if (sd.gOS("recepcion").equals("oficina")) {
                PSP.paramProclet(sd, "cod_oficina()");
                recepcion = " AND respuesta.m0_cod_oficina = '"+sd.gOS("cod_oficina")+"' ";
                // fin recepcion = oficina
            } else if (sd.gOS("recepcion").equals("municipio")) {
                PSP.paramProclet(sd,"cod_municipio()");
                String cod_municipio = sd.gOS("cod_municipio").substring(3);
                
                String oficinasList = "";
                String select_oficinas = "SELECT t02_coor" +
                        " FROM oficina "+
                        " WHERE t02_codmunicip = "+cod_municipio+
                        " AND t02_inesta='S'";
                
                
                PSP.sqlProclet(sd, "oficinas[]=" + select_oficinas);
                
                if (sd.gI("oficinas.length") > 0) {
                    int numOfi = sd.gI("oficinas.length");
                    
                    for (int i = 0; i < numOfi; i++) {
                        //oficinasList += sd.gOS("oficinas[" + i + "].t02_coor")+",";
                        oficinasList += "'"+sd.gOS("oficinas[" + i + "].t02_coor")+"',";
                        
                    }
                    oficinasList = oficinasList.substring(oficinasList.length()-1);
                }
				
				if(oficinasList != null && !oficinasList.equals("") && !oficinasList.equals(",")){
	                recepcion = " AND respuesta.m0_cod_oficina IN ("+oficinasList+") ";	
				}
                //recepcion = " AND respuesta.m0_cod_oficina IN ("+oficinasList+") ";
            } // fin recepcion = municipio
            else if (sd.gOS("recepcion").equals("territorio")) {
                PSP.paramProclet(sd,"cod_territorio()");
                String cod_territorio = sd.gOS("cod_territorio");
                // Recoger los municipios de la comarca
                List municipioList = q53ProcedenciaClass.getMunicipiosByTerritorio(sd, cod_territorio);
                //sd.setVal("municipioList", municipioList);
                
                // Recoger las oficinas del territorio
                String muni = "";
                int n = municipioList.size();
                for (int i = 0; i < n; i++) {
                    q53MunicipioBean municipio = (q53MunicipioBean) municipioList.get(i);
                    String tmp = municipio.getCodMunicipio();
                    
                    String tmp_muni = tmp.substring(3);
                    
                    if (i < (n - 1)) {
                        muni += (tmp_muni + ",");
                    } else {
                        muni += tmp_muni;
                    }
                }
                String oficinasList = "";
                String select_oficinas = "SELECT t02_coor" +
                        " FROM oficina "+
                        " WHERE t02_codmunicip IN (" + muni + ")"+
                        " AND t02_inesta='S'";
                
                PSP.sqlProclet(sd, "oficinas[]=" + select_oficinas);
                
                if (sd.gI("oficinas.length") > 0) {
                    int numOfi = sd.gI("oficinas.length");
                    
                    for (int i = 0; i < numOfi; i++) {
                        oficinasList += "'"+sd.gOS("oficinas[" + i + "].t02_coor")+"',";
                    }
                    oficinasList = oficinasList.substring(0,oficinasList.length()-1);
                }
				
				if(oficinasList != null && !oficinasList.equals("") && !oficinasList.equals(",")){
	                recepcion = " AND respuesta.m0_cod_oficina IN ("+oficinasList+") ";	
				}
                //recepcion = " AND respuesta.m0_cod_oficina IN ("+oficinasList+") ";
                // fin recepcion = comarca
            } // fin recepcion = territorio historico
        } // fin tipo perfil administrador o coordinador
        else{//perfil usuario de oficina
// 02.10.2006            PSP.paramProclet(sd, "cod_oficina()");
// 02.10.2006            recepcion = " AND respuesta.m0_cod_oficina = '"+sd.gOS("cod_oficina")+"' ";
            recepcion = " AND respuesta.m0_cod_oficina = '"+sd.gOS("q53_cki.q53_oficina")+"' ";
        }
        return recepcion;
        
    }
    
	 /**
     * Mtodo que nos devuelve el trozo de consulta del lugar de recepcion
     * @param sd 
     * @throws com.cidat.proclets.ProcletException 
     * @return String con la consulta
     */
    public static String getRecepcionEncuesta(ProcletServiceData sd,q53LogEstadisticas q53Estlog,String fileName) throws ProcletException {
        // Por lugar de recepcion de la encuesta
        String txtRecepcion = "";
        if (!q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
            if (sd.gOS("recepcion").equals("comarca")) { // todas las oficinas de la comarca
                PSP.paramProclet(sd,"cod_comarca()");
                String cod_comarca = sd.gOS("cod_comarca");
                // Recoger los municipios de la comarca
                List municipioList = q53ProcedenciaClass.getMunicipiosByComarca(sd, cod_comarca,q53Estlog,fileName);
                sd.setVal("municipioList", municipioList);
                // Recoger las oficinas de la comarca
                String muni = "";
                int n = municipioList.size();
                for (int i = 0; i < n; i++) {
                    q53MunicipioBean municipio = (q53MunicipioBean) municipioList.get(i);
                    String tmp = municipio.getCodMunicipio();
                    String tmp_muni = tmp.substring(3);
                    if (i < (n - 1)) {
                        muni += (tmp_muni + ",");
                    } else {
                        muni += tmp_muni;
                    }
                }
                String oficinasList = "";
                String select_oficinas = "SELECT t02_coor" +
                        " FROM oficina "+
                        " WHERE t02_codmunicip IN (" + muni + ")"+
                        " AND t02_inesta='S'";
				q53Estlog.log(sd.getLogFilePath(),fileName,"q53EstPredefinidasUtil:getRecepcionEncuesta()::::"+select_oficinas);
                PSP.sqlProclet(sd, "oficinas[]=" + select_oficinas);
                if (sd.gI("oficinas.length") > 0) {
                    int numOfi = sd.gI("oficinas.length");
                    
                    for (int i = 0; i < numOfi; i++) {
                        oficinasList += "'"+sd.gOS("oficinas[" + i + "].t02_coor")+"',";
                    }
                    oficinasList = oficinasList.substring(0,oficinasList.length()-1);
                }
				
				if(oficinasList != null && !oficinasList.equals("") && !oficinasList.equals(",")){
	                txtRecepcion = " AND respuesta.m0_cod_oficina IN ("+oficinasList+") ";	
				}
                // fin recepcion = comarca
            } else if (sd.gOS("recepcion").equals("oficina")) {
                PSP.paramProclet(sd, "cod_oficina()");
                txtRecepcion = " AND respuesta.m0_cod_oficina = '"+sd.gOS("cod_oficina")+"' ";
                // fin recepcion = oficina
            } else if (sd.gOS("recepcion").equals("municipio")) {
                PSP.paramProclet(sd,"cod_municipio()");
                String cod_municipio = sd.gOS("cod_municipio").substring(5);
                String oficinasList = "";
                String select_oficinas = "SELECT t02_coor" +
                        " FROM oficina "+
                        " WHERE t02_codmunicip = "+cod_municipio+
                        " AND t02_inesta='S'";
                
                q53Estlog.log(sd.getLogFilePath(),fileName,"q53EstPredefinidasUtil:getRecepcionEncuesta()::::"+select_oficinas);
                PSP.sqlProclet(sd, "oficinas[]=" + select_oficinas);
                
                if (sd.gI("oficinas.length") > 0) {
                    int numOfi = sd.gI("oficinas.length");
                    
                    for (int i = 0; i < numOfi; i++) {
                        //oficinasList += sd.gOS("oficinas[" + i + "].t02_coor")+",";
                        oficinasList += "'"+sd.gOS("oficinas[" + i + "].t02_coor")+"',";
                    }
                    oficinasList = oficinasList.substring(0,oficinasList.length()-1);
                }
				if(oficinasList != null && !oficinasList.equals("") && !oficinasList.equals(",")){
                    if (oficinasList.indexOf(",") == -1)
                    {
                        //txtRecepcion = " AND respuesta.m0_cod_oficina LIKE '"+oficinasList+"' ";	
                        txtRecepcion = " AND respuesta.m0_cod_oficina LIKE "+oficinasList+" ";	
                    } else {
                        txtRecepcion = " AND respuesta.m0_cod_oficina IN ("+oficinasList+") ";	
                    }
				}
                //recepcion = " AND respuesta.m0_cod_oficina IN ("+oficinasList+") ";
            } // fin recepcion = municipio
            else if (sd.gOS("recepcion").equals("territorio")) {
                PSP.paramProclet(sd,"cod_territorio()");
                String cod_territorio = sd.gOS("cod_territorio");
                if (cod_territorio.equals("0")) // Araba
                {
                    cod_territorio = "01";
                } else if (cod_territorio.equals("1")) // Bizkaia
                {
                    cod_territorio = "48";
                } else if (cod_territorio.equals("2")) // Gipuzkoa
                {
                    cod_territorio = "20";
                }

                // Recoger las oficinas del territorio
                String oficinasList = "";
                String select_oficinas = "SELECT t02_coor" +
                        " FROM oficina "+
                        " WHERE t02_inesta='S' AND substr(decode (length(t02_coor),5,'0'||t02_coor,t02_coor),0,2) = "+cod_territorio;
                q53Estlog.log(sd.getLogFilePath(),fileName,"q53EstPredefinidasUtil:getRecepcionEncuesta()::::"+select_oficinas);
                PSP.sqlProclet(sd, "oficinas[]=" + select_oficinas);
                
                if (sd.gI("oficinas.length") > 0) {
                    int numOfi = sd.gI("oficinas.length");
                    
                    for (int i = 0; i < numOfi; i++) {
                        oficinasList += "'"+sd.gOS("oficinas[" + i + "].t02_coor")+"',";
                    }
                    oficinasList = oficinasList.substring(0,oficinasList.length()-1);
                }
                
                if(oficinasList != null && !oficinasList.equals("") && !oficinasList.equals(",")){
                    txtRecepcion = " AND respuesta.m0_cod_oficina IN ("+oficinasList+") ";	
                }
            } // fin recepcion = territorio historico
        } // fin tipo perfil administrador o coordinador
        else{//perfil usuario de oficina
            txtRecepcion = " AND respuesta.m0_cod_oficina = '"+sd.gOS("q53_cki.q53_oficina")+"' ";
        }
        return txtRecepcion;
        
    }
    
    
    
    
    
}
