package itourbaskServlet;

import itourbaskBeans.q53EncuestaBean;
import itourbaskBeans.q53FechaBean;
import itourbaskBeans.q53RespuestaBean;
import itourbaskClases.q53EncuestaClass;
import itourbaskClases.q53RespuestaClass;

import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53RecorrerPreguntas;
import q53_util.q53Util;
import util.q53LiteralesEncuestaGV;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53usrVerRespuestasServlet extends q53Servlet {
    /**
     * DOCUMENT ME!
     *
     * @param sd DOCUMENT ME!
     *
     * @throws ProcletException DOCUMENT ME!
     */
    public void pspProcess(ProcletServiceData sd) throws ProcletException {
        try {
            // establece el contentType del response
            sd.res.setContentType("text/html");
            sd.res.setHeader("Pragma", "no-cache");
            sd.res.setHeader("Cache-Control", "no-cache");
            sd.res.setHeader("Expires", "0");
         // Trapi para que chute
        	//sd.servletSrvVersion = 8;
        	
            // tratar las cookies
            q53_tratarCookies(sd);

            String perfilUser = "NO";
            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
                perfilUser = "SI";
            }

            String perfilCoord = "NO";
            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
                perfilCoord = "SI";
            }

            String perfilAdmin = "NO";
            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
                perfilAdmin = "SI";
            }

            sd.setVal("perfilUser", perfilUser);
            sd.setVal("perfilCoord", perfilCoord);
            sd.setVal("perfilAdmin", perfilAdmin);

            String codOficina = sd.gOS("q53_cki.q53_oficina");
            PSP.paramProclet(sd,
                "cod_encuesta(), cod_version(), cod_respuesta(), accion(), respuesta_rd_asociada(), encuestas_terminadas(), fechaInicio(), fechaFin(), numRespuestas(), respNum(), gv_cod_encuesta(), gv_cod_version()");

            String fechaInicio = sd.gOS("fechaInicio");
            String fechaFin = sd.gOS("fechaFin");
            String codEncuesta = sd.gOS("cod_encuesta");

            String numResp = sd.gOS("numRespuestas");
            String respNum = sd.gOS("respNum");
            String codVersion = sd.gOS("cod_version");
            String codRespuesta = sd.gOS("cod_respuesta");

            int nuRespEncOfi = 0;
            String num_respuesta = "0";

            String gvCodEncuesta = sd.gOS("gv_cod_encuesta");
            String gvCodVersion = sd.gOS("gv_cod_version");

            String usuario = sd.gOS("q53_cki.q53_usuario");
            String codRespEncOfi = sd.gOS("codRespuesta");

           q53EncuestaBean encuestaBean = null;

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
                if (codEncuesta.equals("") || codEncuesta.equals("0")) {
                    //No hay codigo de encuesta o es "0" en este caso 
                    //tenemos que mostrar las respuestas de la encuesta del g.v.
					encuestaBean = q53EncuestaClass.getEncByDate(sd,
                            codOficina, codEncuesta, codVersion, fechaInicio,
                            fechaFin);
                    sd.setVal("pagina", "recogida_de_datos");
                } else {
                    //Hay codigo de encuesta o es distinto de "0" en este caso 
                    //tenemos que mostrar las respuestas de la encuesta propia de la oficina.
                    String encuesta=sd.gOS("encuesta");
                    q53EncuestaBean encuestaVisible = null;
                    if(encuesta.equals("pres")){
                        encuestaVisible = q53EncuestaClass.getEncuestaVisiblePres(sd,
                             codOficina);
                     }else{
                        encuestaVisible = q53EncuestaClass.getEncuestaVisibleNoPres(sd,
                                 codOficina);
                     }
                    sd.setVal("pagina", "otras_encuestas");
                    sd.setVal("hay_preg_ofi", "SI");
                }

// 08.05.2007 Nuevo
                if (encuestaBean == null) {
                // Al modificar la respuesta, me quedo sin ninguna respuesta para el periodo de tiempo, asi que redirijo a la pagina de busqueda
                    q53_redirigir(sd,"/q53ItourbaskWar/q53usrBusquedaServlet?accion=inicioBusqueda");
                    return;
                }
// 08.05.2007 Fin Nuevo

                if (encuestaBean != null) {
//21.11.2006                    if (sd.gI("enc.length") > 0) {
                        // hay encuesta. recoger preguntas
                        sd.setVal("hay_preg", "SI");

                        //Recuperamos la lista de preguntas de la encuesta (tanto la del g.v. como
                        //en el caso de la encuesta propia de la oficina)
                        List preguntasList = q53EncuestaClass.getPreguntasEncOfiData(sd,
                                encuestaBean.getCodEncuesta(),
                                encuestaBean.getCodVersion());
                        encuestaBean.setPreguntasList(preguntasList);
                        //Recuperamos las respuestas de la encuesta del g.v. filtradas por fechas
                        q53RespuestaBean respuestaBean = q53RespuestaClass.getRespuestasDataFilterByDate(sd,
                                fechaInicio, fechaFin,
                                encuestaBean.getCodEncuesta(),
                                encuestaBean.getCodVersion(), codOficina);
//26.09.2006                                encuestaBean.getCodVersion(), "");
                        sd.setVal("numRespuestas",
                            new Integer(respuestaBean.getNumRespuestas()));
                        sd.setVal("maxCodRespuesta",
                            respuestaBean.getMaxCodRespuesta());
                        sd.setVal("minCodRespuesta",
                            respuestaBean.getMinCodRespuesta());
                        // String num_respuesta = "0";
                        // inicializamos el nmero de la respuesta a 0.
                        if (respuestaBean != null) {
                            int numRespuestas = respuestaBean.getNumRespuestas();
                            if (numRespuestas > 0) {
                                sd.setVal("hay_resp", "SI");
                                // la respuesta que se muestre depender de los parmetros
                                // cod_respuesta y accion.
                                //
                                // si cod_respuesta & accion son vacios, devuelve la primera
                                //      respuesta de la encuesta
                                // si accion es "primera" devuelve el cdigo de la primera
                                //      respuesta de la encuesta
                                // si accion es "ultima" devuelve el cdigo de la ltima
                                //      respuesta de la encuesta
                                // si cod_respuesta existe y accion es vaco, devuelve esa
                                //      respuesta
                                // si cod_respuesta existe y accion es "anterior", devuelve la
                                //      respuesta anterior a la de cod_respuesta
                                // si cod_respuesta existe y accion es "siguiente", devuelve la
                                //      respuesta siguiente a la de cod_respuesta
                                String cod_respuesta = q53RespuestaClass.calcularCodRespuesta(sd,
                                        respuestaBean, fechaInicio, fechaFin,
                                        codRespuesta,
                                        encuestaBean.getCodVersion());
                                sd.setVal("cod_respuesta", cod_respuesta); // machacamos el valor incluso si viene en el parametro
                                sd.setVal("codRespuesta", cod_respuesta);

                                // Calculamos el numero de respuesta
                                num_respuesta = q53RespuestaClass.calcularNumRespuesta(sd,
                                        cod_respuesta, fechaInicio, fechaFin,
                                        codOficina, encuestaBean.getCodEncuesta(),
                                        encuestaBean.getCodVersion(),"");
                                // recorrer pregunta por pregunta para coger la info. de los campos
                                // que dependen del tipo de pregunta
                                // y
                                // recorrer todas las respuestas de la respuesta cod_respuesta
                                List respBeanList = q53RespuestaClass.recorrerPreguntasRespuesta(sd,
                                        preguntasList, cod_respuesta);
                                encuestaBean.setRespuestasList(respBeanList);
                                nuRespEncOfi = respBeanList.size();
                            }
                        }
                        // guardamos en el sd el nmero de la respuesta
                        //sd.setVal("num_respuesta", num_respuesta);
//21.11.2006                    }
                }

                sd.setVal("encuestaBean", encuestaBean);

                //Como ahora podremos modifica las respuestas tanto de la encuesta
                //del g.v. como de la propia de la oficina necesitamos los datos de
                //las pregutnas en este caso la fecha mxima y mnima
                q53FechaBean q53FechaBean = q53EncuestaClass.getGVDate(sd);
                sd.setVal("fechasGV", q53FechaBean);

                //Dependiendo de si es la encuesta del g.v. o la propia de la oficina
                //la forma de calcula el numero de respuestas y el numero de respuesta
                //es diferente
                if (codEncuesta.equals("") || codEncuesta.equals("0")) {
                    if (sd.gOS("accion").equals(q53Constantes.ACCION_ANTERIOR)) {
                        int nResp = (new Integer(respNum)).intValue();
                        respNum = "" + new Integer(nResp - 1);
                    } else if (sd.gOS("accion").equals(q53Constantes.ACCION_SIGUIENTE)) {
                        int nResp = (new Integer(respNum)).intValue();
                        respNum = "" + new Integer(nResp + 1);
                    } else if (sd.gOS("accion").equals(q53Constantes.ACCION_PRIMERA)) {
                        respNum = "1";
                    } else if (sd.gOS("accion").equals(q53Constantes.ACCION_ULTIMA)) {
                        respNum = numResp;
                    }
                    sd.setVal("numResp", numResp);
                    sd.setVal("respNum", respNum);

                    String n0Descripcion = "N0_" + codEncuesta + "_" +
                        encuestaBean.getCodVersion();

                    n0Descripcion = q53Util.getLiteral(sd, n0Descripcion,
                            q53Util.getIdioma(sd));
                    sd.setVal("descEncuestaGV", n0Descripcion);
                    q53RecorrerPreguntas.cogerPreguntaProcedencia(sd,
                        "preg_gv", 2);
                    q53RecorrerPreguntas.cogerPreguntaFecha(sd, 0);
                } else {
                    sd.setVal("numResp", sd.gOS("numRespuestas"));
                    sd.setVal("respNum", num_respuesta);
                }

                //Recuperamos los datos necesarios para que al pulsar el botno volver
                //ueda volver a la pagian de recogida de datos
                String numEncHoy = q53EncuestaClass.getNumEncuestasHoy(sd);
                sd.setVal("numEncHoy", numEncHoy);
                sd.setVal("literalesCalendario",
                    q53LiteralesEncuestaGV.getLiteralesCalendario(sd));
                sd.setVal("literalesGrupos",
                    q53LiteralesEncuestaGV.getLiteralesGrupos(sd));
                sd.setVal("literalesGruposEdad",
                    q53LiteralesEncuestaGV.getLiteralesGruposEdad(sd));
                sd.setVal("literalesIdiomaConsulta",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_4",
                        "N3_4_", 8));
                sd.setVal("literalesInformacionSolicitada",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_7",
                        "N3_7_", 7));
                sd.setVal("literalesTipoServicio",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_1",
                        "N3_1_", 6));
                sd.setVal("literalesMedioRecepcion",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_3",
                        "N3_3_", 8));
                sd.setVal("literalesTipoInformacion",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_8",
                        "N3_8_", 20));
					//IGC 20150519 INICIO INCLUIR PREGUNTA VALIDACION ESTANCIA
                    sd.setVal("literalesValoracionEstancia",
                        q53LiteralesEncuestaGV.getLiteralesOpcionesDesdeHasta(sd, "N1_12",
                            "N3_12_", 0, 5));
                    sd.setVal("textoAyudaValoracionEstancia",
                        q53LiteralesEncuestaGV.getLiteralPregunta(sd, "AYUDA_VALORACION_ESTANCIA"));
					//IGC 20150519 FIN INCLUIR PREGUNTA VALIDACION ESTANCIA

                sd.setVal("fechaInicio", fechaInicio);
                sd.setVal("fechaFin", fechaFin);
//                sd.setVal("codRespuesta", codRespuesta);
                sd.setVal("cod_encuesta", codEncuesta);
                sd.setVal("cod_version", codVersion);

                PSP.setTemplatePageProclet(sd, "/q53_usr_verRespuestas.jsp");
            } // if perfil coordinador
            else if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO) ||
                    q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) { // perfil administrador o usuario 
                //if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
                encuestaBean = null;

                //Miramos si la encuesta es la del g.v.
                if (codEncuesta.equals("") || codEncuesta.equals("0")) {
                    //Buscamos los datos de la encuesta del g.v.
                    encuestaBean = q53EncuestaClass.getEncByDate(sd,
                            codOficina, codEncuesta, codVersion, fechaInicio,
                            fechaFin);
                    sd.setVal("pagina", "recogida_de_datos");
                } else {
                    //Buscamos los datos de la encuesta del propia de la oficina
                    //que esta visible.
                    String encuesta=sd.gOS("encuesta");
                    q53EncuestaBean encuestaVisible = null;
                    if(encuesta.equals("pres")){
                        encuestaVisible = q53EncuestaClass.getEncuestaVisiblePres(sd,
                             codOficina);
                     }else{
                        encuestaVisible = q53EncuestaClass.getEncuestaVisibleNoPres(sd,
                                 codOficina);
                     }
                    sd.setVal("pagina", "otras_encuestas");
                    sd.setVal("hay_preg_ofi", "SI");
                }

                String numRespEncOfi = "0";

// 08.05.2007 Nuevo
                if (encuestaBean == null) {
                // Al modificar la respuesta, me quedo sin ninguna respuesta para el periodo de tiempo, asi que redirijo a la pagina de busqueda
                    q53_redirigir(sd,"/q53ItourbaskWar/q53usrBusquedaServlet?accion=inicioBusqueda");
                    return;
                }
// 08.05.2007 Fin Nuevo

                if (encuestaBean != null) {
                    // hay encuesta. recoger preguntas
                    sd.setVal("hay_preg", "SI");

                    //Recuperamos en una lista las preguntas de la encuesta
                    List preguntasList = q53EncuestaClass.getPreguntasEncOfiData(sd,
                            encuestaBean.getCodEncuesta(),
                            encuestaBean.getCodVersion());
                    encuestaBean.setPreguntasList(preguntasList);

                    //Recuperamos el numero de rspuestas y los codigos de respuesta mximo y mnimo
                    // de la lista de respuesta filtrada por fechas en el caso de la encuesta del g.v. 
                    //y sin filtrar en el caso dela encuesta propia de la oficina 
                    q53RespuestaBean respuestaBean = q53RespuestaClass.getRespuestasDataFilterByDate(sd,
                            fechaInicio, fechaFin,
                            encuestaBean.getCodEncuesta(),
                            encuestaBean.getCodVersion(), codOficina);

                    if (respuestaBean != null) {
                        numRespEncOfi = (new Integer(respuestaBean.getNumRespuestas())).toString();
                        sd.setVal("numRespuestas",
                            new Integer(respuestaBean.getNumRespuestas()));
                        sd.setVal("maxCodRespuesta",
                            respuestaBean.getMaxCodRespuesta());
                        sd.setVal("minCodRespuesta",
                            respuestaBean.getMinCodRespuesta());

                        int numRespuestas = respuestaBean.getNumRespuestas();

                        if (numRespuestas > 0) {
                            sd.setVal("hay_resp", "SI");

                            // la respuesta que se muestre depender de los parmetros
                            // cod_respuesta y accion.
                            //
                            // si cod_respuesta & accion son vacios, devuelve la primera
                            //      respuesta de la encuesta
                            // si accion es "primera" devuelve el cdigo de la primera
                            //      respuesta de la encuesta
                            // si accion es "ultima" devuelve el cdigo de la ltima
                            //      respuesta de la encuesta
                            // si cod_respuesta existe y accion es vaco, devuelve esa
                            //      respuesta
                            // si cod_respuesta existe y accion es "anterior", devuelve la
                            //      respuesta anterior a la de cod_respuesta
                            // si cod_respuesta existe y accion es "siguiente", devuelve la
                            //      respuesta siguiente a la de cod_respuesta
                            String cod_respuesta = q53RespuestaClass.calcularCodRespuesta(sd,
                                    respuestaBean, fechaInicio, fechaFin,
                                    codRespuesta, encuestaBean.getCodVersion());

                            sd.setVal("cod_respuesta", cod_respuesta); // machacamos el valor incluso si viene en el parametro
                            sd.setVal("codRespuesta", cod_respuesta);
                            num_respuesta = q53RespuestaClass.calcularNumRespuesta(sd,
                                    cod_respuesta, fechaInicio, fechaFin,
                                    codOficina, encuestaBean.getCodEncuesta(),
                                    encuestaBean.getCodVersion(),"");

                            // recorrer pregunta por pregunta para coger la info. de los campos
                            // que dependen del tipo de pregunta
                            // y
                            // recorrer todas las respuestas de la respuesta cod_respuesta
                            List respBeanList = q53RespuestaClass.recorrerPreguntasRespuesta(sd,
                                    preguntasList, cod_respuesta);
                            encuestaBean.setRespuestasList(respBeanList);
                            nuRespEncOfi = respBeanList.size();
                            
                        }
                    }
                }

                sd.setVal("encuestaBean", encuestaBean);
                q53FechaBean q53FechaBean = q53EncuestaClass.getGVDate(sd);
                sd.setVal("fechasGV", q53FechaBean);

                if (codEncuesta.equals("") || codEncuesta.equals("0")) {
                    if (sd.gOS("accion").equals(q53Constantes.ACCION_ANTERIOR)) {
                        int nResp = (new Integer(respNum)).intValue();
                        respNum = "" + new Integer(nResp - 1);
                    } else if (sd.gOS("accion").equals(q53Constantes.ACCION_SIGUIENTE)) {
                        int nResp = (new Integer(respNum)).intValue();
                        respNum = "" + new Integer(nResp + 1);
                    } else if (sd.gOS("accion").equals(q53Constantes.ACCION_PRIMERA)) {
                        respNum = "1";
                    } else if (sd.gOS("accion").equals(q53Constantes.ACCION_ULTIMA)) {
                        respNum = numResp;
                    }

                    sd.setVal("numResp", numResp);
                    sd.setVal("respNum", respNum);

                    String n0Descripcion = "N0_" +
                        encuestaBean.getCodEncuesta() + "_" +
                        encuestaBean.getCodVersion();

                    n0Descripcion = q53Util.getLiteral(sd, n0Descripcion,
                            q53Util.getIdioma(sd));

                    sd.setVal("descEncuestaGV", n0Descripcion);
                    q53RecorrerPreguntas.cogerPreguntaProcedencia(sd,
                        "preg_gv", 2);
                    q53RecorrerPreguntas.cogerPreguntaFecha(sd, 0);
                } else {
                    //sd.setVal("numResp",
                    //    new Integer(nuRespEncOfi).toString());
                    sd.setVal("numResp", numRespEncOfi);
                    sd.setVal("respNum", num_respuesta);
                }

                String numEncHoy = q53EncuestaClass.getNumEncuestasHoy(sd);
                sd.setVal("numEncHoy", numEncHoy);
                sd.setVal("literalesCalendario",
                    q53LiteralesEncuestaGV.getLiteralesCalendario(sd));
                sd.setVal("literalesGrupos",
                    q53LiteralesEncuestaGV.getLiteralesGrupos(sd));
                sd.setVal("literalesGruposEdad",
                    q53LiteralesEncuestaGV.getLiteralesGruposEdad(sd));
                sd.setVal("literalesIdiomaConsulta",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_4",
                        "N3_4_", 8));
                sd.setVal("literalesInformacionSolicitada",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_7",
                        "N3_7_", 7));
                sd.setVal("literalesTipoServicio",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_1",
                        "N3_1_", 6));
                sd.setVal("literalesMedioRecepcion",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_3",
                        "N3_3_", 8));
                sd.setVal("literalesTipoInformacion",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_8",
                        "N3_8_", 20));
					//IGC 20150519 INICIO INCLUIR PREGUNTA VALIDACION ESTANCIA
                    sd.setVal("literalesValoracionEstancia",
                        q53LiteralesEncuestaGV.getLiteralesOpcionesDesdeHasta(sd, "N1_12",
                            "N3_12_", 0, 5));
                    sd.setVal("textoAyudaValoracionEstancia",
                        q53LiteralesEncuestaGV.getLiteralPregunta(sd, "AYUDA_VALORACION_ESTANCIA"));
					//IGC 20150519 FIN INCLUIR PREGUNTA VALIDACION ESTANCIA

                sd.setVal("fechaInicio", fechaInicio);
                sd.setVal("fechaFin", fechaFin);

//                sd.setVal("codRespuesta", codRespuesta);
                sd.setVal("cod_encuesta", codEncuesta);
                sd.setVal("cod_version", codVersion);

                PSP.setTemplatePageProclet(sd, "/q53_usr_verRespuestas.jsp");

                // } // fin perfil administrador
            } else {
                // el usuario no tiene el perfil necesario. seguramente es porque
                // se ha perdido la sesin y hay que redirigirlo al login, para que
                // vuelva a meter su usuario y contrasea
                sd.setVal("pagina", "q53_gen_login");
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
