package itourbaskServlet;

import itourbaskBeans.q53EncuestaBean;
import itourbaskBeans.q53FechaBean;
import itourbaskBeans.q53RespuestaBean;
import itourbaskClases.q53EncuestaClass;
import itourbaskClases.q53RespuestaClass;

import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53RecorrerPreguntas;
import q53_util.q53Util;
import util.q53LiteralesEncuestaGV;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53usrVerRespuestasNoPresencialServlet extends q53Servlet {
    /**
     * DOCUMENT ME!
     *
     * @param sd DOCUMENT ME!
     *
     * @throws ProcletException DOCUMENT ME!
     */
    public void pspProcess(ProcletServiceData sd) throws ProcletException {
        try {
            // establece el contentType del response
        	sd.res.setContentType("text/html; charset=ISO-8859-1");
            sd.res.setHeader("Pragma", "no-cache");
            sd.res.setHeader("Cache-Control", "no-cache");
            sd.res.setHeader("Expires", "0");
         // Trapi para que chute
        	//sd.servletSrvVersion = 8;
        	
            // tratar las cookies
            q53_tratarCookies(sd);

            String perfilUser = "NO";
            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
                perfilUser = "SI";
            }

            String perfilCoord = "NO";
            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
                perfilCoord = "SI";
            }

            String perfilAdmin = "NO";
            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
                perfilAdmin = "SI";
            }

            sd.setVal("perfilUser", perfilUser);
            sd.setVal("perfilCoord", perfilCoord);
            sd.setVal("perfilAdmin", perfilAdmin);

            String codOficina = sd.gOS("q53_cki.q53_oficina");
            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR))
             codOficina=sd.req.getSession().getAttribute("pofi")==null?"":sd.req.getSession().getAttribute("pofi").toString();
            q53LogEstadisticas.printLog("codOficina:"+codOficina);
            PSP.paramProclet(sd,
                "vuelve_a_recogida(),mensajeOK(),cod_encuesta(), cod_version(), cod_respuesta(), accion(), respuesta_rd_asociada(), encuestas_terminadas(), fechaInicio(), fechaFin(), fechaInicioVis(), fechaFinVis(), numRespuestas(), respNum(), gv_cod_encuesta(), gv_cod_version(), tipo_ordenacion(), asc(), codigosRespuesta(),usuario()");

            
            String codigosRespuesta = "";
            codigosRespuesta = (String)sd.req.getSession(true).getAttribute("codigosRespuest");
            sd.req.getSession(true).setAttribute("codigosRespuest","");
            q53LogEstadisticas.printLog("codigosRespuesta=::::session"+codigosRespuesta);
            if(codigosRespuesta==null || codigosRespuesta.equals(""))
            	codigosRespuesta = sd.gOS("codigosRespuesta");
            else
            	sd.setVal("codigosRespuesta",codigosRespuesta);
            String usuarioSelect = sd.gOS("usuario");
            q53LogEstadisticas.printLog("usuarioSelect=::::"+usuarioSelect);
            String fechaInicio = sd.gOS("fechaInicio");
            String fechaFin = sd.gOS("fechaFin");
            String fechaInicioVis = sd.gOS("fechaInicioVis");
            String fechaFinVis = sd.gOS("fechaFinVis");
            String mensajeOK = sd.gOS("mensajeOK");
            String codEncuesta = sd.gOS("cod_encuesta");
            String numResp = sd.gOS("numRespuestas");
            String respNum = sd.gOS("respNum");
            String codVersion = sd.gOS("cod_version");
            String codRespuesta = sd.gOS("cod_respuesta");
            String codRespuestaOfi=null;

            int nuRespEncOfi = 0;
            String num_respuesta = "0";

            String gvCodEncuesta = sd.gOS("gv_cod_encuesta");
            String gvCodVersion = sd.gOS("gv_cod_version");

            String usuario = sd.gOS("q53_cki.q53_usuario");
            String codRespEncOfi = sd.gOS("codRespuesta");
            
            String tipo_ordenacion = sd.gOS("tipo_ordenacion");
            String asc = sd.gOS("asc");
            q53LogEstadisticas.printLog("Tipo Ordenacion GET No Presencial: "+tipo_ordenacion);

           q53EncuestaBean encuestaBean = null;
           q53EncuestaBean encuestaBeanOfi = null;
           
           sd.setVal("mensajeOK", mensajeOK);
            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {

            	encuestaBean = null;
                encuestaBeanOfi =null;

                //Miramos si la encuesta es la del g.v.
               
                //Buscamos los datos de la encuesta del g.v.
                    encuestaBean = q53EncuestaClass.getEncByDate(sd,
                            codOficina, codEncuesta, codVersion, fechaInicio,
                            fechaFin);
                    sd.setVal("pagina", "recogida_de_datos");
                  
                String numRespEncOfi = "0";

// 08.05.2007 Nuevo
                if (encuestaBean == null) {
                // Al modificar la respuesta, me quedo sin ninguna respuesta para el periodo de tiempo, asi que redirijo a la pagina de busqueda
                    q53_redirigir(sd,"/q53ItourbaskWar/q53usrBusquedaServlet?accion=inicioBusqueda");
                    return;
                }
// 08.05.2007 Fin Nuevo

                if (encuestaBean != null) {

                        // hay encuesta. recoger preguntas
                        sd.setVal("hay_preg", "SI");

                        //Recuperamos la lista de preguntas de la encuesta 
                        List preguntasList = q53EncuestaClass.getPreguntasEncOfiData(sd,
                                encuestaBean.getCodEncuesta(),
                                encuestaBean.getCodVersion());
                        encuestaBean.setPreguntasList(preguntasList);
                        //Recuperamos las respuestas de la encuesta del g.v. filtradas por fechas
                        String pendientes=(String)sd.req.getSession(true).getAttribute("pendientes");
                    		if(pendientes==null)pendientes="";
                    		String ultima=(String)sd.req.getSession(true).getAttribute("ultima");
                        q53RespuestaBean respuestaBean = q53RespuestaClass.getRespuestasDataFilterByDateTipo(sd,
                                fechaInicio, fechaFin,
                                encuestaBean.getCodEncuesta(),
                                encuestaBean.getCodVersion(), codOficina,"nopres",pendientes,ultima);
//26.09.2006                                encuestaBean.getCodVersion(), "");
                        
                        if (respuestaBean != null) {
                        	numRespEncOfi = (new Integer(respuestaBean.getNumRespuestas())).toString();
                        	sd.setVal("numRespuestas",
                                    new Integer(respuestaBean.getNumRespuestas()));
                                sd.setVal("maxCodRespuesta",
                                    respuestaBean.getMaxCodRespuesta());
                                sd.setVal("minCodRespuesta",
                                    respuestaBean.getMinCodRespuesta());
                                
                            int numRespuestas = respuestaBean.getNumRespuestas();
                            if (numRespuestas > 0) {
                                sd.setVal("hay_resp", "SI");
                                // la respuesta que se muestre depender de los parmetros
                                // cod_respuesta y accion.
                                //
                                // si cod_respuesta & accion son vacios, devuelve la primera
                                //      respuesta de la encuesta
                                // si accion es "primera" devuelve el cdigo de la primera
                                //      respuesta de la encuesta
                                // si accion es "ultima" devuelve el cdigo de la ltima
                                //      respuesta de la encuesta
                                // si cod_respuesta existe y accion es vaco, devuelve esa
                                //      respuesta
                                // si cod_respuesta existe y accion es "anterior", devuelve la
                                //      respuesta anterior a la de cod_respuesta
                                // si cod_respuesta existe y accion es "siguiente", devuelve la
                                //      respuesta siguiente a la de cod_respuesta
                                String cod_respuesta = q53RespuestaClass.calcularCodRespuesta(sd,
                                        respuestaBean, fechaInicio, fechaFin,
                                        codRespuesta,
                                        encuestaBean.getCodVersion());
                                sd.setVal("cod_respuesta", cod_respuesta); // machacamos el valor incluso si viene en el parametro
                                sd.setVal("codRespuesta", cod_respuesta);
                                codRespuesta = cod_respuesta;
                              //Comprobamos si la respuesta tiene respuestas de oficina
                                if (q53EncuestaClass.tieneRespOfi(sd,codRespuesta)){
                                	q53LogEstadisticas.printLog("SI TIENE RESPUESTAS DE OFICINA");
                                    	//Cogemos el codigo de respuesta de la oficina asociada a la del gv
                                    	codRespuestaOfi=q53EncuestaClass.coger_cod_ofi(sd,codRespuesta);
                                     //Buscamos los datos de la encuesta del propia de la oficina
                                     encuestaBeanOfi = q53EncuestaClass.getEncuesta(sd,
                                      		codRespuestaOfi);
                                     q53LogEstadisticas.printLog("HA COGIDO LA ENCUESTA DE OFICINA");
                                     
                                     sd.setVal("pagina", "recogida_de_datos");
                                     sd.setVal("hay_preg_ofi", "SI");
                                }else{
                                	sd.setVal("hay_preg_ofi", "NO");
                                	q53LogEstadisticas.printLog("NO TIENE RESPUESTAS DE OFICINA");
                                 }
                                if (encuestaBeanOfi != null) {  
                                    //Recuperamos en una lista las preguntas de la encuesta de oficina
                  	                    List preguntasListOfi = q53EncuestaClass.getPreguntasEncOfiData(sd,
                  	                            encuestaBeanOfi.getCodEncuesta(),
                  	                            encuestaBeanOfi.getCodVersion());
                  	                    encuestaBeanOfi.setPreguntasList(preguntasListOfi);
                  	                	List respBeanList = q53RespuestaClass.recorrerPreguntasRespuesta(sd,
                  	                			preguntasListOfi, codRespuestaOfi);
                  	                	encuestaBeanOfi.setRespuestasList(respBeanList);
                  	                	sd.setVal("codRespuestaOfi", codRespuestaOfi);
                  	                	sd.setVal("encuestaBeanOfi", encuestaBeanOfi);
                                      }
                                
                                // Calculamos el numero de respuesta
                                num_respuesta = q53RespuestaClass.calcularNumRespuesta(sd,
                                        cod_respuesta, fechaInicio, fechaFin,
                                        codOficina, encuestaBean.getCodEncuesta(),
                                        encuestaBean.getCodVersion(),"nopres");
                                // recorrer pregunta por pregunta para coger la info. de los campos
                                // que dependen del tipo de pregunta
                                // y
                                // recorrer todas las respuestas de la respuesta cod_respuesta
                                List respBeanList = q53RespuestaClass.recorrerPreguntasRespuesta(sd,
                                        preguntasList, cod_respuesta);
                                encuestaBean.setRespuestasList(respBeanList);
                                nuRespEncOfi = respBeanList.size();
                                
                            }
                        }
                        // guardamos en el sd el nmero de la respuesta
                        //sd.setVal("num_respuesta", num_respuesta);
//21.11.2006                    }
                }

                sd.setVal("encuestaBean", encuestaBean);

               
                q53FechaBean q53FechaBean = q53EncuestaClass.getGVDate(sd);
                sd.setVal("fechasGV", q53FechaBean);

                if (sd.gOS("accion").equals(q53Constantes.ACCION_ANTERIOR)) {
                    int nResp = (new Integer(respNum)).intValue();
                    respNum = "" + new Integer(nResp - 1);
                } else if (sd.gOS("accion").equals(q53Constantes.ACCION_SIGUIENTE)) {
                    int nResp = (new Integer(respNum)).intValue();
                    respNum = "" + new Integer(nResp + 1);
                } else if (sd.gOS("accion").equals(q53Constantes.ACCION_PRIMERA)) {
                    respNum = "1";
                } else if (sd.gOS("accion").equals(q53Constantes.ACCION_ULTIMA)) {
                    respNum = numResp;
                }
                sd.setVal("numResp", numResp);
                sd.setVal("respNum", respNum);

                String n0Descripcion = "N0_" + codEncuesta + "_" +
                    encuestaBean.getCodVersion();

                n0Descripcion = q53Util.getLiteral(sd, n0Descripcion,
                        q53Util.getIdioma(sd));
                sd.setVal("descEncuestaGV", n0Descripcion);
                q53RecorrerPreguntas.cogerPreguntaProcedencia(sd,
                    "preg_gv", 2);
                q53RecorrerPreguntas.cogerPreguntaFecha(sd, 0);
                
                String numEncHoy = q53EncuestaClass.getNumEncuestasHoy(sd);
                sd.setVal("numEncHoy", numEncHoy);
                sd.setVal("literalesCalendario",
                    q53LiteralesEncuestaGV.getLiteralesCalendario(sd));
                sd.setVal("literalesGrupos",
                    q53LiteralesEncuestaGV.getLiteralesGrupos(sd));
                sd.setVal("literalesGruposEdad",
                    q53LiteralesEncuestaGV.getLiteralesGruposEdad(sd));
                sd.setVal("literalesIdiomaConsulta",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_4",
                        "N3_4_", 8));
                sd.setVal("literalesInformacionSolicitada",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_7",
                        "N3_7_", 7));
                sd.setVal("literalesTipoServicio",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_1",
                        "N3_1_", 6));
                sd.setVal("literalesMedioRecepcion",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_3",
                        "N3_3_", 8));
                sd.setVal("literalesTipoInformacion",
                    q53LiteralesEncuestaGV.getLiteralesOpcionesTipoInfo(sd, "N1_8",
                        "N3_8_", 50));
								sd.setVal("literalesMedioRespuesta",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_9",
                        "N3_9_", 8));

				 
				sd.setVal("fechaInicio", fechaInicio);
				sd.setVal("fechaFin", fechaFin);
				sd.setVal("fechaInicioVis", fechaInicioVis);
				sd.setVal("fechaFinVis", fechaFinVis);
				
//                sd.setVal("codRespuesta", codRespuesta);
                sd.setVal("cod_encuesta", codEncuesta);
                sd.setVal("cod_version", codVersion);
                
                q53LogEstadisticas.printLog("Tipo Ordenacion SET COOR : "+tipo_ordenacion);
                sd.setVal("tipo_ordenacion", tipo_ordenacion);
                sd.setVal("asc", asc);
                sd.setVal("usuarioSelect", usuarioSelect);
                
                PSP.setTemplatePageProclet(sd, "/q53_usr_verRespuestas_no_presencial.jsp");
            } // if perfil coordinador
            else if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO) ||
                    q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) { // perfil administrador o usuario 
                //if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
                encuestaBean = null;
                encuestaBeanOfi =null;

                //Miramos si la encuesta es la del g.v.
               
                //Buscamos los datos de la encuesta del g.v.
                    encuestaBean = q53EncuestaClass.getEncByDate(sd,
                            codOficina, codEncuesta, codVersion, fechaInicio,
                            fechaFin);
                    sd.setVal("pagina", "recogida_de_datos");
                  
                String numRespEncOfi = "0";

// 08.05.2007 Nuevo
                if (encuestaBean == null) {
                // Al modificar la respuesta, me quedo sin ninguna respuesta para el periodo de tiempo, asi que redirijo a la pagina de busqueda
                    q53_redirigir(sd,"/q53ItourbaskWar/q53usrBusquedaServlet?accion=inicioBusqueda");
                    return;
                }
// 08.05.2007 Fin Nuevo

                if (encuestaBean != null) {
                    // hay encuesta. recoger preguntas
                    sd.setVal("hay_preg", "SI");

                    //Recuperamos en una lista las preguntas de la encuesta
                    List preguntasList = q53EncuestaClass.getPreguntasEncOfiData(sd,
                            encuestaBean.getCodEncuesta(),
                            encuestaBean.getCodVersion());
                    encuestaBean.setPreguntasList(preguntasList);
                    
                    //Recuperamos el numero de rspuestas y los codigos de respuesta mximo y mnimo
                    // de la lista de respuesta filtrada por fechas en el caso de la encuesta del g.v. 
                    //y sin filtrar en el caso dela encuesta propia de la oficina 
                    String pendientes=(String)sd.req.getSession(true).getAttribute("pendientes");
                    if(pendientes==null)pendientes="";
                  	String ultima=(String)sd.req.getSession(true).getAttribute("ultima");
                    q53RespuestaBean respuestaBean = q53RespuestaClass.getRespuestasDataFilterByDateTipo(sd,
                            fechaInicio, fechaFin,
                            encuestaBean.getCodEncuesta(),
                            encuestaBean.getCodVersion(), codOficina,"nopres",pendientes,ultima);

                    if (respuestaBean != null) {
                        numRespEncOfi = (new Integer(respuestaBean.getNumRespuestas())).toString();
                        sd.setVal("numRespuestas",
                            new Integer(respuestaBean.getNumRespuestas()));
                        sd.setVal("maxCodRespuesta",
                            respuestaBean.getMaxCodRespuesta());
                        sd.setVal("minCodRespuesta",
                            respuestaBean.getMinCodRespuesta());

                        int numRespuestas = respuestaBean.getNumRespuestas();

                        if (numRespuestas > 0) {
                            sd.setVal("hay_resp", "SI");

                            // la respuesta que se muestre depender de los parmetros
                            // cod_respuesta y accion.
                            //
                            // si cod_respuesta & accion son vacios, devuelve la primera
                            //      respuesta de la encuesta
                            // si accion es "primera" devuelve el cdigo de la primera
                            //      respuesta de la encuesta
                            // si accion es "ultima" devuelve el cdigo de la ltima
                            //      respuesta de la encuesta
                            // si cod_respuesta existe y accion es vaco, devuelve esa
                            //      respuesta
                            // si cod_respuesta existe y accion es "anterior", devuelve la
                            //      respuesta anterior a la de cod_respuesta
                            // si cod_respuesta existe y accion es "siguiente", devuelve la
                            //      respuesta siguiente a la de cod_respuesta
                            String cod_respuesta = q53RespuestaClass.calcularCodRespuesta(sd,
                                    respuestaBean, fechaInicio, fechaFin,
                                    codRespuesta, encuestaBean.getCodVersion());

                            sd.setVal("cod_respuesta", cod_respuesta); // machacamos el valor incluso si viene en el parametro
                            sd.setVal("codRespuesta", cod_respuesta);
                            codRespuesta = cod_respuesta;
                          //Comprobamos si la respuesta tiene respuestas de oficina
                            if (q53EncuestaClass.tieneRespOfi(sd,codRespuesta)){
                            	q53LogEstadisticas.printLog("SI TIENE RESPUESTAS DE OFICINA");
                                	//Cogemos el codigo de respuesta de la oficina asociada a la del gv
                                	codRespuestaOfi=q53EncuestaClass.coger_cod_ofi(sd,codRespuesta);
                                 //Buscamos los datos de la encuesta del propia de la oficina
                                 encuestaBeanOfi = q53EncuestaClass.getEncuesta(sd,
                                  		codRespuestaOfi);
                                 q53LogEstadisticas.printLog("HA COGIDO LA ENCUESTA DE OFICINA");
                                 
                                 sd.setVal("pagina", "recogida_de_datos");
                                 sd.setVal("hay_preg_ofi", "SI");
                            }else{
                            	sd.setVal("hay_preg_ofi", "NO");
                            	q53LogEstadisticas.printLog("NO TIENE RESPUESTAS DE OFICINA");
                             }
                            if (encuestaBeanOfi != null) {  
                                //Recuperamos en una lista las preguntas de la encuesta de oficina
              	                    List preguntasListOfi = q53EncuestaClass.getPreguntasEncOfiData(sd,
              	                            encuestaBeanOfi.getCodEncuesta(),
              	                            encuestaBeanOfi.getCodVersion());
              	                    encuestaBeanOfi.setPreguntasList(preguntasListOfi);
              	                	List respBeanList = q53RespuestaClass.recorrerPreguntasRespuesta(sd,
              	                			preguntasListOfi, codRespuestaOfi);
              	                	encuestaBeanOfi.setRespuestasList(respBeanList);
              	                	sd.setVal("codRespuestaOfi", codRespuestaOfi);
              	                	sd.setVal("encuestaBeanOfi", encuestaBeanOfi);
                                  }

                            num_respuesta = q53RespuestaClass.calcularNumRespuesta(sd,
                                    cod_respuesta, fechaInicio, fechaFin,
                                    codOficina, encuestaBean.getCodEncuesta(),
                                    encuestaBean.getCodVersion(),"nopres");

                            // recorrer pregunta por pregunta para coger la info. de los campos
                            // que dependen del tipo de pregunta
                            // y
                            // recorrer todas las respuestas de la respuesta cod_respuesta
                            List respBeanList = q53RespuestaClass.recorrerPreguntasRespuesta(sd,
                                    preguntasList, cod_respuesta);
                            encuestaBean.setRespuestasList(respBeanList);
                            nuRespEncOfi = respBeanList.size();
                            
                        }
                    }
                }

                sd.setVal("encuestaBean", encuestaBean);
                q53FechaBean q53FechaBean = q53EncuestaClass.getGVDate(sd);
                sd.setVal("fechasGV", q53FechaBean);

                if (sd.gOS("accion").equals(q53Constantes.ACCION_ANTERIOR)) {
                    int nResp = (new Integer(respNum)).intValue();
                    respNum = "" + new Integer(nResp - 1);
                } else if (sd.gOS("accion").equals(q53Constantes.ACCION_SIGUIENTE)) {
                    int nResp = (new Integer(respNum)).intValue();
                    respNum = "" + new Integer(nResp + 1);
                } else if (sd.gOS("accion").equals(q53Constantes.ACCION_PRIMERA)) {
                    respNum = "1";
                } else if (sd.gOS("accion").equals(q53Constantes.ACCION_ULTIMA)) {
                    respNum = numResp;
                }
                sd.setVal("numResp", numResp);
                sd.setVal("respNum", respNum);

                String n0Descripcion = "N0_" +
                encuestaBean.getCodEncuesta() + "_" +
                encuestaBean.getCodVersion();

                n0Descripcion = q53Util.getLiteral(sd, n0Descripcion,
                q53Util.getIdioma(sd));
                
                sd.setVal("descEncuestaGV", n0Descripcion);
                q53RecorrerPreguntas.cogerPreguntaProcedencia(sd,
                "preg_gv", 2);
                q53RecorrerPreguntas.cogerPreguntaFecha(sd, 0);
                

                String numEncHoy = q53EncuestaClass.getNumEncuestasHoy(sd);
                sd.setVal("numEncHoy", numEncHoy);
                sd.setVal("literalesCalendario",
                    q53LiteralesEncuestaGV.getLiteralesCalendario(sd));
                sd.setVal("literalesGrupos",
                    q53LiteralesEncuestaGV.getLiteralesGrupos(sd));
                sd.setVal("literalesGruposEdad",
                    q53LiteralesEncuestaGV.getLiteralesGruposEdad(sd));
                sd.setVal("literalesIdiomaConsulta",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_4",
                        "N3_4_", 8));
                sd.setVal("literalesInformacionSolicitada",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_7",
                        "N3_7_", 7));
                sd.setVal("literalesTipoServicio",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_1",
                        "N3_1_", 6));
                sd.setVal("literalesMedioRecepcion",
                    q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_3",
                        "N3_3_", 8));
                sd.setVal("literalesTipoInformacion",
                    q53LiteralesEncuestaGV.getLiteralesOpcionesTipoInfo(sd, "N1_8",
                        "N3_8_", 50));

                /*if(fechaInicio == fechaInicioVis){
                	fechaInicio = fechaInicioAux;
                	fechaFin = fechaFinAux;
                }*/
                sd.setVal("fechaInicio", fechaInicio);
                sd.setVal("fechaFin", fechaFin);
                sd.setVal("fechaInicioVis", fechaInicioVis);
                sd.setVal("fechaFinVis", fechaFinVis);

//                sd.setVal("codRespuesta", codRespuesta);
                sd.setVal("cod_encuesta", codEncuesta);
                sd.setVal("cod_version", codVersion);
                
                q53LogEstadisticas.printLog("Tipo Ordenacion SET USU: "+tipo_ordenacion);
                sd.setVal("tipo_ordenacion", tipo_ordenacion);
                sd.setVal("asc", asc);
                sd.setVal("usuarioSelect", usuarioSelect);
                sd.setVal("vuelve_a_recogida",sd.gOS("vuelve_a_recogida"));
                PSP.setTemplatePageProclet(sd, "/q53_usr_verRespuestas_no_presencial.jsp");

                // } // fin perfil administrador
            } else {
                // el usuario no tiene el perfil necesario. seguramente es porque
                // se ha perdido la sesin y hay que redirigirlo al login, para que
                // vuelva a meter su usuario y contrasea
                sd.setVal("pagina", "q53_gen_login");
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
