package itourbaskServlet;

import itourbaskClases.q53NotificacionesClass;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpSession;

import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;
public class q53usrNotificacionesServlet extends q53Servlet {
	
    public void pspProcess(ProcletServiceData sd) throws ProcletException {
    	try {     
    		q53LogEstadisticas.printLog("ENTRA EN EL q53usrNotificacionesServlet");    		
    		HttpSession session = sd.req.getSession(true);
	        // tratar las cookies
            q53_tratarCookies(sd);             
            String oficina_actual=sd.gOS("q53_cki.q53_oficina");
            PSP.paramProclet(sd, "tipo_envio(),hacer_batch(),num_notificaciones(),hay_batch(),generar_rollo(),generar_etiquetas()");      
            
            q53LogEstadisticas.printLog("hay_batch:"+sd.gOS("hay_batch"));
    		q53LogEstadisticas.printLog("hacer_batch:"+sd.gOS("hacer_batch"));
    		q53LogEstadisticas.printLog("tipo_envio:"+sd.gOS("tipo_envio"));
    		q53LogEstadisticas.printLog("generar_rollo:"+sd.gOS("generar_rollo"));
               
            if(sd.gOS("hay_batch").equals("si")){
            	String num_notificaciones=sd.gOS("num_notificaciones");
            	List lista_notificaciones = null;
            	Hashtable datos = new Hashtable();
            	lista_notificaciones = q53Util.convertir_en_lista(num_notificaciones,"-");
            	session.setAttribute("lista_notificaciones",lista_notificaciones);
            	for(int i=0;i<lista_notificaciones.size();i++){
	            	datos.put("nombre_"+i,sd.req.getParameter("nombre_"+lista_notificaciones.get(i).toString()));
	            	datos.put("direccion_"+i,sd.req.getParameter("direccion_"+lista_notificaciones.get(i).toString()));
	            	datos.put("localidad_"+i,sd.req.getParameter("localidad_"+lista_notificaciones.get(i).toString()));
	            	datos.put("codPostal_"+i,sd.req.getParameter("codPostal_"+lista_notificaciones.get(i).toString()));	            	
	        	}
	        	session.setAttribute("datos_notificaciones",datos);
            	PSP.setTemplatePageProclet(sd, "/q53_usr_formato_impresion.jsp");
            }else if(sd.gOS("hacer_batch").equals("si")){
            	PSP.paramProclet(sd, "posicion()");
            	ServletOutputStream stream = null;  
            	q53LogEstadisticas.printLog("Entra hacer_batch");
            	List lista_notificaciones = (List)session.getAttribute("lista_notificaciones");
            	q53LogEstadisticas.printLog("Lista de notificaciones = "+lista_notificaciones.toString());
            	Hashtable datos=(Hashtable)session.getAttribute("datos_notificaciones");	            	
	        	q53LogEstadisticas.printLog("ANTES DE ENTRAR A GENERAR ETIQUETAS");
	        	if(sd.gOS("generar_etiquetas").equals("1"))
	        		q53NotificacionesClass.generar_etiquetas(lista_notificaciones.size(),datos,sd.gOS("posicion"),oficina_actual);
	        	else if(sd.gOS("generar_rollo").equals("1"))
	        		q53NotificacionesClass.generar_etiquetas_rollo(lista_notificaciones.size(),datos,sd.gOS("posicion"),oficina_actual);       		
	        	q53LogEstadisticas.printLog("SALE DE GENERAR ETIQUETAS");
	        	try{  
          	        stream = sd.res.getOutputStream();  
                    sd.res.setContentType("text/rtf");  
                    sd.res.addHeader("Content-Disposition","attachment; filename=Etiquetas"+oficina_actual+".rtf");            
                    stream.write(q53NotificacionesClass.leer_archivo_origen("/datos/q53/file/notificaciones/Etiquetas"+oficina_actual+".rtf"));  
	            }catch (IOException ioe) {  
	                throw new ServletException(ioe.getMessage());        
	            }finally {  
	                if(stream != null)  
	                    stream.close();        
	            }          	            	
	        	q53_redirigir(sd, sd.req.getParameter("url_anterior"));
	        }else if(sd.gOS("generar_etiquetas").equals("1")){            	
            	PSP.paramProclet(sd, "nombre(),direccion(),localidad(),codPostal(),posicion()");
            	Hashtable datos = new Hashtable();
            	datos.put("nombre",sd.gOS("nombre"));
            	datos.put("direccion",sd.gOS("direccion"));
            	datos.put("localidad", sd.gOS("localidad"));
            	datos.put("codPostal", sd.gOS("codPostal"));
            	q53NotificacionesClass.generar_etiquetas(0,datos,sd.gOS("posicion"),oficina_actual);
            	ServletOutputStream stream = null;
            	try{  
            	    stream = sd.res.getOutputStream();  
                    sd.res.setContentType("text/rtf");  
                    sd.res.addHeader("Content-Disposition","attachment; filename=Etiquetas"+oficina_actual+".rtf");            
                    stream.write(q53NotificacionesClass.leer_archivo_origen("/datos/q53/file/notificaciones/Etiquetas"+oficina_actual+".rtf"));  
                }catch (IOException ioe) {  
                	throw new ServletException(ioe.getMessage());        
                }finally {  
	                if(stream != null)  
	                  stream.close();        
                } 
	        }else if(sd.gOS("generar_rollo").equals("1")){
	        	PSP.paramProclet(sd, "nombre(),direccion(),localidad(),codPostal(),posicion()");
	        	q53LogEstadisticas.printLog("Entra en generar rollo");
            	Hashtable datos = new Hashtable();
            	datos.put("nombre_0",sd.gOS("nombre"));
            	datos.put("direccion_0",sd.gOS("direccion"));
            	datos.put("localidad_0", sd.gOS("localidad"));
            	datos.put("codPostal_0", sd.gOS("codPostal"));
            	q53NotificacionesClass.generar_etiquetas_rollo(1,datos,sd.gOS("posicion"),oficina_actual);
            	ServletOutputStream stream = null;
            	try{  
            	    stream = sd.res.getOutputStream();  
                    sd.res.setContentType("text/rtf");  
                    sd.res.addHeader("Content-Disposition","attachment; filename=Etiquetas"+oficina_actual+".rtf");            
                    stream.write(q53NotificacionesClass.leer_archivo_origen("/datos/q53/file/notificaciones/Etiquetas"+oficina_actual+".rtf"));  
                }catch (IOException ioe) {  
                	throw new ServletException(ioe.getMessage());        
                }finally {  
	                if(stream != null)  
	                  stream.close();        
                } 
	        }else if(sd.gOS("tipo_envio").equals("1")){
            	PSP.paramProclet(sd, "nombre(),direccion(),localidad(),codPostal()");
            	PSP.setTemplatePageProclet(sd, "/q53_usr_formato_impresion.jsp");
			}else if(sd.gOS("tipo_envio").equals("3")){
            	PSP.paramProclet(sd, "fax(),fecha(),hojas(),remitente(),destinatario()");
            	//Si se introducen nuevos campos en las plantillas hay que meterlos aqui, y tienen que corresponder con el nombre
            	//que se les asigna en la hashtable
            	Hashtable datos = new Hashtable();
            	datos.put("FAX",sd.gOS("fax"));
            	datos.put("FECHA",sd.gOS("fecha"));
            	datos.put("NHOJAS", sd.gOS("hojas"));
            	datos.put("DESTINATARIO", sd.gOS("destinatario"));
            	Hashtable datos_oficina= q53Util.getDatosFax(sd,oficina_actual);
            	datos.put("OFICINA",(String)datos_oficina.get("nombre"));
            	datos.put("CP",(String)datos_oficina.get("cod_postal"));
            	datos.put("FAXOFI",(String)datos_oficina.get("fax"));
            	datos.put("TELEFONO",(String)datos_oficina.get("telefono"));
            	datos.put("DIRECCION",(String)datos_oficina.get("direccion"));
            	//FIN Si se introducen nuevos campos en las plantillas hay que meterlos aqui, y tienen que corresponder con el nombre
            	//que se les asigna en la hashtable
            	q53NotificacionesClass.generar_fax(datos,oficina_actual);
            	ServletOutputStream stream = null;
            	try{  
            	    stream = sd.res.getOutputStream();  
                    sd.res.setContentType("text/rtf");  
                    sd.res.addHeader("Content-Disposition","inline; filename=Fax"+oficina_actual+".rtf");            
                    stream.write(q53NotificacionesClass.leer_archivo_origen("/datos/q53/file/notificaciones/Fax"+oficina_actual+".rtf"));	
                }catch (IOException ioe) {  
                	  throw new ServletException(ioe.getMessage());        
                }finally {  
	                  if(stream != null)  
	                    stream.close();        
                }
			}
    	} catch (Exception e) {
	            e.printStackTrace();
        }
    }
}
        
        
        
        
        
        
        
        
        
        
        
        
        