package itourbaskServlet;

import itourbaskClases.q53RespuestaTablaClass;

import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


public class q53usrMostrarCodigosServlet extends q53Servlet {
    public void pspProcess(ProcletServiceData sd) throws ProcletException {
        try {
            // establece el contentType del response
            q53LogEstadisticas.printLog("Procesando respuesta no presencial servlet");
            String q53_idioma = q53Util.getIdioma(sd);
            sd.res.setContentType("text/html");
            sd.res.setHeader("Pragma", "no-cache");
            sd.res.setHeader("Cache-Control", "no-cache");
            sd.res.setHeader("Expires", "0");
	
            // tratar las cookies
            q53_tratarCookies(sd);

            String perfilUser = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
                perfilUser = "SI";
            }

            String perfilCoord = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
                perfilCoord = "SI";
            }

            String perfilAdmin = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
                perfilAdmin = "SI";
            }

            sd.setVal("perfilUser", perfilUser);
            sd.setVal("perfilCoord", perfilCoord);
            sd.setVal("perfilAdmin", perfilAdmin);
            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO) ||
                    q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                    q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
                    	
                PSP.paramProclet(sd,"pregunta(),lan(),info()");
                String lan=sd.gOS("lan");
                if(lan.length()>0)q53_idioma=lan;
                String pregunta=sd.gOS("pregunta");
                String info=sd.gOS("info");
                q53LogEstadisticas.printLog("Pregunta::::"+pregunta);	
				q53RespuestaTablaClass resp=new q53RespuestaTablaClass();
				List opciones=resp.getOpcionesaMostrar(sd,pregunta,q53_idioma);
				q53LogEstadisticas.printLog("Idioma::::"+q53_idioma);								    	
                sd.req.setAttribute("opciones",opciones);
                sd.req.setAttribute("info",info);
                sd.req.setAttribute("pregunta",pregunta);
                if(lan.equals("C")){
                	if(info.length()==0){
                		sd.req.setAttribute("GEN_VOLVER","aceptar");
                	}else{
                		sd.req.setAttribute("GEN_VOLVER","cerrar");
                	}
                }else{
                	if(info.length()==0){
                		sd.req.setAttribute("GEN_VOLVER","onartu");
                	}else{
                		sd.req.setAttribute("GEN_VOLVER","itxi");
                	}	
                }
                q53LogEstadisticas.printLog("FIN Procesando respuesta no presencial servlet"); 
                sd.req.getRequestDispatcher("q53_usr_mostrarcodigos.jsp").forward(sd.req,sd.res); 
            } else {
                // el usuario no tiene el perfil necesario. seguramente es porque
                // se ha perdido la sesin y hay que redirigirlo al login, para que
                // vuelva a meter su usuario y contrasea
                sd.setVal("pagina", "q53_gen_login");
                q53LogEstadisticas.printLog("FIN Procesando respuesta no presencial servlet"); 
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");                    
            }
           
        } catch (Exception e) {
        	 q53LogEstadisticas.printLog("Excepcion::::"+e.getMessage());	
             e.printStackTrace();
        }
    }
    
    
}
