package itourbaskServlet;

import itourbaskClases.q53EncuestaClass;
import itourbaskClases.q53ModificarRespuestasClass;

import java.io.PrintWriter;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletServiceData;

public class q53usrModificarRespuestasServlet extends q53Servlet {
    
    /**
     * Procleto que guarda la encuesta rellenada y muestra de nuevo la encuesta
     * para rellenar
     **/
	
public void pspProcess(ProcletServiceData sd){
    // establece el contentType del response
    sd.res.setContentType("text/html");
    sd.res.setHeader("Pragma", "no-cache");
    sd.res.setHeader("Cache-Control", "no-cache");
    sd.res.setHeader("Expires", "0");
    String solo_ofi_y_fecha = "";
    q53LogEstadisticas.printLog("ENTRA");
    if(sd.req.getParameter("solo_ofi_y_fecha")!=null)
    	solo_ofi_y_fecha = (String)sd.req.getParameter("solo_ofi_y_fecha");
    //Si se quiere solamente modificar la oficina y la fecha de visita de una respuesta
	if(solo_ofi_y_fecha.equals("1")){
    	PrintWriter out=null;
    	try{
    		int respuesta = 1;
    		out=sd.res.getWriter();
    		respuesta = q53ModificarRespuestasClass.modificarRespuestaFechayOfi(sd,(String)sd.req.getParameter("cod_respuesta_mod"),
    						(String)sd.req.getParameter("fecha_mod"),(String)sd.req.getParameter("ofi_mod"));
    		out.print(respuesta);
    	}catch(Exception e){
    		q53LogEstadisticas.printLog("Ha ocurrido un error cuando se intentaba modificar la oficina y la fecha de visita");
    		q53LogEstadisticas.printLog("Mensaje -> "+e.getMessage());
    		if(out!=null){
    			out.print("1");
    		}
    	}
    }else{
	    try{
	        // tratar las cookies
	        q53_tratarCookies(sd);
	        q53Util.pasar_a_sd(sd);
	
	        String perfilUser = "NO";
	        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO))
	            perfilUser = "SI";
	
	        String perfilCoord = "NO";
	        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR))
	            perfilCoord = "SI";
	
	        String perfilAdmin = "NO";
	        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO))
	            perfilAdmin = "SI";
	
	        sd.setVal("perfilUser", perfilUser);
	        sd.setVal("perfilCoord", perfilCoord);
	        sd.setVal("perfilAdmin", perfilAdmin);
	
	        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO) ||
	        q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
	        q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
	        // es_recogida_datos se utiliza en el jsp q53_usr_guardar.jsp para
	        // saber si hay que mostrar como ttulo "Recogida de datos" o el
	        // nombre de la encuesta.
	            PSP.paramProclet(sd, "tipo_envio(),nombre(),direccion(),localidad(),codPostal(),email(),fax(),fecha(),hojas(),remitente(),destinatario(),check_envio(),vuelve_a_recogida(),es_recogida_datos(), cod_encuesta(), cod_version(), encuesta_descripcion(), encuestas_terminadas(), cod_respuesta(), fechaInicio(), fechaFin(), fechaInicioVis(), fechaFinVis(),numRespuestas(), respNum(), grp_2_2_1(), grp_2_2_2(), grp_5_4_1(), grp_5_4_2(), grp_5_4_3(), grp_5_4_4(), sinConcretar(),encuesta(),asc(),tipo_ordenacion(), codigosRespuesta(),usuario()");
	            
	            PSP.setValInSessionProclet(sd, "n_Hombres", sd.gOS("grp_2_2_1"));
	            PSP.setValInSessionProclet(sd, "n_Mujeres", sd.gOS("grp_2_2_2"));
	            PSP.setValInSessionProclet(sd, "n_Menor27", sd.gOS("grp_5_4_1"));
	            PSP.setValInSessionProclet(sd, "n_Entre27_45", sd.gOS("grp_5_4_2"));
	            PSP.setValInSessionProclet(sd, "n_Entre46_65", sd.gOS("grp_5_4_3"));
	            PSP.setValInSessionProclet(sd, "n_Mas65", sd.gOS("grp_5_4_4"));
	            PSP.setValInSessionProclet(sd, "sinConcretar", sd.gOS("sinConcretar"));
	/*
	q53LogEstadisticas.printLog("numHombres : " +sd.gOS("grp_2_2_1"));
	q53LogEstadisticas.printLog("numMujeres : " + sd.gOS("grp_2_2_2"));
	q53LogEstadisticas.printLog("menor27 : " + sd.gOS("grp_5_4_1"));
	q53LogEstadisticas.printLog("entre27_45 : " + sd.gOS("grp_5_4_2"));
	q53LogEstadisticas.printLog("entre46_65 : " + sd.gOS("grp_5_4_3"));
	q53LogEstadisticas.printLog("mayor65 : " + sd.gOS("grp_5_4_4"));
	q53LogEstadisticas.printLog("sinConcretar : " + sd.gOS("sinConcretar"));
	*/
	            // Inicializar variables a cero
	            PSP.setValInSessionProclet(sd, "hombresAsig", "0");
	            PSP.setValInSessionProclet(sd, "mujeresAsig", "0");
	            PSP.setValInSessionProclet(sd, "menor27Asig", "0");
	            PSP.setValInSessionProclet(sd, "entre27_45Asig", "0");
	            PSP.setValInSessionProclet(sd, "entre46_65Asig", "0");
	            PSP.setValInSessionProclet(sd, "mas65Asig", "0");
	            PSP.setValInSessionProclet(sd, "sinConcretarAsig", "0");
	
	
	            // recoger parametros de encuesta gv
	            // si hay encuesta_gv -> coger las preguntas de la base de datos.
	            // para cada pregunta -> tratarla dependiendo de su tipo.
	            //      coger los parmetros necesarios
	            //      guardar la respuesta en la base de datos
	
	            //String usuarioSelect = sd.gOS("usuarioSelect");
	            String gvCodEncuesta = sd.gOS("cod_encuesta");
	            String gvCodVersion = sd.gOS("cod_version");
	            String ofiCodEncuesta = sd.gOS("cod_encuesta");
	            String ofiCodVersion = sd.gOS("cod_version");
	            String codOficina = sd.gOS("q53_cki.q53_oficina");
	            String usuario = sd.gOS("q53_cki.q53_usuario");
	            String codRespuesta = sd.gOS("cod_respuesta");
	            String fechaInicio = sd.gOS("fechaInicio");
	            String fechaFin = sd.gOS("fechaFin");
	            String fechaInicioVis = sd.gOS("fechaInicioVis");
	            String fechaFinVis = sd.gOS("fechaFinVis");
	            String asc = sd.gOS("asc");
	            String tipo_ordenacion = sd.gOS("tipo_ordenacion");
	            q53LogEstadisticas.printLog("fechaInicio: "+fechaInicio);
	            q53LogEstadisticas.printLog("fechaFin: "+fechaFin);
	            q53LogEstadisticas.printLog("fechaInicioVis: "+fechaInicioVis);
	            q53LogEstadisticas.printLog("fechaFinVis: "+fechaFinVis);
	            q53LogEstadisticas.printLog("asc: "+asc);
	            q53LogEstadisticas.printLog("tipo_ordenacion: "+tipo_ordenacion);
	            String codRespEncOfi = "";
	            if (q53EncuestaClass.tieneRespOfi(sd,codRespuesta)){
	            	codRespEncOfi = q53EncuestaClass.coger_cod_ofi(sd,codRespuesta);
	            }
	            q53LogEstadisticas.printLog("codRespEncOfi: "+codRespEncOfi);
	
	            if (!gvCodEncuesta.equals("")) {
	            // hay encuesta gv
	                sd.setVal("pagina", q53Constantes.PAG_RECOGIDA_DATOS);
	
	                // recorrer pregunta por pregunta para coger la info. de los campos
	                // que dependen del tipo de pregunta
	                q53LogEstadisticas.printLog("GOBIERNO VASCO "+gvCodEncuesta+" "+gvCodVersion+" "+codRespuesta);
	                q53ModificarRespuestasClass.modificarRespuestasEncGV(sd, gvCodEncuesta,
	                gvCodVersion, codRespuesta);
	
	
	                // guardo el codigo de la respuesta, que ser el cdigo de respuesta
	                // de recogida de datos asociada al resto de respuestas del visitante
	                sd.setVal("respuesta_rd_asociada",
	                sd.gOS("preg_gv_cod_rpta.cod_respuesta"));
	            }
	
	            // recoger parametros de encuesta ofi
	            // si hay encuesta_ofi, hacer lo mismo.
	            PSP.paramProclet(sd, "ofi_cod_encuesta(),ofi_cod_version()");
	            q53LogEstadisticas.printLog("Codigo Oficina: "+sd.req.getParameter("ofi_cod_encuesta"));
	
	            //El codigo de oficina y el codigo de version los recoge del request 
	            //Ademas El campo terminarAmbas indica que se quiere guardar tambien la encuesta propia de la oficina
	            if ((sd.req.getParameter("ofi_cod_encuesta") != null) &&
	            !(sd.req.getParameter("ofi_cod_encuesta").equals(""))) {
	                String codEncuestaOfi = sd.req.getParameter("ofi_cod_encuesta");
	                String codVersionEncOfi = sd.req.getParameter("ofi_cod_version");
	                sd.setVal("pagina", "otras_encuestas");
	
	                PSP.paramProclet(sd, "respuesta_rd_asociada()");
	                String respRDAsociada = sd.gOS("respuesta_rd_asociada");
	
	                //Tenemos que volver a la pagina de recogida de datos necesitamos la encuesta visible de la oficina
	                // recorrer pregunta por pregunta para coger la info. de los campos
	                // que dependen del tipo de pregunta
	                q53LogEstadisticas.printLog("OFICINA "+codEncuestaOfi+" "+codVersionEncOfi+" "+codRespEncOfi);
	                q53ModificarRespuestasClass.modificarRespuestasEncOfi(sd, codEncuestaOfi,
	                codVersionEncOfi, codRespEncOfi);
	            }
	            q53LogEstadisticas.printLog("codigosRespuesta antes de redirigir a q53usrVerRespuestasPresencialServlet"+sd.gOS("codigosRespuesta"));
	            //Una vez guardados los cambios se redirije a la misma pagina con los campos vacios
	            //para poder hacer una nueva encuesta
	            //PSP.setTemplatePageProclet(sd, "/q53_usr_encuesta.jsp");
	            sd.req.getSession(true).setAttribute("codigosRespuest",sd.gOS("codigosRespuesta"));
	            if (sd.gOS("encuesta").equals("pres")){
	            	q53_redirigir(sd,            
	            	"/q53ItourbaskWar/q53usrVerRespuestasPresencialServlet?vuelve_a_recogida="+sd.gOS("vuelve_a_recogida")+"&cod_encuesta=" +
	            	sd.gOS("cod_encuesta") + "&mensajeOK=1&cod_version=" +
	            	sd.gOS("cod_version") + "&recogida_datos=" +
	            	sd.gOS("recogida_datos") + "&fechaInicio=" + sd.gOS("fechaInicio") + "&fechaFin=" + sd.gOS("fechaFin") + "&fechaInicioVis=" + sd.gOS("fechaInicioVis") + "&fechaFinVis=" + sd.gOS("fechaFinVis") + "&asc=" + sd.gOS("asc") + "&tipo_ordenacion=" + sd.gOS("tipo_ordenacion")+ "&numRespuestas=" + sd.gOS("numRespuestas") + "&respNum=" + sd.gOS("respNum") + "&cod_respuesta=" + codRespuesta + "&usuario=" 
	            	+ sd.gOS("usuario"));
	            }else{
	            	 	q53_redirigir(sd,            
	            	"/q53ItourbaskWar/q53usrVerRespuestasNoPresencialServlet?vuelve_a_recogida="+sd.gOS("vuelve_a_recogida")+"&cod_encuesta=" +
	            	sd.gOS("cod_encuesta") + "&mensajeOK=1&cod_version=" +
	            	sd.gOS("cod_version") + "&recogida_datos=" +
	            	sd.gOS("recogida_datos") + "&fechaInicio=" + sd.gOS("fechaInicio") + "&fechaFin=" + sd.gOS("fechaFin") + "&fechaInicioVis=" + sd.gOS("fechaInicioVis") + "&fechaFinVis=" + sd.gOS("fechaFinVis") + "&asc=" + sd.gOS("asc") + "&tipo_ordenacion=" + sd.gOS("tipo_ordenacion")+ "&numRespuestas=" + sd.gOS("numRespuestas") + "&respNum=" + sd.gOS("respNum") + "&cod_respuesta=" + codRespuesta + "&usuario=" 
	            	+ sd.gOS("usuario"));
	          }
	        } // if perfil
	        else {
	        // el usuario no tiene el perfil necesario. seguramente es porque
	        // se ha perdido la sesin y hay que redirigirlo al login, para que
	        // vuelva a meter su usuario y contrasea
	            sd.setVal("pagina", "q53_gen_login");
	            q53_redirigir(sd,
	            "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
	        }
	    }catch(Exception e){
	        e.printStackTrace();
	    }
    }   
}
	
}
