package itourbaskServlet;

import q53_util.q53Constantes;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


public class q53usrListarServlet extends q53Servlet {
    public void pspProcess(ProcletServiceData sd) throws ProcletException {
        // establece el contentType del response
        sd.res.setContentType("text/html");
        sd.res.setHeader("Pragma", "no-cache");
        sd.res.setHeader("Cache-Control", "no-cache");
        sd.res.setHeader("Expires", "0");

        // tratar las cookies
        q53_tratarCookies(sd);

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            PSP.paramProclet(sd,
                "respuesta_rd_asociada(),encuestas_terminadas()");

            // select de las encuestas de la oficina
            String select_enc = "SELECT N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_RECOGIDA_DATOS";
            select_enc += " FROM ENCUESTA";
            select_enc += (" WHERE N0_COD_OFICINA='" +
            sd.gOS("q53_cki.q53_oficina") +
            "' AND N0_RECOGIDA_DATOS!='S' AND N0_VERSION_ANTIGUA='N' AND N0_VISIBLE='S'");
            PSP.sqlProclet(sd, "enc[]=" + select_enc);
            sd.setVal("pagina", "q53_usr_listar");
            PSP.setTemplatePageProclet(sd, "/q53_usr_listar.jsp");
        } // if perfil
        else {
            // el usuario no tiene el perfil necesario. seguramente es porque
            // se ha perdido la sesion y hay que redirigirlo al login, para que
            // vuelva a meter su usuario y contrasea
            sd.setVal("pagina", "q53_gen_login");
            q53_redirigir(sd,
                "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
        }
    }
}
