package itourbaskServlet;

import itourbaskClases.q53RespuestaTablaClass;

import java.io.PrintWriter;
import java.io.StringWriter;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53usrGuardarTablaTemporalServlet extends q53Servlet {
   public void pspProcess(ProcletServiceData sd) throws ProcletException { 
    	// establece el contentType del response sd.res.setContentType("text/html"); 
    
    try{
    	sd.res.setHeader("Pragma", "no-cache"); sd.res.setHeader("Cache-Control", "no-cache"); 
    	sd.res.setHeader("Expires", "0"); 
    	q53LogEstadisticas.printLog("Antes de tratar las cookies"); // tratar las cookies 
    	q53_tratarCookies(sd); 
    	q53LogEstadisticas.printLog("Despues de tratar las cookies"); 
    	q53LogEstadisticas.printLog("Perfil de..."); 
    	
    	String perfilUser = "NO";
        
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
            perfilUser = "SI";
						q53LogEstadisticas.printLog("Usuario");
        }
        
        String perfilCoord = "NO";
        
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            perfilCoord = "SI";
						q53LogEstadisticas.printLog("Coordinador");
        }
        
        String perfilAdmin = "NO";
        
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
            perfilAdmin = "SI";
						q53LogEstadisticas.printLog("Administrador");
        }
        
        sd.setVal("perfilUser", perfilUser);
        sd.setVal("perfilCoord", perfilCoord);
        sd.setVal("perfilAdmin", perfilAdmin);
        
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
			q53LogEstadisticas.printLog("Tengo el perfil adecuado, recojo los paramtros");
            // es_recogida_datos se utiliza en el jsp q53_usr_guardar.jsp para
            // saber si hay que mostrar como ttulo "Recogida de datos" o el
            // nombre de la encuesta.
            PSP.paramProclet(sd,"linea(),numTipo(),numEncActiv()");
            int linea=0;
            if(!sd.gOS("linea").equals("")){
            	linea=Integer.valueOf(sd.gOS("linea")).intValue();
          	}
            int numTipo=0;
            int numEncActiv=0;
            if(sd.gI("numTipo")!=0){
            	numTipo=sd.gI("numTipo");
            	numEncActiv=sd.gI("numEncActiv");
            	
          	}
            PSP.paramProclet(sd,"id"+linea+"(),fech_0_dia_"+linea+"(),fech_0_mes_"+linea+
            "(),fech_0_anio_"+linea+"(),fech_0_hora_"+linea+"(),totvis"+linea+"(),grp_2_2_1"+linea+
            "(),grp_2_2_2"+linea+"(),grp_5_4_1"+linea+"(),grp_5_4_2"+linea+"(),grp_5_4_3"+linea+"(),grp_5_4_4"+linea+
            "(),grp_5_4_5"+linea+"(),totalPersonasProc"+linea+"(),opt_local"+linea+"(),cposProc"+linea+
            "(),proc_pais_6_"+linea+"(),opt_check_7"+linea+"(),opt_check_8"+linea+
            "(),opt_12"+linea+"(),fech_10_dia2_"+linea+"(),fech_10_mes2_"+linea+"(),fech_10_anio2_"+linea+"(),opt_3"+linea+
            "(),opt_9"+linea+"(),chkHabilitar"+linea+"(),txt_"+linea+"(),encuesta(),cod_usu(),continestable()");
            
            //recuperacion de los datos sobre la encuesta activada
            if(numEncActiv!=0){
        		int j=1;
        		while(j<numTipo+1){
        			PSP.paramProclet(sd,"numOpciones"+j+"(),codPregunta"+j+"()");
        			int codPregunta=0;
        			int numOpciones=0;
        			if(sd.gI("numOpciones"+j)!=0){
	        			codPregunta=sd.gI("codPregunta"+j);
	        			numOpciones=sd.gI("numOpciones"+j);
	        			if (numOpciones!=0 && numOpciones<10){
	        				String numeroIndice=Integer.toString(numOpciones).substring(0,1);
	        				if(!numeroIndice.equals("")){
	            				numOpciones=Integer.parseInt(numeroIndice);
	            				for(int w=0;w<numOpciones;w++){
	            					PSP.paramProclet(sd,"opt_check_a"+codPregunta+w+linea+"()");
	            				}
	        				}
	        				PSP.paramProclet(sd,"opt_"+codPregunta+linea+"(),txt_"+codPregunta+linea+"(),fech_"+codPregunta+"_dia_"+linea+
	        				"(),fech_"+codPregunta+"_mes_"+linea+"(),fech_"+codPregunta+"_anio_"+linea+"()");
	        				j++;
	        			}else if(numOpciones!=0){
	        				String numeroIndice=Integer.toString(numOpciones).substring(0,2);
	        				if(!numeroIndice.equals("")){
	            				numOpciones=Integer.parseInt(numeroIndice);
	            				for(int w=0;w<numOpciones;w++){
	            					PSP.paramProclet(sd,"opt_check_a"+codPregunta+w+linea+"()");
	            				}
	        				}
	        				PSP.paramProclet(sd,"opt_"+codPregunta+linea+"(),txt_"+codPregunta+linea+"(),fech_"+codPregunta+"_dia_"+linea+
	        				"(),fech_"+codPregunta+"_mes_"+linea+"(),fech_"+codPregunta+"_anio_"+linea+"()");
	        				j++;
	        			}
        			}
        		}
	        }
            q53LogEstadisticas.printLog("ID:"+sd.gOS("id"+linea));
            q53LogEstadisticas.printLog("parametro fech_0_hora :"+sd.gOS("fech_0_hora_"+linea));
	        if (!sd.gOS("id"+linea).equals("")){
            	q53RespuestaTablaClass.guardarLineaEncTemp(sd,sd.gOS("encuesta"),linea);
          	}
          	q53LogEstadisticas.printLog("Despues de q53RespuestaTablaClass.guardarLineaEncTemp");
            sd.req.getSession().setAttribute("continestable",sd.gOS("continestable"));  
        }else{// if perfil
            // el usuario no tiene el perfil necesario. seguramente es porque
            // se ha perdido la sesin y hay que redirigirlo al login, para que
            // vuelva a meter su usuario y contrasea
            sd.setVal("pagina", "q53_gen_login");
			q53LogEstadisticas.printLog("q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
			q53LogEstadisticas.printLog("********** FIN **********");
            q53_redirigir(sd,
                    "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
        }
    }catch(ProcletException e){
    	q53LogEstadisticas.printLog("HA SALTADO UNA EXCEPCION : "+e.getMessage());
    	throw e;
    }catch(Exception e){
  	    q53LogEstadisticas.printLog("Excepcion capturada y no relanzada : "+e.getMessage());
  	    q53LogEstadisticas.printLog(stack2string(e));
    }
  }
  
  public static String stack2string(Exception e) {
	  try {
	    StringWriter sw = new StringWriter();
	    PrintWriter pw = new PrintWriter(sw);
	    e.printStackTrace(pw);
	    return "------\r\n" + sw.toString() + "------\r\n";
	  }
	  catch(Exception e2) {
	    return "bad stack2string";
	  }
	 }


}