package itourbaskServlet;

import itourbaskClases.q53RespuestaClass;
import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53usrGuardarServlet extends q53Servlet {
    /**
     * Procleto que guarda la encuesta rellenada y muestra de nuevo la encuesta
     * para rellenar
     *
     * @param sd DOCUMENT ME!
     *
     * @throws ProcletException DOCUMENT ME!
     */


    public void pspProcess(ProcletServiceData sd) throws ProcletException {
        // establece el contentType del response
        sd.res.setContentType("text/html");
        sd.res.setHeader("Pragma", "no-cache");
        sd.res.setHeader("Cache-Control", "no-cache");
        sd.res.setHeader("Expires", "0");
        q53LogEstadisticas.printLog("Antes de tratar las cookies");
        // tratar las cookies
        q53_tratarCookies(sd);
        q53LogEstadisticas.printLog("Despues de tratar las cookies");
        q53LogEstadisticas.printLog("Perfil de...");
        String perfilUser = "NO";
        String codigo_aleatorio = q53Util.obtener_cod_aleatorio();
        
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
            perfilUser = "SI";
            q53LogEstadisticas.printLog("Usuario");
        }
        
        String perfilCoord = "NO";
        
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            perfilCoord = "SI";
            q53LogEstadisticas.printLog("Coordinador");
        }
        
        String perfilAdmin = "NO";
        
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
            perfilAdmin = "SI";
            q53LogEstadisticas.printLog("Administrador");
        }
        
        sd.setVal("perfilUser", perfilUser);
        sd.setVal("perfilCoord", perfilCoord);
        sd.setVal("perfilAdmin", perfilAdmin);
        
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
        	q53LogEstadisticas.printLog("Tengo el perfil adecuado, recojo los parametros");
            // es_recogida_datos se utiliza en el jsp q53_usr_guardar.jsp para
            // saber si hay que mostrar como ttulo "Recogida de datos" o el
            // nombre de la encuesta.
            PSP.paramProclet(sd,
                    "es_recogida_datos(),cod_encuesta(),cod_version(),encuesta_descripcion(),encuestas_terminadas()," +
                    "gv_cod_encuesta(),gv_cod_version(),proc_local_6(),nPersonasProcedencia_6_1(),nPersonasProcedencia_6_2()," +
                    "nPersonasProcedencia_6_3(),grp_2_2_1(0),grp_2_2_2(0),grp_5_4_1(0),grp_5_4_2(0),grp_5_4_3(0),grp_5_4_4(0),"+
                    "sinConcretar(0),encuesta(),cpos(),fech_0_dia(),fech_0_mes(),fech_0_anio(),fech_0_hora(),mantener(),mantener_nopres(),mantener_ultima()," +
                    "tipo_envio(),1apellido(),2apellido(),nombre(),direccion(),portal(),piso(),localidad(),codPostal(),email(),fax()," +
                    "fecha(),hojas(),remitente(),destinatario(),check_envio()");
          
            //Sacar los datos que hemos recogido en el jsp
            /*String[] nombres= sd.getValNames("");
            ArrayList lista = new ArrayList();  
            for(int i = 0; i < nombres.length; i++){ 
              if(sd.gOS(nombres[i]).length()>0)
            	  lista.add(nombres[i]); 
            } 
            Collections.sort(lista);
            String nombre;
            for(int x=0;x<lista.size();x++){
            	nombre=(String)lista.get(x);
            	if(nombre.length()>0)
            		q53LogEstadisticas.printLog("NOMBRE: "+nombre+" VALOR: "+sd.gOS(nombre));
            }*/
            //FIN Sacar los datos que hemos recogido en el jsp
	        if (sd.gOS("encuesta").equals("pres")){
	            String grp_2_2_1 = sd.gOS("grp_2_2_1");
	            String grp_2_2_2 = sd.gOS("grp_2_2_2");
	            String grp_5_4_1 = sd.gOS("grp_5_4_1");
	            String grp_5_4_2 = sd.gOS("grp_5_4_2");
	            String grp_5_4_3 = sd.gOS("grp_5_4_3");
	            String grp_5_4_4 = sd.gOS("grp_5_4_4");
	            String sinConcretar = sd.gOS("sinConcretar");
	            if (grp_2_2_1.equals("") || grp_2_2_1==null) grp_2_2_1="0";
	            if (grp_2_2_2.equals("") || grp_2_2_2==null) grp_2_2_2="0";
	            if (grp_5_4_1.equals("") || grp_5_4_1==null) grp_5_4_1="0";
	            if (grp_5_4_2.equals("") || grp_5_4_2==null) grp_5_4_2="0";
	            if (grp_5_4_3.equals("") || grp_5_4_3==null) grp_5_4_3="0";
	            if (grp_5_4_4.equals("") || grp_5_4_4==null) grp_5_4_4="0";
	            if (sinConcretar.equals("") || sinConcretar==null) sinConcretar="0";
	
	            q53LogEstadisticas.printLog("Meto en sesion los valores");
	            //        q53LogEstadisticas.printLog("n_Hombres:"+grp_2_2_1);
	            //        q53LogEstadisticas.printLog("n_Mujeres:"+grp_2_2_2);
	            //        q53LogEstadisticas.printLog("n_Menor27:"+grp_5_4_1);
	            //        q53LogEstadisticas.printLog("n_Entre27_45:"+grp_5_4_2);
	            //        q53LogEstadisticas.printLog("n_Entre46_65:"+grp_5_4_3);
	            //        q53LogEstadisticas.printLog("n_Mas65:"+grp_5_4_4);
	            //        q53LogEstadisticas.printLog("sinConcretar:"+sinConcretar);
	
	            PSP.setValInSessionProclet(sd, "n_Hombres", grp_2_2_1);
	            PSP.setValInSessionProclet(sd, "n_Mujeres", grp_2_2_2);
	            PSP.setValInSessionProclet(sd, "n_Menor27", grp_5_4_1);
	            PSP.setValInSessionProclet(sd, "n_Entre27_45", grp_5_4_2);
	            PSP.setValInSessionProclet(sd, "n_Entre46_65", grp_5_4_3);
	            PSP.setValInSessionProclet(sd, "n_Mas65", grp_5_4_4);
	            PSP.setValInSessionProclet(sd, "sinConcretar", sinConcretar);
	            
	            q53LogEstadisticas.printLog("Ya se han metido en sesion");
	            
	            // Inicializar variables a cero
	            q53LogEstadisticas.printLog("Inicializar a cero las variables de asignacion de personas");
	            PSP.setValInSessionProclet(sd, "hombresAsig", "0");
	            PSP.setValInSessionProclet(sd, "mujeresAsig", "0");
	            PSP.setValInSessionProclet(sd, "menor27Asig", "0");
	            PSP.setValInSessionProclet(sd, "entre27_45Asig", "0");
	            PSP.setValInSessionProclet(sd, "entre46_65Asig", "0");
	            PSP.setValInSessionProclet(sd, "mas65Asig", "0");
	            PSP.setValInSessionProclet(sd, "sinConcretarAsig", "0");
	        }

            String gvCodEncuesta = sd.gOS("gv_cod_encuesta");
            String gvCodVersion = sd.gOS("gv_cod_version");
            String codOficina = sd.gOS("q53_cki.q53_oficina");
            String usuario = sd.gOS("q53_cki.q53_usuario");
            String dia=sd.gOS("fech_0_dia");
            String mes=sd.gOS("fech_0_mes");
            String anio=sd.gOS("fech_0_anio");
            String hora=sd.gOS("fech_0_hora");
            String mant=sd.gOS("mantener");
            String mantnopres=sd.gOS("mantener_nopres");
            sd.req.getSession(true).setAttribute("dia",dia);
            sd.req.getSession(true).setAttribute("mes",mes);
            sd.req.getSession(true).setAttribute("anio",anio);
            sd.req.getSession(true).setAttribute("hora",hora);
            sd.req.getSession(true).setAttribute("mantener",mant);
            sd.req.getSession(true).setAttribute("mantener_nopres",mantnopres);
            //        q53LogEstadisticas.printLog("gvCodEncuesta:"+gvCodEncuesta);
            //        q53LogEstadisticas.printLog("gvCodVersion:"+gvCodVersion);
            //        q53LogEstadisticas.printLog("codOficina:"+codOficina);
            //        q53LogEstadisticas.printLog("usuario:"+usuario);
            //        q53LogEstadisticas.printLog("hora:"+sd.req.getSession(true).getAttribute("hora"));
            //        q53LogEstadisticas.printLog("mes:"+mes);
            //        q53LogEstadisticas.printLog("anio:"+anio);
            //        q53LogEstadisticas.printLog("hora:"+hora);

            //        q53LogEstadisticas.printLog("Tipo de encuesta : " + sd.gOS("encuesta"));                    
            //        q53LogEstadisticas.printLog("Cdigo postal::::"+sd.gOS("cpos"));  

            //
        
        		//si es comunidad autnoma solo se graba su campo
        		//si es Territorio solo se graba su campo
        		//si es pais solo se graba su campo         
        

            if (!gvCodEncuesta.equals("")) {
                // hay encuesta gv
                sd.setVal("pagina", q53Constantes.PAG_RECOGIDA_DATOS);
                //        q53LogEstadisticas.printLog("pagina:"+q53Constantes.PAG_RECOGIDA_DATOS);
                //INSERTAMOS LA RESPUESTA EN LA b.d.
                q53LogEstadisticas.printLog("Insertamos la respuesta en la base de datos");
                //String codRespuesta = q53RespuestaClass.setRespuestaEncGV(sd,
                //        codOficina, usuario, gvCodEncuesta, gvCodVersion);
                String encuesta=sd.gOS("encuesta");
                String codRespuesta = q53RespuestaClass.setRespuestaEncGV(sd,
                        codOficina, usuario, gvCodEncuesta, gvCodVersion,encuesta);
                
                // recorrer pregunta por pregunta para coger la info. de los campos
                // que dependen del tipo de pregunta
                q53LogEstadisticas.printLog("Recorrer cada pregunta y guardarla");
                //        q53LogEstadisticas.printLog("Cdigo de Encuesta : " + gvCodEncuesta);
                //        q53LogEstadisticas.printLog("Cdigo de version : " + gvCodVersion);
                //        q53LogEstadisticas.printLog("Cdigo de respuesta : " + codRespuesta);
                q53RespuestaClass.guardarRespuestasEncGV(sd, gvCodEncuesta,
                        gvCodVersion, codRespuesta);
//                String[] valores = sd.getValNames("");
//                for(int g=0;g<valores.length;g++){
//                	q53LogEstadisticas.printLog("VALORES EN EL SD:::: -> " +valores[g] + " <- -> " +sd.getVal(valores[g])+ " <-");
//                }
                // guardo el codigo de la respuesta, que ser el cdigo de respuesta
                // de recogida de datos asociada al resto de respuestas del visitante
                sd.setVal("respuesta_rd_asociada",
                        sd.gOS("preg_gv_cod_rpta.cod_respuesta"));
                if(sd.gOS("check_envio").equals("on")){
                	q53LogEstadisticas.printLog("Hay que guardar para notificaciones");
                	q53RespuestaClass.guardarNotificaciones(sd,codRespuesta);             	
                }
            }
            // recoger parametros de encuesta ofi
            // si hay encuesta_ofi, hacer lo mismo.
            PSP.paramProclet(sd, "ofi_cod_encuesta(),ofi_cod_version(),terminarAmbas()");
            
            //El codigo de oficina y el codigo de version los recoge del request
            //Ademas El campo terminarAmbas indica que se quiere guardar tambien la encuesta propia de la oficina
/*            if ((sd.req.getParameter("ofi_cod_encuesta") != null) &&
                    !(sd.req.getParameter("ofi_cod_encuesta").equals("")) &&
                    (sd.req.getParameter("terminarAmbas") != null) &&
                    sd.req.getParameter("terminarAmbas").equals("1")) {*/
            q53LogEstadisticas.printLog("Antes de if ofi_cod_encuesta y terminarAmbas");
            //        q53LogEstadisticas.printLog("sd.gOS(ofi_cod_encuesta):-" + sd.gOS("ofi_cod_encuesta")+ "-");
            //        q53LogEstadisticas.printLog("sd.gOS(terminarAmbas):-" + sd.gOS("terminarAmbas")+ "-");
            if (sd.gOS("ofi_cod_encuesta") != null && !sd.gOS("ofi_cod_encuesta").equals("") &&
                    sd.gOS("terminarAmbas") != null && sd.gOS("terminarAmbas").equals("1")) {
                String codEncuestaOfi = sd.gOS("ofi_cod_encuesta");
                String codVersionEncOfi = sd.gOS("ofi_cod_version");
                String encuesta=sd.gOS("encuesta");
                sd.setVal("pagina", "otras_encuestas");
                
                PSP.paramProclet(sd, "respuesta_rd_asociada()");
                
                //         q53LogEstadisticas.printLog("sd.gOS(respuesta_rd_asociada)-" + sd.gOS("respuesta_rd_asociada") + "-");
                String respRDAsociada = sd.gOS("respuesta_rd_asociada");
                
                //INSERTAMOS LA RESPUESTA propia de la oficina EN LA b.d.
                q53LogEstadisticas.printLog("Antes de q53RespuestaClass.setRespuestaEncOfi");
                String codRespEncOfi = q53RespuestaClass.setRespuestaEncOfi(sd,
                        codOficina, usuario, codEncuestaOfi, codVersionEncOfi,
                        respRDAsociada,encuesta);
                q53LogEstadisticas.printLog("Antes de q53RespuestaClass.setRespuestaEncOfi");
                
                //Tenemos que volver a la pagina de recogida de datos necesitamos la encuesta visible de la oficina
                // recorrer pregunta por pregunta para coger la info. de los campos
                // que dependen del tipo de pregunta
                q53LogEstadisticas.printLog("Antes de q53RespuestaClass.guardarRespuestasEncOfi");
                q53RespuestaClass.guardarRespuestasEncOfi(sd, codEncuestaOfi,
                        codVersionEncOfi, codRespEncOfi);
                q53LogEstadisticas.printLog("Despues de q53RespuestaClass.guardarRespuestasEncOfi");
            }
            
            
            q53LogEstadisticas.printLog("Antes de Redirigir a /q53ItourbaskWar/q53usrEncuestaServlet");
            q53LogEstadisticas.printLog("********** FIN **********");
            //        q53LogEstadisticas.printLog("Tipo de encuesta antes de redirigir: " + sd.gOS("encuesta"));
            //        q53LogEstadisticas.printLog("Valor de mantener_ultima antes de redirigir: " + sd.gOS("mantener_ultima"));
			if (sd.gOS("encuesta").equals("pres")){
			        q53_redirigir(sd, "/q53ItourbaskWar/q53usrEncuestaPresencialServlet?cod_al="+codigo_aleatorio+"&mostrar_fecha=S&mantener_ultima="+sd.gOS("mantener_ultima"));
			}else{
					q53_redirigir(sd, "/q53ItourbaskWar/q53usrEncuestaNoPresencialServlet?cod_al="+codigo_aleatorio+"&mostrar_fecha=S&mantener_ultima="+sd.gOS("mantener_ultima"));
			}          
			q53LogEstadisticas.printLog("Despus de Redirigir a /q53ItourbaskWar/q53usrEncuestaServlet");
			

        } // if perfil
        
        else {
            // el usuario no tiene el perfil necesario. seguramente es porque
            // se ha perdido la sesin y hay que redirigirlo al login, para que
            // vuelva a meter su usuario y contrasea
            sd.setVal("pagina", "q53_gen_login");
            q53LogEstadisticas.printLog("q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
            q53LogEstadisticas.printLog("********** FIN **********");
            q53_redirigir(sd,
                    "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
        }
    }
}
