package itourbaskServlet;

import itourbaskBeans.q53EncuestaBean;
import itourbaskBeans.q53FechaBean;
import itourbaskClases.q53EncuestaClass;

import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53RecorrerPreguntas;
import q53_util.q53Util;
import util.q53LiteralesEncuestaGV;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


public class q53usrEncuestaServlet extends q53Servlet {
    public void pspProcess(ProcletServiceData sd) throws ProcletException {
        try {
            // establece el contentType del response
            sd.res.setContentType("text/html");
            sd.res.setHeader("Pragma", "no-cache");
            sd.res.setHeader("Cache-Control", "no-cache");
            sd.res.setHeader("Expires", "0");

            // tratar las cookies
            q53_tratarCookies(sd);

            String perfilUser = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
                perfilUser = "SI";
            }

            String perfilCoord = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
                perfilCoord = "SI";
            }

            String perfilAdmin = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
                perfilAdmin = "SI";
            }

            sd.setVal("perfilUser", perfilUser);
            sd.setVal("perfilCoord", perfilCoord);
            sd.setVal("perfilAdmin", perfilAdmin);
            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO) ||
                    q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                    q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
			    PSP.paramProclet(sd, "cod_encuesta(),cod_version(),accion(),respuesta_rd_asociada(),encuestas_terminadas()");


                if (sd.gOS("cod_encuesta").equals("") || sd.gOS("cod_encuesta").equals("0")) {
                    //En la pantalla derecgida de datos aparece la encuesta del g.v. 
                    //Y si la oficina tiene alguna encuesta visible tambien aparece.

                    sd.setVal("es_recogida_datos", "SI");
                    sd.setVal("pagina", "recogida_de_datos");

                    //Recuperamos la fecha mxima y mnima para poder rellenar la combo
                    //de aos en la encuesta del g.v..
                    q53FechaBean q53FechaBean = q53EncuestaClass.getGVDate(sd);
                    sd.setVal("fechasGV", q53FechaBean);

                    String codOficina = sd.gOS("q53_cki.q53_oficina");

                    //Recuperamos la pregunta de procedencias(informacin para rellenar
                    //las diferentes combos de municipio territorio,comunidad autonoma
                    //y pais).
                    q53RecorrerPreguntas.cogerPreguntaProcedencia(sd,
                        "preg_gv", 2);
                    //Recuperamos los datos de la pregunta de tipo fecha
                    q53RecorrerPreguntas.cogerPreguntaFecha(sd, 0);

                    //Recuperamos el nmero de encuestas realizadas hoy
                    String numEncHoy = q53EncuestaClass.getNumEncuestasHoy(sd);

                    //Pasamos los diferentes parametros a la JSP
                    sd.setVal("numEncHoy", numEncHoy);

                    //Los literales de las preguntas de la encuesta del g.v.
                    //Los recuperamos en diferentes metodos desde la b.d.
                    //y los pasamos a la jsp en diferentes listas                   
                    sd.setVal("literalesCalendario",
                        q53LiteralesEncuestaGV.getLiteralesCalendario(sd));
                    sd.setVal("literalesGrupos",
                        q53LiteralesEncuestaGV.getLiteralesGrupos(sd));
                    sd.setVal("literalesIdiomaConsulta",
                        q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_4",
                            "N3_4_", 8));
                    sd.setVal("literalesInformacionSolicitada",
                        q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_7",
                            "N3_7_", 7));
                    sd.setVal("literalesTipoServicio",
                        q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_1",
                            "N3_1_", 6));
                    sd.setVal("literalesMedioRecepcion",
                        q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_3",
                            "N3_3_", 8));
                    sd.setVal("literalesTipoInformacion",
                        q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_8",
                            "N3_8_", 20));
					//IGC 20150519 INICIO INCLUIR PREGUNTA VALIDACION ESTANCIA
                    sd.setVal("literalesValoracionEstancia",
                        q53LiteralesEncuestaGV.getLiteralesOpcionesDesdeHasta(sd, "N1_12",
                            "N3_12_", 0, 5));
                    sd.setVal("textoAyudaValoracionEstancia",
                        q53LiteralesEncuestaGV.getLiteralPregunta(sd, "AYUDA_VALORACION_ESTANCIA"));
					//IGC 20150519 FIN INCLUIR PREGUNTA VALIDACION ESTANCIA
                    //recupermos los datos propios de la encuesa del g.v.
                    //Como por ejemplo codigo de encuesta,codigo de version etc..
                    q53EncuestaBean encuestaGV = q53EncuestaClass.getGVEncData(sd,
                            "0", "1");
					sd.setVal("encuestaGV", encuestaGV);

                    String codPadre = q53EncuestaClass.getCodOfiPadre(sd, codOficina);
                    sd.setVal("codPadre",codPadre);

                    //Miramos si la oficina tiene alguna encuesta
                    if (q53EncuestaClass.isEncuestaOficina(sd, codOficina,codPadre)) {
                        //Miramos si la oficina tiene alguna encuesta visible
                        if (q53EncuestaClass.isEncuestaOficinaVisible(sd)) {
                            //Enumerationel caso de que tenga una encuesta visible
                            //Recuperamos los datos de esa encuesta (codigo de encuesta,de version,descripcion
                            //de la encuesta,si es visible)

                            String encuesta=sd.gOS("encuesta");
                            q53EncuestaBean encuestaVisible = null;
                            if(encuesta.equals("pres")){
                                encuestaVisible = q53EncuestaClass.getEncuestaVisiblePres(sd,
                                     codOficina);
                             }else if(encuesta.equals("nopres")){
                                encuestaVisible = q53EncuestaClass.getEncuestaVisibleNoPres(sd,
                                         codOficina);
                             }

                            //Nos aseguramos de que esta visible
                            if (encuestaVisible.isEncuestaVisible()) {
                                sd.setVal("hay_preg_ofi", "SI");

                                //Recuperamos las pregutnas de esa encuesta y las recojemos en una lista
                                //que despues enviaremos a la JSP
                                List preguntasList = q53EncuestaClass.generarEncuestas(sd);
                                sd.setVal("preguntasList", preguntasList);
                                sd.setVal("encVisible", encuestaVisible);
                            } else {
                                //No hay encuesta visible propia de la oficina
                                sd.setVal("hay_preg_ofi", "NO");
                            }
                        } else {
                            //No hay encuesta visible propia de la oficina
                            sd.setVal("hay_preg_ofi", "NO");
                        }
                    } else {
                        //la focina no tiene encuesta propia
                        sd.setVal("hay_preg_ofi", "NO");
                    }
                } else {
                    // hay parmetro de cdigo de encuesta.
                    // Se muestran las preguntas de la encuesta elegida
                    sd.setVal("es_recogida_datos", "SI");
                    sd.setVal("pagina", "recogida_de_datos");

                    q53FechaBean q53FechaBean = q53EncuestaClass.getGVDate(sd);
                    sd.setVal("fechasGV", q53FechaBean);

                    String codOficina = sd.gOS("q53_cki.q53_oficina");
                    q53RecorrerPreguntas.cogerPreguntaProcedencia(sd,
                        "preg_gv", 2);
                    q53RecorrerPreguntas.cogerPreguntaFecha(sd, 0);

                    String numEncHoy = q53EncuestaClass.getNumEncuestasHoy(sd);
                    sd.setVal("numEncHoy", numEncHoy);
                    sd.setVal("literalesCalendario",
                        q53LiteralesEncuestaGV.getLiteralesCalendario(sd));
                    sd.setVal("literalesGrupos",
                        q53LiteralesEncuestaGV.getLiteralesGrupos(sd));
                    sd.setVal("literalesIdiomaConsulta",
                        q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_4",
                            "N3_4_", 8));
                    sd.setVal("literalesInformacionSolicitada",
                        q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_7",
                            "N3_7_", 7));
                    sd.setVal("literalesTipoServicio",
                        q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_1",
                            "N3_1_", 6));
                    sd.setVal("literalesMedioRecepcion",
                        q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_3",
                            "N3_3_", 8));
                    sd.setVal("literalesTipoInformacion",
                        q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_8",
                            "N3_8_", 20));
					//IGC 20150519 INICIO INCLUIR PREGUNTA VALIDACION ESTANCIA
                    sd.setVal("literalesValoracionEstancia",
                        q53LiteralesEncuestaGV.getLiteralesOpcionesDesdeHasta(sd, "N1_12",
                            "N3_12_", 0, 5));
                    sd.setVal("textoAyudaValoracionEstancia",
                        q53LiteralesEncuestaGV.getLiteralPregunta(sd, "AYUDA_VALORACION_ESTANCIA"));
					//IGC 20150519 FIN INCLUIR PREGUNTA VALIDACION ESTANCIA

                    String codPadre = q53EncuestaClass.getCodOfiPadre(sd, codOficina);
                    sd.setVal("codPadre",codPadre);
                    //Miramos si la oficina tiene alguna encuesta
                    if (q53EncuestaClass.isEncuestaOficina(sd, codOficina,codPadre)) {
                        //miramos si la oficina tiene encuesta visible
                        if (q53EncuestaClass.isEncuestaOficinaVisible(sd)) {
                            String encuesta=sd.gOS("encuesta");
                            q53EncuestaBean encuestaVisible = null;
                            if(encuesta.equals("pres")){
                                encuestaVisible = q53EncuestaClass.getEncuestaVisiblePres(sd,
                                     codOficina);
                             }else if(encuesta.equals("nopres")){
                                encuestaVisible = q53EncuestaClass.getEncuestaVisibleNoPres(sd,
                                         codOficina);
                             }

                            if (encuestaVisible.isEncuestaVisible()) {
                                sd.setVal("hay_preg_ofi", "SI");

                                List preguntasList = q53EncuestaClass.generarEncuestas(sd);
                                sd.setVal("preguntasList", preguntasList);
                                sd.setVal("encVisible", encuestaVisible);
                            } else {
                                sd.setVal("hay_preg_ofi", "NO");
                            }
                        } else {
                            sd.setVal("hay_preg_ofi", "NO");
                        }
                    } else {
                        sd.setVal("hay_preg_ofi", "NO");
                    }
                }
                //si se pulsa el boton imprimir nos envia a la JSP de impresion
                if (sd.gOS("accion").equals(q53Constantes.ACCION_IMPRIMIR)) {
                    // se saca la encuesta para poder imprimir y rellenar en el papel
                    sd.setVal("pagina", "q53_usr_encuesta_print");
                    PSP.setTemplatePageProclet(sd, "/q53_usr_encuesta_print.jsp");
                } else {
                    // se saca la encuesta normal, para rellenarla en la web
                    PSP.setTemplatePageProclet(sd, "/q53_usr_encuesta.jsp");
                }
            } // if perfil

            else {
                // el usuario no tiene el perfil necesario. seguramente es porque
                // se ha perdido la sesin y hay que redirigirlo al login, para que
                // vuelva a meter su usuario y contrasea
                sd.setVal("pagina", "q53_gen_login");
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    
}
