package itourbaskServlet;

import itourbaskBeans.q53EncuestaBean;
import itourbaskBeans.q53FechaBean;
import itourbaskClases.q53EncuestaClass;
import itourbaskClases.q53RespuestaClass;

import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53RecorrerPreguntas;
import q53_util.q53Util;
import util.q53LiteralesEncuestaGV;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


public class q53usrEncuestaPresencialServletHTA extends q53Servlet {
    public void pspProcess(ProcletServiceData sd) throws ProcletException {
        try {
            // establece el contentType del response
            sd.res.setContentType("text/html");
            sd.res.setHeader("Pragma", "no-cache");
            sd.res.setHeader("Cache-Control", "no-cache");
            sd.res.setHeader("Expires", "0");
            
            // tratar las cookies
            //q53_tratarCookies(sd);
            
            //pasar las variables de sesion al sd
            q53Util.pasar_a_sd(sd);
            String perfilUser = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
                perfilUser = "SI";
            }

            String perfilCoord = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
                perfilCoord = "SI";
            }

            String perfilAdmin = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
                perfilAdmin = "SI";
            }

            sd.setVal("perfilUser", perfilUser);
            sd.setVal("perfilCoord", perfilCoord);
            sd.setVal("perfilAdmin", perfilAdmin);
            
            String perfiles = sd.gOS("q53_cki.q53_perfil");
            
            if (perfiles.equals("")){
                // el usuario no tiene el perfil seguramente es porque
                // se ha perdido la sesi�n y hay que redirigirlo al login, para que
                // vuelva a meter su usuario y contrase�a
                sd.setVal("pagina", "q53_gen_login");
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
            }else{
            
                sd.setVal("preguntasInteres", q53RespuestaClass.cogerPreguntaOpciones(sd, "8"));
                if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO) ||
                        q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                        q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
    			    PSP.paramProclet(sd, "cod_encuesta(),cod_version(),accion(),respuesta_rd_asociada(),encuestas_terminadas(),cpos()");
    
                    if (sd.gOS("cod_encuesta").equals("") || sd.gOS("cod_encuesta").equals("0")) {
                    	//q53LogEstadisticas.printLog("Entramos por cod_encuesta --" + sd.gOS("cod_encuesta"));     
                        //En la pantalla derecgida de datos aparece la encuesta del g.v. 
                        //Y si la oficina tiene alguna encuesta visible tambien aparece.
    
                        sd.setVal("es_recogida_datos", "SI");
                        sd.setVal("pagina", "recogida_de_datos_HTA");
    
                        //Recuperamos la fecha m�xima y m�nima para poder rellenar la combo
                        //de a�os en la encuesta del g.v..
                        q53FechaBean q53FechaBean = q53EncuestaClass.getGVDate(sd);
                        sd.setVal("fechasGV", q53FechaBean);
    
                        String codOficina = sd.gOS("q53_cki.q53_oficina");
    
                        //Recuperamos la pregunta de procedencias(informaci�n para rellenar
                        //las diferentes combos de municipio territorio,comunidad autonoma
                        //y pais).
                        q53LogEstadisticas.printLog("Recorrer preguntaProcedencia");  
                        q53RecorrerPreguntas.cogerPreguntaProcedencia(sd,
                            "preg_gv", 2);
                        //Recuperamos los datos de la pregunta de tipo fecha
                        q53LogEstadisticas.printLog("Recorrer preguntaFecha");  
                        q53RecorrerPreguntas.cogerPreguntaFecha(sd, 0);
    
                        //Recuperamos el n�mero de encuestas realizadas hoy
                        String numEncHoy = q53EncuestaClass.getNumEncuestasHoy(sd);
    
                        //Pasamos los diferentes parametros a la JSP
                        sd.setVal("numEncHoy", numEncHoy);
    
                        //Los literales de las preguntas de la encuesta del g.v.
                        //Los recuperamos en diferentes metodos desde la b.d.
                        //y los pasamos a la jsp en diferentes listas                   
                        sd.setVal("literalesCalendario",
                            q53LiteralesEncuestaGV.getLiteralesCalendario(sd));
                        sd.setVal("literalesGrupos",
                            q53LiteralesEncuestaGV.getLiteralesGrupos(sd));
                        sd.setVal("literalesIdiomaConsulta",
                            q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_4",
                                "N3_4_", 8));
                        sd.setVal("literalesInformacionSolicitada",
                            q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_7",
                                "N3_7_", 7));
                        sd.setVal("literalesTipoServicio",
                            q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_1",
                                "N3_1_", 6));
                        sd.setVal("literalesMedioRecepcion",
                            q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_3",
                                "N3_3_", 8));
                        sd.setVal("literalesTipoInformacion",
                            q53LiteralesEncuestaGV.getLiteralesOpcionesTipoInfo(sd, "N1_8",
                                "N3_8_", 50));
    					//IGC 20150519 INICIO INCLUIR PREGUNTA VALIDACION ESTANCIA
                        sd.setVal("literalesValoracionEstancia",
                            q53LiteralesEncuestaGV.getLiteralesOpcionesDesdeHasta(sd, "N1_12",
                                "N3_12_", 0, 5));
                        sd.setVal("textoAyudaValoracionEstancia",
                            q53LiteralesEncuestaGV.getLiteralPregunta(sd, "AYUDA_VALORACION_ESTANCIA"));
    					//IGC 20150519 FIN INCLUIR PREGUNTA VALIDACION ESTANCIA
                        q53LogEstadisticas.printLog("Recogidos los literales");  
                        //recupermos los datos propios de la encuesa del g.v.
                        //Como por ejemplo codigo de encuesta,codigo de version etc..
                        q53EncuestaBean encuestaGV = q53EncuestaClass.getGVEncData(sd,
                                "0", "1");
    					sd.setVal("encuestaGV", encuestaGV);
    
                        String codPadre = q53EncuestaClass.getCodOfiPadre(sd, codOficina);
                        sd.setVal("codPadre",codPadre);
    
                        //Miramos si la oficina tiene alguna encuesta
                        if (q53EncuestaClass.isEncuestaOficina(sd, codOficina,codPadre)) {
                        	q53LogEstadisticas.printLog("La oficina tiene encuesta");  
                            //Miramos si la oficina tiene alguna encuesta visible
                            if (q53EncuestaClass.isEncuestaOficinaVisible(sd)) {
                            	q53LogEstadisticas.printLog("La oficina tiene encuesta visible");  
                                //Enumerationel caso de que tenga una encuesta visible
                                //Recuperamos los datos de esa encuesta (codigo de encuesta,de version,descripcion
                                //de la encuesta,si es visible)
                                q53EncuestaBean encuestaVisible = q53EncuestaClass.getEncuestaVisiblePres(sd,
                                        codOficina);
    
                                //Nos aseguramos de que esta visible
                                if (encuestaVisible.isEncuestaVisible()) {
                                    sd.setVal("hay_preg_ofi", "SI");
    q53LogEstadisticas.printLog("Nos aseguramos de que est� visible");  
                                    //Recuperamos las pregutnas de esa encuesta y las recojemos en una lista
                                    //que despues enviaremos a la JSP
                                    List preguntasList = q53EncuestaClass.generarEncuestas(sd);
                                    sd.setVal("preguntasList", preguntasList);
                                    sd.setVal("encVisible", encuestaVisible);
                                } else {
                                    //No hay encuesta visible propia de la oficina
                                    sd.setVal("hay_preg_ofi", "NO");
                                    q53LogEstadisticas.printLog("No hay encuesta visible de la oficina");  
                                }
                            } else {
                                //No hay encuesta visible propia de la oficina
                                sd.setVal("hay_preg_ofi", "NO");
                            }
                        } else {
                            //la focina no tiene encuesta propia
                            sd.setVal("hay_preg_ofi", "NO");
                            q53LogEstadisticas.printLog("La oficina no tiene encuesta propia");  
                        }
                    } else {
                        // hay par�metro de c�digo de encuesta.
                        // Se muestran las preguntas de la encuesta elegida
                        //q53LogEstadisticas.printLog("Entramos por cod_encuesta --" + sd.gOS("cod_encuesta"));  
                        sd.setVal("es_recogida_datos", "SI");
                        sd.setVal("pagina", "recogida_de_datos_HTA");
    
                        q53FechaBean q53FechaBean = q53EncuestaClass.getGVDate(sd);
                        sd.setVal("fechasGV", q53FechaBean);
    
                        String codOficina = sd.gOS("q53_cki.q53_oficina");
    //q53LogEstadisticas.printLog("C�digo postal::::"+sd.gOS("cpos"));     
    String select_local = "select * from oficina where t02_coor='"+codOficina+"'";
    
            //q53LogEstadisticas.printLog("::::"+select_local);
            PSP.sqlProclet(sd, "preg_local[]=" + select_local);
                   
                        q53RecorrerPreguntas.cogerPreguntaProcedencia(sd,
                            "preg_gv", 2);
                        q53RecorrerPreguntas.cogerPreguntaFecha(sd, 0);
    
                        String numEncHoy = q53EncuestaClass.getNumEncuestasHoy(sd);
                        sd.setVal("numEncHoy", numEncHoy);
                        sd.setVal("literalesCalendario",
                            q53LiteralesEncuestaGV.getLiteralesCalendario(sd));
                        sd.setVal("literalesGrupos",
                            q53LiteralesEncuestaGV.getLiteralesGrupos(sd));
                        sd.setVal("literalesIdiomaConsulta",
                            q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_4",
                                "N3_4_", 8));
                        sd.setVal("literalesInformacionSolicitada",
                            q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_7",
                                "N3_7_", 7));
                        sd.setVal("literalesTipoServicio",
                            q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_1",
                                "N3_1_", 6));
                        sd.setVal("literalesMedioRecepcion",
                            q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_3",
                                "N3_3_", 8));
                        sd.setVal("literalesTipoInformacion",
                            q53LiteralesEncuestaGV.getLiteralesOpciones(sd, "N1_8",
                                "N3_8_", 20));
    					//IGC 20150519 INICIO INCLUIR PREGUNTA VALIDACION ESTANCIA
                        sd.setVal("literalesValoracionEstancia",
                            q53LiteralesEncuestaGV.getLiteralesOpcionesDesdeHasta(sd, "N1_12",
                                "N3_12_", 0, 5));
                        sd.setVal("textoAyudaValoracionEstancia",
                            q53LiteralesEncuestaGV.getLiteralPregunta(sd, "AYUDA_VALORACION_ESTANCIA"));
    					//IGC 20150519 FIN INCLUIR PREGUNTA VALIDACION ESTANCIA
    q53LogEstadisticas.printLog("guardamos los literales");  
                        String codPadre = q53EncuestaClass.getCodOfiPadre(sd, codOficina);
                        sd.setVal("codPadre",codPadre);
                        //Miramos si la oficina tiene alguna encuesta
                        if (q53EncuestaClass.isEncuestaOficina(sd, codOficina,codPadre)) {
                        	q53LogEstadisticas.printLog("La oficina tiene encuesta ");  
                            //miramos si la oficina tiene encuesta visible
                            if (q53EncuestaClass.isEncuestaOficinaVisible(sd)) {
                                q53EncuestaBean encuestaVisible = q53EncuestaClass.getEncuestaVisiblePres(sd,
                                        codOficina);
    q53LogEstadisticas.printLog("La oficina tiene encuesta visible");  
                                if (encuestaVisible.isEncuestaVisible()) {
                                    sd.setVal("hay_preg_ofi", "SI");
    q53LogEstadisticas.printLog("HAY_PREG_OFI =SI");  
                                    List preguntasList = q53EncuestaClass.generarEncuestas(sd);
                                    sd.setVal("preguntasList", preguntasList);
                                    sd.setVal("encVisible", encuestaVisible);
                                } else {
    q53LogEstadisticas.printLog("HAY_PREG_OFI =NO1");  
                                    sd.setVal("hay_preg_ofi", "NO");
                                }
                            } else {
                                sd.setVal("hay_preg_ofi", "NO");
    q53LogEstadisticas.printLog("HAY_PREG_OFI =NO2");                              
                            }
                        } else {
                            sd.setVal("hay_preg_ofi", "NO");
    q53LogEstadisticas.printLog("HAY_PREG_OFI =NO3");                          
                        }
                    }
                    //si se pulsa el boton imprimir nos envia a la JSP de impresion
    
                        // se saca la encuesta normal, para rellenarla en la web
                    q53LogEstadisticas.printLog("Redireccionamos al jsp");
                    q53LogEstadisticas.printLog("Redirigir");
                     
                        PSP.setTemplatePageProclet(sd, "/q53_usr_encuesta_presenciaHTA.jsp");	
                }else { // if perfil
                    // el usuario no tiene el perfil necesario. seguramente es porque
                    // se ha perdido la sesi�n y hay que redirigirlo al login, para que
                    // vuelva a meter su usuario y contrase�a
                    q53LogEstadisticas.printLog("NO HAY SESION");                  
                    sd.setVal("pagina", "q53_gen_login");
                    q53_redirigir(sd,
                        "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    
}
