package itourbaskServlet;

import itourbaskClases.q53BorrarRespuestasClass;
import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletServiceData;



public class q53usrBorrarRespuestasServlet extends q53Servlet {
    
    /**
     * Procleto que guarda la encuesta rellenada y muestra de nuevo la encuesta
     * para rellenar
     **/
public void pspProcess(ProcletServiceData sd){
    // establece el contentType del response
    sd.res.setContentType("text/html");
    sd.res.setHeader("Pragma", "no-cache");
    sd.res.setHeader("Cache-Control", "no-cache");
    sd.res.setHeader("Expires", "0");
    try{
        // tratar las cookies
        q53_tratarCookies(sd);

        String codigo_aleatorio = q53Util.obtener_cod_aleatorio();
        String perfilUser = "NO";
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO))
            perfilUser = "SI";

        String perfilCoord = "NO";
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR))
            perfilCoord = "SI";

        String perfilAdmin = "NO";
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO))
            perfilAdmin = "SI";

        sd.setVal("perfilUser", perfilUser);
        sd.setVal("perfilCoord", perfilCoord);
        sd.setVal("perfilAdmin", perfilAdmin);

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO) ||
        q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
        q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
        // es_recogida_datos se utiliza en el jsp q53_usr_guardar.jsp para
        // saber si hay que mostrar como ttulo "Recogida de datos" o el
        // nombre de la encuesta.
            PSP.paramProclet(sd, "vuelve_a_recogida(),es_administrador(),cod_respuesta(),fechaInicio(),fechaFin(),fechaInicioVis(),fechaFinVis(),cod_encuesta(),cod_version(),encuesta(), asc(), tipo_ordenacion(),usuario()");
           
            String codRespuesta = sd.gOS("cod_respuesta");
			String fechaInicio=sd.gOS("fechaInicio");
			String fechaFin=sd.gOS("fechaFin");
			String fechaInicioVis=sd.gOS("fechaInicioVis");
			String fechaFinVis=sd.gOS("fechaFinVis");
			String cod_encuesta=sd.gOS("cod_encuesta");
			String cod_version=sd.gOS("cod_version");
			String encuesta=sd.gOS("encuesta");
			String asc=sd.gOS("asc");
			String tipo_ordenacion=sd.gOS("tipo_ordenacion");
			String es_administrador=sd.gOS("es_administrador");
						
			//q53LogEstadisticas.printLog("fechaInicio "+fechaInicio);
			//q53LogEstadisticas.printLog("fechaFin "+fechaFin);
			//q53LogEstadisticas.printLog("fechaInicioVis "+fechaInicioVis);
			//q53LogEstadisticas.printLog("fechaFinVis "+fechaFinVis);
			//q53LogEstadisticas.printLog("asc "+asc);
			//q53LogEstadisticas.printLog("tipo_ordenacion "+tipo_ordenacion);
			q53LogEstadisticas.printLog("cod_respuesta "+codRespuesta);
			//q53LogEstadisticas.printLog("es_administrador "+es_administrador);
			
					
            if (!codRespuesta.equals("")) {
            // hay encuesta gv
                sd.setVal("pagina", q53Constantes.PAG_RECOGIDA_DATOS);
                if(es_administrador.equals("1")){
	                // Si el usuario es administrador antes de borrar la respuesta se almacenara en las tablas q53BxT00
	                q53BorrarRespuestasClass.guardarEnB(sd, codRespuesta);
                }
                // Borrar la respuesta
                q53BorrarRespuestasClass.borrarRespuestas(sd, codRespuesta);
            }
           	String pendientes=(String)sd.req.getSession(true).getAttribute("pendientes");
			if(pendientes==null)pendientes="";
			String URL;
			if(sd.gOS("vuelve_a_recogida").equals("1"))
				if(sd.gOS("encuesta").equals("pres"))
					URL="/q53ItourbaskWar/q53usrEncuestaPresencialServlet?cod_al="+codigo_aleatorio;
				else
					URL="/q53ItourbaskWar/q53usrEncuestaNoPresencialServlet?cod_al="+codigo_aleatorio;
			else
				URL="/q53ItourbaskWar/q53usrBusquedaServlet?encuesta="+encuesta+"&fechaInicio="+fechaInicio+"&fechaFin="+fechaFin+"&fechaInicioVis="+fechaInicioVis+"&fechaFinVis="+fechaFinVis+"&asc="+asc+"&tipo_ordenacion="+tipo_ordenacion+"&cod_encuesta="+cod_encuesta+"&cod_version="+cod_version+"&respuesta_rd_asociada=&encuestas_terminadas=&pendientes="+pendientes + "&usuario=" + sd.gOS("usuario");	
            q53_redirigir(sd,URL);
        } // if perfil
        else {
        // el usuario no tiene el perfil necesario. seguramente es porque
        // se ha perdido la sesin y hay que redirigirlo al login, para que
        // vuelva a meter su usuario y contrasea
            sd.setVal("pagina", "q53_gen_login");
            q53_redirigir(sd,
            "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
        }
    }catch(Exception e){
        e.printStackTrace();
    }

}
	
}
