package itourbaskServlet;

import itourbaskBeans.q53EncuestaBean;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53RecorrerPreguntas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53encVerServlet extends q53Servlet {
    /**
     * DOCUMENT ME!
     *
     * @param sd DOCUMENT ME!
     *
     * @throws ProcletException DOCUMENT ME!
     */

    public void pspProcess(ProcletServiceData sd) throws ProcletException {


        try {
        	HttpSession session = sd.req.getSession(true);
        	String idioma = (String)session.getAttribute("q53_cki.q53_idioma");
        	String oficina = (String)session.getAttribute("q53_cki.q53_oficina");
        	/*sd.setVal("q53_cki.q53_idioma",(String)session.getAttribute("q53_cki.q53_idioma"));
            sd.setVal("q53_cki.q53_oficina",(String)session.getAttribute("q53_cki.q53_oficina"));
            sd.setVal("q53_cki.q53_perfil",(String)session.getAttribute("q53_cki.q53_perfil"));
            sd.setVal("q53_cki.q53_usuario",(String)session.getAttribute("q53_cki.q53_usuario"));*/
            // establece el contentType del response
            sd.res.setContentType("text/html");
            sd.res.setHeader("Pragma", "no-cache");
            sd.res.setHeader("Cache-Control", "no-cache");
            sd.res.setHeader("Expires", "0");

            // tratar las cookies
            q53_tratarCookies(sd);
            q53Util.pasar_a_sd(sd);
            
            String perfilUser = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
                perfilUser = "SI";
            }

            String perfilCoord = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
                perfilCoord = "SI";
            }

            String perfilAdmin = "NO";

            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
                perfilAdmin = "SI";
            }

            sd.setVal("perfilUser", perfilUser);
            sd.setVal("perfilCoord", perfilCoord);
            sd.setVal("perfilAdmin", perfilAdmin);
			
            if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                    q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
                PSP.paramProclet(sd,
                    "cod_encuesta(),cod_version(),genEncuesta(),cod_ver_maximo(),accion(),recogida_datos()");

                String codEncuesta = sd.gOS("cod_encuesta");
                String codVersion = sd.gOS("cod_version");

                // Sacamos el idioma de la cookie para saber el formato de la fecha
                String formato = "";

                if (idioma.equals(q53Constantes.IDIOMA_CAS)) {
                    formato = q53Constantes.FORMATO_FECHA_HORA_CAS;
                } else {
                    formato = q53Constantes.FORMATO_FECHA_HORA_EUS;
                }

                // select de las preguntas de la encuesta elegida. Si no hay encuesta
                // elegida, sacar la de recogida de datos.
                q53EncuestaBean encuesta = geEncuestaData(sd, codEncuesta,
                        codVersion, formato);

                sd.setVal("encuestaData",encuesta);


                // si hay encuesta, se coge el nmero de respuestas a la encuesta
                // (nota: puede ser que sea una oficina sin encuesta de recogida de
                // datos. En ese caso no habra enc[0]!)                
                if (encuesta != null) {
                    boolean isVersionAntigua = encuesta.isVersionAntigua();
                    List oldVersionEncuestaList = getOldVersionEncuesta(sd,
                            formato, codEncuesta, isVersionAntigua);
                    
                    String hayEncuestaPresencialVisible = hayEncuestaPresVisible(sd);
                    String hayEncuestaNoPresencialVisible = hayEncuestaNoPresVisible(sd);
                    sd.setVal("hayEncuestaPresencialVisible",hayEncuestaPresencialVisible);
                    sd.setVal("hayEncuestaNoPresencialVisible",hayEncuestaNoPresencialVisible);
                    /*String isEncuestaPres = ifEncuestaPres(sd);
                    sd.setVal("tipoPres",isEncuestaPres);
                    
                    String isEncuestaNopres = ifEncuestaNopres(sd);
                    sd.setVal("tipoNoPres",isEncuestaNopres);
                    String isEncuestaPresyNopres = ifEncuestaPresyNopres(sd);
                    sd.setVal("tipoPresyNopres",isEncuestaPresyNopres);*/
                    sd.setVal("oldVersionEncuesta",oldVersionEncuestaList);
                    sd.setVal("hay_preg", "SI");
                 
                    String select_preg =
                        "SELECT N1_COD_PREGUNTA, N1_DESCRIPCION, N1_TIPO_PREGUNTA, NZ_ORDEN, NZ_OBLIGATORIA" +
                        " FROM PREGUNTA, ENCUESTA_PREGUNTA" +
                        " WHERE NZ_COD_ENCUESTA=${enc[0].n0_cod_encuesta} AND NZ_COD_VERSION=${enc[0].n0_cod_version}" +
                        " AND NZ_COD_PREGUNTA=N1_COD_PREGUNTA" +
                        " ORDER BY NZ_ORDEN";

                    PSP.sqlProclet(sd, "preg[]=" + select_preg);

                    // recorrer pregunta por pregunta para coger la info. de los campos
                    // que dependen del tipo de pregunta
                    q53RecorrerPreguntas.recorrerPreguntas(sd, "preg");
                }

                // se saca la encuesta normal, para rellenarla en la web
                if (sd.gOS("recogida_datos").equals("S")) {
                    sd.setVal("pagina", q53Constantes.PAG_ENC_ACTIVADA);
                } else {
                    sd.setVal("pagina", q53Constantes.PAG_OTRAS_ENC);
                }
                
                PSP.setTemplatePageProclet(sd, "/q53_enc_ver.jsp");
            } // if perfil
            else {
                // el usuario no tiene el perfil necesario. seguramente es porque
                // se ha perdido la sesion y hay que redirigirlo al login, para que
                // vuelva a meter su usuario y contrasea
                sd.setVal("pagina", "q53_gen_login");
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
            }         

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Mtdo que nos devuelve los datos de la encuesta
     *
     * @param sd el objeto ProcletServiceData
     * @param codEncuesta String Codigo de la encuesta
     * @param codVersion String codigo de la version de la encuest
     * @param formato String formato de visualizacion de las fechas que cambia
     *        dependiendo del idioma
     *
     * @return List con las preguntas de la encuesta
     *
     * @throws ProcletException DOCUMENT ME!
     */
    private q53EncuestaBean geEncuestaData(ProcletServiceData sd,
        String codEncuesta, String codVersion, String formato)
        throws ProcletException {
        q53EncuestaBean encuesta = null;

        // select de las preguntas de la encuesta elegida. Si no hay encuesta
        // elegida, sacar la de recogida de datos.
        String select_enc =
            "SELECT N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_RECOGIDA_DATOS, " +
            "N0_VISIBLE, N0_TEXTO, N0_VERSION_ANTIGUA, TO_CHAR(N0_FECHA_CREACION,'" +
            formato + "')N0_FECHA_CREACION, N0_TIPO_ENCUESTA ";
        select_enc += " FROM ENCUESTA";

        select_enc += (" WHERE N0_COD_ENCUESTA=" + codEncuesta +
        " AND N0_COD_VERSION=" + codVersion);
        PSP.sqlProclet(sd, "enc[]=" + select_enc);

        if (sd.gI("enc.length") > 0) {
            encuesta = new q53EncuestaBean();
            encuesta.setCodEncuesta(codEncuesta);
            encuesta.setCodVersion(codVersion);
            encuesta.setDescripcionEncuesta(sd.gOS("enc[0].n0_descripcion"));

            boolean recogidaDatos = false;

            if (sd.gOS("enc[0].n0_recogida_datos").equals("S")) {
                recogidaDatos = true;
            }

            encuesta.setRecogidaDatos(recogidaDatos);
            
            String presencial = "";
            q53LogEstadisticas.printLog("N0_TIPO_ENCUESTA: "+ sd.gOS("enc[2].n0_tipo_encuesta"));
            if (sd.gOS("enc[0].n0_tipo_encuesta").equals("pres")) {
                presencial = "pres";
                q53LogEstadisticas.printDebug("He entrado tipo pres " + presencial);   
            }else if(sd.gOS("enc[0].n0_tipo_encuesta").equals("nopres")) {
                presencial = "nopres";
                q53LogEstadisticas.printDebug("He entrado tipo no pres " + presencial);   
            }
            
            encuesta.setTipo(presencial);
            q53LogEstadisticas.printLog("Es presencial? " + presencial);
            
            boolean visible = false;

            if (sd.gOS("enc[0].n0_visible").equals("S")) {
                visible = true;
            }

            encuesta.setEncuestaVisible(visible);
            encuesta.setEncuestaTexto(sd.gOS("enc[0].n0_texto"));
            q53LogEstadisticas.printLog("Es visible? " + visible);

            boolean versionAntigua = false;

            if (sd.gOS("enc[0].n0_version_antigua").equals("S")) {
                versionAntigua = true;
            }

            boolean isResponse = getRespuestaToEnc(sd, codEncuesta, codVersion);
            encuesta.setHayRespuesta(isResponse);

            encuesta.setVersionAntigua(versionAntigua);
            encuesta.setFechaCreacionEncuesta(sd.gOS("enc[0].n0_fecha_creacion"));
        }

        return encuesta;
    }

    /**
     * Mtodo que nos indica si la encuesta tien respuestas
     *
     * @param sd el objeto ProcletServiceData
     * @param codEncuesta String cosigo de la encuesta
     * @param codVersion String codigo de la version
     *
     * @return boolean true si la encuesta tiene respuestas y false en caso
     *         contrario
     *
     * @throws ProcletException
     */
    private boolean getRespuestaToEnc(ProcletServiceData sd,
        String codEncuesta, String codVersion) throws ProcletException {
		
        boolean isResponse = false;
        String rtdo_resp = "SELECT M0_COD_RESPUESTA" + " FROM RESPUESTA" +
            " WHERE M0_COD_ENCUESTA=" + codEncuesta + " AND M0_COD_VERSION=" +
            codVersion;
        PSP.sqlProclet(sd, "resp[]=" + rtdo_resp);

        if (sd.gI("resp.length") > 0) {
            isResponse = true;
        }

        return isResponse;
    }

    /**
     * Metodo que nos devuelve los datos de la encuesta de la oficina
     * diciendonos si es o no visible
     *
     * @param sd el objeto rocletServiceData
     *
     * @return q53EncuestaBean objeto que contiene todos los datos de al
     *         encuesta de la oficina
     *
     * @throws ProcletException
     */
    

    private String hayEncuestaPresVisible(ProcletServiceData sd)
    throws ProcletException {
    	HttpSession session = sd.req.getSession(true);
    	String oficina = (String)session.getAttribute("q53_cki.q53_oficina");
        String select_enc_ofi = "SELECT N0_VISIBLE"
                              + " FROM ENCUESTA"
                              + " WHERE N0_COD_OFICINA='" +oficina +"'"
                              + " AND N0_RECOGIDA_DATOS!='S' "
                              + " AND N0_VERSION_ANTIGUA='N' "
                              + " AND (N0_TIPO_ENCUESTA='pres' or N0_TIPO_ENCUESTA IS NULL) "
                              + " AND (N0_VISIBLE='S') "
                              + " ORDER BY n0_visible DESC";
    
        q53LogEstadisticas.printSql("select n0_visible" + select_enc_ofi);
        PSP.sqlProclet(sd, "enc_ofi_presencial[]=" + select_enc_ofi);
        if (sd.gOS("enc_ofi_presencial[0].n0_visible").equals("S")){
            q53LogEstadisticas.printLog("hayEncuestaPresVisible IF ENC_OFI ");
            return "S";
        }else{
            q53LogEstadisticas.printLog("hayEncuestaPresVisible ELSE ENC_OFI ");
            return "N";    
        }
    }
    private String hayEncuestaNoPresVisible(ProcletServiceData sd)
    throws ProcletException {
    	HttpSession session = sd.req.getSession(true);
    	String oficina = (String)session.getAttribute("q53_cki.q53_oficina");
        String select_enc_ofi = "SELECT N0_VISIBLE"
            + " FROM ENCUESTA"
            + " WHERE N0_COD_OFICINA='" +oficina +"'"
            + " AND N0_RECOGIDA_DATOS!='S' "
            + " AND N0_VERSION_ANTIGUA='N' "
            + " AND (N0_TIPO_ENCUESTA='nopres' or N0_TIPO_ENCUESTA IS NULL) "
            + " AND (N0_VISIBLE='S') "
            + " ORDER BY n0_visible DESC";
    
        q53LogEstadisticas.printLog("select n0_visible " + select_enc_ofi);
        PSP.sqlProclet(sd, "enc_ofi_no_presencial[]=" + select_enc_ofi);
       
        if (sd.gOS("enc_ofi_no_presencial[0].n0_visible").equals("S")){
            q53LogEstadisticas.printLog("hayEncuestaNoPresVisible IF ENC_OFI ");
            return "S";
        }else{
            q53LogEstadisticas.printLog("hayEncuestaNoPresVisible ELSE ENC_OFI ");
          return "N";     
        }
   }
    
    

    /**
     * Mtodoq eu nos devuelve los datos de las diferentes versions de la
     * encuesta
     *
     * @param sd El objeto ProcletServiceData
     * @param formato String formato de las fechas (depende del idioma)
     * @param codEncuesta String codiga de la encuesta
     * @param isVersionAntigua boolean que indica si la encuesta es version
     *        antigua o no
     *
     * @return Lista de las versiones de la encuesta
     *
     * @throws ProcletException
     */
    private List getOldVersionEncuesta(ProcletServiceData sd, String formato,
        String codEncuesta, boolean isVersionAntigua) throws ProcletException {
		
        List oldVersionEncuestaList = null;
        String versionAntigua = "S";

        if (isVersionAntigua) {
            versionAntigua = "N";
        }

        String select_ant =
            "SELECT N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_RECOGIDA_DATOS, " +
            "N0_VISIBLE, N0_TEXTO, N0_VERSION_ANTIGUA, " +
            "TO_CHAR(N0_FECHA_CREACION,'" + formato +
            "')N0_FECHA_CREACION FROM ENCUESTA " + "WHERE N0_COD_ENCUESTA=" +
            codEncuesta + " AND N0_VERSION_ANTIGUA='" + versionAntigua + "'";
        PSP.sqlProclet(sd, "ant[]=" + select_ant);

        if (sd.gI("ant.length") > 0) {
            oldVersionEncuestaList = new ArrayList();
        }

        int numOldVersion = sd.gI("ant.length");

        for (int i = 0; i < numOldVersion; i++) {
            q53EncuestaBean oldVersionEncuesta = new q53EncuestaBean();
            oldVersionEncuesta.setCodEncuesta(codEncuesta);
            oldVersionEncuesta.setCodVersion(sd.gOS("ant[" + i +
                    "].n0_cod_version"));
            oldVersionEncuesta.setDescripcionEncuesta(sd.gOS("ant[" + i +
                    "].n0_descripcion"));

            boolean recogidaDatos = false;

            if (sd.gOS("ant[" + i + "].n0_recogida_datos").equals("S")) {
                recogidaDatos = true;
            }

            oldVersionEncuesta.setRecogidaDatos(recogidaDatos);

            boolean encuestaVisible = false;

            if (sd.gOS("ant[" + i + "].n0_visible").equals("S")) {
                encuestaVisible = true;
            }

            oldVersionEncuesta.setEncuestaVisible(encuestaVisible);
            oldVersionEncuesta.setEncuestaTexto(sd.gOS("ant[" + i +
                    "].n0_texto"));

            boolean oldVersion = false;

            if (sd.gOS("ant[" + i + "].n0_version_antigua").equals("S")) {
                oldVersion = true;
            }

            oldVersionEncuesta.setVersionAntigua(oldVersion);
            oldVersionEncuesta.setFechaCreacionEncuesta(sd.gOS("ant[" + i +
                    "].n0_fecha_creacion"));

            oldVersionEncuestaList.add(oldVersionEncuesta);
        }

        return oldVersionEncuestaList;
    }
}
