package itourbaskServlet;

import itourbaskBeans.q53FechaBean;
import itourbaskBeans.q53OpcionBean;
import itourbaskBeans.q53OpcionesBean;
import itourbaskBeans.q53PreguntaBean;
import itourbaskBeans.q53TextoBean;

import java.util.ArrayList;
import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;
import util.q53LiteralesEncuestaGV;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53encVerPreguntaServlet extends q53Servlet {
    /**
     * DOCUMENT ME!
     *
     * @param sd DOCUMENT ME!
     *
     * @throws ProcletException DOCUMENT ME!
     */


    public void pspProcess(ProcletServiceData sd) throws ProcletException {

        // establece el contentType del response
        sd.res.setContentType("text/html");
        sd.res.setHeader("Pragma", "no-cache");
        sd.res.setHeader("Cache-Control", "no-cache");
        sd.res.setHeader("Expires", "0");

        // tratar las cookies
        q53_tratarCookies(sd);
        q53Util.pasar_a_sd(sd);
        
        String perfilUser = "NO";

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
            perfilUser = "SI";
        }

        String perfilCoord = "NO";

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            perfilCoord = "SI";
        }

        String perfilAdmin = "NO";

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
            perfilAdmin = "SI";
        }

        sd.setVal("perfilUser", perfilUser);
        sd.setVal("perfilCoord", perfilCoord);
        sd.setVal("perfilAdmin", perfilAdmin);
        PSP.paramProclet(sd, "accion()");

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            PSP.paramProclet(sd,
                "cod_encuesta(),cod_version(),genEncuesta(),accion(),recogida_datos()");

            if (sd.gOS("accion").equals(q53Constantes.ACCION_NUEVO)) {
                // creacin de la pregunta. no hay que hacer nada
            } else if (sd.gOS("accion").equals(q53Constantes.ACCION_MODIFICAR)) {
                // modificacin de la pregunta
                PSP.paramProclet(sd, "cod_pregunta()");

                String codPregunta = sd.gOS("cod_pregunta");
				

                q53PreguntaBean pregunta = getPreguntaData(sd, codPregunta);

                if (pregunta != null) {
					
                    String tipo_pregunta = pregunta.getTipoPregunta();

                    if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                        getPreguntaOpcionesData(sd, pregunta);
                    } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                        getPreguntaTextoData(sd, pregunta);
                    } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                        getPreguntaFechaData(sd, pregunta);
                    }

                    sd.setVal("pregunta", pregunta);
                }
            }

            sd.setVal("literalesCalendario",
                q53LiteralesEncuestaGV.getLiteralesCalendario(sd));

            if (sd.gOS("recogida_datos").equals("S")) {
                sd.setVal("pagina", q53Constantes.PAG_ENC_ACTIVADA);
            } else {
                sd.setVal("pagina", q53Constantes.PAG_OTRAS_ENC);
            }


            PSP.setTemplatePageProclet(sd, "/q53_enc_verPregunta.jsp");
        } // if perfil
        else {
            // el usuario no tiene el perfil necesario. seguramente es porque
            // se ha perdido la sesion y hay que redirigirlo al login, para que
            // vuelva a meter su usuario y contrasea
            sd.setVal("pagina", "q53_gen_login");
            q53_redirigir(sd,
                "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
        }
    }

    /**
     * Mtodo que nos devuelve los datos de la pregunta
     *
     * @param sd el objeto ProcletServiceData
     * @param codPregunta String codigo de la pregunta
     *
     * @return q53PreguntaBean que es el objeto con los datos de la pregunta
     *
     * @throws ProcletException
     */
    private q53PreguntaBean getPreguntaData(ProcletServiceData sd,
        String codPregunta) throws ProcletException {
		
        q53PreguntaBean pregunta = null;
        String select =
            "SELECT N1_COD_PREGUNTA, N1_DESCRIPCION, N1_TIPO_PREGUNTA,NZ_OBLIGATORIA,NZ_ORDEN" +
            " FROM PREGUNTA,ENCUESTA_PREGUNTA" + " WHERE N1_COD_PREGUNTA=" +
            codPregunta + " AND NZ_COD_PREGUNTA = N1_COD_PREGUNTA";

        PSP.sqlProclet(sd, "preg[]=" + select);
        q53LogEstadisticas.printSql("select: -" + select);

        if (sd.gI("preg.length") > 0) {
            pregunta = new q53PreguntaBean();
            pregunta.setCodPregunta(codPregunta);
            pregunta.setDescripcionPregunta(sd.gOS("preg[0].n1_descripcion"));
            pregunta.setTipoPregunta(sd.gOS("preg[0].n1_tipo_pregunta"));

            boolean obligatoria = false;

            if (sd.gOS("preg[0].nz_obligatoria").equals("S")) {
                obligatoria = true;
            }

            pregunta.setObligatoria(obligatoria);
            pregunta.setOrden(sd.gOS("preg[0].nz_orden"));
        }

        return pregunta;
    }

    /**
     * Mtodo que nos devuelve los datos de la pregunta de tipo opciones
     *
     * @param sd el objeto ProcletServiceData
     * @param pregunta el objeto q53PreguntaBean con los datos de la pregunta
     *
     * @throws ProcletException
     */
    private void getPreguntaOpcionesData(ProcletServiceData sd,
        q53PreguntaBean pregunta) throws ProcletException {
		
        String select_preg =
            "preg_pr[]=SELECT N2_COD_PREGUNTA, N2_FORMATO, N3_COD_OPCION, N3_DESCRIPCION, N2_CONSULTA" +
            " FROM PR_OPS_OPCION, PR_OPCIONES" + " WHERE N2_COD_PREGUNTA=" +
            pregunta.getCodPregunta() +
            " AND N2_COD_PREGUNTA=N3_COD_PREGUNTA(+) ORDER BY N3_ORDEN";
        PSP.sqlProclet(sd, select_preg);
        q53LogEstadisticas.printSql("select opciones: -" + select_preg);

        if (sd.gI("preg_pr.length") > 0) {
            q53OpcionesBean pregOpciones = new q53OpcionesBean();
            pregOpciones.setFormato(sd.gOS("preg_pr[0].n2_formato"));
            boolean consulta = false;

            if (sd.gI("preg_pr[0].n2_consulta")== 1) {
                q53LogEstadisticas.printLog("entro en consulta = 1: -" + sd.gI("preg_pr[0].n2_consulta"));
                consulta = true;
                q53LogEstadisticas.printLog("entro en consulta = 1: -" + consulta);
            }
            pregunta.setConsulta(consulta);
            
            int numOpciones = sd.gI("preg_pr.length");
            List opcionList = new ArrayList();

            for (int i = 0; i < numOpciones; i++) {
                q53OpcionBean opcion = new q53OpcionBean();
                opcion.setCodOpciones(sd.gOS("preg_pr[" + i +
                        "].n3_cod_opcion"));
                opcion.setDescipcionOpcion(sd.gOS("preg_pr[" + i +
                        "].n3_descripcion"));
                opcionList.add(opcion);
            }

            pregOpciones.setOpcionList(opcionList);
            pregunta.setPreguntaOpciones(pregOpciones);
        }
    }

    /**
     * Mtodo que nos devuelve los datos de la pregutna de tipo texto
     *
     * @param sd el objeto ProcletServiceData
     * @param pregunta el objeto q53PreguntaBean con los datos de la pregunta
     *
     * @throws ProcletException
     */
    private void getPreguntaTextoData(ProcletServiceData sd,
        q53PreguntaBean pregunta) throws ProcletException {
		
        String select_preg = "preg_pr[]=SELECT N4_TAMANO" + " FROM PR_TEXTO" +
            " WHERE N4_COD_PREGUNTA=" + pregunta.getCodPregunta();
        PSP.sqlProclet(sd, select_preg);

        q53TextoBean texto = new q53TextoBean();
        texto.setTamaoTexto(sd.gI("preg_pr[0].n4_tamano"));
        pregunta.setPreguntaTexto(texto);
    }

    /**
     * Mtodo que nos devuelve los dsatos de la pregunta de tipo fecha
     *
     * @param sd el objeto ProcletServiceData
     * @param pregunta q53PreguntaBean objeto con los datos de la pregunta
     *
     * @throws ProcletException
     */
    private void getPreguntaFechaData(ProcletServiceData sd,
        q53PreguntaBean pregunta) throws ProcletException {
		
        String select_preg =
            "preg_pr[]=SELECT TO_CHAR(N6_FECHA_MIN, 'DD/MM/YYYY') N6_FECHA_MIN, " +
            "TO_CHAR(N6_FECHA_MAX, 'DD/MM/YYYY') N6_FECHA_MAX" +
            " FROM PR_FECHA WHERE N6_COD_PREGUNTA=" +
            pregunta.getCodPregunta();
        PSP.sqlProclet(sd,select_preg);

        q53FechaBean fecha = new q53FechaBean();
        fecha.setFechaMax(sd.gOS("preg_pr[0].n6_fecha_max"));
        fecha.setFechaMin(sd.gOS("preg_pr[0].n6_fecha_min"));
        pregunta.setPreguntaFecha(fecha);
    }
}
