package itourbaskServlet;

import itourbaskBeans.q53EncuestaBean;
import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;

/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53encVerDatosGrlesServlet extends q53Servlet {
    /**
     * DOCUMENT ME!
     *
     * @param sd DOCUMENT ME!
     *
     * @throws ProcletException DOCUMENT ME!
     */

    public void pspProcess(ProcletServiceData sd) throws ProcletException {

        // establece el contentType del response
        sd.res.setContentType("text/html");
        sd.res.setHeader("Pragma", "no-cache");
        sd.res.setHeader("Cache-Control", "no-cache");
        sd.res.setHeader("Expires", "0");

        // tratar las cookies
        q53_tratarCookies(sd);
        q53Util.pasar_a_sd(sd);
        String perfilUser = "NO";

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
            perfilUser = "SI";
        }

        String perfilCoord = "NO";

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            perfilCoord = "SI";
        }

        String perfilAdmin = "NO";

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
            perfilAdmin = "SI";
        }

        sd.setVal("perfilUser", perfilUser);
        sd.setVal("perfilCoord", perfilCoord);
        sd.setVal("perfilAdmin", perfilAdmin);


        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            PSP.paramProclet(sd, "accion(), recogida_datos(),genEncuesta()");

            if (sd.gOS("accion").equals(q53Constantes.ACCION_NUEVO)) {
                sd.setVal("recogida_datos",sd.gOS("recogida_datos"));
            } else if (sd.gOS("accion").equals(q53Constantes.ACCION_MODIFICAR_ENC)) {
                // modificacin de la encuesta. hay que presentar una caja de
                // texto con el nombre de la encuesta, para poder cambiarlo.
                PSP.paramProclet(sd, "cod_encuesta(),cod_version(),genEncuesta()");
                String codEncuesta = sd.gOS("cod_encuesta");
                String codVersion = sd.gOS("cod_version");
                
               
                q53EncuestaBean encuesta = getEncuestaData(sd,codEncuesta, codVersion);
                if (sd.gOS("recogida_datos").equals("S")) {
                    encuesta.setRecogidaDatos(true);
                }else{
                    encuesta.setRecogidaDatos(false);
                }
                sd.setVal("encuesta",encuesta);
            }

            if (sd.gOS("recogida_datos").equals("S")) {
                sd.setVal("pagina", q53Constantes.PAG_ENC_ACTIVADA);
            } else {
                if (sd.gOS("accion").equals(q53Constantes.ACCION_NUEVO)) {
                    sd.setVal("pagina", q53Constantes.PAG_CREAR_ENC);
                } else {
                    sd.setVal("pagina", q53Constantes.PAG_OTRAS_ENC);
                }
            }


            PSP.setTemplatePageProclet(sd, "/q53_enc_verDatosGrles.jsp");
        } // if perfil
        else {
            // el usuario no tiene el perfil necesario. seguramente es porque
            // se ha perdido la sesion y hay que redirigirlo al login, para que
            // vuelva a meter su usuario y contrasea
            sd.setVal("pagina", "q53_gen_login");
            q53_redirigir(sd,
                "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
        }
    }

    /**
     * Mtodo que nos devuelve los datos de la encuesta
     *
     * @param sd el objeto ProcletServiceData
     * @param codEncuesta String codigo de la encuesta
     * @param codVersion String codigo version de la encuesta
     *
     * @return q53EncuestaBean objeto con los datos de la encuesta
     *
     * @throws ProcletException DOCUMENT ME!
     */
    private q53EncuestaBean getEncuestaData(ProcletServiceData sd,
        String codEncuesta, String codVersion) throws ProcletException {
		
        q53EncuestaBean encuesta = new q53EncuestaBean();
        String select_enc = "SELECT N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_TEXTO, N0_TIPO_ENCUESTA";
        select_enc += " FROM ENCUESTA";
        select_enc += (" WHERE N0_COD_ENCUESTA=" + codEncuesta +
        " AND N0_COD_VERSION=" + codVersion);

        q53LogEstadisticas.printLog("select_enc::::"+select_enc);
        PSP.sqlProclet(sd, "enc[]=" + select_enc);
        encuesta.setCodEncuesta(codEncuesta);
        encuesta.setCodVersion(codVersion);
        encuesta.setDescripcionEncuesta(sd.gOS("enc[0].n0_descripcion"));
        encuesta.setEncuestaTexto(sd.gOS("enc[0].n0_texto"));

        if (sd.gOS("enc[0].n0_tipo_encuesta").equals("")) {
            encuesta.setTipo("");
            q53LogEstadisticas.printLog("es presencial y no presencial");
        }
        else if (sd.gOS("enc[0].n0_tipo_encuesta").equals("pres")) {
          encuesta.setTipo("pres");
          q53LogEstadisticas.printLog("es presencial ");
        }else if(sd.gOS("enc[0].n0_tipo_encuesta").equals("nopres")) {
           encuesta.setTipo("nopres");
          q53LogEstadisticas.printLog("es no presencial ");
        }else{
            System.out.println("ninguno de los dos -"+sd.gOS("enc[0].n0_tipo_encuesta")+"-");
        }
        
 
        return encuesta;
    }
}
