package itourbaskServlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

import javax.servlet.http.Cookie;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


public class q53encModificarServlet extends q53Servlet {


    public void pspProcess(ProcletServiceData sd) throws ProcletException {

        // establece el contentType del response
        sd.res.setContentType("text/html");
        sd.res.setHeader("Pragma", "no-cache");
        sd.res.setHeader("Cache-Control", "no-cache");
        sd.res.setHeader("Expires", "0");

         // tratar las cookies
            q53_tratarCookies(sd);
            q53Util.pasar_a_sd(sd);
            String perfilUser = "NO";
            if(q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)){
                perfilUser = "SI";
            }
            String perfilCoord = "NO";
            if(q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)){
                perfilCoord = "SI";
            }
            String perfilAdmin = "NO";
            if(q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)){
                perfilAdmin = "SI";
            }
            sd.setVal("perfilUser",perfilUser);
            sd.setVal("perfilCoord",perfilCoord);
            sd.setVal("perfilAdmin",perfilAdmin);
            Cookie[] cookies=sd.req.getCookies();
            String oficinas_hijo="";
            for(int i=0;i<cookies.length;i++){
        		if(cookies[i].getName().equals("q53_oficinas_hijo")){
        			oficinas_hijo=cookies[i].getValue();			
        		}
        	}
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            PSP.paramProclet(sd, "accion(),genEncuesta(),recogida_datos()");
            q53LogEstadisticas.printLog("Accion:::: "+sd.gOS("accion"));
            if (sd.gOS("accion").equals(q53Constantes.ACCION_NUEVO)) {
                // creacin de la encuesta. insert del registro.
                PSP.paramProclet(sd, "descripcion(),texto(),tipo()");

                String select_cod_encuesta = "rtdo_cod_encuesta=SELECT SEQ_ENCUESTA.NEXTVAL COD_ENCUESTA FROM DUAL;";

                String insert =
                    "=INSERT INTO ENCUESTA (N0_COD_ENCUESTA,N0_COD_VERSION," +
                    " N0_VERSION_ANTIGUA,N0_DESCRIPCION,N0_TEXTO,N0_COD_OFICINA,N0_RECOGIDA_DATOS," +
                    " N0_VISIBLE,N0_COD_PERSONA,N0_FECHA_CREACION,N0_TIPO_ENCUESTA)" +
                    " VALUES (${rtdo_cod_encuesta.cod_encuesta},0," +
                    " 'N','${descripcion}','${texto}','${q53_cki.q53_oficina}','${recogida_datos}'," +
                    " 'N',${q53_cki.q53_usuario},SYSDATE,'${tipo}');";
                q53LogEstadisticas.printLog("select_cod_encuesta::::"+select_cod_encuesta);
                q53LogEstadisticas.printLog("OPCREAR:insert::::"+insert);
                PSP.sqlProclet(sd, select_cod_encuesta + insert);

                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53encListarPreguntasServlet?cod_encuesta=" +
                    sd.gOS("rtdo_cod_encuesta.cod_encuesta") +
                    "&cod_version=0&recogida_datos=" +
                    sd.gOS("recogida_datos") + "&accion=" + sd.gOS("accion") + "&genEncuesta=" + sd.gOS("genEncuesta"));
            } else if (sd.gOS("accion").equals(q53Constantes.ACCION_MODIFICAR_ENC)) {
                // modificacin de la encuesta. update del registro.
                PSP.paramProclet(sd,
                    "cod_encuesta(),cod_version(),descripcion(),texto(),tipo()");

                String select = "UPDATE ENCUESTA " +
                    " SET N0_DESCRIPCION='${descripcion}', N0_TEXTO='${texto}', N0_TIPO_ENCUESTA='${tipo}' " +
                    " WHERE N0_COD_ENCUESTA=${cod_encuesta} AND N0_COD_VERSION='${cod_version}';";
                //q53LogEstadisticas.printLog("select::::"+select);
                PSP.sqlProclet(sd, "=" + select);
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53encVerServlet?cod_encuesta=" +
                    sd.gOS("cod_encuesta") + "&cod_version=" +
                    sd.gOS("cod_version") + "&recogida_datos=" +
                    sd.gOS("recogida_datos") + "&genEncuesta=" + sd.gOS("genEncuesta"));
            } else if (sd.gOS("accion").equals(q53Constantes.ACCION_VISIBLE)) {
                // poner visible/invisible la encuesta, dependiendo del
                // parmetro value. Si es "S" poner "N"; Si no poner "S".
                q53LogEstadisticas.printDebug("q53encModificarServlet::ENTRA ACCION VISIBLE");
                PSP.paramProclet(sd, "cod_encuesta(),cod_version(),value()");
                
                String update = "UPDATE ENCUESTA " + " SET N0_VISIBLE='" +
                    (sd.gOS("value").equals("S") ? "N" : "S") + "'" +
                    " WHERE N0_COD_ENCUESTA=${cod_encuesta} AND N0_COD_VERSION=${cod_version};";
                q53LogEstadisticas.printLog("update::::"+update);
                PSP.sqlProclet(sd, "=" + update);
                
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53encVerServlet?cod_encuesta=" +
                    sd.gOS("cod_encuesta") + "&cod_version=" +
                    sd.gOS("cod_version") + "&recogida_datos=" +
                    sd.gOS("recogida_datos") +  "&genEncuesta=" + sd.gOS("genEncuesta"));
            } else if (sd.gOS("accion").equals(q53Constantes.ACCION_MODIFICAR_PREG)) {
                // crea una nueva versin de la encuesta para modificar la lista de preguntas
                //  .- coger cod_encuesta/cod_version y poner version_antigua a S
                //  .- crear encuesta nueva con los datos de la anterior con cod_version+1 y version_antigua a N
                //  .- duplicar las preguntas y asociarlas a la nueva encuesta
                //  .- redirigir a q53encListarPreguntas con cod_encusta/cod_version+1
                //
                // (nota: como lo hacemos con el SQLProclet, si falla una de las sentencias
                // se hace un rollback de todas; es decir, o se ejecutan todas bien o
                // no se ejectua ninguna)
                PSP.paramProclet(sd, "cod_encuesta(),cod_version()");

                //  .- coger cod_encuesta/cod_version y poner version_antigua a S
                String query = "=UPDATE ENCUESTA " +
                    " SET N0_VERSION_ANTIGUA='S', N0_VISIBLE='N'" +
                    " WHERE N0_COD_ENCUESTA=${cod_encuesta} AND N0_COD_VERSION=${cod_version};";

                //  .- crear encuesta nueva con los datos de la anterior con cod_version+1 y version_antigua a N
                query += ("=INSERT INTO ENCUESTA (N0_COD_ENCUESTA,N0_COD_VERSION," +
                " N0_VERSION_ANTIGUA,N0_DESCRIPCION,N0_TEXTO,N0_COD_OFICINA,N0_RECOGIDA_DATOS," +
                " N0_VISIBLE,N0_COD_PERSONA,N0_FECHA_CREACION,N0_TIPO_ENCUESTA)" +
                " (SELECT N0_COD_ENCUESTA,N0_COD_VERSION+1," +
                " 'N',N0_DESCRIPCION,N0_TEXTO,N0_COD_OFICINA,N0_RECOGIDA_DATOS," +
                " N0_VISIBLE,N0_COD_PERSONA,SYSDATE,N0_TIPO_ENCUESTA FROM ENCUESTA" +
                " WHERE N0_COD_ENCUESTA=${cod_encuesta} AND N0_COD_VERSION=${cod_version});");

                //  .- duplicar las preguntas y asociarlas a la nueva encuesta
                String select =
                    "rtdo_preg[]=SELECT SEQ_PREGUNTA.NEXTVAL COD_PREGUNTA_NUEVA," +
                    " N1_COD_PREGUNTA, N1_DESCRIPCION, N1_TIPO_PREGUNTA " +
                    " FROM PREGUNTA" + " WHERE N1_COD_PREGUNTA IN " +
                    "  (SELECT NZ_COD_PREGUNTA FROM ENCUESTA_PREGUNTA" +
                    "  WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version});";
                //q53LogEstadisticas.printLog("select ::::"+select);
                PSP.sqlProclet(sd, select);

                for (int i = 0; i < sd.gI("rtdo_preg.length"); i++) {
                    // por cada pregunta, aadir una query de:
                    //  INSERT PREGUNTA, PR_[tipo] y ENCUESTA_PREGUNTA
                    query += ("=INSERT INTO PREGUNTA (N1_COD_PREGUNTA,N1_DESCRIPCION,N1_TIPO_PREGUNTA)" +
                    " VALUES (${rtdo_preg[" + i +
                    "].cod_pregunta_nueva},'${rtdo_preg[" + i +
                    "].n1_descripcion}',${rtdo_preg[" + i +
                    "].n1_tipo_pregunta});");

                    String tipo_pregunta = sd.gOS("rtdo_preg[" + i +
                            "].n1_tipo_pregunta");

                    if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                        query += ("=INSERT INTO PR_OPCIONES (N2_COD_PREGUNTA,N2_FORMATO, N2_CONSULTA)" +
                        "(SELECT ${rtdo_preg[" + i +
                        "].cod_pregunta_nueva},N2_FORMATO, N2_CONSULTA FROM PR_OPCIONES" +
                        " WHERE N2_COD_PREGUNTA=${rtdo_preg[" + i +
                        "].n1_cod_pregunta});");

                        query += ("=INSERT INTO PR_OPS_OPCION (N3_COD_PREGUNTA,N3_COD_OPCION,N3_ORDEN,N3_DESCRIPCION)" +
                        "(SELECT ${rtdo_preg[" + i +
                        "].cod_pregunta_nueva},N3_COD_OPCION,N3_ORDEN,N3_DESCRIPCION FROM PR_OPS_OPCION" +
                        " WHERE N3_COD_PREGUNTA=${rtdo_preg[" + i +
                        "].n1_cod_pregunta});");
                    } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                        query += ("=INSERT INTO PR_TEXTO (N4_COD_PREGUNTA,N4_TAMANO)" +
                        "(SELECT ${rtdo_preg[" + i +
                        "].cod_pregunta_nueva},N4_TAMANO FROM PR_TEXTO" +
                        " WHERE N4_COD_PREGUNTA=${rtdo_preg[" + i +
                        "].n1_cod_pregunta});");
                    } else if (tipo_pregunta.equals(q53Constantes.TIPO_PROCEDENCIA)) {
                        // no hace falta hacer nada.
                    } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                        query += ("=INSERT INTO PR_FECHA (N6_COD_PREGUNTA,N6_FECHA_MIN,N6_FECHA_MAX)" +
                        "(SELECT ${rtdo_preg[" + i +
                        "].cod_pregunta_nueva},N6_FECHA_MIN,N6_FECHA_MAX FROM PR_FECHA" +
                        " WHERE N6_COD_PREGUNTA=${rtdo_preg[" + i +
                        "].n1_cod_pregunta});");
                    }

                    query += ("=INSERT INTO ENCUESTA_PREGUNTA (NZ_COD_ENCUESTA,NZ_COD_VERSION,NZ_COD_PREGUNTA,NZ_ORDEN,NZ_OBLIGATORIA)" +
                    " (SELECT NZ_COD_ENCUESTA,NZ_COD_VERSION+1,${rtdo_preg[" +
                    i + "].cod_pregunta_nueva},NZ_ORDEN,NZ_OBLIGATORIA" +
                    " FROM ENCUESTA_PREGUNTA WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_COD_PREGUNTA=${rtdo_preg[" +
                    i + "].n1_cod_pregunta});");
                }
                //q53LogEstadisticas.printLog("query ::::"+query);
                PSP.sqlProclet(sd, query);

                //  .- redirigir a q53encListarPreguntas con cod_encusta/cod_version+1 (hay que coger el cod_version como integer!)
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53encListarPreguntasServlet?cod_encuesta=" +
                    sd.gOS("cod_encuesta") + "&cod_version=" +
                    (sd.gI("cod_version") + 1) + "&recogida_datos=" +
                    sd.gOS("recogida_datos") +"&genEncuesta=" + sd.gOS("genEncuesta"));
            } else if (sd.gOS("accion").equals("modificar_preguntas")) {
            	q53LogEstadisticas.printLog("modificar_preguntas");
                PSP.paramProclet(sd, "cod_encuesta(),cod_version()");
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53encListarPreguntasServlet?cod_encuesta=" +
                    sd.gOS("cod_encuesta") + "&cod_version=" +
                    sd.gOS("cod_version") + "&recogida_datos=" +
                    sd.gOS("recogida_datos") + "&genEncuesta=" + sd.gOS("genEncuesta"));
            } else if (sd.gOS("accion").equals("borrar_encuesta")) {
                PSP.paramProclet(sd, "cod_encuesta()");
                q53LogEstadisticas.printLog("cod_encuesta::::"+sd.gOS("cod_encuesta"));
                String pregunta =
                    "resultado_cod_pregunta[]=SELECT NZ_COD_PREGUNTA FROM ENCUESTA_PREGUNTA" +
                    " WHERE NZ_COD_ENCUESTA=${cod_encuesta};";
                q53LogEstadisticas.printLog("seleccionar pregunta()::::"+pregunta);
                PSP.sqlProclet(sd, pregunta);

                String delete = "";
                q53LogEstadisticas.printLog("resultado_cod_pregunta.length::::"+sd.gI("resultado_cod_pregunta.length"));
                for (int i = 0; i < sd.gI("resultado_cod_pregunta.length");
                        i++) {
                    String delete_tipo = "";
                    String delete_resp = "";

                    delete_resp += ("=DELETE RESP_FECHA WHERE M6_COD_RESPUESTA in (SELECT M1_COD_RESPUESTA FROM RESPUESTA_PREGUNTA" +
                    " WHERE M1_COD_PREGUNTA=${resultado_cod_pregunta[" + i +
                    "].nz_cod_pregunta});");

                    delete_resp += ("=DELETE RESP_OPCIONES WHERE M2_COD_RESPUESTA in (SELECT M1_COD_RESPUESTA FROM RESPUESTA_PREGUNTA" +
                    " WHERE M1_COD_PREGUNTA=${resultado_cod_pregunta[" + i +
                    "].nz_cod_pregunta});");

                    delete_resp += ("=DELETE RESP_PROCEDENCIA WHERE M5_COD_RESPUESTA in (SELECT M1_COD_RESPUESTA FROM RESPUESTA_PREGUNTA" +
                    " WHERE M1_COD_PREGUNTA=${resultado_cod_pregunta[" + i +
                    "].nz_cod_pregunta});");

                    delete_resp += ("=DELETE RESP_TEXTO WHERE M4_COD_RESPUESTA in (SELECT M1_COD_RESPUESTA FROM RESPUESTA_PREGUNTA" +
                    " WHERE M1_COD_PREGUNTA=${resultado_cod_pregunta[" + i +
                    "].nz_cod_pregunta});");

                    delete_resp += ("=DELETE RESPUESTA_PREGUNTA WHERE  M1_COD_RESPUESTA in (SELECT M1_COD_RESPUESTA FROM RESPUESTA_PREGUNTA" +
                    " WHERE M1_COD_PREGUNTA=${resultado_cod_pregunta[" + i +
                    "].nz_cod_pregunta});");

                    delete_tipo += ("=DELETE PR_FECHA WHERE N6_COD_PREGUNTA=${resultado_cod_pregunta[" +
                    i + "].nz_cod_pregunta};");

                    delete_tipo += ("=DELETE PR_OPS_OPCION WHERE N3_COD_PREGUNTA=${resultado_cod_pregunta[" +
                    i + "].nz_cod_pregunta};");

                    delete_tipo += ("=DELETE PR_OPCIONES WHERE N2_COD_PREGUNTA=${resultado_cod_pregunta[" +
                    i + "].nz_cod_pregunta};");

                    delete_tipo += ("=DELETE PR_TEXTO WHERE N4_COD_PREGUNTA=${resultado_cod_pregunta[" +
                    i + "].nz_cod_pregunta};");

                    delete_tipo += ("=DELETE ENCUESTA_PREGUNTA WHERE NZ_COD_PREGUNTA=${resultado_cod_pregunta[" +
                    i + "].nz_cod_pregunta};");

                    delete_tipo += ("=DELETE PREGUNTA WHERE N1_COD_PREGUNTA=${resultado_cod_pregunta[" +
                    i + "].nz_cod_pregunta};");

                    q53LogEstadisticas.printLog("delete_resp::::"+delete_resp);
                    q53LogEstadisticas.printLog("delete_tipo::::"+delete_tipo);
                    PSP.sqlProclet(sd, delete_resp + delete_tipo);
                }

                String delete_respuesta = "=DELETE RESPUESTA WHERE M0_COD_ENCUESTA=${cod_encuesta};";

                String delete_encuesta = "=DELETE ENCUESTA WHERE N0_COD_ENCUESTA=${cod_encuesta};";

                q53LogEstadisticas.printLog("delete_respuesta::::"+delete_respuesta);
                q53LogEstadisticas.printLog("delete_encuesta::::"+delete_encuesta);
                PSP.sqlProclet(sd, delete_respuesta + delete_encuesta);
				

                q53_redirigir(sd, "/q53ItourbaskWar/q53encListarServlet");
            } else if (sd.gOS("accion").equals("propagar")) {
            	// Propagar la encuesta a las oficinas hijas.
                q53LogEstadisticas.printDebug("q53encModificarServlet::ENTRA ACCION PROPAGAR");
                PSP.paramProclet(sd, "cod_encuesta(),cod_version(),value()");

                copiarEncuestaAhijos(sd,sd.gOS("cod_encuesta"),sd.gOS("cod_version"),oficinas_hijo);
                
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53encVerServlet?cod_encuesta=" +
                    sd.gOS("cod_encuesta") + "&cod_version=" +
                    sd.gOS("cod_version") + "&recogida_datos=" +
                    sd.gOS("recogida_datos") +  "&genEncuesta=" + sd.gOS("genEncuesta"));
            }
        } // if perfil
        else {
            // el usuario no tiene el perfil necesario. seguramente es porque
            // se ha perdido la sesion y hay que redirigirlo al login, para que
            // vuelva a meter su usuario y contrasea
            sd.setVal("pagina", "q53_gen_login");
            q53_redirigir(sd,
                "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
        }
    }
    
    /**
     * Mtodo que copia la encuesta padre a todas las oficinas hijo
     *
     * @param sd el objeto ProcletServiceData
     * @param codEncuesta String codigo de la encuesta de la oficina padre
     * @param codVersion String codigo version de la encuesta de la oficina padre
     * @param oficinas_hijo String String que contiene los nombres y codigos de las oficinas hijo separadas por "." y "/"
     *
     *
     * @throws ProcletException DOCUMENT ME!
     */
    private void copiarEncuestaAhijos(ProcletServiceData sd,
        String codEncuesta, String codVersion,String oficinas_hijo) throws ProcletException {	
    	q53LogEstadisticas.printLog("Ha entrado en copiarEncuestaAhijos");
    	//Parte en la que cogemos los datos de las oficinas hijo
	    	String[] codigos_oficinas={"nada"};
	        StringTokenizer tokens=new StringTokenizer(oficinas_hijo, "*");
			int nDatos=tokens.countTokens();
	        codigos_oficinas=new String[nDatos-1];
	        int j=0;
	        while(tokens.hasMoreTokens()){
	            String str=tokens.nextToken();     
	            if(!str.split("#")[0].equals(sd.gOS("q53_cki.q53_oficina"))){
		            codigos_oficinas[j]=str.split("#")[0];
		            j++;
	            }
	    	}
	        q53LogEstadisticas.printLog("Ha cogido "+codigos_oficinas.length+" oficinas hijo = "+codigos_oficinas.toString());
        //FIN Parte en la que cogemos los datos de las oficinas hijo
        //Parte en la que cogemos los datos de la encuesta que se quiere copiar a las hijas
	        String n0_descripcion,n0_texto,n0_tipo_encuesta,fecha_min,fecha_max;
	        int num_preguntas = 0;
	        String select_enc = "SELECT N0_DESCRIPCION, N0_TEXTO, N0_TIPO_ENCUESTA";
	        select_enc += " FROM ENCUESTA";
	        select_enc += (" WHERE N0_COD_ENCUESTA=" + codEncuesta +
	        " AND N0_COD_VERSION=" + codVersion);
	        PSP.sqlProclet(sd, "enc[]=" + select_enc); 
	        n0_descripcion=sd.gOS("enc[0].n0_descripcion");
	        n0_texto=sd.gOS("enc[0].n0_texto");
	        n0_tipo_encuesta=sd.gOS("enc[0].n0_tipo_encuesta");
	        //obtenemos el numero de preguntas y las variables para almacenarlas 
	        ArrayList preguntasList=new ArrayList();
	        ArrayList opcionesList=new ArrayList();
	        HashMap pregunta=new HashMap();
	        HashMap opcion=new HashMap();;
	        String cod_pregunta,tipo;
	        select_enc="select nz_cod_pregunta, nz_orden, nz_obligatoria from encuesta_pregunta where nz_cod_encuesta="+codEncuesta+" and nz_cod_version="+codVersion+"";
	        PSP.sqlProclet(sd, "enc[]=" + select_enc); 
	        num_preguntas=sd.gI("enc.length");
	        for (int i = 0; i < num_preguntas; i++) {
	        	//recojo el valor de tipo, descripcion, obligatoria, orden y dependiendo del tipo otros valores	        	
	        	pregunta=new HashMap();
	        	pregunta.put("orden",sd.gOS("enc["+i+"].nz_orden"));
	        	pregunta.put("obligatoria",sd.gOS("enc["+i+"].nz_obligatoria"));
	        	cod_pregunta=sd.gOS("enc["+i+"].nz_cod_pregunta");
	        	select_enc="select n1_tipo_pregunta, n1_descripcion from pregunta where n1_cod_pregunta="+cod_pregunta;
	        	//q53LogEstadisticas.printLog("select de cada pregunta ->"+select_enc);
	        	PSP.sqlProclet(sd, "pregunta[]=" + select_enc);
	        	tipo=sd.gOS("pregunta[0].n1_tipo_pregunta");
	        	pregunta.put("tipo", tipo);
	        	pregunta.put("descripcion",sd.gOS("pregunta[0].n1_descripcion"));	 
	        	if(tipo.equals("1")){
		        //si es de tipo texto
	        		select_enc="select n4_tamano from pr_texto where n4_cod_pregunta="+cod_pregunta;
	        		//q53LogEstadisticas.printLog("select de la pregunta tipo texto ->"+select_enc);
	        		PSP.sqlProclet(sd, "tipo[]=" + select_enc);
	        		pregunta.put("tamano",sd.gOS("tipo[0].n4_tamano"));
	        	}else if(tipo.equals("3")){
	        	//si es de tipo fecha	
	        		select_enc="select n6_fecha_min,n6_fecha_max from pr_fecha where n6_cod_pregunta="+cod_pregunta;
	        		//q53LogEstadisticas.printLog("select de la pregunta fecha ->"+select_enc);
	        		PSP.sqlProclet(sd, "tipo[]=" + select_enc);
	        		fecha_min=sd.gOS("tipo[0].n6_fecha_min").split(" ")[0];
	        		fecha_max=sd.gOS("tipo[0].n6_fecha_max").split(" ")[0];
	        		pregunta.put("fecha_min",fecha_min.split("-")[2]+"/"+fecha_min.split("-")[1]+"/"+fecha_min.split("-")[0]);
	        		pregunta.put("fecha_max",fecha_max.split("-")[2]+"/"+fecha_max.split("-")[1]+"/"+fecha_max.split("-")[0]);
	        	}else if(tipo.equals("0")){
	        	//si es de tipo opciones
	        		select_enc="select n3_cod_opcion, n3_orden, n3_descripcion from pr_ops_opcion where n3_cod_pregunta="+cod_pregunta;
	        		//q53LogEstadisticas.printLog("select1 de la pregunta opciones ->"+select_enc);
	        		PSP.sqlProclet(sd, "tipo[]=" + select_enc);
	        		select_enc="select n2_consulta, n2_formato from pr_opciones where n2_cod_pregunta="+cod_pregunta;
	        		//q53LogEstadisticas.printLog("select2 de la pregunta opciones ->"+select_enc);
	        		PSP.sqlProclet(sd, "consulta[]=" + select_enc);
	        		for (int l = 0; l < sd.gI("tipo.length"); l++) {
	        			opcion=new HashMap();
	        			opcion.put("cod_opcion", sd.gOS("tipo["+l+"].n3_cod_opcion"));
	        			opcion.put("orden", sd.gOS("tipo["+l+"].n3_orden"));
	        			opcion.put("descripcion", sd.gOS("tipo["+l+"].n3_descripcion"));        			
	        			opcionesList.add(opcion);
	        		}
	        		pregunta.put("consulta", sd.gOS("consulta[0].n2_consulta"));
	        		pregunta.put("formato", sd.gOS("consulta[0].n2_formato"));
	        		pregunta.put("opciones",opcionesList);
	        	}
	        	preguntasList.add(pregunta);
	        	opcionesList=new ArrayList();
	            //q53LogEstadisticas.printLog("preguntasList "+preguntasList.toString());
	        }
        //FIN Parte en la que cogemos los datos de la encuesta que se quiere copiar a las hijas
        //Parte en la que insertamos para cada oficina hijo los datos de la encuesta padre y ponemos a no visible las encuestas hijo
	        for(int k=0;k<codigos_oficinas.length;k++){
	        	q53LogEstadisticas.printLog("codigos_oficinas hijo "+codigos_oficinas[k]);
	        	poner_no_visible(sd,codigos_oficinas[k],codEncuesta);
	        	insertar_preguntas(sd,codigos_oficinas[k],preguntasList,n0_descripcion,n0_texto,n0_tipo_encuesta);	
	        }
	    //FIN Parte en la que insertamos para cada oficina hijo los datos de la encuesta padre	        
    }
    /**
     * Mtodo que realiza las inserts de una encuesta para una oficina hijo
     *
     * @param sd el objeto ProcletServiceData
     * @param oficina_hijo String codigo de la oficina hijo
     * @param preguntasList ArrayList contiene la informacion de todas las preguntas
     * @param n0_descripcion,n0_texto,n0_tipo_encuesta String informacion a cerca de la encuesta que se quiere copiar
     *
     *
     * @throws ProcletException DOCUMENT ME!
     */
    private void insertar_preguntas(ProcletServiceData sd,String oficina_hijo, 
    	ArrayList preguntasList,String n0_descripcion,String n0_texto,String n0_tipo_encuesta) throws ProcletException {
    		//Generamos un codigo nuevo para la pregunta
	    		String query_string,cod_encuesta,cod_pregunta,tipo;
	    		query_string="SELECT SEQ_ENCUESTA.NEXTVAL COD_ENCUESTA FROM DUAL";
		    	PSP.sqlProclet(sd, "codigo[]=" + query_string);	    	
		    	cod_encuesta=sd.gOS("codigo[0].cod_encuesta");
	    	//FIN Generamos un codigo nuevo para la pregunta
		    //Insertamos los valores principales de la pregunta y despues los datos concretos para cada tipo de pregunta
		    	query_string="INSERT INTO ENCUESTA (N0_COD_ENCUESTA,N0_COD_VERSION, N0_VERSION_ANTIGUA,N0_DESCRIPCION,N0_TEXTO,N0_COD_OFICINA,N0_RECOGIDA_DATOS,"+ 
		    	"N0_VISIBLE,N0_COD_PERSONA,N0_FECHA_CREACION,N0_TIPO_ENCUESTA)"+
		    	"VALUES ('"+cod_encuesta+"','0', 'N','"+n0_descripcion+"','"+n0_texto+"','"+oficina_hijo+"','N','S','"+sd.gOS("q53_cki.q53_usuario")+"',SYSDATE,'"+n0_tipo_encuesta+"')";
		    	PSP.sqlProclet(sd, "=" + query_string);
		    	q53LogEstadisticas.printLog("insert encuesta "+query_string);	    	
		    	Iterator preguntas = preguntasList.iterator();
		    	//q53LogEstadisticas.printLog("preguntas "+preguntasList.toString());
		    	Iterator opciones;
		    	ArrayList opcionesList;
		        HashMap pre,op;
		    	while(preguntas.hasNext()){
		    		pre = new HashMap();
		    		pre=(HashMap)preguntas.next();
			        //q53LogEstadisticas.printLog("pregunta "+pre.toString());
			        query_string="SELECT SEQ_PREGUNTA.NEXTVAL COD_PREGUNTA FROM DUAL";
			        PSP.sqlProclet(sd, "codigo[]=" + query_string);
			        cod_pregunta=sd.gOS("codigo[0].cod_pregunta");
			        query_string="INSERT INTO PREGUNTA (N1_COD_PREGUNTA,N1_DESCRIPCION,N1_TIPO_PREGUNTA) " +
		    	 		"VALUES ('"+cod_pregunta+"','"+(String)pre.get("descripcion")+"','"+(String)pre.get("tipo")+"');" +
		    	 		"=INSERT INTO ENCUESTA_PREGUNTA (NZ_COD_ENCUESTA,NZ_COD_VERSION,NZ_COD_PREGUNTA,NZ_ORDEN,NZ_OBLIGATORIA) " +
		    	 		"VALUES ('"+cod_encuesta+"','0','"+cod_pregunta+"','"+(String)pre.get("orden")+"','"+(String)pre.get("obligatoria")+"')";
			        //q53LogEstadisticas.printLog("insert pregunta "+query_string);
			        PSP.sqlProclet(sd, "=" + query_string);
			        tipo=(String)pre.get("tipo"); 
		            if(tipo.equals("3")){
		            	 query_string="INSERT INTO PR_FECHA (N6_COD_PREGUNTA,N6_FECHA_MIN,N6_FECHA_MAX) VALUES ('"+cod_pregunta+"',TO_DATE('"+(String)pre.get("fecha_min")+"','DD/MM/YYYY'),TO_DATE('"+(String)pre.get("fecha_max")+"','DD/MM/YYYY'))";
		            	 //q53LogEstadisticas.printLog("insert pregunta fecha "+query_string);
		            	 PSP.sqlProclet(sd, "=" + query_string);
		            }else if(tipo.equals("1")){
		            	 query_string="INSERT INTO PR_TEXTO (N4_COD_PREGUNTA,N4_TAMANO) VALUES ('"+cod_pregunta+"','"+(String)pre.get("tamano")+"')";
		            	 //q53LogEstadisticas.printLog("insert pregunta texto "+query_string);
		            	 PSP.sqlProclet(sd, "=" + query_string);
		            }else if(tipo.equals("0")){
		            	 q53LogEstadisticas.printDebug("FORMATO DE PREGUNTA TIPO OPCION ="+(String)pre.get("formato"));
		            	 query_string="INSERT INTO PR_OPCIONES (N2_COD_PREGUNTA,N2_FORMATO,N2_CONSULTA) " +
		            	 		"VALUES ('"+cod_pregunta+"','"+(String)pre.get("formato")+"','"+(String)pre.get("consulta")+"');";
		            	 opcionesList=(ArrayList)pre.get("opciones");
		            	 opciones=opcionesList.iterator();
		            	 //q53LogEstadisticas.printLog("opcionesList "+opcionesList.toString());
		            	 while(opciones.hasNext()){
		            		 op=new HashMap();
		            		 op=(HashMap)opciones.next();
		            		 //q53LogEstadisticas.printLog("opciont "+op.toString());
		            		 query_string+="=INSERT INTO PR_OPS_OPCION (N3_COD_PREGUNTA,N3_COD_OPCION,N3_ORDEN,N3_DESCRIPCION) " +
		            	 		"VALUES ('"+cod_pregunta+"','"+(String)op.get("cod_opcion")+"','"+(String)op.get("orden")+"','"+(String)op.get("descripcion")+"');";
		            	 }
		            	 //q53LogEstadisticas.printLog("insert pregunta opciones "+query_string);
		            	 PSP.sqlProclet(sd, "=" + query_string);
		            }	        	
		        }
	    	//FIN Insertamos los valores principales de la pregunta y despues los datos concretos para cada tipo de pregunta
    }
    
    /**
     * Mtodo que pone a no visible las encuestas de la oficina hijo
     *
     * @param sd el objeto ProcletServiceData
     * @param oficina_hijo String codigo de la oficina hijo
     *
     * @throws ProcletException DOCUMENT ME!
     */
    private void poner_no_visible(ProcletServiceData sd,String oficina_hijo,String codEncuesta) throws ProcletException {
       	String query_string="select n0_tipo_encuesta from encuesta where n0_cod_encuesta="+codEncuesta;
       	q53LogEstadisticas.printLog("query_string1 ->"+query_string);
    	PSP.sqlProclet(sd, "tipoenc[]=" + query_string);
    	String tipo_padre=sd.gOS("tipoenc[0].n0_tipo_encuesta");
    	String tipo_padre_contrario="nada";
    	String update;
    	if(tipo_padre.equals("pres"))
    		tipo_padre_contrario="nopres";
    	else if(tipo_padre.equals("nopres"))
    		tipo_padre_contrario="pres";
    	if(tipo_padre.equals("pres")||tipo_padre.equals("nopres")){
    		query_string="select count(*)numero_filas from encuesta where n0_visible='S' and n0_cod_oficina='"+oficina_hijo+"'";
    		q53LogEstadisticas.printLog("query_string2 ->"+query_string);
    		PSP.sqlProclet(sd,"resul[]="+query_string);
    		int num_filas=sd.gI("resul[0].numero_filas");
    		query_string="select n0_cod_encuesta, NVL(n0_tipo_encuesta,'presynopres') n0_tipo_encuesta from encuesta where n0_visible='S' and n0_cod_oficina='"+oficina_hijo+"'";
    		q53LogEstadisticas.printLog("query_string3 ->"+query_string);
    		PSP.sqlProclet(sd,"result[]="+query_string);
    		String tipo_hijo;
    		for(int i=0;i<num_filas;i++){
    			tipo_hijo=sd.gOS("result["+i+"].n0_tipo_encuesta");
    			q53LogEstadisticas.printLog("tipo_hijo ->"+tipo_hijo+"<-");
    			if(tipo_hijo.equals("presynopres")){
    				update="=update encuesta set n0_tipo_encuesta='"+tipo_padre_contrario+"' where n0_cod_encuesta='"+sd.gOS("result["+i+"].n0_cod_encuesta")+"'";
    				q53LogEstadisticas.printLog("cambias el tipo ->"+update);
    	    		PSP.sqlProclet(sd,update); 
    			}else if(tipo_hijo.equals(tipo_padre)){
    				update="=update encuesta set n0_visible='N' where n0_cod_encuesta='"+sd.gOS("result["+i+"].n0_cod_encuesta")+"'";
    				q53LogEstadisticas.printLog("pones a no visible ->"+update);
    	    		PSP.sqlProclet(sd,update); 
    			}   				
    		}   			
    	}else{
    		update="=update encuesta set n0_visible='N' where n0_cod_oficina='"+oficina_hijo+"'";
    		q53LogEstadisticas.printLog("pones a no visible todas ->"+update);
    		PSP.sqlProclet(sd,update); 
    	}
    }
}
























