package itourbaskServlet;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


public class q53encModificarPreguntaServlet extends q53Servlet {

    public void pspProcess(ProcletServiceData sd) throws ProcletException {

        // establece el contentType del response
        sd.res.setContentType("text/html");
        sd.res.setHeader("Pragma", "no-cache");
        sd.res.setHeader("Cache-Control", "no-cache");
        sd.res.setHeader("Expires", "0");

        // tratar las cookies
            q53_tratarCookies(sd);
            q53Util.pasar_a_sd(sd);
            
            String perfilUser = "NO";
            if(q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)){
                perfilUser = "SI";
            }
            String perfilCoord = "NO";
            if(q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)){
                perfilCoord = "SI";
            }
            String perfilAdmin = "NO";
            if(q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)){
                perfilAdmin = "SI";
            } 
            sd.setVal("perfilUser",perfilUser);
            sd.setVal("perfilCoord",perfilCoord);
            sd.setVal("perfilAdmin",perfilAdmin);

        // obtener los datos del usuario de las cookies, y guardarlos en el sd
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            PSP.paramProclet(sd,
                "cod_encuesta(),genEncuesta(), cod_version(),accion(),recogida_datos()"); 
            
            q53LogEstadisticas.printLog("cod_encuesta()::::"+sd.gOS("cod_encuesta"));
            q53LogEstadisticas.printLog("cod_version()::::"+sd.gOS("cod_version"));

            if (sd.gOS("accion").equals(q53Constantes.ACCION_NUEVO)) {
                // aadir pregunta
                PSP.paramProclet(sd,
                    "descripcion(),obligatoria(S),tipo_pregunta()");
                
                q53LogEstadisticas.printLog("tipo_pregunta()::::"+sd.gOS("tipo_pregunta"));
                q53LogEstadisticas.printLog("descripcion()::::"+sd.gOS("descripcion"));
                q53LogEstadisticas.printLog("obligatoria()::::"+sd.gOS("obligatoria"));

                String select = "rtdo_cod_pregunta=SELECT SEQ_PREGUNTA.NEXTVAL COD_PREGUNTA FROM DUAL;";
                select += ("rtdo_encuesta=SELECT NVL(MAX(NZ_ORDEN+1), 1) NZ_ORDEN" +
                " FROM ENCUESTA_PREGUNTA, ENCUESTA" +
                " WHERE N0_COD_ENCUESTA=${cod_encuesta} AND N0_COD_VERSION=${cod_version}" +
                " AND N0_COD_ENCUESTA=NZ_COD_ENCUESTA(+) AND N0_COD_VERSION=NZ_COD_VERSION(+);");

                String insert =
                    "=INSERT INTO PREGUNTA (N1_COD_PREGUNTA,N1_DESCRIPCION,N1_TIPO_PREGUNTA)" +
                    " VALUES (${rtdo_cod_pregunta.cod_pregunta},'${descripcion}','${tipo_pregunta}');";
                insert += ("=INSERT INTO ENCUESTA_PREGUNTA (NZ_COD_ENCUESTA,NZ_COD_VERSION,NZ_COD_PREGUNTA,NZ_ORDEN,NZ_OBLIGATORIA)" +
                " VALUES (${cod_encuesta},${cod_version},${rtdo_cod_pregunta.cod_pregunta},${rtdo_encuesta.nz_orden},'${obligatoria}');");

                String insert_tipo = "";

                if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_OPCIONES)) {
                    PSP.paramProclet(sd, "formato(),opciones[u], consulta()");

                    insert_tipo += ("=INSERT INTO PR_OPCIONES (N2_COD_PREGUNTA,N2_FORMATO,N2_CONSULTA)" +
                    " VALUES (${rtdo_cod_pregunta.cod_pregunta},${formato},${consulta});");

                    String opcion = "";
                    int tmp = -1;

                    for (int i = 0; i < sd.gI("opciones.length"); i++) {
                        // opcion vendr como [value]#[texto]
                        opcion = sd.gOS("opciones[" + i + "]");
                        tmp = opcion.indexOf("#");

                        // pongo en sd el opc_value[i] y el opc_texto[i] para
                        // que, en el caso de que haya comillas simples o
                        // caracteres especiales, sea el sqlProclet el que los
                        // trate
                        sd.setVal("opc_value[" + i + "]",
                            opcion.substring(0, tmp));
                        sd.setVal("opc_texto[" + i + "]",
                            opcion.substring(tmp + 1));
                        insert_tipo += ("=INSERT INTO PR_OPS_OPCION (N3_COD_PREGUNTA,N3_COD_OPCION,N3_ORDEN,N3_DESCRIPCION)" +
                        " VALUES (${rtdo_cod_pregunta.cod_pregunta},${opc_value[" +
                        i + "]}," + i + ",'${opc_texto[" + i + "]}');");
                    }
                } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_TEXTO)) {
                    PSP.paramProclet(sd, "tamano()");

                    insert_tipo += ("=INSERT INTO PR_TEXTO (N4_COD_PREGUNTA,N4_TAMANO)" +
                    " VALUES (${rtdo_cod_pregunta.cod_pregunta},${tamano});");
                } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_PROCEDENCIA)) {
                    // no hay que hacer nada para este tipo
                } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_FECHA)) {
                    PSP.paramProclet(sd, "fecha_min(),fecha_max()");
                    q53LogEstadisticas.printLog("fecha_min()::::"+sd.gOS("fecha_min"));
                    q53LogEstadisticas.printLog("fecha_max()::::"+sd.gOS("fecha_max"));
                    
                    insert_tipo += ("=INSERT INTO PR_FECHA (N6_COD_PREGUNTA,N6_FECHA_MIN,N6_FECHA_MAX)" +
                    " VALUES (${rtdo_cod_pregunta.cod_pregunta},TO_DATE('${fecha_min}','DD/MM/YYYY'),TO_DATE('${fecha_max}','DD/MM/YYYY'));");
                }

                q53LogEstadisticas.printLog("select ::::"+select);
                q53LogEstadisticas.printLog("insert ::::"+insert);
                q53LogEstadisticas.printLog("insert_tipo::::"+insert_tipo);
                PSP.sqlProclet(sd, select + insert + insert_tipo);
            } else if (sd.gOS("accion").equals(q53Constantes.ACCION_MODIFICAR)) {
                // modificar pregunta

                /**
                * 1.- coger tipo_pregunta actual, antes de modificar
                * 2.- update PREGUNTA de los campos descripcion, y tipo_pregunta
                *     update ENCUESTA_PREGUNTA del campo obligatorio
                * 3.- si tipo_pregunta = nuevo tipo_pregunta -> UPDATE de la
                *     tabla PR_XXX
                *       si el tipo es de OPCIONES, DELETE y luego INSERT de las
                *       nuevas opciones
                * 4.- si tipo_pregunta != nuevo tipo_pregunta -> DELETE de la
                *     tabla PR_XXX y luego INSERT en la nueva PR_XXX
                *
                **/
                PSP.paramProclet(sd,
                    "cod_pregunta(),descripcion(),obligatoria(S),tipo_pregunta()");

                String select_preg_actual = "rtdo_preg_actual=SELECT N1_TIPO_PREGUNTA FROM PREGUNTA WHERE N1_COD_PREGUNTA=${cod_pregunta};";
                PSP.sqlProclet(sd, select_preg_actual);

                String update = "=UPDATE PREGUNTA" +
                    " SET N1_DESCRIPCION='${descripcion}', N1_TIPO_PREGUNTA=${tipo_pregunta}" +
                    " WHERE N1_COD_PREGUNTA=${cod_pregunta};";

                update += ("=UPDATE ENCUESTA_PREGUNTA SET NZ_OBLIGATORIA='${obligatoria}'" +
                " WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_COD_PREGUNTA=${cod_pregunta};");

                if (sd.gOS("rtdo_preg_actual.n1_tipo_pregunta").equals(sd.gOS("tipo_pregunta"))) {
                    // mismo tipo de pregunta -> UPDATE
                    if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_OPCIONES)) {
                        PSP.paramProclet(sd, "formato(),opciones[u], consulta()");

                        update += ("=UPDATE PR_OPCIONES SET N2_FORMATO=${formato}, N2_CONSULTA=${consulta}" +
                        " WHERE N2_COD_PREGUNTA=${cod_pregunta};");

                        update += "=DELETE PR_OPS_OPCION WHERE N3_COD_PREGUNTA=${cod_pregunta};";

                        String opcion = "";
                        int tmp = -1;

                        for (int i = 0; i < sd.gI("opciones.length"); i++) {
                            // opcion vendr como [value]#[texto]
                            opcion = sd.gOS("opciones[" + i + "]");
                            tmp = opcion.indexOf("#");

                            // pongo en sd el opc_value[i] y el opc_texto[i] para
                            // que, en el caso de que haya comillas simples o
                            // caracteres especiales, sea el sqlProclet el que los
                            // trate
                            sd.setVal("opc_value[" + i + "]",
                                opcion.substring(0, tmp));
                            sd.setVal("opc_texto[" + i + "]",
                                opcion.substring(tmp + 1));
                            update += ("=INSERT INTO PR_OPS_OPCION (N3_COD_PREGUNTA,N3_COD_OPCION,N3_ORDEN,N3_DESCRIPCION)" +
                            " VALUES (${cod_pregunta},${opc_value[" + i +
                            "]}," + i + ",'${opc_texto[" + i + "]}');");
                        }
                    } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_TEXTO)) {
                        PSP.paramProclet(sd, "tamano()");

                        update += ("=UPDATE PR_TEXTO SET N4_TAMANO=${tamano}" +
                        " WHERE N4_COD_PREGUNTA=${cod_pregunta};");
                    } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_PROCEDENCIA)) {
                        // no hay que hacer nada para este tipo
                    } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_FECHA)) {
                        PSP.paramProclet(sd, "fecha_min(),fecha_max()");

                        update += ("=UPDATE PR_FECHA SET N6_FECHA_MIN=TO_DATE('${fecha_min}','DD/MM/YYYY'), N6_FECHA_MAX=TO_DATE('${fecha_max}','DD/MM/YYYY')" +
                        " WHERE N6_COD_PREGUNTA=${cod_pregunta};");
                    }
                } // if mismo tipo_pregunta

                else {
                    // distinto tipo de pregunta -> DELETE y INSERT
                    // DELETE
                    if (sd.gOS("rtdo_preg_actual.n1_tipo_pregunta").equals(q53Constantes.TIPO_OPCIONES)) {
                        update += "=DELETE PR_OPS_OPCION WHERE N3_COD_PREGUNTA=${cod_pregunta};";
                        update += "=DELETE PR_OPCIONES WHERE N2_COD_PREGUNTA=${cod_pregunta};";
                    } else if (sd.gOS("rtdo_preg_actual.n1_tipo_pregunta")
                                     .equals(q53Constantes.TIPO_TEXTO)) {
                        update += "=DELETE PR_TEXTO WHERE N4_COD_PREGUNTA=${cod_pregunta};";
                    } else if (sd.gOS("rtdo_preg_actual.n1_tipo_pregunta")
                                     .equals(q53Constantes.TIPO_PROCEDENCIA)) {
                        // no hay que hacer nada para este tipo
                    } else if (sd.gOS("rtdo_preg_actual.n1_tipo_pregunta")
                                     .equals(q53Constantes.TIPO_FECHA)) {
                        update += "=DELETE PR_FECHA WHERE N6_COD_PREGUNTA=${cod_pregunta};";
                    }

                    // INSERT
                    if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_OPCIONES)) {
                        PSP.paramProclet(sd, "formato(),opciones[u], consulta()");

                        update += ("=INSERT INTO PR_OPCIONES (N2_COD_PREGUNTA,N2_FORMATO,N2_CONSULTA)" +
                        " VALUES (${cod_pregunta},${formato}, ${consulta});");

                        String opcion = "";
                        int tmp = -1;

                        for (int i = 0; i < sd.gI("opciones.length"); i++) {
                            // opcion vendr como [value]#[texto]
                            opcion = sd.gOS("opciones[" + i + "]");
                            tmp = opcion.indexOf("#");

                            // pongo en sd el opc_value[i] y el opc_texto[i] para
                            // que, en el caso de que haya comillas simples o
                            // caracteres especiales, sea el sqlProclet el que los
                            // trate
                            sd.setVal("opc_value[" + i + "]",
                                opcion.substring(0, tmp));
                            sd.setVal("opc_texto[" + i + "]",
                                opcion.substring(tmp + 1));
                            update += ("=INSERT INTO PR_OPS_OPCION (N3_COD_PREGUNTA,N3_COD_OPCION,N3_ORDEN,N3_DESCRIPCION)" +
                            " VALUES (${cod_pregunta},${opc_value[" + i +
                            "]}," + i + ",'${opc_texto[" + i + "]}');");
                        }
                    } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_TEXTO)) {
                        PSP.paramProclet(sd, "tamano()");

                        update += ("=INSERT INTO PR_TEXTO (N4_COD_PREGUNTA,N4_TAMANO)" +
                        " VALUES (${cod_pregunta},${tamano});");
                    } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_PROCEDENCIA)) {
                        // no hay que hacer nada para este tipo
                    } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_FECHA)) {
                        PSP.paramProclet(sd, "fecha_min(),fecha_max()");

                        update += ("=INSERT INTO PR_FECHA (N6_COD_PREGUNTA,N6_FECHA_MIN,N6_FECHA_MAX)" +
                        " VALUES (${cod_pregunta},TO_DATE('${fecha_min}','DD/MM/YYYY'),TO_DATE('${fecha_max}','DD/MM/YYYY'));");
                    }
                }

                // else mismo tipo_pregunta
                PSP.sqlProclet(sd, update);
            } // if accion = modificar

            else if (sd.gOS("accion").equals(q53Constantes.ACCION_ELIMINAR)) {
                // eliminar pregunta
                PSP.paramProclet(sd, "cod_pregunta(),tipo_pregunta()");

                // hay que actualizar el orden del resto de las preguntas!!
                String select_orden = "rtdo_orden=SELECT NZ_ORDEN FROM ENCUESTA_PREGUNTA WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_COD_PREGUNTA=${cod_pregunta};";
                String update_orden = "=UPDATE ENCUESTA_PREGUNTA SET NZ_ORDEN=NZ_ORDEN-1 WHERE NZ_ORDEN>${rtdo_orden.nz_orden} AND NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version};";

                String delete_tipo = "";

                if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_OPCIONES)) {
                    delete_tipo += "=DELETE PR_OPS_OPCION WHERE N3_COD_PREGUNTA=${cod_pregunta};";
                    delete_tipo += "=DELETE PR_OPCIONES WHERE N2_COD_PREGUNTA=${cod_pregunta};";
                } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_TEXTO)) {
                    delete_tipo += "=DELETE PR_TEXTO WHERE N4_COD_PREGUNTA=${cod_pregunta};";
                } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_PROCEDENCIA)) {
                    // no hay que hacer nada para este tipo
                } else if (sd.gOS("tipo_pregunta").equals(q53Constantes.TIPO_FECHA)) {
                    delete_tipo += "=DELETE PR_FECHA WHERE N6_COD_PREGUNTA=${cod_pregunta};";
                }

                String delete = "=DELETE ENCUESTA_PREGUNTA WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_COD_PREGUNTA=${cod_pregunta};";
                delete += "=DELETE PREGUNTA WHERE N1_COD_PREGUNTA=${cod_pregunta};";

                // nota: si falla una de las queries se hace rollback para todas
                PSP.sqlProclet(sd, select_orden + update_orden + delete_tipo + delete);
            } else if (sd.gOS("accion").equals(q53Constantes.ACCION_OBLIGATORIA)) {
                // si valor_actual="S" -> poner obligatoria a "N"
                // si valor_actual="N" -> poner obligatoria a "S"
                PSP.paramProclet(sd, "cod_pregunta(),valor_actual()");

                String update = "=UPDATE ENCUESTA_PREGUNTA SET NZ_OBLIGATORIA='" +
                    (sd.gOS("valor_actual").equals("S") ? "N" : "S") + "'" +
                    " WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_COD_PREGUNTA=${cod_pregunta};";
                PSP.sqlProclet(sd, update);
            } else if (sd.gOS("accion").equals(q53Constantes.ACCION_SUBIR)) {
                // "sube" la pregunta: la cambia el orden (orden menos uno)
                PSP.paramProclet(sd, "cod_pregunta()");

                String select_orden =
                    "rtdo_orden=SELECT NZ_ORDEN FROM ENCUESTA_PREGUNTA" +
                    " WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_COD_PREGUNTA=${cod_pregunta};";
                PSP.sqlProclet(sd, select_orden);

                if (sd.gI("rtdo_orden.nz_orden") == 1) {
                    // ya es el primero, no hay que hacer nada.
                } else {
                    String select_pregunta_anterior = "rtdo_anterior=SELECT NZ_COD_PREGUNTA FROM ENCUESTA_PREGUNTA WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_ORDEN=(${rtdo_orden.nz_orden}-1);";

                    String update =
                        "=UPDATE ENCUESTA_PREGUNTA SET NZ_ORDEN=(NZ_ORDEN-1)" +
                        " WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_COD_PREGUNTA=${cod_pregunta};";
                    update += ("=UPDATE ENCUESTA_PREGUNTA SET NZ_ORDEN=(NZ_ORDEN+1)" +
                    " WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_COD_PREGUNTA=${rtdo_anterior.nz_cod_pregunta};");
                    PSP.sqlProclet(sd, select_pregunta_anterior + update);
                }
            } else if (sd.gOS("accion").equals(q53Constantes.ACCION_BAJAR)) {
                // "baja" la pregunta: la cambia el orden (orden ms uno)
                PSP.paramProclet(sd, "cod_pregunta()");

                String select_orden =
                    "rtdo_orden=SELECT NZ_ORDEN FROM ENCUESTA_PREGUNTA" +
                    " WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_COD_PREGUNTA=${cod_pregunta};";

                // se mira cuntas preguntas tienen un orden mayor que esta
                select_orden += ("rtdo_orden_mayor=SELECT COUNT(NZ_COD_PREGUNTA) NUMERO FROM ENCUESTA_PREGUNTA" +
                " WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version}" +
                " AND NZ_ORDEN>${rtdo_orden.nz_orden}");
                PSP.sqlProclet(sd, select_orden);

                if (sd.gI("rtdo_orden_mayor.numero") == 0) {
                    // ya es el ltimo, no hay que hacer nada.
                } else {
                    String select_pregunta_siguiente =
                        "rtdo_siguiente=SELECT NZ_COD_PREGUNTA FROM ENCUESTA_PREGUNTA" +
                        " WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_ORDEN=(${rtdo_orden.nz_orden}+1);";

                    String update =
                        "=UPDATE ENCUESTA_PREGUNTA SET NZ_ORDEN=(NZ_ORDEN+1)" +
                        " WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_COD_PREGUNTA=${cod_pregunta};";
                    update += ("=UPDATE ENCUESTA_PREGUNTA SET NZ_ORDEN=(NZ_ORDEN-1)" +
                    " WHERE NZ_COD_ENCUESTA=${cod_encuesta} AND NZ_COD_VERSION=${cod_version} AND NZ_COD_PREGUNTA=${rtdo_siguiente.nz_cod_pregunta};");
                    PSP.sqlProclet(sd, select_pregunta_siguiente + update);
                }
            }

            /*Se redirije a la misma pagina con las pregutnas de la encuesta y los datos de la encuesta*/
            q53_redirigir(sd,
                "/q53ItourbaskWar/q53encListarPreguntasServlet?cod_encuesta=" +
                sd.gOS("cod_encuesta") + "&cod_version=" +
                sd.gOS("cod_version") + "&recogida_datos=" +
                sd.gOS("recogida_datos") + "&accion=modificar&genEncuesta=" + sd.gOS("genEncuesta"));
        } // if perfil
        else {
            // el usuario no tiene el perfil necesario. seguramente es porque
            // se ha perdido la sesion y hay que redirigirlo al login, para que
            // vuelva a meter su usuario y contrasea
            sd.setVal("pagina", "q53_gen_login");
            q53_redirigir(sd,
                "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
        }
    }
}
