package itourbaskServlet;

import itourbaskBeans.q53EncuestaBean;

import java.util.ArrayList;
import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53encListarServlet extends q53Servlet {
    /**
     * DOCUMENT ME!
     *
     * @param sd DOCUMENT ME!
     *
     * @throws ProcletException DOCUMENT ME!
     */
	
    public void pspProcess(ProcletServiceData sd) throws ProcletException {

        // establece el contentType del response
        sd.res.setContentType("text/html");
        sd.res.setHeader("Pragma", "no-cache");
        sd.res.setHeader("Cache-Control", "no-cache");
        sd.res.setHeader("Expires", "0");
     
        // tratar las cookies
        q53_tratarCookies(sd);
        q53Util.pasar_a_sd(sd);
        
        /*
        HttpSession session = sd.req.getSession(true);
      
        if(sd.req.getParameter("q53_perfil")!=null){
        	session.setAttribute("q53_cki.q53_idioma", sd.req.getParameter("txtCodIdioma"));
        	session.setAttribute("q53_cki.q53_oficina", sd.req.getParameter("txtCodOficina"));
        	session.setAttribute("q53_cki.q53_perfil",sd.req.getParameter("q53_perfil")); 
        	session.setAttribute("q53_cki.q53_usuario",sd.req.getParameter("txtCodUsuario")); 
	    }
        
        q53LogEstadisticas.printLog("ID de sesion ::::"+session.getId());      
        q53LogEstadisticas.printLog("idioma ::::"+(String)session.getAttribute("q53_cki.q53_idioma"));
        q53LogEstadisticas.printLog("oficina ::::"+(String)session.getAttribute("q53_cki.q53_oficina"));
        q53LogEstadisticas.printLog("usuario ::::"+(String)session.getAttribute("q53_cki.q53_usuario"));
        q53LogEstadisticas.printLog("q53_perfil ::::"+(String)session.getAttribute("q53_cki.q53_perfil"));
        
        sd.setVal("q53_cki.q53_idioma",(String)session.getAttribute("q53_cki.q53_idioma"));
        sd.setVal("q53_cki.q53_oficina",(String)session.getAttribute("q53_cki.q53_oficina"));
        sd.setVal("q53_cki.q53_perfil",(String)session.getAttribute("q53_cki.q53_perfil"));
        sd.setVal("q53_cki.q53_usuario",(String)session.getAttribute("q53_cki.q53_usuario"));
        */
        /*En la lista de encuestan aparecen solo las encuestas activas
         Los datos que se sacan son el nombre  de la encuesta si esta visible o no ,la fecha de validez(que
         es la de creacin de la encuesta),y si se ha recogido informacin de esa encuesta(es decir si
         la encuesta tiene alguna respuesta)*/
        PSP.paramProclet(sd, "genEncuesta()");
        // obtener los datos del usuario de las cookies, y guardarlos en el sd
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            // select de las encuestas de la oficina que NO son recogida de datos
            // si hay encuesta, se coge el nmero de respuestas a la encuesta
            // (nota: puede ser que sea una oficina sin encuesta de recogida de
            // datos. En ese caso no habra enc[0]!)
            List encList = getEncuestaByOficinaList(sd);
            List encuestaList = new ArrayList();

            if (encList.size() > 0) {
                int numEnc = encList.size();

                for (int i = 0; i < numEnc; i++) {
                    q53EncuestaBean encuesta = (q53EncuestaBean) encList.get(i);

                    String hayInfo = ifHayRespEnc(sd, encuesta);

                    if (hayInfo.equals("SI")) {
                        encuesta.setHayRespuesta(true);
                    } else {
                        encuesta.setHayRespuesta(false);
                    }

                    encuestaList.add(encuesta);
                }
            }

            sd.setVal("encuestaList", encuestaList);
            sd.setVal("pagina", q53Constantes.PAG_OTRAS_ENC);
            q53LogEstadisticas.printLog("redirige a q53_enc_listar.jsp");
            PSP.setTemplatePageProclet(sd, "/q53_enc_listar.jsp");
        } // if perfil
        else {
            // el usuario no tiene el perfil necesario. seguramente es porque
            // se ha perdido la sesion y hay que redirigirlo al login, para que
            // vuelva a meter su usuario y contrasea
        	q53LogEstadisticas.printLog("Algo ha fallado en la informacion de perfil!");
            sd.setVal("pagina", "q53_gen_login");
            q53_redirigir(sd,
                "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
        }
    }

    /**
     * Mtodo que nos devuelve una lista con los datos de las diferentes
     * versiones de la encuesta de la oficina
     *
     * @param sd el objeto ProcletServiceData
     *
     * @return Lista con los datos de las diferentes versiones de la encuesa de
     *         la oficina
     *
     * @throws ProcletException
     */
    private List getEncuestaByOficinaList(ProcletServiceData sd)
        throws ProcletException {
		
        List encList = new ArrayList();

        // Sacamos el idioma de la cookie para saber el formato de la fecha
        String formato = "";

        if (sd.gOS("q53_cki.q53_idioma").equals("C")) {
            formato = q53Constantes.FORMATO_FECHA_CAS;
        } else {
            formato = q53Constantes.FORMATO_FECHA_EUS;
        }

        String select_enc = "SELECT N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_RECOGIDA_DATOS, N0_VISIBLE, N0_TIPO_ENCUESTA, ";
        select_enc += ("TO_CHAR(N0_FECHA_CREACION,'" + formato +
        "')N0_FECHA_CREACION");
        select_enc += " FROM ENCUESTA";
        select_enc += " WHERE N0_VERSION_ANTIGUA='N'"+
                      " AND N0_RECOGIDA_DATOS!='S' ";
        
        select_enc += " AND N0_COD_OFICINA='" + sd.gOS("q53_cki.q53_oficina") +"';";
                      

        q53LogEstadisticas.printLog("select_enc ::::"+select_enc);
        PSP.sqlProclet(sd, "enc[]=" + select_enc);
        q53LogEstadisticas.printSql("select " + select_enc);

        if (sd.gI("enc.length") > 0) {
            int numEnc = sd.gI("enc.length");

            for (int i = 0; i < numEnc; i++) {
                q53EncuestaBean encuesta = new q53EncuestaBean();
                encuesta.setCodEncuesta(sd.gOS("enc[" + i +
                        "].n0_cod_encuesta"));
                encuesta.setCodVersion(sd.gOS("enc[" + i + "].n0_cod_version"));

                encuesta.setDescripcionEncuesta(sd.gOS("enc[" + i +
                        "].n0_descripcion"));

                if (sd.gOS("enc[" + i + "].n0_visible").equals("S")) {
                    encuesta.setEncuestaVisible(true);
                } else {
                    encuesta.setEncuestaVisible(false);
                }
                String tipo= "";
                q53LogEstadisticas.printLog("N0_TIPO_ENCUESTA: "+ sd.gOS("enc[2].n0_tipo_encuesta"));
                if (sd.gOS("enc[" + i + "].n0_tipo_encuesta").equals("pres")) {
                    tipo = "pres";
                    q53LogEstadisticas.printLog("He entrado tipo pres " + tipo);   
                }else if(sd.gOS("enc[" + i + "].n0_tipo_encuesta").equals("nopres")) {
                    tipo = "nopres";
                    q53LogEstadisticas.printLog("He entrado tipo no pres " + tipo);   
                }else if(sd.gOS("enc[0].n0_tipo_encuesta").equals("pres y nopres")) {
                    tipo = "pres y nopres";
                    q53LogEstadisticas.printLog("He entrado tipo pres y no pres " + tipo);   
                }
                
                encuesta.setTipo(tipo);
                q53LogEstadisticas.printLog("Es presencial? " + tipo);

                encuesta.setFechaCreacionEncuesta(sd.gOS("enc[" + i +
                        "].n0_fecha_creacion"));
                encuesta.setRecogidaDatos(true);
                encuesta.setVersionAntigua(false);
                encuesta.setCodOficina(sd.gOS("q53_cki.q53_oficina"));
                encList.add(encuesta);
            }
        }

        return encList;
    }

    /**
     * Metodo que nos indica si una encuesta tiene respuesta
     *
     * @param sd el objeto ProcletServiceData
     * @param encuesta objeto q53EncuestaBean que contiene los datos de la
     *        encuesta
     *
     * @return String que nos indica si ahy o no respuesta
     *
     * @throws ProcletException
     */
    private String ifHayRespEnc(ProcletServiceData sd, q53EncuestaBean encuesta)
        throws ProcletException {
		
        String rtdo_resp = "SELECT M0_COD_RESPUESTA" + " FROM RESPUESTA" +
            " WHERE M0_COD_ENCUESTA=" + encuesta.getCodEncuesta() +
            " AND M0_COD_VERSION=" + encuesta.getCodVersion();

        q53LogEstadisticas.printLog("rtdo_resp ::::"+rtdo_resp);
        PSP.sqlProclet(sd, "resp[]=" + rtdo_resp);

        String hayInfo = "NO";

        if (sd.gI("resp.length") > 0) {
            hayInfo = "SI";
        }

        return hayInfo;
    }
}
