package itourbaskServlet;

import itourbaskBeans.q53EncuestaBean;
import itourbaskBeans.q53PreguntaBean;
import itourbaskClases.q53EncuestaClass;

import java.util.ArrayList;
import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53encListarPreguntasServlet extends q53Servlet {
    /**
     * DOCUMENT ME!
     *
     * @param sd DOCUMENT ME!
     *
     * @throws ProcletException DOCUMENT ME!
     */

    public void pspProcess(ProcletServiceData sd) throws ProcletException {

        // establece el contentType del response
        sd.res.setContentType("text/html");
        sd.res.setHeader("Pragma", "no-cache");
        sd.res.setHeader("Cache-Control", "no-cache");
        sd.res.setHeader("Expires", "0");

        // tratar las cookies
        q53_tratarCookies(sd);
        q53Util.pasar_a_sd(sd);

        String perfilUser = "NO";

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
            perfilUser = "SI";
        }

        String perfilCoord = "NO";

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            perfilCoord = "SI";
        }

        String perfilAdmin = "NO";

        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
            perfilAdmin = "SI";
        }

        sd.setVal("perfilUser", perfilUser);
        sd.setVal("perfilCoord", perfilCoord);
        sd.setVal("perfilAdmin", perfilAdmin);
        // obtener los datos del usuario de la sesion, y guardarlos en el sd
        if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO) ||
                q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            /*recupera la accion de los parametros que lengthllegan para poder saber si es
             crear una pregunta o modificar una ya existente*/
            PSP.paramProclet(sd,
                "cod_encuesta(),cod_version(),genEncuesta(),recogida_datos(),accion()");

            String codEncuesta = sd.gOS("cod_encuesta");
            String codVersion = sd.gOS("cod_version");
            String accion = sd.gOS("accion");
            String recogidaDatos = sd.gOS("recogida_datos");

            // select de las preguntas de recogida de datos de la oficina

           
            q53EncuestaBean encuesta = getEncuestaData(sd, codEncuesta,
                    codVersion);

            //String select_ant = "";
            List encuestaList = getOldVersionOfEncuesta(sd, encuesta);

           
            if (sd.gI("enc.length") > 0) {
                // hay encuesta. recoger preguntas
                sd.setVal("hay_preg", "SI");

              
                List preguntasList = getPreguntasListByEncuesta(sd,encuesta);
				 sd.setVal("preguntasList",preguntasList);
				 

                // recorrer pregunta por pregunta para coger la info. de los campos
                // que dependen del tipo de pregunta
				
	            q53EncuestaClass.recorrerPreguntas(sd, "preg",codEncuesta,codVersion);
				
                
            }

            if (sd.gOS("recogida_datos").equals("S")) {
                sd.setVal("pagina", q53Constantes.PAG_ENC_ACTIVADA);
            } else {
                sd.setVal("pagina", q53Constantes.PAG_OTRAS_ENC);
            }

            /*Una vez creada la encuesta se redirije a la pagina de crear pregunta*/
            if (sd.gOS("accion").equals(q53Constantes.ACCION_NUEVO)) {
				
                q53_redirigir(sd,
                    "/q53ItourbaskWar/q53encVerPreguntaServlet?cod_encuesta=" +
                    sd.gOS("cod_encuesta") + "&cod_version=" +
                    sd.gOS("cod_version") + "&accion=" + sd.gOS("accion") +
                    "&recogida_datos=" + sd.gOS("recogida_datos") + "&genEncuesta="
                    + sd.gOS("genEncuesta"));
            } else {
				
                PSP.setTemplatePageProclet(sd, "/q53_enc_listarPreguntas.jsp");
            }
        } // if perfil
        else {
            // el usuario no tiene el perfil necesario. seguramente es porque
            // se ha perdido la sesion y hay que redirigirlo al login, para que
            // vuelva a meter su usuario y contrasea
            sd.setVal("pagina", "q53_gen_login");
            q53_redirigir(sd,
                "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion");
        }
    }

    

    /**
     * select de la lista de versiones anteriores de la encuesta
     *
     * @param sd el objeto ProcletServiceData
     * @param encuesta Objeto que contien los datos de la encuesta
     *
     * @return
     *
     * @throws ProcletException
     */
    private List getOldVersionOfEncuesta(ProcletServiceData sd,
        q53EncuestaBean encuesta) throws ProcletException {
		
        List oldVersionEncList = new ArrayList();
        String oldVersion = "S";

        if (encuesta.isVersionAntigua()) {
            oldVersion = "N";
        }

        String select_ant = "SELECT N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_RECOGIDA_DATOS, ";
        select_ant += "N0_VISIBLE, N0_TEXTO, N0_VERSION_ANTIGUA FROM ENCUESTA";
        select_ant += (" WHERE N0_COD_ENCUESTA=" + encuesta.getCodEncuesta() +
        " AND N0_VERSION_ANTIGUA='" + oldVersion + "'");
        q53LogEstadisticas.printLog("select_ant ::::"+select_ant);
        PSP.sqlProclet(sd, "ant[]=" + select_ant);

        if (sd.gI("ant.length") > 0) {
            int numEnc = sd.gI("ant.length");

            for (int i = 0; i < numEnc; i++) {
                q53EncuestaBean versionEnc = new q53EncuestaBean();
                versionEnc.setCodEncuesta(sd.gOS("ant[" + i +
                        "].n0_cod_encuesta"));
                versionEnc.setCodVersion(sd.gOS("ant[" + i +
                        "].n0_cod_version"));
                versionEnc.setCodEncuesta(sd.gOS("ant[" + i +
                        "].n0_descripcion"));

                if (sd.gOS("ant[" + i + "].n0_recogida_datos").equals("N")) {
                    versionEnc.setRecogidaDatos(false);
                } else {
                    versionEnc.setRecogidaDatos(true);
                }

                if (sd.gOS("ant[" + i + "].n0_visible").equals("N")) {
                    versionEnc.setEncuestaVisible(false);
                } else {
                    versionEnc.setEncuestaVisible(true);
                }

                if (sd.gOS("ant[" + i + "].n0_version_antigua").equals("N")) {
                    versionEnc.setVersionAntigua(false);
                } else {
                    versionEnc.setVersionAntigua(true);
                }

                oldVersionEncList.add(versionEnc);
            }
        }

        return oldVersionEncList;
    }

    /**
     * Mtodo que nos devuelve la lista de preguntas de una encuesta
     *
     * @param sd el objeto ProcletServiceData
     * @param encuesta objeto q53EncuestaBean que contiene los datos de la encuesta
     *
     * @return List lista de las preguntas
     *
     * @throws ProcletException 
     */
    private List getPreguntasListByEncuesta(ProcletServiceData sd,
        q53EncuestaBean encuesta) throws ProcletException {
		  
    	List preguntasList = new ArrayList();
        String select_preg = "SELECT DISTINCT N1_COD_PREGUNTA, N1_DESCRIPCION, N1_TIPO_PREGUNTA, NZ_ORDEN, NZ_OBLIGATORIA, N2_CONSULTA";
        select_preg += " FROM PREGUNTA, ENCUESTA_PREGUNTA, PR_OPCIONES, PR_TEXTO, PR_FECHA";
        select_preg += (" WHERE NZ_COD_ENCUESTA=" + encuesta.getCodEncuesta() +
        " AND NZ_COD_VERSION=" + encuesta.getCodVersion());
        select_preg += " AND NZ_COD_PREGUNTA=N1_COD_PREGUNTA";
        select_preg += " AND (NZ_COD_PREGUNTA=N2_COD_PREGUNTA OR NZ_COD_PREGUNTA=N4_COD_PREGUNTA OR NZ_COD_PREGUNTA=N6_COD_PREGUNTA)";
        select_preg += " ORDER BY NZ_ORDEN";
        
        q53LogEstadisticas.printLog("select_preg::::"+select_preg);
        PSP.sqlProclet(sd, "preg[]=" + select_preg);

        String select_preg2 = "SELECT DISTINCT N1_COD_PREGUNTA, N1_DESCRIPCION, N1_TIPO_PREGUNTA, NZ_ORDEN, NZ_OBLIGATORIA, N2_CONSULTA";
        select_preg2 += " FROM PREGUNTA, ENCUESTA_PREGUNTA, PR_OPCIONES, PR_TEXTO, PR_FECHA";
        select_preg2 += (" WHERE NZ_COD_ENCUESTA=" + encuesta.getCodEncuesta() +
        " AND NZ_COD_VERSION=" + encuesta.getCodVersion());
        select_preg2 += " AND NZ_COD_PREGUNTA=N1_COD_PREGUNTA";
        select_preg2 += " AND NZ_COD_PREGUNTA=N2_COD_PREGUNTA";
        select_preg2 += " ORDER BY NZ_ORDEN";
        
        q53LogEstadisticas.printLog("select_preg2::::"+select_preg2);
        PSP.sqlProclet(sd, "preg2[]=" + select_preg2);

        if (sd.gI("preg.length") > 0) {
            int numPreg = sd.gI("preg.length");
            
            for (int i = 0; i < numPreg; i++) {
            	q53PreguntaBean pregunta = new q53PreguntaBean();
            	int codPregunta1 = sd.gI("preg[" + i + "].n1_cod_pregunta");
            	int codPregunta2 = 0;
            	if((i+1) < numPreg) {
            		codPregunta2 = sd.gI("preg[" + (i+1) + "].n1_cod_pregunta");
            	}
            	if((codPregunta1 == codPregunta2)&&((i+1) < numPreg)){
            		pregunta.setCodPregunta(sd.gOS("preg[" + i +
                            "].n1_cod_pregunta"));
                    pregunta.setDescripcionPregunta(sd.gOS("preg[" + i +
                            "].n1_descripcion"));
                    pregunta.setTipoPregunta(sd.gOS("preg[" + i +
                            "].n1_tipo_pregunta"));
                    pregunta.setOrden(sd.gOS("preg[" + i + "].nz_orden"));

                    if (sd.gOS("preg[" + i + "].nz_obligatoria").equals("S")) {
                        pregunta.setObligatoria(true);
                    } else {
                        pregunta.setObligatoria(false);
                    }
                    i++;
            	}else{
            		pregunta.setCodPregunta(sd.gOS("preg[" + i +
                            "].n1_cod_pregunta"));
                    pregunta.setDescripcionPregunta(sd.gOS("preg[" + i +
                            "].n1_descripcion"));
                    pregunta.setTipoPregunta(sd.gOS("preg[" + i +
                            "].n1_tipo_pregunta"));
                    pregunta.setOrden(sd.gOS("preg[" + i + "].nz_orden"));

                    if (sd.gOS("preg[" + i + "].nz_obligatoria").equals("S")) {
                        pregunta.setObligatoria(true);
                    } else {
                        pregunta.setObligatoria(false);
                    }
                    
                    if (sd.gI("preg[" + i + "].n2_consulta")== 1) { 
                        pregunta.setConsulta(true);
                    } else {
                        pregunta.setConsulta(false);
                    }
            	}
                preguntasList.add(pregunta);
            }
        }

        return preguntasList;
    }
    
    private q53EncuestaBean  getEncuestaData(ProcletServiceData sd,String codEncuesta,String
                    codVersion) throws ProcletException{
		
        q53EncuestaBean encuesta = new q53EncuestaBean();
        // select de las preguntas de recogida de datos de la oficina
            String select_enc = "SELECT N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_TEXTO, N0_RECOGIDA_DATOS";
            select_enc += " FROM ENCUESTA";
            select_enc += " WHERE N0_COD_ENCUESTA="+codEncuesta+" AND N0_COD_VERSION="+codVersion;

            q53LogEstadisticas.printLog("select_enc ::::"+select_enc);
            PSP.sqlProclet(sd, "enc[]=" + select_enc);
            encuesta.setCodEncuesta(sd.gOS("enc[0].n0_cod_encuesta"));
            encuesta.setCodVersion(sd.gOS("enc[0].n0_cod_version"));
            encuesta.setDescripcionEncuesta(sd.gOS("enc[0].n0_descripcion"));
            boolean recogidaDatos = false;
            if(sd.gOS("enc[0].n0_recogida_datos").equals("S")){
                recogidaDatos = true;
            }
            encuesta.setRecogidaDatos(recogidaDatos);
            
            return encuesta;
        
    }
}
