package itourbaskServlet;
import itourbaskClases.q53RespuestaXMLHTAClass;

import java.io.PrintWriter;
import java.io.StringReader;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;

import q53_util.q53LogEstadisticas;

import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


public class q53_usr_XMLServletHTA extends q53Servlet {
  private void guardarEncuesta(ProcletServiceData sd,Document doc)
	throws Exception
	{
	  	//ESTE METODO GRABA TODAS LAS RESPUESTAS QUE ENCUENTREN EN EL XML, PRIMERO LAS DE GV Y DESPUES LAS DE OFICINA,
	  	//ASOCIANDO SECUENCIALMENTE LOS CODIGOS DE RESPUESTA DE GV A LAS RESPUESTAS DE OFICINA
  	q53RespuestaXMLHTAClass.setNumErrores(0);
	    q53LogEstadisticas.printLog("GUARDANDO RESPUESTAS GV...");
	    String codFichero=doc.getElementsByTagName("encuestas").item(0).getAttributes().getNamedItem("codigoFichero").getNodeValue();
	    NamedNodeMap atributos=doc.getElementsByTagName("encuestaPV").item(0).getAttributes();
	    String enc=atributos.getNamedItem("codEncuesta").getNodeValue();
	    String per="";
	    String ver=atributos.getNamedItem("codVersion").getNodeValue();
	    String ofi=atributos.getNamedItem("codOficina").getNodeValue();
	   
	    List codRespuestas= q53RespuestaXMLHTAClass.guardarRespuestasEncGV(sd,enc,ver,ofi,per,doc,codFichero);
	  	
	    q53LogEstadisticas.printLog("GUARDANDO RESPUESTAS GV FIN");
        //Miramos si la oficina tiene alguna encuesta visible

        //Nos aseguramos de que esta visible
	    if(doc.getElementsByTagName("encuestaOFI")!=null && doc.getElementsByTagName("encuestaOFI").getLength()>0){
           	   atributos=doc.getElementsByTagName("encuestaOFI").item(0).getAttributes();
           	   q53LogEstadisticas.printLog("GUARDANDO RESPUESTAS OFI...");
               enc=atributos.getNamedItem("codEncuesta").getNodeValue();
               ver=atributos.getNamedItem("codVersion").getNodeValue();
               q53RespuestaXMLHTAClass.guardarRespuestasEncOFI(sd,enc,ver,ofi,per,codRespuestas,doc,codFichero);
               q53LogEstadisticas.printLog("GUARDANDO RESPUESTAS OFI FIN");
	    }
	    
	}


    public void pspProcess(ProcletServiceData sd) throws ProcletException {
        PrintWriter out=null;
        String activar_avisos = (String)sd.req.getParameter("activar_avisos");
    	if(activar_avisos==null)
    		activar_avisos="";
        try {
			q53LogEstadisticas.printLog("ENTRA");
			// establece el contentType del response
			sd.res.setContentType("text/plain");
			String probar_conexion = (String)sd.req.getParameter("probar_conexion");
			q53LogEstadisticas.printLog("probar_conexion = "+probar_conexion);
			out=sd.res.getWriter();
			if(probar_conexion==null || probar_conexion==""){
				String xml=(String)sd.req.getParameter("info");
				q53LogEstadisticas.printLog("XML:"+xml);
				q53LogEstadisticas.printLog("INICIO TRATAMIENTO-");
				q53LogEstadisticas.printLog("DocumentBuilderFactory.newInstance()-");
				DocumentBuilderFactory dbf=DocumentBuilderFactory.newInstance();
				q53LogEstadisticas.printLog("dbf.newDocumentBuilder");
				DocumentBuilder db=dbf.newDocumentBuilder();
				q53LogEstadisticas.printLog("new InputSource( new StringReader(xml))-");
				InputSource isoXML = new InputSource( new StringReader(xml)); 
				q53LogEstadisticas.printLog("db.parse(isoXML)-");
				Document doc=db.parse(isoXML);
				q53LogEstadisticas.printLog("guardarEncuesta(sd,doc)-");
				guardarEncuesta(sd,doc);
				q53LogEstadisticas.printLog("q53RespuestaXMLHTAClass.executeInserts(sd)");
				q53RespuestaXMLHTAClass.executeInserts(sd);
				q53LogEstadisticas.printLog("FIN TRATAMIENTO-");
			}
			out.print("ok," + q53RespuestaXMLHTAClass.getNumErrores());
			out.close();
        } catch (Exception e) {
			q53LogEstadisticas.printError("",e);
            if(out!=null){
                try{
                    String errortipo=e.getMessage();
                    int tipo=1;
                    if(errortipo.indexOf("Q53A2.Q53M0T00_U_COD_XML")!=-1)
                    	tipo=0;
                    q53LogEstadisticas.printLog("FALLO!!!"+e.getMessage());
                    String respuesta=sd.gOS("respuesta");
                    if(respuesta!=null || respuesta.length()>0)
                    	respuesta=" respuesta - "+respuesta;
                    else 
                    	respuesta="";
                    q53LogEstadisticas.printLog("Fallo "+respuesta+",");
                    q53LogEstadisticas.printLog("Mensaje enviado "+e.getMessage()+",");
                	if(activar_avisos.equals("1")){
                		out.print(tipo+"Fallo "+respuesta+",");
                	}else{
                		out.print("ok," + q53RespuestaXMLHTAClass.getNumErrores());
                	}               
                    out.close();
                }catch(Exception ex){
                    q53LogEstadisticas.printError("",ex);
                    if(activar_avisos.equals("1")){
                		out.print("Ha habido errores ->"+ex.getMessage());
                	}else{
                		out.print("ok," + q53RespuestaXMLHTAClass.getNumErrores());
                	}               
                }
            }
        }
    }
    
}
