package itourbaskServlet;

import java.io.File;
import java.io.IOException;

import javax.servlet.http.Cookie;

import q53_util.q53Constantes;

import com.cidat.proclets.PSPServlet;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletProperties;
import com.cidat.proclets.ProcletServiceData;


public abstract class q53Servlet extends PSPServlet {
    /**
     * definicin del mtodo abstracto getProcletProperties de la clase
     * PSPServlet.
     *
     * recoge los parmetros necesarios para los proclets del fichero [config]/q53/q53.properties
     *
     * @return ProcletProperties
     **/
    public ProcletProperties getProcletProperties() {
        File ficheroproperties = new File(q53Constantes.PATH_PROPERTIES_FILE);

        return new ProcletProperties(ficheroproperties);
    }

    /**
     * Hace un sendRedirect a la url pasada como parmetro
     * @param ds Un objeto de tipo ProcletServiceData
     * @param url El String con la direccion UL a la cual se redirije
     *
     */
    public void q53_redirigir(ProcletServiceData sd, String url) {
        try {
            sd.res.sendRedirect(url);
        } catch (IOException ioe) {
            log("trm_redirigir: " + ioe.getMessage());
        }
    }

    /**
     * Introduce en el sd la informacin de las cookies.
     * @param sd El objeto ProcletServiceData
     *
     */
    public void q53_tratarCookies(ProcletServiceData sd)
        throws ProcletException {
        Cookie[] arr_cki = sd.req.getCookies();

        for (int i = 0; i < arr_cki.length; i++) {
            sd.setVal("q53_cki." + arr_cki[i].getName(), arr_cki[i].getValue());
            sd.req.getSession(true).setAttribute("q53_cki." + arr_cki[i].getName(), arr_cki[i].getValue());
        }

    }
}
