package itourbaskServlet;

import itourbaskClases.q53RespuestaClass;
import itourbaskClases.q53RespuestaXMLClass;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;

import q53_util.q53LogEstadisticas;
import q53_util.q53ParserXMLPlanos;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;

import encuestas.PreguntaDocument.Pregunta;
import encuestas.RespuestaDocument.Respuesta;
import encuestas.RespuestasDocument.Respuestas;

public class q53ServiceIncorporarXMLServlet extends q53Servlet {
	
	//Variables general
	String textoXML;
	
	//Variables para el fichero de respuesta XML
	String fin_respuesta;
	String codigos_respuestaXML;
	String fin_codigos_respuestaXML;   		
	String textos_respuestaXML;
	String fin_textos_respuestaXML;
	String envia_respuesta;
	ServletOutputStream out;
	
	//Variables para el email
	String servidorIn;
	String fromIn;
	String subjectIn;
	String select_email;
	String toIn;
	String textoIn;
	
    public void pspProcess(ProcletServiceData sd) throws ProcletException {
    	
    	HttpServletRequest request = sd.req;       
        sd.res.setContentType("text/html");
        sd.res.setHeader("expires","0");            
        sd.res.setHeader("Pragma","no-cache");          
        sd.res.setHeader("Cache-Control","no-cache");     
        sd.res.setHeader("Cache-Control","no-store");    
//      q53LogEstadisticas.printLog("Valores en el sd :"+sd.getValNames(""));
    	try {  
    		//PARAMETROS EMAIL//
    		servidorIn = q53Util.getQ53Property("correo.servidor");
    		fromIn = q53Util.getQ53Property("correo.from");
    		subjectIn = "NO SE HAN PODIDO GRABAR RESPUESTAS EN LA MAQUINA DE PLANOS / EZIN DIRA GRABATU PLANOEN MAKINAKO ERANTZUNAK";
    		textoIn = "Ha ocurrido un error al intentar introducir las respuestas del fichero xml de la maquina de planos, se envian adjuntos" +
    				" el fichero en el cual se genero el error y el fichero enviado de respuesta de la aplicacin.<br><br>" +
    				"Errore bat gertatu da planoen makinako xml fitxategiaren erantzunak sartzen saiatzean, errorea gertatu deneko fitxategia eta aplikazioaren erantzuna"+ 
    				" bidali deneko fitxategia erantsita bidaltzen dira.<br>";
       		select_email = "SELECT T03_COEML FROM q53a1.Q5303T00 WHERE T03_COOFI='20M000'";
            PSP.sqlProclet(sd, "emailOficina[] = " + select_email );
    		toIn = sd.gOS("emailOficina[0].t03_coeml");
    		//FIN PARAMETROS EMAIL//
    		fin_respuesta = "</respuesta>";
    		codigos_respuestaXML = "<codigo>";
    		fin_codigos_respuestaXML = "</codigo>";   		
    		textos_respuestaXML = "<texto>";
    		fin_textos_respuestaXML = "</texto>";
    		envia_respuesta = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><respuesta>";
    		textoXML = "";
    		String mensaje_respuesta = "";
    		out = sd.res.getOutputStream();
    		if(!"".equals(sd.req.getParameter("texto")) && sd.req.getParameter("texto")!=null){
    			//recibe un parametro post(comportamiento para pruebas)
    			textoXML = sd.req.getParameter("texto");
    		}else if(!"".equals((String)sd.req.getAttribute("texto")) && sd.req.getAttribute("texto")!=null){
    			//recibe un atributo(pasa por el hta)
    			textoXML = (String)sd.req.getAttribute("texto");
    		}else{
    			//recibe un inputStream(este seria el comportamiento normal en produccion)
    			InputStream is = sd.req.getInputStream();    		
				textoXML = convertStreamToString(is);
    		}
    		q53LogEstadisticas.printLog("Ha recibido el parametro : "+textoXML);
    		textoXML = preparar_XML(textoXML);
    		q53LogEstadisticas.printLog("Despues de limpiarlo : "+textoXML);
    		byte[] textoBytes = textoXML.getBytes();
            q53ParserXMLPlanos parser = new q53ParserXMLPlanos();
            boolean validacion = true;
            try { 
            	if(parser.validar_contra_xsd(new ByteArrayInputStream(textoBytes))){
               		validacion = parser.parsearRespuesta(sd,new ByteArrayInputStream(textoBytes));
               		mensaje_respuesta = parser.mensaje_respuesta;
            		if(!validacion){
            			q53LogEstadisticas.printLog("Mensaje de respuesta : "+mensaje_respuesta);
            			codigos_respuestaXML += "1$$";
            			textos_respuestaXML += formatear_tags(mensaje_respuesta)+"$$";
            			finalizar_envio_respuesta();
            			q53LogEstadisticas.printLog("Codigo respuesta del email enviado (0=OK) : "+enviar_mail(sd));
            		}else{
            			Respuestas resp = parser.resp;
            			Respuesta[] respuesta = parser.respuesta;
            			String codRespuesta,codRespuestaAsociada;
            			Calendar cal;
            			String optaux,dia,mes,anio,fechaVersionPlanos,m0Fecha,m0FechaResp,hora,min,seg,codRespEncOfi,
            			codEncuestaOfi,codVersionEncOfi,codPreguntaOfi;
            			String[] opciones;
            			Pregunta[] pregunta;
        	            String select_ficheroXML = "SELECT COUNT(*) FICHERO_REPETIDO from Q53M0T00 where M0_COD_FICH_XML='" + resp.getClaveFichero()+ "'";
        	            PSP.sqlProclet(sd, "existeficheroXML[]=" + select_ficheroXML );
        	            q53LogEstadisticas.printLog(select_ficheroXML);
        	            int ficheroRepetido = sd.gI("existeficheroXML[0].fichero_repetido");
	        	        if (ficheroRepetido!=0){
	        	        	codigos_respuestaXML += "4$$";
	            			textos_respuestaXML += "Fichero Repetido: " + resp.getClaveFichero()+"$$";
               	        }
            			for(int i=0;i<respuesta.length;i++){
////////////////////////////PARTE DE COMPROBACION DE SI LA CLAVE DE LA RESPUESTA SE ENCUENTRA EN LA BBDD//////////////
	        	            String select_respuestaXML = "SELECT COUNT(*) RESPUESTA_REPETIDA from Q53M0T00 where M0_COD_RES_XML='" + respuesta[i].getClaveRespuesta()+ "'";
	        	            PSP.sqlProclet(sd, "existeRespuestaXML[]=" + select_respuestaXML );
	        	            q53LogEstadisticas.printLog(select_respuestaXML);
	        	            int respuestaRepetida = sd.gI("existeRespuestaXML[0].respuesta_repetida");
		        	        if (respuestaRepetida==0){
 		            				
		////////////////////////////FIN PARTE DE COMPROBACION DE SI LA CLAVE DE LA RESPUESTA SE ENCUENTRA EN LA BBDD//////////      				
		///////////////////////////////////////////////RESPUESTA GV///////////////////////////////////////////////////////////////               				
		            				cal = respuesta[i].getFechaVersionSoftwarePlanos();
		            				dia = String.valueOf(cal.get(Calendar.DATE));
		            				mes = String.valueOf(cal.get(Calendar.MONTH) + 1);
		            				anio = String.valueOf(cal.get(Calendar.YEAR));
		            				
		            				fechaVersionPlanos=dia+"/"+mes+"/"+anio;
		            				
		            				cal = respuesta[i].getRespuestaPV().getFechaVisita();
		            				dia = String.valueOf(cal.get(Calendar.DATE));
		            				mes = String.valueOf(cal.get(Calendar.MONTH) + 1);
		            				anio = String.valueOf(cal.get(Calendar.YEAR));
		            				hora = String.valueOf(cal.get(Calendar.HOUR_OF_DAY));
		            				min = String.valueOf(cal.get(Calendar.MINUTE));
		            				seg = String.valueOf(cal.get(Calendar.SECOND));
		            				
		            				if(hora.length()<2) hora="0"+hora;
		            				if(min.length()<2) min="0"+min;
		            				if(seg.length()<2) seg="0"+seg;
		            				if(dia.length()<2) seg="0"+dia;
		            				if(mes.length()<2) seg="0"+mes;
		            				
		            				m0Fecha=dia+"/"+mes+"/"+anio+" "+hora+":"+min+":"+seg;
		            				
		            	        	try{
		            				codRespuesta = q53RespuestaXMLClass.setRespuestaEncGV(sd,resp.getCodOficina(),"",
		            						respuesta[i].getRespuestaPV().getCodEncuesta().toString(),
		            						String.valueOf(respuesta[i].getRespuestaPV().getCodVersionEncuesta()),"pres",
		            						"registroP",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getTotal()),
		            						m0Fecha,respuesta[i].getClaveRespuesta(),resp.getClaveFichero(),fechaVersionPlanos);
		            	        	} catch(Exception e) {
		            	        		codigos_respuestaXML += "3$$";
		                    			textos_respuestaXML += formatear_tags("Excepcion Guardado :"+e.toString()+" ---- "+e.getMessage())+"$$";		            	  
		            	            	if(i>=respuesta.length-1){
		            	            		finalizar_envio_respuesta();
			            	            	q53LogEstadisticas.printLog("Codigo respuesta del email enviado (0=OK) : "+enviar_mail(sd));
			            	            	return;
		            	            	}else{
		            	            		q53LogEstadisticas.printLog("Ha ido mal el guardado");
		            	            		continue;
		            	            	}
		            	            }
		             				
		            				sd.setVal("q53_cki.q53_oficina",resp.getCodOficina());
		            				sd.setVal("gv_cod_encuesta",respuesta[i].getRespuestaPV().getCodEncuesta().toString());
		            				sd.setVal("gv_cod_version",String.valueOf(respuesta[i].getRespuestaPV().getCodVersionEncuesta()));
		            				
		            				sd.setVal("fech_10_dia2",dia);
		            				sd.setVal("fech_10_mes2",mes);
		            				sd.setVal("fech_10_anio2",anio);
		            				sd.setVal("fech_0_dia",dia);
		            				sd.setVal("fech_0_mes",mes);
		            				sd.setVal("fech_0_anio",anio);
		            				sd.setVal("fech_0_hora",hora);
		            	        	sd.setVal("local",respuesta[i].getRespuestaPV().getProcedencia().getLocal().toString());
		            	        	if(respuesta[i].getRespuestaPV().getProcedencia().getLocal().toString().equals("N")){ 		
		            	        		sd.setVal("proc_pais_6_1",String.valueOf(respuesta[i].getRespuestaPV().getProcedencia().getCodPais()));
		            	        		if(String.valueOf(respuesta[i].getRespuestaPV().getProcedencia().getCodPais()).equals("0")){
		            	        			sd.setVal("cpos1",respuesta[i].getRespuestaPV().getProcedencia().getCodPostal());
		            	        		}else if(String.valueOf(respuesta[i].getRespuestaPV().getProcedencia().getCodPais()).equals("10")){
		            	        			if(respuesta[i].getRespuestaPV().getProcedencia().getCodPostal()!=null){
		            	        				sd.setVal("cpos1",respuesta[i].getRespuestaPV().getProcedencia().getCodPostal());
			            	        			}else{
			            	        				sd.setVal("cpos1","");
			            	        			}
		            	        			}else{
			            	        			sd.setVal("cpos1","");
			            	        		}
		            	        		sd.setVal("opt_local","off");
		            	        		sd.setVal("local","");
		            	        	}else{
		            	        		sd.setVal("proc_pais_6_1","0");
		            	        		sd.setVal("cpos1","");
		            	        		sd.setVal("opt_local","on");
		            	        	} 	
		            	        	
		            	        	////////PONGO LOS VALORES LOCAL Y PLANOS Y MAPAS COMO VALORES QUE SIEMPRE SERAN LOS MISMOS////////
		            				sd.setVal("opt_7",String.valueOf(respuesta[i].getRespuestaPV().getTipoInformacion().getSolicitada().getOpcionArray(0)));
		            				sd.setVal("opt_8",String.valueOf(respuesta[i].getRespuestaPV().getTipoInformacion().getDemandada().getOpcionArray(0)));
		            				
		            				sd.setVal("nPersonasProcedencia_6_1",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getTotal()));
		            				sd.setVal("totalPersonas",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getTotal()));
		            				sd.setVal("sinConcretar",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getEdad().getSinConcretar()));
		            							
		            				//////////ORDENAR LOS GRUPOS DE EDAD/////////
		            				sd.setVal("grp_5_4_3",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getEdad().getAdultos()));
		            		    	sd.setVal("grp_5_4_2",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getEdad().getJovenes()));
		            		    	sd.setVal("grp_5_4_4",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getEdad().getJubilados()));
		            		    	sd.setVal("grp_5_4_1",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getEdad().getNinos()));
		            		    	sd.setVal("grp_5_4_5",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getEdad().getSinConcretar()));
		            		    	
		            				sd = ordenarGruposEdad(sd,respuesta[i].getRespuestaPV().getVisitantes().getSexo().getHombres(),respuesta[i].getRespuestaPV().getVisitantes().getSexo().getMujeres());
		            	        	////////// FIN ORDENAR LOS GRUPOS DE EDAD/////////
		            	        	
		            	        	sd.setVal("grp_2_2_1",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getSexo().getHombres()));
		            	        	sd.setVal("grp_2_2_2",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getSexo().getMujeres()));  
		            	        	
									//IGC 20150519 INICIO INCLUIR PREGUNTA VALIDACION ESTANCIA
									////////PONGO LOS de la valoracion de la estancia/.   No se activa, ya que la mquina de planos no se modifica
									//      	validado = validar_valor("entre1y5","ValoracionEstancia",String.valueOf(respuesta[i].getRespuestaPV().getValoracionEstancia()),"","");
									//			sd.setVal("opt_12",String.valueOf(respuesta[i].getRespuestaPV().getValoracionEstancia(0)));
									//       	q53LogEstadisticas.printLog("VALORACION_ESTANCIA ->: "+respuesta[i].getRespuestaPV().getValoracionEstancia());
									//      	if(!validado)break;
									//IGC 20150519 FIN INCLUIR PREGUNTA VALIDACION ESTANCIA
		            	        	
		            	        	q53LogEstadisticas.printLog("Antes de guardarRespuestasEncGV");
		            	        	try{
		            	        	q53RespuestaClass.guardarRespuestasEncGV(sd, sd.gOS("gv_cod_encuesta"), sd.gOS("gv_cod_version"), codRespuesta);
		            	        	} catch(Exception e) {
		            	            	q53LogEstadisticas.printLog("Ha saltado una excepcion : "+e.toString());	
		            	            	q53LogEstadisticas.printLog("Mensaje :"+e.getMessage());
		            	            	codigos_respuestaXML += "3$$";
		                    			textos_respuestaXML += formatear_tags("Excepcion Guardado:"+e.toString()+" ---- "+e.getMessage())+"$$";
		            	            	if(i>=respuesta.length-1){
		            	            		finalizar_envio_respuesta();
			            	            	q53LogEstadisticas.printLog("Codigo respuesta del email enviado (0=OK) : "+enviar_mail(sd));
			            	            	return;
		            	            	}else{
		            	            		q53LogEstadisticas.printLog("Ha ido mal el guardado");
		            	            		continue;
		            	            	}		            	         
		            	            }
		            	        	
		///////////////////////////////////////////////FIN RESPUESTA GV///////////////////////////////////////////////////////////////   	
		///////////////////////////////////////////////RESPUESTA OFICINA///////////////////////////////////////////////////////////////   
		            	        	if(respuesta[i].getRespuestaOFI()!=null){
		            	        		
		            	        		codEncuestaOfi = String.valueOf(respuesta[i].getRespuestaOFI().getCodEncuesta());
		            	        		codVersionEncOfi = String.valueOf(respuesta[i].getRespuestaOFI().getCodVersionEncuesta());
		            	        		sd.setVal("ofi_cod_encuesta",codEncuestaOfi);
		             		        	sd.setVal("ofi_cod_version",codVersionEncOfi);
		             		        	sd.setVal("respuesta_rd_asociada",codRespuesta);
		             		        	sd.setVal("cod_encuesta",codEncuestaOfi);
		             		        	sd.setVal("cod_version",codVersionEncOfi);
		             		        	m0FechaResp=dia+"/"+mes+"/"+anio;
		             		            
		                	        	try{
		            	                codRespEncOfi = q53RespuestaXMLClass.setRespuestaEncOfi(sd,
		            	                		resp.getCodOficina(),"", codEncuestaOfi,
		            	                		codVersionEncOfi, codRespuesta, "pres", "registroP", m0Fecha,"", 
		            	                		resp.getClaveFichero(), fechaVersionPlanos, m0FechaResp, hora);
			            	        	} catch(Exception e) {
			            	            	q53LogEstadisticas.printLog("Ha saltado una excepcion : "+e.toString());	
			            	            	q53LogEstadisticas.printLog("Mensaje :"+e.getMessage());
			            	            	codigos_respuestaXML += "3$$";
			                    			textos_respuestaXML += formatear_tags("Excepcion Guardado:"+e.toString()+" ---- "+e.getMessage())+"$$";
			            	            	if(i>=respuesta.length-1){
			            	            		finalizar_envio_respuesta();
				            	            	q53LogEstadisticas.printLog("Codigo respuesta del email enviado (0=OK) : "+enviar_mail(sd));
				            	            	return;
			            	            	}else{
			            	            		q53LogEstadisticas.printLog("Ha ido mal el guardado");
			            	            		continue;
			            	            	}
			            	            }
		            	                
		            	                pregunta=respuesta[i].getRespuestaOFI().getPreguntaArray();
		
		            		        	for(int j=0;j<pregunta.length;j++){
		            		        		codPreguntaOfi = q53RespuestaClass.obtenerCodigoPregunta( sd, codEncuestaOfi, codVersionEncOfi, pregunta[j].getOrden());
		            				        if(pregunta[j].getNumero()!=null){
		            				        	sd.setVal("txt_"+codPreguntaOfi,pregunta[j].getNumero().toString()); 
		            				        }
		            				        if(pregunta[j].getOpcionesMultiples()!=null){
		            				        	opciones=pregunta[j].getOpcionesMultiples().getOpcionArray();
		            			        		for(int k=0;k<opciones.length;k++){  
		            			        			sd.setVal("opt_"+codPreguntaOfi,String.valueOf(Integer.parseInt(opciones[k])-1));
		            			        		}	
		            				        }
		            				        if(pregunta[j].getOpcionUnica()!=null){
		            				        	sd.setVal("opt_"+codPreguntaOfi,String.valueOf(pregunta[j].getOpcionUnica().intValue() - 1));	
		            				        }
		            				        if(pregunta[j].getTexto()!=null){
		            				        	sd.setVal("txt_"+codPreguntaOfi,pregunta[j].getTexto());
		            				        }
		            				        if(pregunta[j].getFecha()!=null){  	
		            				        	cal = pregunta[j].getFecha();
		                        				dia = String.valueOf(cal.get(Calendar.DATE));
		                        				mes = String.valueOf(cal.get(Calendar.MONTH) + 1);
		                        				anio = String.valueOf(cal.get(Calendar.YEAR));
		                        				hora = String.valueOf(cal.get(Calendar.HOUR));
		                        				sd.setVal("fech_"+codPreguntaOfi+"_anio",anio);
		                        				sd.setVal("fech_"+codPreguntaOfi+"_mes",mes);
		                        				sd.setVal("fech_"+codPreguntaOfi+"_dia",dia);
		                        				sd.setVal("fech_"+codPreguntaOfi+"_hora",hora);
		            				        }
		            		        	}
		            		        		
		            		        	try{
		            		        		q53RespuestaClass.guardarRespuestasEncOfi(sd, codEncuestaOfi, codVersionEncOfi, codRespEncOfi);
			            	        	} catch(Exception e) {
			            	            	q53LogEstadisticas.printLog("Ha saltado una excepcion : "+e.toString());	
			            	            	q53LogEstadisticas.printLog("Mensaje :"+e.getMessage());	
			            	            	codigos_respuestaXML += "3$$";
			                    			textos_respuestaXML += formatear_tags("Excepcion Guardado:"+e.toString()+" ---- "+e.getMessage())+"$$";
			            	            	if(i>=respuesta.length-1){
			            	            		finalizar_envio_respuesta();
				            	            	q53LogEstadisticas.printLog("Codigo respuesta del email enviado (0=OK) : "+enviar_mail(sd));
				            	            	return;
			            	            	}else{
			            	            		q53LogEstadisticas.printLog("Ha ido mal el guardado");
			            	            		continue;
			            	            	}
			            	            }
		             	                
		            	        	}
		///////////////////////////////////////////////FIN RESPUESTA OFICINA/////////////////////////////////////////////////////////////// 
		        	        }
            			}
            			codigos_respuestaXML += "0$$";
            			textos_respuestaXML += "OK"+"$$";
            			finalizar_envio_respuesta();
            		}
            	}else{
            		q53LogEstadisticas.printLog("No ha validado, el documento presenta errores");
            		codigos_respuestaXML += "1$$";
        			textos_respuestaXML += formatear_tags("No ha validado, el documento presenta errores :"+parser.mensaje_respuesta)+"$$";
        			finalizar_envio_respuesta();   
            		q53LogEstadisticas.printLog("Codigo respuesta del email enviado (0=OK) : "+enviar_mail(sd));
             	}           		
            } catch (Exception e) {
            	q53LogEstadisticas.printLog("Ha saltado una excepcion : "+e.toString());	
            	q53LogEstadisticas.printLog("Mensaje :"+e.getMessage());
            	codigos_respuestaXML += "2$$";
    			textos_respuestaXML += formatear_tags("Excepcion :"+e.toString()+" ---- "+e.getMessage())+"$$";
    			finalizar_envio_respuesta();
            	q53LogEstadisticas.printLog("Codigo respuesta del email enviado (0=OK) : "+enviar_mail(sd));
                return;
            }
    	} catch (Exception e) {
    		q53LogEstadisticas.printLog("Ha saltado una excepcion, mensaje :"+e.toString()+" ---- "+e.getMessage());	
    	}
    }
    
 
   
    
/*
 * enviar_mail()
 * envia un email de error con la descripcion del mismo y el fichero xml que detalla lo ocurrido
 * return hay_error ->devuelve un 0 si todo ha ido bien y un 1 en caso de errores 
 */    
   public int enviar_mail(ProcletServiceData sd) throws ProcletException,FileNotFoundException,IOException{
	   	//obtenemos la hora actual del servidor para introducirla en el email
	   	Calendar f = Calendar.getInstance();	   
	   	String fecha_act = f.get(Calendar.DAY_OF_MONTH)+"/"+(f.get(Calendar.MONTH)+1)+"/"+f.get(Calendar.YEAR)+" "+f.get(Calendar.HOUR_OF_DAY)+":"+f.get(Calendar.MINUTE)+":"+f.get(Calendar.SECOND);
		textoIn = textoIn +"Fecha/Data : "+fecha_act;
		q53LogEstadisticas.printLog("Cuerpo del email : " +textoIn);
	   	//se crea el archivo que se enviara adjunto en el email
	    String directorio = "/datos/q53/file/maquina_planos/xml_descripcion_error.xml";
	    FileOutputStream elFichero = new FileOutputStream(new File (directorio));
	    elFichero.close();
	    elFichero = new FileOutputStream(new File(directorio));
	    elFichero.write(envia_respuesta.getBytes());
	    elFichero.close();
	    //se crea el segundo archivo que se enviara adjunto en el email
	    String directorio2 = "/datos/q53/file/maquina_planos/xml_origen_del_error.xml";
	    FileOutputStream elFichero2 = new FileOutputStream(new File (directorio2));
	    elFichero2.close();
	    elFichero2 = new FileOutputStream(new File(directorio));
	    elFichero2.write(textoXML.getBytes());
	    elFichero2.close();
	    int hay_error = q53Util.enviaCorreo (sd,servidorIn,fromIn,toIn,null,null,subjectIn,textoIn,null,directorio,directorio2);
		return hay_error;
   }
    
/*
 * ordenarGruposEdad(ProcletServiceData sd,int totalHombres, int totalMujeres)
 * asigna un numero de personas equitativo por cada sexo a cada grupo de edad
 */
    public ProcletServiceData ordenarGruposEdad(ProcletServiceData sd,int totalHombres, int totalMujeres) throws ProcletException {
    	
    	int numHombres = totalHombres;
    	int numMujeres = totalMujeres;
    	int totalPersonas = totalHombres + totalMujeres;
    	int ratioHombres = numHombres / totalPersonas;
    	int mujeresAcumulado = 0;
        int hombresAcumulado = 0;
        int grupo, grupoM, grupoH;
        String grupotext;
        int i;
        for(i = 1; i < 6; i++) {
            grupoH = 0;
            grupoM = 0;
    		grupotext = sd.gOS("grp_5_4_"+i);
    		if (grupotext!="") {
                grupo = Integer.parseInt(grupotext);
                grupoH = Math.round(grupo * ratioHombres);
                grupoM = grupo - grupoH;
                mujeresAcumulado = mujeresAcumulado + grupoM;
                hombresAcumulado = hombresAcumulado + grupoH;
    		} else if(i==5) {
                grupo = (numHombres+numMujeres)-(mujeresAcumulado+hombresAcumulado);
                grupoH = Math.round(grupo * ratioHombres);
                grupoM = grupo - grupoH;
                mujeresAcumulado = mujeresAcumulado + grupoM;
                hombresAcumulado = hombresAcumulado + grupoH;
    		}
    		sd.setVal("grp_5_4_"+i+"_H",String.valueOf(grupoH));
    		sd.setVal("grp_5_4_"+i+"_M",String.valueOf(grupoM));
    		
        }
        if (hombresAcumulado != numHombres) {
    		int diferencia = numHombres - hombresAcumulado;
    	    grupo=0;
    		grupoH=0;
    		grupoM=0;
    		for(i = 5; i > 0; i--) {
    			grupo = Integer.parseInt(sd.gOS("grp_5_4_"+i));
    			if (grupo > 0) {
    				if (diferencia > 0) {
    					grupoH=Integer.parseInt(sd.gOS("grp_5_4_"+i+"_H"));
    					grupoM=Integer.parseInt(sd.gOS("grp_5_4_"+i+"_M"));
    					grupoM=grupoM-1;
    					grupoH=grupoH+1;
    					sd.setVal("grp_5_4_"+i+"_H",String.valueOf(grupoH));
    					sd.setVal("grp_5_4_"+i+"_M",String.valueOf(grupoM));
    					diferencia = diferencia - 1;
    				} else if (diferencia < 0) {
    					grupoH=Integer.parseInt(sd.gOS("grp_5_4_"+i+"_H"));
    					grupoM=Integer.parseInt(sd.gOS("grp_5_4_"+i+"_M"));
    					grupoM=grupoM+1;
    					grupoH=grupoH-1;
    					sd.setVal("grp_5_4_"+i+"_H",String.valueOf(grupoH));
    					sd.setVal("grp_5_4_"+i+"_M",String.valueOf(grupoM));
    					diferencia = diferencia + 1;
    				}
    			}
    		}
        }
       return sd;   	    	  	
    }

/*
 * preparar_XML(String textoXML)
 * elimina los caracteres anteriores al inicio del textoXML y cambia el encoding a ISO-8859-15
 */
    public String preparar_XML(String textoXML){
    	
    	int inicio,fin;
    	String aux;
    	textoXML = textoXML.substring(textoXML.indexOf("<"));
    	inicio = textoXML.lastIndexOf("<?");
    	fin = textoXML.indexOf("?>");
    	aux = textoXML.substring(inicio, fin);
    	textoXML = textoXML.replaceFirst(aux, "xml version='1.0' encoding='ISO-8859-15'");
    	return textoXML;
    	
    }
   
/*
 * formatear_tags(String mensaje)
 * etiqueta el mensaje en CDATA
 */
    public String formatear_tags(String mensaje){
    	
    	mensaje = "<![CDATA["+mensaje;
    	mensaje = mensaje+"]]>";
    	return mensaje;
    }
    
/*
 * finalizar_envio_respuesta()
 * cierra las etiquetas del xml de respuesta y lo manda
 */
    public void finalizar_envio_respuesta() throws IOException {
    	
    	codigos_respuestaXML = codigos_respuestaXML.substring(0, codigos_respuestaXML.length()-2);
    	codigos_respuestaXML += fin_codigos_respuestaXML;
    	textos_respuestaXML = textos_respuestaXML.substring(0, textos_respuestaXML.length()-2);
		textos_respuestaXML += fin_textos_respuestaXML;		
		envia_respuesta += codigos_respuestaXML;
		envia_respuesta += textos_respuestaXML;
		envia_respuesta += fin_respuesta;
		q53LogEstadisticas.printLog("Respuesta xml: "+envia_respuesta);
    	out.print(envia_respuesta);
		
    }
    
/*
 * convertStreamToString(InputStream is)
 * convierte un objeto de tipo InputStream a String
 */
    public String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
        	StringBuffer sb = new StringBuffer();
            String line;
            
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            } finally {
                is.close();
            }
            return sb.toString();
        } else {        
            return "";
        }
    }
}