/*
 * Created on 02-jun-2011
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package itourbaskServlet;

import itourbaskClases.q53BorrarRespuestasClass;
import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;

/**
 * Servlet para hacer borrados de varias respuestas a la vez. 
 * 
 * Uso:
 * Se pasa el codigo de dichas respuestas en un parametro llamado:
 * 
 * codigos_a_eliminar
 * 
 * Separados, estos codigos, por espacios.
 */
public class q53BorradoMasivo extends q53Servlet {

	ProcletServiceData	objectPsd	= null;
	public void pspProcess(ProcletServiceData sd) throws ProcletException {
		objectPsd = sd;
		objectPsd.res.setContentType("text/html");
		objectPsd.res.setHeader("Pragma", "no-cache");
		objectPsd.res.setHeader("Cache-Control", "no-cache");
		objectPsd.res.setHeader("Expires", "0");
		String URLDestino="";
		try {
			//q53LogEstadisticas.printLog("perfil:"+objectPsd.gOS("q53_cki.q53_perfil"));
			// tratar las cookies
			q53_tratarCookies(objectPsd);
			q53LogEstadisticas.printLog("perfil:"+objectPsd.gOS("q53_cki.q53_perfil"));
			setPerfil();
			// Si tiene algun perfil esta logeado
			if (q53Util.esPerfil(objectPsd, q53Constantes.PERFIL_USRO) || q53Util.esPerfil(objectPsd, q53Constantes.PERFIL_ADMO)
					|| q53Util.esPerfil(objectPsd, q53Constantes.PERFIL_COOR)) {
				//Coger los parametros que se mandan desde el jsp del sd
				PSP.paramProclet(objectPsd, "codigos_a_eliminar(), encuesta(), usuario(), pofi(), fechaInicio(), fechaFin(), pendientes(), ultima(), fechaInicioVis(), fechaFinVis(), tipo_ordenacion()");
				
				q53LogEstadisticas.printLog("encuesta: "+objectPsd.gOS("encuesta"));
				q53LogEstadisticas.printLog("usuario: "+objectPsd.gOS("usuario"));
				q53LogEstadisticas.printLog("pofi: "+objectPsd.gOS("pofi"));
				q53LogEstadisticas.printLog("fechaInicio: "+objectPsd.gOS("fechaInicio"));
				q53LogEstadisticas.printLog("fechaFin: "+objectPsd.gOS("fechaFin"));
				q53LogEstadisticas.printLog("pendientes: "+objectPsd.gOS("pendientes"));
				q53LogEstadisticas.printLog("ultima: "+objectPsd.gOS("ultima"));
				q53LogEstadisticas.printLog("fechaInicioVis: "+objectPsd.gOS("fechaInicioVis"));
				q53LogEstadisticas.printLog("fechaFinVis: "+objectPsd.gOS("fechaFinVis"));
				q53LogEstadisticas.printLog("tipo_ordenacion: "+objectPsd.gOS("tipo_ordenacion"));
				
				//Metemos en un array los codigos a eliminar
				String[] codigos = obtenerCodigosAEliminar();
				//borramos cada codigo
				int i=0;
				for ( i=0 ; i < codigos.length; i++) {
					eliminarRespuestaPorCodigo(codigos[i]);
				}
				//Establecemos la pagina a la que vamos a ir a partir de aqui
				q53LogEstadisticas.printLog("Eliminados todos: "+i);
				sd.setVal("pagina", q53Constantes.PAG_RECOGIDA_DATOS);
				URLDestino = getUrlDestinoTrasBorrar(i);
    		}else{
		      // el usuario no tiene el perfil necesario. seguramente es porque
		      // se ha perdido la sesin y hay que redirigirlo al login, para que
		      // vuelva a meter su usuario y contrasea
		       sd.setVal("pagina", "q53_gen_login");
		       URLDestino = "/q53ItourbaskWar/q53_gen_login.jsp?es_usuario_no_sesion";
		    }
			q53_redirigir(sd,URLDestino);
		} catch (Exception e) {
			q53LogEstadisticas.printError("Se ha producido un error al tratar de eliminar los codigos " + sd.gOS("codigos_a_eliminar"), e);
			return;
		}
	}

	/**
	 * @return
	 */
	private String getUrlDestinoTrasBorrar(int i) {
		String destino;
		q53LogEstadisticas.printLog("tipo de encuesta: " + objectPsd.gOS("encuesta"));
		if(objectPsd.gOS("encuesta").equals("pres")){
			//destino="/q53ItourbaskWar/q53usrBusquedaServlet?cod_al="+q53Util.obtener_cod_aleatorio()+"&encuesta=pres&accion=inicioBusqueda&cuantos="+i;			
			destino="/q53ItourbaskWar/q53usrBusquedaServlet?cod_al="+q53Util.obtener_cod_aleatorio()+"&encuesta=pres&usuario="+objectPsd.gOS("usuario")+"&ultima="+objectPsd.gOS("ultima")+"&pofi="+objectPsd.gOS("pofi")+"&pendientes="+objectPsd.gOS("pendientes")+"&fechaInicio="+objectPsd.gOS("fechaInicio")+"&fechaFin="+objectPsd.gOS("fechaFin")+"&fechaInicioVis="+objectPsd.gOS("fechaInicioVis")+"&fechaFinVis="+objectPsd.gOS("fechaFinVis")+"&asc=1&tipo_ordenacion="+objectPsd.gOS("tipo_ordenacion");
			q53LogEstadisticas.printLog("destino: " +destino);
		}else{
			//destino="/q53ItourbaskWar/q53usrBusquedaServlet?cod_al="+q53Util.obtener_cod_aleatorio()+"&encuesta=nopres&accion=inicioBusqueda&cuantos="+i;
			destino="/q53ItourbaskWar/q53usrBusquedaServlet?cod_al="+q53Util.obtener_cod_aleatorio()+"&encuesta=nopres&usuario="+objectPsd.gOS("usuario")+"&ultima="+objectPsd.gOS("ultima")+"&pofi="+objectPsd.gOS("pofi")+"&pendientes="+objectPsd.gOS("pendientes")+"&fechaInicio="+objectPsd.gOS("fechaInicio")+"&fechaFin="+objectPsd.gOS("fechaFin")+"&fechaInicioVis="+objectPsd.gOS("fechaInicioVis")+"&fechaFinVis="+objectPsd.gOS("fechaFinVis")+"&asc=1&tipo_ordenacion="+objectPsd.gOS("tipo_ordenacion");
			q53LogEstadisticas.printLog("destino: " +destino);
		}// TODO Auto-generated method stub
		return destino;
	}

	/**
	 * @param string
	 * @throws ProcletException
	 */
	private void eliminarRespuestaPorCodigo(String codigo) throws ProcletException {
		if (codigo.equals("")){
			return;// No va a borrar nada, omito hacerlo
		}
		q53LogEstadisticas.printLog("Eliminando codigo: " + codigo);
		if (q53Util.esPerfil(objectPsd, q53Constantes.PERFIL_ADMO)) {
			q53BorrarRespuestasClass.guardarEnB(objectPsd, codigo);
		}
		q53BorrarRespuestasClass.borrarRespuestas(objectPsd, codigo);
		q53LogEstadisticas.printLog("Eliminado");
	}

	/**
	 * 
	 */
	private void setPerfil() {		
		String perfilUser = "NO";
		if (q53Util.esPerfil(objectPsd, q53Constantes.PERFIL_USRO)) perfilUser = "SI";

		String perfilCoord = "NO";
		if (q53Util.esPerfil(objectPsd, q53Constantes.PERFIL_COOR)) perfilCoord = "SI";

		String perfilAdmin = "NO";
		if (q53Util.esPerfil(objectPsd, q53Constantes.PERFIL_ADMO)) perfilAdmin = "SI";

		objectPsd.setVal("perfilUser", perfilUser);
		objectPsd.setVal("perfilCoord", perfilCoord);
		objectPsd.setVal("perfilAdmin", perfilAdmin);
		q53LogEstadisticas.printLog("Obtenido perfil:" + perfilAdmin + perfilCoord + perfilUser);
	}

	private String[] obtenerCodigosAEliminar() {
		q53LogEstadisticas.printLog("Codigos a eliminar: " + objectPsd.gOS("codigos_a_eliminar"));
		return objectPsd.gOS("codigos_a_eliminar").split(" ");
	}

}