/*
 * Created on 26-ene-2011
 *
 */
package itourbaskServlet;

import java.io.IOException;

import q53_util.q53LogEstadisticas;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;

/**
 *  
 *
 * Servlet que es llamado desde AJAX para modificar las preguntas de las encuestas
 * Actualmente solo para cambiar si es consulta o no.
 */
public class q53AjaxModificadorEncuestas extends q53Servlet {
	
	private ProcletServiceData sd;
	private int index = 0;
	private int codPregunta = 0;
	/* (non-Javadoc)
	 * @see com.cidat.proclets.PSPServlet#pspProcess(com.cidat.proclets.ProcletServiceData)
	 */
	public void pspProcess(ProcletServiceData psd) {
		try {
			this.sd = psd;
			PSP.paramProclet(sd,"codPregunta(),index(), newValue()");
			codPregunta = (new Integer(sd.gOS("codPregunta"))).intValue();
			index = (new Integer(sd.gOS("index"))).intValue();
			changeConsulta();
			return;
		} catch (NumberFormatException e) {
			q53LogEstadisticas.printError("Error al procesar parametros ", e);
			e.printStackTrace();
		} catch (ProcletException e) {
			q53LogEstadisticas.printError("Error al obtener parametros ", e);
			e.printStackTrace();
		}
	}
	
	/**metodo encargado de cambiar en la DDBB el valor de la consulta por el que le es
	 * proveido al servlet en el procletservicedata como parametro 'newValue'.
	 * 
	 * Escribe en la respuesta el valor final de la propiedad consulta en 'newValue'
	 * 
	 * @param codPregunta codigo de pregunta cuya propiedad 'consulta' hay que alterar
	 * 
	 */
	private void changeConsulta() throws ProcletException{
		int newValue = Integer.valueOf(sd.gOS("newValue")).intValue();
		String respuesta = "codPregunta=" + codPregunta + "&consulta" + index + "=" + newValue;
		String sql = "=update PR_OPCIONES set n2_consulta=" + newValue +" where n2_cod_pregunta=" + codPregunta;
		try {
			java.io.PrintWriter out = sd.res.getWriter();
			q53LogEstadisticas.printLog("respuesta: " + respuesta);
			PSP.sqlProclet(sd, sql);
			out.println(respuesta);
		} catch (IOException e) {
			q53LogEstadisticas.printError("Error al obtener la respuesta", e);
		}
	}
}
